/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public final class MoreCollectors {
    private static final Collector<Object, ?, Optional<Object>> TO_OPTIONAL = Collector.of(ToOptionalState::new, ToOptionalState::add, ToOptionalState::combine, ToOptionalState::getOptional, Collector.Characteristics.UNORDERED);
    private static final Object NULL_PLACEHOLDER = new Object();
    private static final Collector<Object, ?, Object> ONLY_ELEMENT = Collector.of(ToOptionalState::new, (state, o) -> {
        void var1_1;
        state.add(o == null ? NULL_PLACEHOLDER : var1_1);
    }, ToOptionalState::combine, state -> {
        Object object;
        Object result = state.getElement();
        if (result == NULL_PLACEHOLDER) {
            return null;
        }
        return object;
    }, Collector.Characteristics.UNORDERED);

    public static <T> Collector<T, ?, Optional<T>> toOptional() {
        return TO_OPTIONAL;
    }

    public static <T> Collector<T, ?, T> onlyElement() {
        return ONLY_ELEMENT;
    }

    private MoreCollectors() {
    }

    private static final class ToOptionalState {
        static final int MAX_EXTRAS = 4;
        Object element = null;
        List<Object> extras = Collections.emptyList();

        ToOptionalState() {
        }

        /*
         * WARNING - void declaration
         */
        final IllegalArgumentException multiples(boolean overflow) {
            void var2_2;
            void var1_1;
            StringBuilder sb = new StringBuilder("expected one element but was: <").append(this.element);
            for (Object o : this.extras) {
                sb.append(", ").append(o);
            }
            if (var1_1 != false) {
                sb.append(", ...");
            }
            sb.append('>');
            throw new IllegalArgumentException(var2_2.toString());
        }

        /*
         * WARNING - void declaration
         */
        final void add(Object o) {
            Preconditions.checkNotNull(o);
            if (this.element == null) {
                this.element = o;
                return;
            }
            if (this.extras.isEmpty()) {
                this.extras = new ArrayList<Object>(4);
                this.extras.add(o);
                return;
            }
            if (this.extras.size() < 4) {
                void var1_1;
                this.extras.add(var1_1);
                return;
            }
            throw this.multiples(true);
        }

        /*
         * WARNING - void declaration
         */
        final ToOptionalState combine(ToOptionalState other) {
            void var1_1;
            if (this.element == null) {
                return other;
            }
            if (other.element == null) {
                return this;
            }
            if (this.extras.isEmpty()) {
                this.extras = new ArrayList<Object>();
            }
            this.extras.add(other.element);
            this.extras.addAll(var1_1.extras);
            if (this.extras.size() > 4) {
                this.extras.subList(4, this.extras.size()).clear();
                throw this.multiples(true);
            }
            return this;
        }

        final Optional<Object> getOptional() {
            if (this.extras.isEmpty()) {
                return Optional.ofNullable(this.element);
            }
            throw this.multiples(false);
        }

        final Object getElement() {
            if (this.element == null) {
                throw new NoSuchElementException();
            }
            if (this.extras.isEmpty()) {
                return this.element;
            }
            throw this.multiples(false);
        }
    }
}

