/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Ordering;
import com.google.common.math.IntMath;
import java.util.AbstractQueue;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible
public final class MinMaxPriorityQueue<E>
extends AbstractQueue<E> {
    private final Heap minHeap;
    private final Heap maxHeap;
    @VisibleForTesting
    final int maximumSize;
    private Object[] queue;
    private int size;
    private int modCount;
    private static final int EVEN_POWERS_OF_TWO = 0x55555555;
    private static final int ODD_POWERS_OF_TWO = -1431655766;
    private static final int DEFAULT_CAPACITY = 11;

    public static <E extends Comparable<E>> MinMaxPriorityQueue<E> create() {
        return new Builder(Ordering.natural()).create();
    }

    public static <E extends Comparable<E>> MinMaxPriorityQueue<E> create(Iterable<? extends E> initialContents) {
        Iterable<? extends E> iterable;
        return new Builder(Ordering.natural()).create(iterable);
    }

    public static <B> Builder<B> orderedBy(Comparator<B> comparator) {
        Comparator<B> comparator2;
        return new Builder(comparator2);
    }

    public static Builder<Comparable> expectedSize(int expectedSize) {
        int n;
        return new Builder(Ordering.natural()).expectedSize(n);
    }

    public static Builder<Comparable> maximumSize(int maximumSize) {
        int n;
        return new Builder(Ordering.natural()).maximumSize(n);
    }

    /*
     * WARNING - void declaration
     */
    private MinMaxPriorityQueue(Builder<? super E> builder, int queueSize) {
        void var2_2;
        void var1_1;
        void var3_3;
        Ordering ordering = ((Builder)builder).ordering();
        this.minHeap = new Heap(ordering);
        this.minHeap.otherHeap = this.maxHeap = new Heap(var3_3.reverse());
        this.maxHeap.otherHeap = this.minHeap;
        this.maximumSize = ((Builder)var1_1).maximumSize;
        this.queue = new Object[var2_2];
    }

    @Override
    public final int size() {
        return this.size;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean add(E element) {
        void var1_1;
        this.offer(var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean addAll(Collection<? extends E> newElements) {
        boolean bl;
        Iterator iterator;
        boolean modified = false;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_3;
            Object element = iterator.next();
            this.offer(var2_3);
            bl = true;
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean offer(E element) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(element);
        ++this.modCount;
        int insertIndex = this.size++;
        this.growIfNeeded();
        this.heapForIndex(insertIndex).bubbleUp((int)var2_2, element);
        return this.size <= this.maximumSize || this.pollLast() != var1_1;
    }

    @Override
    public final E poll() {
        if (this.isEmpty()) {
            return null;
        }
        return this.removeAndGet(0);
    }

    /*
     * WARNING - void declaration
     */
    final E elementData(int index) {
        void var1_1;
        return (E)Objects.requireNonNull(this.queue[var1_1]);
    }

    @Override
    public final E peek() {
        if (this.isEmpty()) {
            return null;
        }
        return this.elementData(0);
    }

    private int getMaxElementIndex() {
        switch (this.size) {
            case 1: {
                return 0;
            }
            case 2: {
                return 1;
            }
        }
        if (this.maxHeap.compareElements(1, 2) <= 0) {
            return 1;
        }
        return 2;
    }

    public final E pollFirst() {
        return this.poll();
    }

    public final E removeFirst() {
        return this.remove();
    }

    public final E peekFirst() {
        return this.peek();
    }

    public final E pollLast() {
        if (this.isEmpty()) {
            return null;
        }
        MinMaxPriorityQueue minMaxPriorityQueue = this;
        return minMaxPriorityQueue.removeAndGet(minMaxPriorityQueue.getMaxElementIndex());
    }

    public final E removeLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        MinMaxPriorityQueue minMaxPriorityQueue = this;
        return minMaxPriorityQueue.removeAndGet(minMaxPriorityQueue.getMaxElementIndex());
    }

    public final E peekLast() {
        if (this.isEmpty()) {
            return null;
        }
        MinMaxPriorityQueue minMaxPriorityQueue = this;
        return minMaxPriorityQueue.elementData(minMaxPriorityQueue.getMaxElementIndex());
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    final MoveDesc<E> removeAt(int index) {
        void var1_1;
        void var3_3;
        Preconditions.checkPositionIndex(index, this.size);
        ++this.modCount;
        --this.size;
        if (this.size == index) {
            this.queue[this.size] = null;
            return null;
        }
        MinMaxPriorityQueue minMaxPriorityQueue = this;
        E actualLastElement = minMaxPriorityQueue.elementData(minMaxPriorityQueue.size);
        MinMaxPriorityQueue minMaxPriorityQueue2 = this;
        int lastElementAt = minMaxPriorityQueue2.heapForIndex(minMaxPriorityQueue2.size).swapWithConceptuallyLastElement(actualLastElement);
        if (lastElementAt == index) {
            this.queue[this.size] = null;
            return null;
        }
        MinMaxPriorityQueue minMaxPriorityQueue3 = this;
        E toTrickle = minMaxPriorityQueue3.elementData(minMaxPriorityQueue3.size);
        this.queue[this.size] = null;
        MoveDesc<E> changes = this.fillHole(index, toTrickle);
        if (var3_3 < var1_1) {
            void var2_2;
            if (changes == null) {
                return new MoveDesc<E>(actualLastElement, toTrickle);
            }
            return new MoveDesc<void>(var2_2, (void)changes.replaced);
        }
        return changes;
    }

    /*
     * WARNING - void declaration
     */
    private MoveDesc<E> fillHole(int index, E toTrickle) {
        int vacated;
        Heap heap = this.heapForIndex(index);
        int bubbledTo = heap.bubbleUpAlternatingLevels(vacated = heap.fillHoleAt(index), toTrickle);
        if (bubbledTo == vacated) {
            void var3_3;
            return var3_3.tryCrossOverAndBubbleUp(index, vacated, toTrickle);
        }
        if (bubbledTo < index) {
            void var1_1;
            void var2_2;
            return new MoveDesc<void>(var2_2, (void)this.elementData((int)var1_1));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    private E removeAndGet(int index) {
        void var2_2;
        void var1_1;
        E value = this.elementData(index);
        this.removeAt((int)var1_1);
        return var2_2;
    }

    private Heap heapForIndex(int i) {
        if (MinMaxPriorityQueue.isEvenLevel(i)) {
            return this.minHeap;
        }
        return this.maxHeap;
    }

    @VisibleForTesting
    static boolean isEvenLevel(int index) {
        int n;
        int oneBased = ~(~(index + 1));
        Preconditions.checkState(oneBased > 0, "negative index");
        return (oneBased & 0x55555555) > (n & 0xAAAAAAAA);
    }

    @VisibleForTesting
    final boolean isIntact() {
        for (int i = 1; i < this.size; ++i) {
            if (Heap.access$400(this.heapForIndex(i), i)) continue;
            return false;
        }
        return true;
    }

    @Override
    public final Iterator<E> iterator() {
        return new QueueIterator();
    }

    @Override
    public final void clear() {
        for (int i = 0; i < this.size; ++i) {
            this.queue[i] = null;
        }
        this.size = 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Object[] toArray() {
        void var1_1;
        Object[] copyTo = new Object[this.size];
        System.arraycopy(this.queue, 0, copyTo, 0, this.size);
        return var1_1;
    }

    public final Comparator<? super E> comparator() {
        return this.minHeap.ordering;
    }

    @VisibleForTesting
    final int capacity() {
        return this.queue.length;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static int initialQueueSize(int configuredExpectedSize, int maximumSize, Iterable<?> initialContents) {
        void var1_1;
        int n;
        int result;
        int n2 = result = configuredExpectedSize == -1 ? 11 : result;
        if (initialContents instanceof Collection) {
            void var2_3;
            int initialSize = ((Collection)initialContents).size();
            result = Math.max(result, (int)var2_3);
        }
        return MinMaxPriorityQueue.capAtMaximumSize(n, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void growIfNeeded() {
        if (this.size > this.queue.length) {
            void var1_2;
            int n = this.calculateNewCapacity();
            Object[] newQueue = new Object[n];
            System.arraycopy(this.queue, 0, newQueue, 0, this.queue.length);
            this.queue = var1_2;
        }
    }

    private int calculateNewCapacity() {
        int n;
        int oldCapacity = this.queue.length;
        n = oldCapacity < 64 ? oldCapacity + 1 << 1 : IntMath.checkedMultiply((int)(n / 2), 3);
        return MinMaxPriorityQueue.capAtMaximumSize(n, this.maximumSize);
    }

    /*
     * WARNING - void declaration
     */
    private static int capAtMaximumSize(int queueSize, int maximumSize) {
        void var1_1;
        return Math.min(queueSize - 1, (int)var1_1) + 1;
    }

    private class QueueIterator
    implements Iterator<E> {
        private int cursor = -1;
        private int nextCursor = -1;
        private int expectedModCount = MinMaxPriorityQueue.access$700(MinMaxPriorityQueue.this);
        private Queue<E> forgetMeNot;
        private List<E> skipMe;
        private E lastFromForgetMeNot;
        private boolean canRemove;

        private QueueIterator() {
        }

        @Override
        public boolean hasNext() {
            this.checkModCount();
            QueueIterator queueIterator = this;
            queueIterator.nextNotInSkipMe(queueIterator.cursor + 1);
            return this.nextCursor < MinMaxPriorityQueue.this.size() || this.forgetMeNot != null && !this.forgetMeNot.isEmpty();
        }

        @Override
        public E next() {
            this.checkModCount();
            QueueIterator queueIterator = this;
            queueIterator.nextNotInSkipMe(queueIterator.cursor + 1);
            if (this.nextCursor < MinMaxPriorityQueue.this.size()) {
                this.cursor = this.nextCursor;
                this.canRemove = true;
                return MinMaxPriorityQueue.this.elementData(this.cursor);
            }
            if (this.forgetMeNot != null) {
                this.cursor = MinMaxPriorityQueue.this.size();
                this.lastFromForgetMeNot = this.forgetMeNot.poll();
                if (this.lastFromForgetMeNot != null) {
                    this.canRemove = true;
                    return this.lastFromForgetMeNot;
                }
            }
            throw new NoSuchElementException("iterator moved past last element in queue.");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.canRemove);
            this.checkModCount();
            this.canRemove = false;
            ++this.expectedModCount;
            if (this.cursor < MinMaxPriorityQueue.this.size()) {
                MoveDesc moved = MinMaxPriorityQueue.this.removeAt(this.cursor);
                if (moved != null) {
                    if (this.forgetMeNot == null || this.skipMe == null) {
                        this.forgetMeNot = new ArrayDeque();
                        this.skipMe = new ArrayList(3);
                    }
                    QueueIterator queueIterator = this;
                    if (!queueIterator.foundAndRemovedExactReference(queueIterator.skipMe, moved.toTrickle)) {
                        this.forgetMeNot.add(moved.toTrickle);
                    }
                    QueueIterator queueIterator2 = this;
                    if (!queueIterator2.foundAndRemovedExactReference(queueIterator2.forgetMeNot, moved.replaced)) {
                        void var1_1;
                        this.skipMe.add(var1_1.replaced);
                    }
                }
                --this.cursor;
                --this.nextCursor;
                return;
            }
            QueueIterator queueIterator = this;
            Preconditions.checkState(queueIterator.removeExact(Objects.requireNonNull(queueIterator.lastFromForgetMeNot)));
            this.lastFromForgetMeNot = null;
        }

        private boolean foundAndRemovedExactReference(Iterable<E> elements, E target) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                Object e = it.next();
                if (e != target) continue;
                it.remove();
                return true;
            }
            return false;
        }

        private boolean removeExact(Object target) {
            for (int i = 0; i < MinMaxPriorityQueue.this.size; ++i) {
                if (MinMaxPriorityQueue.this.queue[i] != target) continue;
                MinMaxPriorityQueue.this.removeAt(i);
                return true;
            }
            return false;
        }

        private void checkModCount() {
            if (MinMaxPriorityQueue.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        /*
         * WARNING - void declaration
         */
        private void nextNotInSkipMe(int c) {
            if (this.nextCursor < c) {
                void var1_1;
                if (this.skipMe != null) {
                    while (c < MinMaxPriorityQueue.this.size()) {
                        QueueIterator queueIterator = this;
                        if (!queueIterator.foundAndRemovedExactReference(queueIterator.skipMe, MinMaxPriorityQueue.this.elementData(c))) break;
                        ++c;
                    }
                }
                this.nextCursor = var1_1;
            }
        }
    }

    private class Heap {
        final Ordering<E> ordering;
        Heap otherHeap;

        /*
         * WARNING - void declaration
         */
        Heap(Ordering<E> ordering) {
            void var2_2;
            this.ordering = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        int compareElements(int a, int b) {
            void var2_2;
            void var1_1;
            return this.ordering.compare(MinMaxPriorityQueue.this.elementData((int)var1_1), MinMaxPriorityQueue.this.elementData((int)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        MoveDesc<E> tryCrossOverAndBubbleUp(int removeIndex, int vacated, E toTrickle) {
            void var1_1;
            int crossOver = this.crossOver(vacated, toTrickle);
            if (crossOver == vacated) {
                return null;
            }
            Object parent = crossOver < removeIndex ? MinMaxPriorityQueue.this.elementData(removeIndex) : MinMaxPriorityQueue.this.elementData(this.getParentIndex(removeIndex));
            if (this.otherHeap.bubbleUpAlternatingLevels(crossOver, toTrickle) < var1_1) {
                void var2_3;
                void var3_4;
                return new MoveDesc<void>(var3_4, var2_3);
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        void bubbleUp(int index, E x) {
            void var2_2;
            void var1_1;
            void var3_4;
            Heap heap22;
            int crossOver = this.crossOverUp(index, x);
            if (crossOver == index) {
                heap22 = this;
            } else {
                void heap22;
                index = heap22;
                heap22 = this.otherHeap;
            }
            var3_4.bubbleUpAlternatingLevels((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        int bubbleUpAlternatingLevels(int index, E x) {
            void var1_1;
            void var2_2;
            int grandParentIndex;
            Object e;
            while (index > 2 && this.ordering.compare(e = MinMaxPriorityQueue.this.elementData(grandParentIndex = this.getGrandparentIndex(index)), x) > 0) {
                void var3_3;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[index] = e;
                index = var3_3;
            }
            ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[index] = var2_2;
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        int findMin(int index, int len) {
            void var3_3;
            if (index >= MinMaxPriorityQueue.this.size) {
                return -1;
            }
            Preconditions.checkState(index > 0);
            int limit = Math.min(index, MinMaxPriorityQueue.this.size - len) + len;
            int minIndex = index;
            for (int i = index + 1; i < limit; ++i) {
                if (this.compareElements(i, minIndex) >= 0) continue;
                minIndex = i;
            }
            return (int)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        int findMinChild(int index) {
            void var1_1;
            Heap heap = this;
            return heap.findMin(heap.getLeftChildIndex((int)var1_1), 2);
        }

        /*
         * WARNING - void declaration
         */
        int findMinGrandChild(int index) {
            void var1_1;
            int leftChildIndex = this.getLeftChildIndex(index);
            if (leftChildIndex < 0) {
                return -1;
            }
            Heap heap = this;
            return heap.findMin(heap.getLeftChildIndex((int)var1_1), 4);
        }

        /*
         * WARNING - void declaration
         */
        int crossOverUp(int index, E x) {
            void var1_1;
            void var2_2;
            Object uncleElement;
            int grandparentIndex;
            int uncleIndex;
            if (index == 0) {
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[0] = x;
                return 0;
            }
            int parentIndex = this.getParentIndex(index);
            Object parentElement = MinMaxPriorityQueue.this.elementData(parentIndex);
            if (parentIndex != 0 && (uncleIndex = this.getRightChildIndex(grandparentIndex = this.getParentIndex(parentIndex))) != parentIndex && this.getLeftChildIndex(uncleIndex) >= MinMaxPriorityQueue.this.size && this.ordering.compare(uncleElement = MinMaxPriorityQueue.this.elementData(uncleIndex), parentElement) < 0) {
                parentIndex = uncleIndex;
                parentElement = uncleElement;
            }
            if (this.ordering.compare(parentElement, x) < 0) {
                void var3_3;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[index] = parentElement;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[parentIndex] = x;
                return (int)var3_3;
            }
            ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[index] = var2_2;
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        int swapWithConceptuallyLastElement(E actualLastElement) {
            Object uncleElement;
            int grandparentIndex;
            int uncleIndex;
            Heap heap = this;
            int parentIndex = heap.getParentIndex(heap.MinMaxPriorityQueue.this.size);
            if (parentIndex != 0 && (uncleIndex = this.getRightChildIndex(grandparentIndex = this.getParentIndex(parentIndex))) != parentIndex && this.getLeftChildIndex(uncleIndex) >= MinMaxPriorityQueue.this.size && this.ordering.compare(uncleElement = MinMaxPriorityQueue.this.elementData(uncleIndex), actualLastElement) < 0) {
                void var3_4;
                void var2_3;
                void var1_1;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[uncleIndex] = var1_1;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[((MinMaxPriorityQueue)MinMaxPriorityQueue.this).size] = var2_3;
                return (int)var3_4;
            }
            return MinMaxPriorityQueue.this.size;
        }

        /*
         * WARNING - void declaration
         */
        int crossOver(int index, E x) {
            void var2_2;
            void var1_1;
            int minChildIndex = this.findMinChild(index);
            if (minChildIndex > 0 && this.ordering.compare(MinMaxPriorityQueue.this.elementData(minChildIndex), x) < 0) {
                void var3_3;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[index] = MinMaxPriorityQueue.this.elementData(minChildIndex);
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[minChildIndex] = x;
                return (int)var3_3;
            }
            return this.crossOverUp((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        int fillHoleAt(int index) {
            void var1_1;
            int minGrandchildIndex;
            while ((minGrandchildIndex = this.findMinGrandChild(index)) > 0) {
                void var2_2;
                ((MinMaxPriorityQueue)MinMaxPriorityQueue.this).queue[index] = MinMaxPriorityQueue.this.elementData(minGrandchildIndex);
                index = var2_2;
            }
            return (int)var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private boolean verifyIndex(int i) {
            if (this.getLeftChildIndex(i) < MinMaxPriorityQueue.this.size && this.compareElements(i, this.getLeftChildIndex(i)) > 0) {
                return false;
            }
            if (this.getRightChildIndex(i) < MinMaxPriorityQueue.this.size && this.compareElements(i, this.getRightChildIndex(i)) > 0) {
                return false;
            }
            if (i > 0 && this.compareElements(i, this.getParentIndex(i)) > 0) {
                return false;
            }
            if (i > 2) {
                void var1_1;
                Heap heap = this;
                if (heap.compareElements(heap.getGrandparentIndex(i), (int)var1_1) > 0) {
                    return false;
                }
            }
            return true;
        }

        private int getLeftChildIndex(int i) {
            return (i << 1) + 1;
        }

        private int getRightChildIndex(int i) {
            return (i << 1) + 2;
        }

        private int getParentIndex(int i) {
            return (i - 1) / 2;
        }

        /*
         * WARNING - void declaration
         */
        private int getGrandparentIndex(int i) {
            void var1_1;
            Heap heap = this;
            return heap.getParentIndex(heap.getParentIndex((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ boolean access$400(Heap x0, int x1) {
            void var1_1;
            return x0.verifyIndex((int)var1_1);
        }
    }

    static class MoveDesc<E> {
        final E toTrickle;
        final E replaced;

        /*
         * WARNING - void declaration
         */
        MoveDesc(E toTrickle, E replaced) {
            void var2_2;
            void var1_1;
            this.toTrickle = var1_1;
            this.replaced = var2_2;
        }
    }

    @Beta
    public static final class Builder<B> {
        private static final int UNSET_EXPECTED_SIZE = -1;
        private final Comparator<B> comparator;
        private int expectedSize = -1;
        private int maximumSize = Integer.MAX_VALUE;

        /*
         * WARNING - void declaration
         */
        private Builder(Comparator<B> comparator) {
            void var1_1;
            this.comparator = (Comparator)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<B> expectedSize(int expectedSize) {
            void var1_1;
            Preconditions.checkArgument(expectedSize >= 0);
            this.expectedSize = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<B> maximumSize(int maximumSize) {
            void var1_1;
            Preconditions.checkArgument(maximumSize > 0);
            this.maximumSize = var1_1;
            return this;
        }

        public final <T extends B> MinMaxPriorityQueue<T> create() {
            return this.create(Collections.emptySet());
        }

        /*
         * WARNING - void declaration
         */
        public final <T extends B> MinMaxPriorityQueue<T> create(Iterable<? extends T> initialContents) {
            void var2_2;
            Iterator iterator;
            Builder builder = this;
            MinMaxPriorityQueue<void> queue = new MinMaxPriorityQueue<void>(builder, MinMaxPriorityQueue.initialQueueSize(builder.expectedSize, this.maximumSize, initialContents));
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object element = iterator.next();
                queue.offer(var3_3);
            }
            return var2_2;
        }

        private <T extends B> Ordering<T> ordering() {
            return Ordering.from(this.comparator);
        }
    }
}

