/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Converter;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractNavigableMap;
import com.google.common.collect.BiMap;
import com.google.common.collect.BoundType;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ForwardingMapEntry;
import com.google.common.collect.ForwardingNavigableSet;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.ImmutableEnumMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.MapDifference;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Range;
import com.google.common.collect.Sets;
import com.google.common.collect.SortedMapDifference;
import com.google.common.collect.Synchronized;
import com.google.common.collect.TransformedIterator;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Maps {
    private Maps() {
    }

    static <K> Function<Map.Entry<K, ?>, K> keyFunction() {
        return EntryFunction.KEY;
    }

    static <V> Function<Map.Entry<?, V>, V> valueFunction() {
        return EntryFunction.VALUE;
    }

    static <K, V> Iterator<K> keyIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        Iterator<Map.Entry<K, V>> iterator;
        return new TransformedIterator<Map.Entry<K, V>, K>(iterator){
            {
                void var1_1;
            }

            @Override
            @ParametricNullness
            K transform(Map.Entry<K, V> entry) {
                return entry.getKey();
            }
        };
    }

    static <K, V> Iterator<V> valueIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        Iterator<Map.Entry<K, V>> iterator;
        return new TransformedIterator<Map.Entry<K, V>, V>(iterator){
            {
                void var1_1;
            }

            @Override
            @ParametricNullness
            V transform(Map.Entry<K, V> entry) {
                return entry.getValue();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @GwtCompatible(serializable=true)
    public static <K extends Enum<K>, V> ImmutableMap<K, V> immutableEnumMap(Map<K, ? extends V> map) {
        void var3_3;
        if (map instanceof ImmutableEnumMap) {
            map = map;
            return map;
        }
        Iterator<Map.Entry<K, V>> entryItr = map.entrySet().iterator();
        if (!entryItr.hasNext()) {
            return ImmutableMap.of();
        }
        Map.Entry entry1 = (Map.Entry)entryItr.next();
        Enum key1 = (Enum)entry1.getKey();
        Object value1 = entry1.getValue();
        CollectPreconditions.checkEntryNotNull(key1, value1);
        Class clazz = key1.getDeclaringClass();
        EnumMap enumMap = new EnumMap(clazz);
        enumMap.put(key1, value1);
        while (entryItr.hasNext()) {
            void var1_1;
            void var2_2;
            Map.Entry entry = (Map.Entry)entryItr.next();
            Enum key = (Enum)entry.getKey();
            Object value = entry.getValue();
            CollectPreconditions.checkEntryNotNull(key, value);
            enumMap.put(var2_2, var1_1);
        }
        return ImmutableEnumMap.asImmutable(var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K extends Enum<K>, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableEnumMap(java.util.function.Function<? super T, ? extends K> keyFunction, java.util.function.Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        return CollectCollectors.toImmutableEnumMap(keyFunction, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K extends Enum<K>, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableEnumMap(java.util.function.Function<? super T, ? extends K> keyFunction, java.util.function.Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        void var2_2;
        void var1_1;
        return CollectCollectors.toImmutableEnumMap(keyFunction, var1_1, var2_2);
    }

    public static <K, V> HashMap<K, V> newHashMap() {
        return new HashMap();
    }

    public static <K, V> HashMap<K, V> newHashMap(Map<? extends K, ? extends V> map) {
        Map<? extends K, ? extends V> map2;
        return new HashMap<K, V>(map2);
    }

    public static <K, V> HashMap<K, V> newHashMapWithExpectedSize(int expectedSize) {
        int n;
        return new HashMap(Maps.capacity(n));
    }

    static int capacity(int expectedSize) {
        if (expectedSize < 3) {
            CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
            return expectedSize + 1;
        }
        if (expectedSize < 0x40000000) {
            int n;
            return (int)((float)n / 0.75f + 1.0f);
        }
        return Integer.MAX_VALUE;
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap() {
        return new LinkedHashMap();
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMap(Map<? extends K, ? extends V> map) {
        Map<? extends K, ? extends V> map2;
        return new LinkedHashMap<K, V>(map2);
    }

    public static <K, V> LinkedHashMap<K, V> newLinkedHashMapWithExpectedSize(int expectedSize) {
        int n;
        return new LinkedHashMap(Maps.capacity(n));
    }

    public static <K, V> ConcurrentMap<K, V> newConcurrentMap() {
        return new ConcurrentHashMap();
    }

    public static <K extends Comparable, V> TreeMap<K, V> newTreeMap() {
        return new TreeMap();
    }

    public static <K, V> TreeMap<K, V> newTreeMap(SortedMap<K, ? extends V> map) {
        SortedMap<K, ? extends V> sortedMap;
        return new TreeMap<K, V>(sortedMap);
    }

    public static <C, K extends C, V> TreeMap<K, V> newTreeMap(Comparator<C> comparator) {
        Comparator<C> comparator2;
        return new TreeMap(comparator2);
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Class<K> type) {
        Class<K> clazz;
        return new EnumMap(Preconditions.checkNotNull(clazz));
    }

    public static <K extends Enum<K>, V> EnumMap<K, V> newEnumMap(Map<K, ? extends V> map) {
        Map<K, ? extends V> map2;
        return new EnumMap<K, V>(map2);
    }

    public static <K, V> IdentityHashMap<K, V> newIdentityHashMap() {
        return new IdentityHashMap();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right) {
        void var1_1;
        MapDifference<? extends K, Object> mapDifference;
        if (left instanceof SortedMap) {
            left = left;
            return Maps.difference(left, right);
        }
        mapDifference = Maps.difference(mapDifference, var1_1, Equivalence.equals());
        return mapDifference;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> MapDifference<K, V> difference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right, Equivalence<? super V> valueEquivalence) {
        void var3_3;
        void var2_2;
        void var1_1;
        Map<? extends K, ? extends V> map;
        Preconditions.checkNotNull(valueEquivalence);
        LinkedHashMap<K, V> onlyOnLeft = Maps.newLinkedHashMap();
        LinkedHashMap<? extends K, ? extends V> onlyOnRight = new LinkedHashMap<K, V>(right);
        LinkedHashMap<K, V> onBoth = Maps.newLinkedHashMap();
        LinkedHashMap<K, V> differences = Maps.newLinkedHashMap();
        Maps.doDifference(map, var1_1, var2_2, onlyOnLeft, onlyOnRight, onBoth, differences);
        return new MapDifferenceImpl<K, V>(var3_3, onlyOnRight, onBoth, differences);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> SortedMapDifference<K, V> difference(SortedMap<K, ? extends V> left, Map<? extends K, ? extends V> right) {
        void var2_2;
        void var3_3;
        void var1_1;
        SortedMap<K, ? extends V> sortedMap;
        Preconditions.checkNotNull(left);
        Preconditions.checkNotNull(right);
        Comparator<K> comparator = Maps.orNaturalOrder(left.comparator());
        TreeMap<K, V> onlyOnLeft = Maps.newTreeMap(comparator);
        TreeMap<? extends K, ? extends V> onlyOnRight = Maps.newTreeMap(comparator);
        onlyOnRight.putAll(right);
        TreeMap<K, V> onBoth = Maps.newTreeMap(comparator);
        TreeMap<K, V> differences = Maps.newTreeMap(comparator);
        Equivalence<Object> equalsEquivalence = Equivalence.equals();
        Maps.doDifference(sortedMap, var1_1, equalsEquivalence, onlyOnLeft, onlyOnRight, onBoth, differences);
        return new SortedMapDifferenceImpl<K, V>(var3_3, onlyOnRight, onBoth, var2_2);
    }

    private static <K, V> void doDifference(Map<? extends K, ? extends V> left, Map<? extends K, ? extends V> right, Equivalence<? super V> valueEquivalence, Map<K, V> onlyOnLeft, Map<K, V> onlyOnRight, Map<K, V> onBoth, Map<K, MapDifference.ValueDifference<V>> differences) {
        for (Map.Entry entry : left.entrySet()) {
            Object leftKey = entry.getKey();
            Object v = entry.getValue();
            if (right.containsKey(leftKey)) {
                V rightValue = NullnessCasts.uncheckedCastNullableTToT(onlyOnRight.remove(leftKey));
                if (valueEquivalence.equivalent(v, rightValue)) {
                    onBoth.put(leftKey, v);
                    continue;
                }
                differences.put(leftKey, ValueDifferenceImpl.create(v, rightValue));
                continue;
            }
            onlyOnLeft.put(leftKey, v);
        }
    }

    private static <K, V> Map<K, V> unmodifiableMap(Map<K, ? extends V> map) {
        Map<K, ? extends V> map2;
        if (map instanceof SortedMap) {
            return Collections.unmodifiableSortedMap((SortedMap)map);
        }
        return Collections.unmodifiableMap(map2);
    }

    static <E> Comparator<? super E> orNaturalOrder(Comparator<? super E> comparator) {
        if (comparator != null) {
            Comparator<? super E> comparator2;
            return comparator2;
        }
        return Ordering.natural();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> asMap(Set<K> set, Function<? super K, V> function) {
        void var1_1;
        Set<K> set2;
        return new AsMapView(set2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> SortedMap<K, V> asMap(SortedSet<K> set, Function<? super K, V> function) {
        void var1_1;
        SortedSet<K> sortedSet;
        return new SortedAsMapView(sortedSet, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <K, V> NavigableMap<K, V> asMap(NavigableSet<K> set, Function<? super K, V> function) {
        void var1_1;
        NavigableSet<K> navigableSet;
        return new NavigableAsMapView(navigableSet, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> Iterator<Map.Entry<K, V>> asMapEntryIterator(Set<K> set, Function<? super K, V> function) {
        void var1_1;
        Set<K> set2;
        return new TransformedIterator<K, Map.Entry<K, V>>(set2.iterator(), (Function)var1_1){
            final /* synthetic */ Function val$function;
            {
                void var1_1;
                this.val$function = function;
                super(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Map.Entry<K, V> transform(@ParametricNullness K key) {
                void var1_1;
                return Maps.immutableEntry(key, this.val$function.apply(var1_1));
            }
        };
    }

    private static <E> Set<E> removeOnlySet(Set<E> set) {
        Set<E> set2;
        return new ForwardingSet<E>(){

            @Override
            protected Set<E> delegate() {
                return set2;
            }

            @Override
            public boolean add(@ParametricNullness E element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> es) {
                throw new UnsupportedOperationException();
            }
        };
    }

    private static <E> SortedSet<E> removeOnlySortedSet(SortedSet<E> set) {
        SortedSet<E> sortedSet;
        return new ForwardingSortedSet<E>(){

            @Override
            protected SortedSet<E> delegate() {
                return sortedSet;
            }

            @Override
            public boolean add(@ParametricNullness E element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> es) {
                throw new UnsupportedOperationException();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public SortedSet<E> headSet(@ParametricNullness E toElement) {
                void var1_1;
                return Maps.removeOnlySortedSet(super.headSet(var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public SortedSet<E> subSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
                void var2_2;
                void var1_1;
                return Maps.removeOnlySortedSet(super.subSet(var1_1, var2_2));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public SortedSet<E> tailSet(@ParametricNullness E fromElement) {
                void var1_1;
                return Maps.removeOnlySortedSet(super.tailSet(var1_1));
            }
        };
    }

    @GwtIncompatible
    private static <E> NavigableSet<E> removeOnlyNavigableSet(NavigableSet<E> set) {
        NavigableSet<E> navigableSet;
        return new ForwardingNavigableSet<E>(){

            @Override
            protected NavigableSet<E> delegate() {
                return navigableSet;
            }

            @Override
            public boolean add(@ParametricNullness E element) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean addAll(Collection<? extends E> es) {
                throw new UnsupportedOperationException();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public SortedSet<E> headSet(@ParametricNullness E toElement) {
                void var1_1;
                return Maps.removeOnlySortedSet(super.headSet(var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public NavigableSet<E> headSet(@ParametricNullness E toElement, boolean inclusive) {
                void var2_2;
                void var1_1;
                return Maps.removeOnlyNavigableSet(super.headSet(var1_1, (boolean)var2_2));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public SortedSet<E> subSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
                void var2_2;
                void var1_1;
                return Maps.removeOnlySortedSet(super.subSet(var1_1, var2_2));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public NavigableSet<E> subSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
                void var3_3;
                void var2_2;
                void var1_1;
                return Maps.removeOnlyNavigableSet(super.subSet(var1_1, (boolean)var2_2, var3_3, toInclusive));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public SortedSet<E> tailSet(@ParametricNullness E fromElement) {
                void var1_1;
                return Maps.removeOnlySortedSet(super.tailSet(var1_1));
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public NavigableSet<E> tailSet(@ParametricNullness E fromElement, boolean inclusive) {
                void var2_2;
                void var1_1;
                return Maps.removeOnlyNavigableSet(super.tailSet(var1_1, (boolean)var2_2));
            }

            @Override
            public NavigableSet<E> descendingSet() {
                return Maps.removeOnlyNavigableSet(super.descendingSet());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> toMap(Iterable<K> keys, Function<? super K, V> valueFunction) {
        void var1_1;
        return Maps.toMap(keys.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> toMap(Iterator<K> keys, Function<? super K, V> valueFunction) {
        void var2_2;
        Preconditions.checkNotNull(valueFunction);
        ImmutableMap.Builder<K, V> builder = ImmutableMap.builder();
        while (keys.hasNext()) {
            void var3_3;
            K key = keys.next();
            builder.put(key, valueFunction.apply(var3_3));
        }
        return var2_2.buildKeepingLast();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> uniqueIndex(Iterable<V> values, Function<? super V, K> keyFunction) {
        void var1_1;
        return Maps.uniqueIndex(values.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> uniqueIndex(Iterator<V> values, Function<? super V, K> keyFunction) {
        Preconditions.checkNotNull(keyFunction);
        ImmutableMap.Builder<K, V> builder = ImmutableMap.builder();
        while (values.hasNext()) {
            V value = values.next();
            builder.put(keyFunction.apply(value), value);
        }
        try {
            void var2_2;
            return var2_2.buildOrThrow();
        }
        catch (IllegalArgumentException duplicateKeys) {
            void var3_4;
            throw new IllegalArgumentException(String.valueOf(var3_4.getMessage()).concat(". To index multiple values under a key, use Multimaps.index."));
        }
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static ImmutableMap<String, String> fromProperties(Properties properties) {
        void var1_1;
        ImmutableMap.Builder<String, String> builder = ImmutableMap.builder();
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            void var3_3;
            String key = (String)Objects.requireNonNull(e.nextElement());
            builder.put(key, Objects.requireNonNull(properties.getProperty((String)var3_3)));
        }
        return var1_1.buildOrThrow();
    }

    /*
     * WARNING - void declaration
     */
    @GwtCompatible(serializable=true)
    public static <K, V> Map.Entry<K, V> immutableEntry(@ParametricNullness K key, @ParametricNullness V value) {
        void var1_1;
        K k;
        return new ImmutableEntry<K, void>(k, var1_1);
    }

    static <K, V> Set<Map.Entry<K, V>> unmodifiableEntrySet(Set<Map.Entry<K, V>> entrySet) {
        Set<Map.Entry<K, V>> set;
        return new UnmodifiableEntrySet<K, V>(Collections.unmodifiableSet(set));
    }

    static <K, V> Map.Entry<K, V> unmodifiableEntry(Map.Entry<? extends K, ? extends V> entry) {
        Map.Entry<? extends K, ? extends V> entry2;
        Preconditions.checkNotNull(entry);
        return new AbstractMapEntry<K, V>(){

            @Override
            @ParametricNullness
            public K getKey() {
                return entry2.getKey();
            }

            @Override
            @ParametricNullness
            public V getValue() {
                return entry2.getValue();
            }
        };
    }

    static <K, V> UnmodifiableIterator<Map.Entry<K, V>> unmodifiableEntryIterator(Iterator<Map.Entry<K, V>> entryIterator) {
        Iterator<Map.Entry<K, V>> iterator;
        return new UnmodifiableIterator<Map.Entry<K, V>>(){

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public Map.Entry<K, V> next() {
                return Maps.unmodifiableEntry((Map.Entry)iterator.next());
            }
        };
    }

    public static <A, B> Converter<A, B> asConverter(BiMap<A, B> bimap) {
        BiMap<A, B> biMap;
        return new BiMapConverter<A, B>(biMap);
    }

    public static <K, V> BiMap<K, V> synchronizedBiMap(BiMap<K, V> bimap) {
        return Synchronized.biMap(bimap, null);
    }

    public static <K, V> BiMap<K, V> unmodifiableBiMap(BiMap<? extends K, ? extends V> bimap) {
        BiMap<? extends K, ? extends V> biMap;
        return new UnmodifiableBiMap<K, V>(biMap, null);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V1, V2> Map<K, V2> transformValues(Map<K, V1> fromMap, Function<? super V1, V2> function) {
        void var1_1;
        return Maps.transformEntries(fromMap, Maps.asEntryTransformer(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V1, V2> SortedMap<K, V2> transformValues(SortedMap<K, V1> fromMap, Function<? super V1, V2> function) {
        void var1_1;
        return Maps.transformEntries(fromMap, Maps.asEntryTransformer(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <K, V1, V2> NavigableMap<K, V2> transformValues(NavigableMap<K, V1> fromMap, Function<? super V1, V2> function) {
        void var1_1;
        return Maps.transformEntries(fromMap, Maps.asEntryTransformer(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V1, V2> Map<K, V2> transformEntries(Map<K, V1> fromMap, EntryTransformer<? super K, ? super V1, V2> transformer) {
        void var1_1;
        Map<K, V1> map;
        return new TransformedEntriesMap(map, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V1, V2> SortedMap<K, V2> transformEntries(SortedMap<K, V1> fromMap, EntryTransformer<? super K, ? super V1, V2> transformer) {
        void var1_1;
        SortedMap<K, V1> sortedMap;
        return new TransformedEntriesSortedMap(sortedMap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <K, V1, V2> NavigableMap<K, V2> transformEntries(NavigableMap<K, V1> fromMap, EntryTransformer<? super K, ? super V1, V2> transformer) {
        void var1_1;
        NavigableMap<K, V1> navigableMap;
        return new TransformedEntriesNavigableMap(navigableMap, var1_1);
    }

    static <K, V1, V2> EntryTransformer<K, V1, V2> asEntryTransformer(Function<? super V1, V2> function) {
        Function<? super V1, V2> function2;
        Preconditions.checkNotNull(function);
        return new EntryTransformer<K, V1, V2>(){

            /*
             * WARNING - void declaration
             */
            @Override
            @ParametricNullness
            public V2 transformEntry(@ParametricNullness K key, @ParametricNullness V1 value) {
                void var2_2;
                return function2.apply(var2_2);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static <K, V1, V2> Function<V1, V2> asValueToValueFunction(EntryTransformer<? super K, V1, V2> transformer, @ParametricNullness K key) {
        void var1_1;
        EntryTransformer<? super K, V1, V2> entryTransformer;
        Preconditions.checkNotNull(transformer);
        return new Function<V1, V2>(){

            /*
             * WARNING - void declaration
             */
            @Override
            @ParametricNullness
            public V2 apply(@ParametricNullness V1 v1) {
                void var1_12;
                return entryTransformer.transformEntry(var1_1, var1_12);
            }
        };
    }

    static <K, V1, V2> Function<Map.Entry<K, V1>, V2> asEntryToValueFunction(EntryTransformer<? super K, ? super V1, V2> transformer) {
        EntryTransformer<? super K, ? super V1, V2> entryTransformer;
        Preconditions.checkNotNull(transformer);
        return new Function<Map.Entry<K, V1>, V2>(){

            /*
             * WARNING - void declaration
             */
            @Override
            @ParametricNullness
            public V2 apply(Map.Entry<K, V1> entry) {
                void var1_1;
                return entryTransformer.transformEntry(entry.getKey(), var1_1.getValue());
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static <V2, K, V1> Map.Entry<K, V2> transformEntry(EntryTransformer<? super K, ? super V1, V2> transformer, Map.Entry<K, V1> entry) {
        EntryTransformer<? super K, ? super V1, V2> entryTransformer;
        void var1_1;
        Preconditions.checkNotNull(transformer);
        Preconditions.checkNotNull(entry);
        return new AbstractMapEntry<K, V2>((Map.Entry)var1_1, entryTransformer){
            final /* synthetic */ Map.Entry val$entry;
            final /* synthetic */ EntryTransformer val$transformer;
            {
                this.val$entry = entry;
                this.val$transformer = entryTransformer;
            }

            @Override
            @ParametricNullness
            public K getKey() {
                return this.val$entry.getKey();
            }

            @Override
            @ParametricNullness
            public V2 getValue() {
                return this.val$transformer.transformEntry(this.val$entry.getKey(), this.val$entry.getValue());
            }
        };
    }

    static <K, V1, V2> Function<Map.Entry<K, V1>, Map.Entry<K, V2>> asEntryToEntryFunction(EntryTransformer<? super K, ? super V1, V2> transformer) {
        EntryTransformer<? super K, ? super V1, V2> entryTransformer;
        Preconditions.checkNotNull(transformer);
        return new Function<Map.Entry<K, V1>, Map.Entry<K, V2>>(){

            /*
             * WARNING - void declaration
             */
            @Override
            public Map.Entry<K, V2> apply(Map.Entry<K, V1> entry) {
                void var1_1;
                return Maps.transformEntry(entryTransformer, var1_1);
            }
        };
    }

    static <K> Predicate<Map.Entry<K, ?>> keyPredicateOnEntries(Predicate<? super K> keyPredicate) {
        return Predicates.compose(keyPredicate, Maps.keyFunction());
    }

    static <V> Predicate<Map.Entry<?, V>> valuePredicateOnEntries(Predicate<? super V> valuePredicate) {
        return Predicates.compose(valuePredicate, Maps.valueFunction());
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> filterKeys(Map<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        void var2_2;
        void var1_1;
        Map<K, V> map;
        Preconditions.checkNotNull(keyPredicate);
        Predicate<Map.Entry<? super K, ?>> entryPredicate = Maps.keyPredicateOnEntries(keyPredicate);
        if (unfiltered instanceof AbstractFilteredMap) {
            return Maps.filterFiltered((AbstractFilteredMap)unfiltered, entryPredicate);
        }
        return new FilteredKeyMap<K, V>(Preconditions.checkNotNull(map), var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> SortedMap<K, V> filterKeys(SortedMap<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        void var1_1;
        return Maps.filterEntries(unfiltered, Maps.keyPredicateOnEntries(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <K, V> NavigableMap<K, V> filterKeys(NavigableMap<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        void var1_1;
        return Maps.filterEntries(unfiltered, Maps.keyPredicateOnEntries(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> BiMap<K, V> filterKeys(BiMap<K, V> unfiltered, Predicate<? super K> keyPredicate) {
        void var1_1;
        BiMap<K, V> biMap;
        Preconditions.checkNotNull(keyPredicate);
        return Maps.filterEntries(biMap, Maps.keyPredicateOnEntries(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> filterValues(Map<K, V> unfiltered, Predicate<? super V> valuePredicate) {
        void var1_1;
        return Maps.filterEntries(unfiltered, Maps.valuePredicateOnEntries(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> SortedMap<K, V> filterValues(SortedMap<K, V> unfiltered, Predicate<? super V> valuePredicate) {
        void var1_1;
        return Maps.filterEntries(unfiltered, Maps.valuePredicateOnEntries(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <K, V> NavigableMap<K, V> filterValues(NavigableMap<K, V> unfiltered, Predicate<? super V> valuePredicate) {
        void var1_1;
        return Maps.filterEntries(unfiltered, Maps.valuePredicateOnEntries(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> BiMap<K, V> filterValues(BiMap<K, V> unfiltered, Predicate<? super V> valuePredicate) {
        void var1_1;
        return Maps.filterEntries(unfiltered, Maps.valuePredicateOnEntries(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> Map<K, V> filterEntries(Map<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        Map<K, V> map;
        Preconditions.checkNotNull(entryPredicate);
        if (unfiltered instanceof AbstractFilteredMap) {
            return Maps.filterFiltered((AbstractFilteredMap)unfiltered, entryPredicate);
        }
        return new FilteredEntryMap<K, V>(Preconditions.checkNotNull(map), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> SortedMap<K, V> filterEntries(SortedMap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        SortedMap<K, V> sortedMap;
        Preconditions.checkNotNull(entryPredicate);
        if (unfiltered instanceof FilteredEntrySortedMap) {
            return Maps.filterFiltered((FilteredEntrySortedMap)unfiltered, entryPredicate);
        }
        return new FilteredEntrySortedMap<K, V>(Preconditions.checkNotNull(sortedMap), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <K, V> NavigableMap<K, V> filterEntries(NavigableMap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        NavigableMap<K, V> navigableMap;
        Preconditions.checkNotNull(entryPredicate);
        if (unfiltered instanceof FilteredEntryNavigableMap) {
            return Maps.filterFiltered((FilteredEntryNavigableMap)unfiltered, entryPredicate);
        }
        return new FilteredEntryNavigableMap<K, V>(Preconditions.checkNotNull(navigableMap), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> BiMap<K, V> filterEntries(BiMap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        BiMap<K, V> biMap;
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(entryPredicate);
        if (unfiltered instanceof FilteredEntryBiMap) {
            return Maps.filterFiltered((FilteredEntryBiMap)unfiltered, entryPredicate);
        }
        return new FilteredEntryBiMap<K, V>(biMap, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> Map<K, V> filterFiltered(AbstractFilteredMap<K, V> map, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        AbstractFilteredMap<K, V> abstractFilteredMap;
        return new FilteredEntryMap(map.unfiltered, Predicates.and(abstractFilteredMap.predicate, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> SortedMap<K, V> filterFiltered(FilteredEntrySortedMap<K, V> map, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        FilteredEntrySortedMap<K, V> filteredEntrySortedMap;
        Predicate<? super Map.Entry<K, V>> predicate = Predicates.and(map.predicate, entryPredicate);
        return new FilteredEntrySortedMap<K, V>(filteredEntrySortedMap.sortedMap(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private static <K, V> NavigableMap<K, V> filterFiltered(FilteredEntryNavigableMap<K, V> map, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        FilteredEntryNavigableMap<K, V> filteredEntryNavigableMap;
        Predicate<? super Map.Entry<K, V>> predicate = Predicates.and(((FilteredEntryNavigableMap)map).entryPredicate, entryPredicate);
        return new FilteredEntryNavigableMap(((FilteredEntryNavigableMap)filteredEntryNavigableMap).unfiltered, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> BiMap<K, V> filterFiltered(FilteredEntryBiMap<K, V> map, Predicate<? super Map.Entry<K, V>> entryPredicate) {
        void var1_1;
        FilteredEntryBiMap<K, V> filteredEntryBiMap;
        Predicate<? super Map.Entry<K, V>> predicate = Predicates.and(map.predicate, entryPredicate);
        return new FilteredEntryBiMap<K, V>(filteredEntryBiMap.unfiltered(), var1_1);
    }

    @GwtIncompatible
    public static <K, V> NavigableMap<K, V> unmodifiableNavigableMap(NavigableMap<K, ? extends V> map) {
        NavigableMap<K, ? extends V> navigableMap;
        Preconditions.checkNotNull(map);
        if (map instanceof UnmodifiableNavigableMap) {
            return map;
        }
        return new UnmodifiableNavigableMap<K, V>(navigableMap);
    }

    private static <K, V> Map.Entry<K, V> unmodifiableOrNull(Map.Entry<K, ? extends V> entry) {
        Map.Entry<K, ? extends V> entry2;
        if (entry == null) {
            return null;
        }
        return Maps.unmodifiableEntry(entry2);
    }

    @GwtIncompatible
    public static <K, V> NavigableMap<K, V> synchronizedNavigableMap(NavigableMap<K, V> navigableMap) {
        return Synchronized.navigableMap(navigableMap);
    }

    /*
     * WARNING - void declaration
     */
    static <V> V safeGet(Map<?, V> map, Object key) {
        Preconditions.checkNotNull(map);
        try {
            void var1_1;
            Map<?, V> map2;
            return map2.get(var1_1);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean safeContainsKey(Map<?, ?> map, Object key) {
        Preconditions.checkNotNull(map);
        try {
            void var1_1;
            Map<?, ?> map2;
            return map2.containsKey(var1_1);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    static <V> V safeRemove(Map<?, V> map, Object key) {
        Preconditions.checkNotNull(map);
        try {
            void var1_1;
            Map<?, V> map2;
            return map2.remove(var1_1);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    static boolean containsKeyImpl(Map<?, ?> map, Object key) {
        void var1_1;
        return Iterators.contains(Maps.keyIterator(map.entrySet().iterator()), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static boolean containsValueImpl(Map<?, ?> map, Object value) {
        void var1_1;
        return Iterators.contains(Maps.valueIterator(map.entrySet().iterator()), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> boolean containsEntryImpl(Collection<Map.Entry<K, V>> c, Object o) {
        void var1_1;
        Collection<Map.Entry<K, V>> collection;
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        return collection.contains(Maps.unmodifiableEntry((Map.Entry)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> boolean removeEntryImpl(Collection<Map.Entry<K, V>> c, Object o) {
        void var1_1;
        Collection<Map.Entry<K, V>> collection;
        if (!(o instanceof Map.Entry)) {
            return false;
        }
        return collection.remove(Maps.unmodifiableEntry((Map.Entry)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    static boolean equalsImpl(Map<?, ?> map, Object object) {
        if (map == object) {
            return true;
        }
        if (object instanceof Map) {
            void var1_1;
            Map<?, ?> map2;
            Map o = (Map)object;
            return map2.entrySet().equals(var1_1.entrySet());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    static String toStringImpl(Map<?, ?> map) {
        void var1_1;
        Object object;
        StringBuilder sb = Collections2.newStringBuilderForCollection(map.size()).append('{');
        boolean first = true;
        for (Map.Entry entry : object.entrySet()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(entry.getKey()).append('=').append(entry.getValue());
        }
        return var1_1.append('}').toString();
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> void putAllImpl(Map<K, V> self, Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            void var2_2;
            self.put(entry.getKey(), var2_2.getValue());
        }
    }

    static <K> K keyOrNull(Map.Entry<K, ?> entry) {
        Map.Entry<K, ?> entry2;
        if (entry == null) {
            return null;
        }
        return entry2.getKey();
    }

    static <V> V valueOrNull(Map.Entry<?, V> entry) {
        Map.Entry<?, V> entry2;
        if (entry == null) {
            return null;
        }
        return entry2.getValue();
    }

    /*
     * WARNING - void declaration
     */
    static <E> ImmutableMap<E, Integer> indexMap(Collection<E> list) {
        void var1_1;
        Iterator<E> iterator;
        ImmutableMap.Builder<void, Integer> builder = new ImmutableMap.Builder<void, Integer>(list.size());
        int i = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Object e = iterator.next();
            builder.put(var3_3, i++);
        }
        return var1_1.buildOrThrow();
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    @GwtIncompatible
    public static <K extends Comparable<? super K>, V> NavigableMap<K, V> subMap(NavigableMap<K, V> map, Range<K> range) {
        NavigableMap<K, V> navigableMap;
        if (map.comparator() != null && map.comparator() != Ordering.natural() && range.hasLowerBound() && range.hasUpperBound()) {
            Preconditions.checkArgument(map.comparator().compare(range.lowerEndpoint(), range.upperEndpoint()) <= 0, "map is using a custom comparator which is inconsistent with the natural ordering.");
        }
        if (range.hasLowerBound() && range.hasUpperBound()) {
            return map.subMap(range.lowerEndpoint(), range.lowerBoundType() == BoundType.CLOSED, range.upperEndpoint(), range.upperBoundType() == BoundType.CLOSED);
        }
        if (range.hasLowerBound()) {
            return map.tailMap(range.lowerEndpoint(), range.lowerBoundType() == BoundType.CLOSED);
        }
        if (range.hasUpperBound()) {
            void var1_1;
            return map.headMap(range.upperEndpoint(), var1_1.upperBoundType() == BoundType.CLOSED);
        }
        return Preconditions.checkNotNull(navigableMap);
    }

    @GwtIncompatible
    static abstract class DescendingMap<K, V>
    extends ForwardingMap<K, V>
    implements NavigableMap<K, V> {
        private transient Comparator<? super K> comparator;
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient NavigableSet<K> navigableKeySet;

        DescendingMap() {
        }

        abstract NavigableMap<K, V> forward();

        @Override
        protected final Map<K, V> delegate() {
            return this.forward();
        }

        @Override
        public Comparator<? super K> comparator() {
            Ordering<? super K> ordering;
            Comparator<? super K> result = this.comparator;
            if (result == null) {
                Comparator forwardCmp = this.forward().comparator();
                if (forwardCmp == null) {
                    forwardCmp = Ordering.natural();
                }
                this.comparator = DescendingMap.reverse(ordering);
                ordering = this.comparator;
            }
            return ordering;
        }

        private static <T> Ordering<T> reverse(Comparator<T> forward) {
            return Ordering.from(forward).reverse();
        }

        @Override
        @ParametricNullness
        public K firstKey() {
            return this.forward().lastKey();
        }

        @Override
        @ParametricNullness
        public K lastKey() {
            return this.forward().firstKey();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> lowerEntry(@ParametricNullness K key) {
            void var1_1;
            return this.forward().higherEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K lowerKey(@ParametricNullness K key) {
            void var1_1;
            return this.forward().higherKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> floorEntry(@ParametricNullness K key) {
            void var1_1;
            return this.forward().ceilingEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K floorKey(@ParametricNullness K key) {
            void var1_1;
            return this.forward().ceilingKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> ceilingEntry(@ParametricNullness K key) {
            void var1_1;
            return this.forward().floorEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K ceilingKey(@ParametricNullness K key) {
            void var1_1;
            return this.forward().floorKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> higherEntry(@ParametricNullness K key) {
            void var1_1;
            return this.forward().lowerEntry(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K higherKey(@ParametricNullness K key) {
            void var1_1;
            return this.forward().lowerKey(var1_1);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return this.forward().lastEntry();
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return this.forward().firstEntry();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return this.forward().pollLastEntry();
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return this.forward().pollFirstEntry();
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return this.forward();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            void var1_1;
            Set<Map.Entry<K, V>> result = this.entrySet;
            if (result == null) {
                this.entrySet = this.createEntrySet();
                return this.entrySet;
            }
            return var1_1;
        }

        abstract Iterator<Map.Entry<K, V>> entryIterator();

        Set<Map.Entry<K, V>> createEntrySet() {
            class EntrySetImpl
            extends EntrySet<K, V> {
                final /* synthetic */ DescendingMap this$0;

                /*
                 * WARNING - void declaration
                 */
                EntrySetImpl(DescendingMap this$0) {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                Map<K, V> map() {
                    return this.this$0;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return this.this$0.entryIterator();
                }
            }
            return new EntrySetImpl(this);
        }

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> navigableKeySet() {
            void var1_1;
            NavigableSet<K> result = this.navigableKeySet;
            if (result == null) {
                this.navigableKeySet = new NavigableKeySet(this);
                return this.navigableKeySet;
            }
            return var1_1;
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.forward().navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> subMap(@ParametricNullness K fromKey, boolean fromInclusive, @ParametricNullness K toKey, boolean toInclusive) {
            void var2_2;
            void var1_1;
            void var3_3;
            return this.forward().subMap(var3_3, toInclusive, var1_1, (boolean)var2_2).descendingMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
            void var2_2;
            void var1_1;
            return this.subMap(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> headMap(@ParametricNullness K toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.forward().tailMap(var1_1, (boolean)var2_2).descendingMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> headMap(@ParametricNullness K toKey) {
            void var1_1;
            return this.headMap(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> tailMap(@ParametricNullness K fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.forward().headMap(var1_1, (boolean)var2_2).descendingMap();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> tailMap(@ParametricNullness K fromKey) {
            void var1_1;
            return this.tailMap(var1_1, true);
        }

        @Override
        public Collection<V> values() {
            return new Values(this);
        }

        @Override
        public String toString() {
            return this.standardToString();
        }
    }

    static abstract class EntrySet<K, V>
    extends Sets.ImprovedAbstractSet<Map.Entry<K, V>> {
        EntrySet() {
        }

        abstract Map<K, V> map();

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            if (o instanceof Map.Entry) {
                void var2_2;
                void var3_3;
                void var1_1;
                Map.Entry entry = (Map.Entry)o;
                Object key = entry.getKey();
                V value = Maps.safeGet(this.map(), key);
                return com.google.common.base.Objects.equal(value, var1_1.getValue()) && (var3_3 != null || this.map().containsKey(var2_2));
            }
            return false;
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            if (this.contains(o) && o instanceof Map.Entry) {
                void var1_1;
                Map.Entry entry = (Map.Entry)o;
                return this.map().keySet().remove(var1_1.getKey());
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            try {
                return super.removeAll(Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var1_1;
                return Sets.removeAllImpl(this, var1_1.iterator());
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            try {
                return super.retainAll(Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var2_2;
                Iterator iterator;
                HashSet keys = Sets.newHashSetWithExpectedSize(c.size());
                iterator = iterator.iterator();
                while (iterator.hasNext()) {
                    void var3_3;
                    Object o = iterator.next();
                    if (!this.contains(o) || !(o instanceof Map.Entry)) continue;
                    Map.Entry entry = (Map.Entry)o;
                    keys.add(var3_3.getKey());
                }
                return this.map().keySet().retainAll((Collection<?>)var2_2);
            }
        }
    }

    static class Values<K, V>
    extends AbstractCollection<V> {
        final Map<K, V> map;

        /*
         * WARNING - void declaration
         */
        Values(Map<K, V> map) {
            void var1_1;
            this.map = (Map)Preconditions.checkNotNull(var1_1);
        }

        final Map<K, V> map() {
            return this.map;
        }

        @Override
        public Iterator<V> iterator() {
            return Maps.valueIterator(this.map().entrySet().iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(Consumer<? super V> action) {
            void var1_1;
            Preconditions.checkNotNull(action);
            this.map.forEach((arg_0, arg_1) -> Values.lambda$forEach$0((Consumer)var1_1, arg_0, arg_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            try {
                return super.remove(o);
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    void var3_3;
                    if (!com.google.common.base.Objects.equal(o, entry.getValue())) continue;
                    this.map().remove(var3_3.getKey());
                    return true;
                }
                return false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeAll(Collection<?> c) {
            try {
                return super.removeAll(Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var2_2;
                HashSet<K> toRemove = Sets.newHashSet();
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!c.contains(entry.getValue())) continue;
                    toRemove.add(entry.getKey());
                }
                return this.map().keySet().removeAll((Collection<?>)var2_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean retainAll(Collection<?> c) {
            try {
                return super.retainAll(Preconditions.checkNotNull(c));
            }
            catch (UnsupportedOperationException unsupportedOperationException) {
                void var2_2;
                HashSet<K> toRetain = Sets.newHashSet();
                for (Map.Entry<K, V> entry : this.map().entrySet()) {
                    if (!c.contains(entry.getValue())) continue;
                    toRetain.add(entry.getKey());
                }
                return this.map().keySet().retainAll((Collection<?>)var2_2);
            }
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.map().containsValue(var1_1);
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$forEach$0(Consumer action, Object k, Object v) {
            void var2_2;
            action.accept(var2_2);
        }
    }

    @GwtIncompatible
    static class NavigableKeySet<K, V>
    extends SortedKeySet<K, V>
    implements NavigableSet<K> {
        /*
         * WARNING - void declaration
         */
        NavigableKeySet(NavigableMap<K, V> map) {
            super(var1_1);
            void var1_1;
        }

        @Override
        NavigableMap<K, V> map() {
            return (NavigableMap)this.map;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K lower(@ParametricNullness K e) {
            void var1_1;
            return this.map().lowerKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K floor(@ParametricNullness K e) {
            void var1_1;
            return this.map().floorKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K ceiling(@ParametricNullness K e) {
            void var1_1;
            return this.map().ceilingKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K higher(@ParametricNullness K e) {
            void var1_1;
            return this.map().higherKey(var1_1);
        }

        @Override
        public K pollFirst() {
            return Maps.keyOrNull(this.map().pollFirstEntry());
        }

        @Override
        public K pollLast() {
            return Maps.keyOrNull(this.map().pollLastEntry());
        }

        @Override
        public NavigableSet<K> descendingSet() {
            return this.map().descendingKeySet();
        }

        @Override
        public Iterator<K> descendingIterator() {
            return this.descendingSet().iterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> subSet(@ParametricNullness K fromElement, boolean fromInclusive, @ParametricNullness K toElement, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.map().subMap(var1_1, (boolean)var2_2, var3_3, toInclusive).navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> subSet(@ParametricNullness K fromElement, @ParametricNullness K toElement) {
            void var2_2;
            void var1_1;
            return this.subSet(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> headSet(@ParametricNullness K toElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.map().headMap(var1_1, (boolean)var2_2).navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> headSet(@ParametricNullness K toElement) {
            void var1_1;
            return this.headSet(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableSet<K> tailSet(@ParametricNullness K fromElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.map().tailMap(var1_1, (boolean)var2_2).navigableKeySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> tailSet(@ParametricNullness K fromElement) {
            void var1_1;
            return this.tailSet(var1_1, true);
        }
    }

    static class SortedKeySet<K, V>
    extends KeySet<K, V>
    implements SortedSet<K> {
        /*
         * WARNING - void declaration
         */
        SortedKeySet(SortedMap<K, V> map) {
            super(var1_1);
            void var1_1;
        }

        @Override
        SortedMap<K, V> map() {
            return (SortedMap)super.map();
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.map().comparator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> subSet(@ParametricNullness K fromElement, @ParametricNullness K toElement) {
            void var2_2;
            void var1_1;
            return new SortedKeySet(this.map().subMap(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> headSet(@ParametricNullness K toElement) {
            void var1_1;
            return new SortedKeySet(this.map().headMap(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedSet<K> tailSet(@ParametricNullness K fromElement) {
            void var1_1;
            return new SortedKeySet(this.map().tailMap(var1_1));
        }

        @Override
        @ParametricNullness
        public K first() {
            return this.map().firstKey();
        }

        @Override
        @ParametricNullness
        public K last() {
            return this.map().lastKey();
        }
    }

    static class KeySet<K, V>
    extends Sets.ImprovedAbstractSet<K> {
        final Map<K, V> map;

        /*
         * WARNING - void declaration
         */
        KeySet(Map<K, V> map) {
            void var1_1;
            this.map = (Map)Preconditions.checkNotNull(var1_1);
        }

        Map<K, V> map() {
            return this.map;
        }

        @Override
        public Iterator<K> iterator() {
            return Maps.keyIterator(this.map().entrySet().iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(Consumer<? super K> action) {
            void var1_1;
            Preconditions.checkNotNull(action);
            this.map.forEach((arg_0, arg_1) -> KeySet.lambda$forEach$0((Consumer)var1_1, arg_0, arg_1));
        }

        @Override
        public int size() {
            return this.map().size();
        }

        @Override
        public boolean isEmpty() {
            return this.map().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.map().containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean remove(Object o) {
            if (this.contains(o)) {
                void var1_1;
                this.map().remove(var1_1);
                return true;
            }
            return false;
        }

        @Override
        public void clear() {
            this.map().clear();
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$forEach$0(Consumer action, Object k, Object v) {
            void var1_1;
            action.accept(var1_1);
        }
    }

    static abstract class IteratorBasedAbstractMap<K, V>
    extends AbstractMap<K, V> {
        IteratorBasedAbstractMap() {
        }

        @Override
        public abstract int size();

        abstract Iterator<Map.Entry<K, V>> entryIterator();

        Spliterator<Map.Entry<K, V>> entrySpliterator() {
            return Spliterators.spliterator(this.entryIterator(), (long)this.size(), 65);
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return new EntrySet<K, V>(this){
                final /* synthetic */ IteratorBasedAbstractMap this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                Map<K, V> map() {
                    return this.this$0;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return this.this$0.entryIterator();
                }

                @Override
                public Spliterator<Map.Entry<K, V>> spliterator() {
                    return this.this$0.entrySpliterator();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void forEach(Consumer<? super Map.Entry<K, V>> action) {
                    void var1_1;
                    this.this$0.forEachEntry(var1_1);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        void forEachEntry(Consumer<? super Map.Entry<K, V>> action) {
            void var1_1;
            this.entryIterator().forEachRemaining((Consumer<Map.Entry<K, V>>)var1_1);
        }

        @Override
        public void clear() {
            Iterators.clear(this.entryIterator());
        }
    }

    @GwtCompatible
    static abstract class ViewCachingAbstractMap<K, V>
    extends AbstractMap<K, V> {
        private transient Set<Map.Entry<K, V>> entrySet;
        private transient Set<K> keySet;
        private transient Collection<V> values;

        ViewCachingAbstractMap() {
        }

        abstract Set<Map.Entry<K, V>> createEntrySet();

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            void var1_1;
            Set<Map.Entry<K, V>> result = this.entrySet;
            if (result == null) {
                this.entrySet = this.createEntrySet();
                return this.entrySet;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<K> keySet() {
            void var1_1;
            Set<K> result = this.keySet;
            if (result == null) {
                this.keySet = this.createKeySet();
                return this.keySet;
            }
            return var1_1;
        }

        Set<K> createKeySet() {
            return new KeySet(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Collection<V> values() {
            void var1_1;
            Collection<V> result = this.values;
            if (result == null) {
                this.values = this.createValues();
                return this.values;
            }
            return var1_1;
        }

        Collection<V> createValues() {
            return new Values(this);
        }
    }

    @GwtIncompatible
    static class UnmodifiableNavigableMap<K, V>
    extends ForwardingSortedMap<K, V>
    implements Serializable,
    NavigableMap<K, V> {
        private final NavigableMap<K, ? extends V> delegate;
        private transient UnmodifiableNavigableMap<K, V> descendingMap;

        /*
         * WARNING - void declaration
         */
        UnmodifiableNavigableMap(NavigableMap<K, ? extends V> delegate) {
            void var1_1;
            this.delegate = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        UnmodifiableNavigableMap(NavigableMap<K, ? extends V> delegate, UnmodifiableNavigableMap<K, V> descendingMap) {
            void var2_2;
            void var1_1;
            this.delegate = var1_1;
            this.descendingMap = var2_2;
        }

        @Override
        protected SortedMap<K, V> delegate() {
            return Collections.unmodifiableSortedMap(this.delegate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> lowerEntry(@ParametricNullness K key) {
            void var1_1;
            return Maps.unmodifiableOrNull(this.delegate.lowerEntry(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K lowerKey(@ParametricNullness K key) {
            void var1_1;
            return this.delegate.lowerKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> floorEntry(@ParametricNullness K key) {
            void var1_1;
            return Maps.unmodifiableOrNull(this.delegate.floorEntry(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K floorKey(@ParametricNullness K key) {
            void var1_1;
            return this.delegate.floorKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> ceilingEntry(@ParametricNullness K key) {
            void var1_1;
            return Maps.unmodifiableOrNull(this.delegate.ceilingEntry(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K ceilingKey(@ParametricNullness K key) {
            void var1_1;
            return this.delegate.ceilingKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V> higherEntry(@ParametricNullness K key) {
            void var1_1;
            return Maps.unmodifiableOrNull(this.delegate.higherEntry(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K higherKey(@ParametricNullness K key) {
            void var1_1;
            return this.delegate.higherKey(var1_1);
        }

        @Override
        public Map.Entry<K, V> firstEntry() {
            return Maps.unmodifiableOrNull(this.delegate.firstEntry());
        }

        @Override
        public Map.Entry<K, V> lastEntry() {
            return Maps.unmodifiableOrNull(this.delegate.lastEntry());
        }

        @Override
        public final Map.Entry<K, V> pollFirstEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final Map.Entry<K, V> pollLastEntry() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K key, java.util.function.Function<? super K, ? extends V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> descendingMap() {
            void var1_1;
            UnmodifiableNavigableMap<K, V> result = this.descendingMap;
            if (result == null) {
                this.descendingMap = new UnmodifiableNavigableMap<K, V>(this.delegate.descendingMap(), this);
                return this.descendingMap;
            }
            return var1_1;
        }

        @Override
        public Set<K> keySet() {
            return this.navigableKeySet();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return Sets.unmodifiableNavigableSet(this.delegate.navigableKeySet());
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return Sets.unmodifiableNavigableSet(this.delegate.descendingKeySet());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
            void var2_2;
            void var1_1;
            return this.subMap(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> subMap(@ParametricNullness K fromKey, boolean fromInclusive, @ParametricNullness K toKey, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return Maps.unmodifiableNavigableMap(this.delegate.subMap(var1_1, (boolean)var2_2, var3_3, toInclusive));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> headMap(@ParametricNullness K toKey) {
            void var1_1;
            return this.headMap(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> headMap(@ParametricNullness K toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Maps.unmodifiableNavigableMap(this.delegate.headMap(var1_1, (boolean)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> tailMap(@ParametricNullness K fromKey) {
            void var1_1;
            return this.tailMap(var1_1, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> tailMap(@ParametricNullness K fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Maps.unmodifiableNavigableMap(this.delegate.tailMap(var1_1, (boolean)var2_2));
        }
    }

    static final class FilteredEntryBiMap<K, V>
    extends FilteredEntryMap<K, V>
    implements BiMap<K, V> {
        private final BiMap<V, K> inverse;

        private static <K, V> Predicate<Map.Entry<V, K>> inversePredicate(Predicate<? super Map.Entry<K, V>> forwardPredicate) {
            Predicate<? super Map.Entry<K, V>> predicate;
            return new Predicate<Map.Entry<V, K>>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean apply(Map.Entry<V, K> input) {
                    void var1_1;
                    return predicate.apply(Maps.immutableEntry(input.getValue(), var1_1.getKey()));
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        FilteredEntryBiMap(BiMap<K, V> delegate, Predicate<? super Map.Entry<K, V>> predicate) {
            super(delegate, predicate);
            void var2_2;
            void var1_1;
            this.inverse = new FilteredEntryBiMap<K, V>(var1_1.inverse(), FilteredEntryBiMap.inversePredicate(var2_2), this);
        }

        /*
         * WARNING - void declaration
         */
        private FilteredEntryBiMap(BiMap<K, V> delegate, Predicate<? super Map.Entry<K, V>> predicate, BiMap<V, K> inverse) {
            super(var1_1, var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.inverse = var3_3;
        }

        final BiMap<K, V> unfiltered() {
            return (BiMap)this.unfiltered;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V forcePut(@ParametricNullness K key, @ParametricNullness V value) {
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(this.apply(key, value));
            return this.unfiltered().forcePut(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            void var1_1;
            this.unfiltered().replaceAll((arg_0, arg_1) -> this.lambda$replaceAll$0((BiFunction)var1_1, arg_0, arg_1));
        }

        @Override
        public final BiMap<V, K> inverse() {
            return this.inverse;
        }

        @Override
        public final Set<V> values() {
            return this.inverse.keySet();
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ Object lambda$replaceAll$0(BiFunction function, Object key, Object value) {
            void var3_3;
            if (this.predicate.apply(Maps.immutableEntry(key, value))) {
                void var2_2;
                void var1_1;
                return var1_1.apply(var2_2, value);
            }
            return var3_3;
        }
    }

    @GwtIncompatible
    private static class FilteredEntryNavigableMap<K, V>
    extends AbstractNavigableMap<K, V> {
        private final NavigableMap<K, V> unfiltered;
        private final Predicate<? super Map.Entry<K, V>> entryPredicate;
        private final Map<K, V> filteredDelegate;

        /*
         * WARNING - void declaration
         */
        FilteredEntryNavigableMap(NavigableMap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
            void var2_2;
            void var1_1;
            this.unfiltered = Preconditions.checkNotNull(unfiltered);
            this.entryPredicate = entryPredicate;
            this.filteredDelegate = new FilteredEntryMap(var1_1, var2_2);
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.unfiltered.comparator();
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            FilteredEntryNavigableMap filteredEntryNavigableMap = this;
            return new NavigableKeySet<K, V>(filteredEntryNavigableMap, filteredEntryNavigableMap){
                final /* synthetic */ FilteredEntryNavigableMap this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean removeAll(Collection<?> collection) {
                    void var1_1;
                    return FilteredEntryMap.removeAllKeys(this.this$0.unfiltered, this.this$0.entryPredicate, var1_1);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public boolean retainAll(Collection<?> collection) {
                    void var1_1;
                    return FilteredEntryMap.retainAllKeys(this.this$0.unfiltered, this.this$0.entryPredicate, var1_1);
                }
            };
        }

        @Override
        public Collection<V> values() {
            FilteredEntryNavigableMap filteredEntryNavigableMap = this;
            return new FilteredMapValues<K, V>(filteredEntryNavigableMap, filteredEntryNavigableMap.unfiltered, this.entryPredicate);
        }

        @Override
        Iterator<Map.Entry<K, V>> entryIterator() {
            return Iterators.filter(this.unfiltered.entrySet().iterator(), this.entryPredicate);
        }

        @Override
        Iterator<Map.Entry<K, V>> descendingEntryIterator() {
            return Iterators.filter(this.unfiltered.descendingMap().entrySet().iterator(), this.entryPredicate);
        }

        @Override
        public int size() {
            return this.filteredDelegate.size();
        }

        @Override
        public boolean isEmpty() {
            return !Iterables.any(this.unfiltered.entrySet(), this.entryPredicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object key) {
            void var1_1;
            return this.filteredDelegate.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.filteredDelegate.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(@ParametricNullness K key, @ParametricNullness V value) {
            void var2_2;
            void var1_1;
            return this.filteredDelegate.put(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V remove(Object key) {
            void var1_1;
            return this.filteredDelegate.remove(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> m) {
            void var1_1;
            this.filteredDelegate.putAll((Map<K, V>)var1_1);
        }

        @Override
        public void clear() {
            this.filteredDelegate.clear();
        }

        @Override
        public Set<Map.Entry<K, V>> entrySet() {
            return this.filteredDelegate.entrySet();
        }

        @Override
        public Map.Entry<K, V> pollFirstEntry() {
            return Iterables.removeFirstMatching(this.unfiltered.entrySet(), this.entryPredicate);
        }

        @Override
        public Map.Entry<K, V> pollLastEntry() {
            return Iterables.removeFirstMatching(this.unfiltered.descendingMap().entrySet(), this.entryPredicate);
        }

        @Override
        public NavigableMap<K, V> descendingMap() {
            return Maps.filterEntries(this.unfiltered.descendingMap(), this.entryPredicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> subMap(@ParametricNullness K fromKey, boolean fromInclusive, @ParametricNullness K toKey, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return Maps.filterEntries(this.unfiltered.subMap(var1_1, (boolean)var2_2, var3_3, toInclusive), this.entryPredicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> headMap(@ParametricNullness K toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Maps.filterEntries(this.unfiltered.headMap(var1_1, (boolean)var2_2), this.entryPredicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V> tailMap(@ParametricNullness K fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Maps.filterEntries(this.unfiltered.tailMap(var1_1, (boolean)var2_2), this.entryPredicate);
        }
    }

    private static class FilteredEntrySortedMap<K, V>
    extends FilteredEntryMap<K, V>
    implements SortedMap<K, V> {
        /*
         * WARNING - void declaration
         */
        FilteredEntrySortedMap(SortedMap<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        SortedMap<K, V> sortedMap() {
            return (SortedMap)this.unfiltered;
        }

        @Override
        public SortedSet<K> keySet() {
            return (SortedSet)super.keySet();
        }

        @Override
        SortedSet<K> createKeySet() {
            return new SortedKeySet();
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.sortedMap().comparator();
        }

        @Override
        @ParametricNullness
        public K firstKey() {
            return (K)this.keySet().iterator().next();
        }

        @Override
        @ParametricNullness
        public K lastKey() {
            SortedMap<K, V> headMap = this.sortedMap();
            K key;
            while (!this.apply(key = headMap.lastKey(), NullnessCasts.uncheckedCastNullableTToT(this.unfiltered.get(key)))) {
                SortedMap<void, V> sortedMap;
                sortedMap = this.sortedMap().headMap((void)sortedMap);
            }
            return key;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> headMap(@ParametricNullness K toKey) {
            void var1_1;
            return new FilteredEntrySortedMap<void, V>(this.sortedMap().headMap(var1_1), this.predicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
            void var2_2;
            void var1_1;
            return new FilteredEntrySortedMap<void, V>(this.sortedMap().subMap(var1_1, var2_2), this.predicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> tailMap(@ParametricNullness K fromKey) {
            void var1_1;
            return new FilteredEntrySortedMap<void, V>(this.sortedMap().tailMap(var1_1), this.predicate);
        }

        class SortedKeySet
        extends FilteredEntryMap.KeySet
        implements SortedSet<K> {
            /*
             * WARNING - void declaration
             */
            SortedKeySet() {
                void var1_1;
            }

            @Override
            public Comparator<? super K> comparator() {
                return FilteredEntrySortedMap.this.sortedMap().comparator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public SortedSet<K> subSet(@ParametricNullness K fromElement, @ParametricNullness K toElement) {
                void var2_2;
                void var1_1;
                return (SortedSet)FilteredEntrySortedMap.this.subMap(var1_1, var2_2).keySet();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public SortedSet<K> headSet(@ParametricNullness K toElement) {
                void var1_1;
                return (SortedSet)FilteredEntrySortedMap.this.headMap(var1_1).keySet();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public SortedSet<K> tailSet(@ParametricNullness K fromElement) {
                void var1_1;
                return (SortedSet)FilteredEntrySortedMap.this.tailMap(var1_1).keySet();
            }

            @Override
            @ParametricNullness
            public K first() {
                return FilteredEntrySortedMap.this.firstKey();
            }

            @Override
            @ParametricNullness
            public K last() {
                return FilteredEntrySortedMap.this.lastKey();
            }
        }
    }

    static class FilteredEntryMap<K, V>
    extends AbstractFilteredMap<K, V> {
        final Set<Map.Entry<K, V>> filteredEntrySet;

        /*
         * WARNING - void declaration
         */
        FilteredEntryMap(Map<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> entryPredicate) {
            super(unfiltered, var2_2);
            void var1_1;
            void var2_2;
            this.filteredEntrySet = Sets.filter(var1_1.entrySet(), this.predicate);
        }

        @Override
        protected Set<Map.Entry<K, V>> createEntrySet() {
            return new EntrySet();
        }

        @Override
        Set<K> createKeySet() {
            return new KeySet();
        }

        /*
         * WARNING - void declaration
         */
        static <K, V> boolean removeAllKeys(Map<K, V> map, Predicate<? super Map.Entry<K, V>> entryPredicate, Collection<?> keyCollection) {
            void var3_3;
            Iterator<Map.Entry<K, V>> entryItr = map.entrySet().iterator();
            boolean result = false;
            while (entryItr.hasNext()) {
                Map.Entry entry = (Map.Entry)entryItr.next();
                if (!entryPredicate.apply(entry) || !keyCollection.contains(entry.getKey())) continue;
                entryItr.remove();
                result = true;
            }
            return (boolean)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        static <K, V> boolean retainAllKeys(Map<K, V> map, Predicate<? super Map.Entry<K, V>> entryPredicate, Collection<?> keyCollection) {
            void var3_3;
            Iterator<Map.Entry<K, V>> entryItr = map.entrySet().iterator();
            boolean result = false;
            while (entryItr.hasNext()) {
                Map.Entry entry = (Map.Entry)entryItr.next();
                if (!entryPredicate.apply(entry) || keyCollection.contains(entry.getKey())) continue;
                entryItr.remove();
                result = true;
            }
            return (boolean)var3_3;
        }

        class KeySet
        extends com.google.common.collect.Maps$KeySet<K, V> {
            /*
             * WARNING - void declaration
             */
            KeySet() {
                void var1_1;
                super(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object o) {
                if (FilteredEntryMap.this.containsKey(o)) {
                    void var1_1;
                    FilteredEntryMap.this.unfiltered.remove(var1_1);
                    return true;
                }
                return false;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean removeAll(Collection<?> collection) {
                void var1_1;
                return FilteredEntryMap.removeAllKeys(FilteredEntryMap.this.unfiltered, FilteredEntryMap.this.predicate, var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean retainAll(Collection<?> collection) {
                void var1_1;
                return FilteredEntryMap.retainAllKeys(FilteredEntryMap.this.unfiltered, FilteredEntryMap.this.predicate, var1_1);
            }

            @Override
            public Object[] toArray() {
                return Lists.newArrayList(this.iterator()).toArray();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public <T> T[] toArray(T[] array) {
                void var1_1;
                return Lists.newArrayList(this.iterator()).toArray((T[])var1_1);
            }
        }

        private class EntrySet
        extends ForwardingSet<Map.Entry<K, V>> {
            private EntrySet() {
            }

            @Override
            protected Set<Map.Entry<K, V>> delegate() {
                return FilteredEntryMap.this.filteredEntrySet;
            }

            @Override
            public Iterator<Map.Entry<K, V>> iterator() {
                EntrySet entrySet = this;
                return new TransformedIterator<Map.Entry<K, V>, Map.Entry<K, V>>(entrySet, entrySet.FilteredEntryMap.this.filteredEntrySet.iterator()){
                    final /* synthetic */ EntrySet this$1;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$1 = var1_1;
                        super(var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    Map.Entry<K, V> transform(Map.Entry<K, V> entry) {
                        void var1_1;
                        return new ForwardingMapEntry<K, V>(this, (Map.Entry)var1_1){
                            final /* synthetic */ Map.Entry val$entry;
                            final /* synthetic */ 1 this$2;
                            {
                                void var1_1;
                                this.this$2 = var1_1;
                                this.val$entry = entry;
                            }

                            @Override
                            protected Map.Entry<K, V> delegate() {
                                return this.val$entry;
                            }

                            /*
                             * WARNING - void declaration
                             */
                            @Override
                            @ParametricNullness
                            public V setValue(@ParametricNullness V newValue) {
                                void var1_1;
                                Preconditions.checkArgument(this.this$2.this$1.FilteredEntryMap.this.apply(this.getKey(), newValue));
                                return super.setValue(var1_1);
                            }
                        };
                    }
                };
            }
        }
    }

    private static class FilteredKeyMap<K, V>
    extends AbstractFilteredMap<K, V> {
        final Predicate<? super K> keyPredicate;

        /*
         * WARNING - void declaration
         */
        FilteredKeyMap(Map<K, V> unfiltered, Predicate<? super K> keyPredicate, Predicate<? super Map.Entry<K, V>> entryPredicate) {
            super(var1_1, var3_3);
            void var2_2;
            void var3_3;
            void var1_1;
            this.keyPredicate = var2_2;
        }

        @Override
        protected Set<Map.Entry<K, V>> createEntrySet() {
            return Sets.filter(this.unfiltered.entrySet(), this.predicate);
        }

        @Override
        Set<K> createKeySet() {
            return Sets.filter(this.unfiltered.keySet(), this.keyPredicate);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.unfiltered.containsKey(key) && this.keyPredicate.apply(var1_1);
        }
    }

    private static final class FilteredMapValues<K, V>
    extends Values<K, V> {
        final Map<K, V> unfiltered;
        final Predicate<? super Map.Entry<K, V>> predicate;

        /*
         * WARNING - void declaration
         */
        FilteredMapValues(Map<K, V> filteredMap, Map<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
            super(var1_1);
            void var3_3;
            void var2_2;
            void var1_1;
            this.unfiltered = var2_2;
            this.predicate = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            Iterator<Map.Entry<K, V>> entryItr = this.unfiltered.entrySet().iterator();
            while (entryItr.hasNext()) {
                void var3_3;
                Map.Entry<K, V> entry = entryItr.next();
                if (!this.predicate.apply(entry) || !com.google.common.base.Objects.equal(var3_3.getValue(), o)) continue;
                entryItr.remove();
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean removeAll(Collection<?> collection) {
            void var3_3;
            Iterator<Map.Entry<K, V>> entryItr = this.unfiltered.entrySet().iterator();
            boolean result = false;
            while (entryItr.hasNext()) {
                Map.Entry<K, V> entry = entryItr.next();
                if (!this.predicate.apply(entry) || !collection.contains(entry.getValue())) continue;
                entryItr.remove();
                result = true;
            }
            return (boolean)var3_3;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean retainAll(Collection<?> collection) {
            void var3_3;
            Iterator<Map.Entry<K, V>> entryItr = this.unfiltered.entrySet().iterator();
            boolean result = false;
            while (entryItr.hasNext()) {
                Map.Entry<K, V> entry = entryItr.next();
                if (!this.predicate.apply(entry) || collection.contains(entry.getValue())) continue;
                entryItr.remove();
                result = true;
            }
            return (boolean)var3_3;
        }

        @Override
        public final Object[] toArray() {
            return Lists.newArrayList(this.iterator()).toArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T[] toArray(T[] array) {
            void var1_1;
            return Lists.newArrayList(this.iterator()).toArray((T[])var1_1);
        }
    }

    private static abstract class AbstractFilteredMap<K, V>
    extends ViewCachingAbstractMap<K, V> {
        final Map<K, V> unfiltered;
        final Predicate<? super Map.Entry<K, V>> predicate;

        /*
         * WARNING - void declaration
         */
        AbstractFilteredMap(Map<K, V> unfiltered, Predicate<? super Map.Entry<K, V>> predicate) {
            void var2_2;
            void var1_1;
            this.unfiltered = var1_1;
            this.predicate = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        boolean apply(Object key, @ParametricNullness V value) {
            void var2_2;
            void var1_1;
            Object k = key;
            return this.predicate.apply(Maps.immutableEntry(var1_1, var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V put(@ParametricNullness K key, @ParametricNullness V value) {
            void var2_2;
            void var1_1;
            Preconditions.checkArgument(this.apply(key, value));
            return this.unfiltered.put(var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void putAll(Map<? extends K, ? extends V> map) {
            void var1_1;
            for (Map.Entry<K, V> entry : map.entrySet()) {
                void var3_3;
                Preconditions.checkArgument(this.apply(entry.getKey(), var3_3.getValue()));
            }
            this.unfiltered.putAll((Map<K, V>)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.unfiltered.containsKey(key) && this.apply(key, this.unfiltered.get(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object key) {
            void var1_1;
            V value = this.unfiltered.get(key);
            if (value != null && this.apply(var1_1, value)) {
                void var2_2;
                return var2_2;
            }
            return null;
        }

        @Override
        public boolean isEmpty() {
            return this.entrySet().isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V remove(Object key) {
            if (this.containsKey(key)) {
                void var1_1;
                return this.unfiltered.remove(var1_1);
            }
            return null;
        }

        @Override
        Collection<V> createValues() {
            AbstractFilteredMap abstractFilteredMap = this;
            return new FilteredMapValues<K, V>(abstractFilteredMap, abstractFilteredMap.unfiltered, this.predicate);
        }
    }

    @GwtIncompatible
    private static class TransformedEntriesNavigableMap<K, V1, V2>
    extends TransformedEntriesSortedMap<K, V1, V2>
    implements NavigableMap<K, V2> {
        /*
         * WARNING - void declaration
         */
        TransformedEntriesNavigableMap(NavigableMap<K, V1> fromMap, EntryTransformer<? super K, ? super V1, V2> transformer) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V2> ceilingEntry(@ParametricNullness K key) {
            void var1_1;
            TransformedEntriesNavigableMap transformedEntriesNavigableMap = this;
            return transformedEntriesNavigableMap.transformEntry(transformedEntriesNavigableMap.fromMap().ceilingEntry(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K ceilingKey(@ParametricNullness K key) {
            void var1_1;
            return this.fromMap().ceilingKey(var1_1);
        }

        @Override
        public NavigableSet<K> descendingKeySet() {
            return this.fromMap().descendingKeySet();
        }

        @Override
        public NavigableMap<K, V2> descendingMap() {
            return Maps.transformEntries(this.fromMap().descendingMap(), this.transformer);
        }

        @Override
        public Map.Entry<K, V2> firstEntry() {
            TransformedEntriesNavigableMap transformedEntriesNavigableMap = this;
            return transformedEntriesNavigableMap.transformEntry(transformedEntriesNavigableMap.fromMap().firstEntry());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V2> floorEntry(@ParametricNullness K key) {
            void var1_1;
            TransformedEntriesNavigableMap transformedEntriesNavigableMap = this;
            return transformedEntriesNavigableMap.transformEntry(transformedEntriesNavigableMap.fromMap().floorEntry(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K floorKey(@ParametricNullness K key) {
            void var1_1;
            return this.fromMap().floorKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V2> headMap(@ParametricNullness K toKey) {
            void var1_1;
            return this.headMap(var1_1, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V2> headMap(@ParametricNullness K toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Maps.transformEntries(this.fromMap().headMap(var1_1, (boolean)var2_2), this.transformer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V2> higherEntry(@ParametricNullness K key) {
            void var1_1;
            TransformedEntriesNavigableMap transformedEntriesNavigableMap = this;
            return transformedEntriesNavigableMap.transformEntry(transformedEntriesNavigableMap.fromMap().higherEntry(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K higherKey(@ParametricNullness K key) {
            void var1_1;
            return this.fromMap().higherKey(var1_1);
        }

        @Override
        public Map.Entry<K, V2> lastEntry() {
            TransformedEntriesNavigableMap transformedEntriesNavigableMap = this;
            return transformedEntriesNavigableMap.transformEntry(transformedEntriesNavigableMap.fromMap().lastEntry());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Map.Entry<K, V2> lowerEntry(@ParametricNullness K key) {
            void var1_1;
            TransformedEntriesNavigableMap transformedEntriesNavigableMap = this;
            return transformedEntriesNavigableMap.transformEntry(transformedEntriesNavigableMap.fromMap().lowerEntry(var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public K lowerKey(@ParametricNullness K key) {
            void var1_1;
            return this.fromMap().lowerKey(var1_1);
        }

        @Override
        public NavigableSet<K> navigableKeySet() {
            return this.fromMap().navigableKeySet();
        }

        @Override
        public Map.Entry<K, V2> pollFirstEntry() {
            TransformedEntriesNavigableMap transformedEntriesNavigableMap = this;
            return transformedEntriesNavigableMap.transformEntry(transformedEntriesNavigableMap.fromMap().pollFirstEntry());
        }

        @Override
        public Map.Entry<K, V2> pollLastEntry() {
            TransformedEntriesNavigableMap transformedEntriesNavigableMap = this;
            return transformedEntriesNavigableMap.transformEntry(transformedEntriesNavigableMap.fromMap().pollLastEntry());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V2> subMap(@ParametricNullness K fromKey, boolean fromInclusive, @ParametricNullness K toKey, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return Maps.transformEntries(this.fromMap().subMap(var1_1, (boolean)var2_2, var3_3, toInclusive), this.transformer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V2> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
            void var2_2;
            void var1_1;
            return this.subMap(var1_1, true, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V2> tailMap(@ParametricNullness K fromKey) {
            void var1_1;
            return this.tailMap(var1_1, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public NavigableMap<K, V2> tailMap(@ParametricNullness K fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Maps.transformEntries(this.fromMap().tailMap(var1_1, (boolean)var2_2), this.transformer);
        }

        /*
         * WARNING - void declaration
         */
        private Map.Entry<K, V2> transformEntry(Map.Entry<K, V1> entry) {
            void var1_1;
            if (entry == null) {
                return null;
            }
            return Maps.transformEntry(this.transformer, var1_1);
        }

        @Override
        protected NavigableMap<K, V1> fromMap() {
            return (NavigableMap)super.fromMap();
        }
    }

    static class TransformedEntriesSortedMap<K, V1, V2>
    extends TransformedEntriesMap<K, V1, V2>
    implements SortedMap<K, V2> {
        protected SortedMap<K, V1> fromMap() {
            return (SortedMap)this.fromMap;
        }

        /*
         * WARNING - void declaration
         */
        TransformedEntriesSortedMap(SortedMap<K, V1> fromMap, EntryTransformer<? super K, ? super V1, V2> transformer) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.fromMap().comparator();
        }

        @Override
        @ParametricNullness
        public K firstKey() {
            return this.fromMap().firstKey();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V2> headMap(@ParametricNullness K toKey) {
            void var1_1;
            return Maps.transformEntries(this.fromMap().headMap(var1_1), this.transformer);
        }

        @Override
        @ParametricNullness
        public K lastKey() {
            return this.fromMap().lastKey();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V2> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
            void var2_2;
            void var1_1;
            return Maps.transformEntries(this.fromMap().subMap(var1_1, var2_2), this.transformer);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V2> tailMap(@ParametricNullness K fromKey) {
            void var1_1;
            return Maps.transformEntries(this.fromMap().tailMap(var1_1), this.transformer);
        }
    }

    static class TransformedEntriesMap<K, V1, V2>
    extends IteratorBasedAbstractMap<K, V2> {
        final Map<K, V1> fromMap;
        final EntryTransformer<? super K, ? super V1, V2> transformer;

        /*
         * WARNING - void declaration
         */
        TransformedEntriesMap(Map<K, V1> fromMap, EntryTransformer<? super K, ? super V1, V2> transformer) {
            void var2_2;
            void var1_1;
            this.fromMap = (Map)Preconditions.checkNotNull(var1_1);
            this.transformer = (EntryTransformer)Preconditions.checkNotNull(var2_2);
        }

        @Override
        public int size() {
            return this.fromMap.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.fromMap.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V2 get(Object key) {
            void var1_1;
            return this.getOrDefault((Object)var1_1, (V2)null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V2 getOrDefault(Object key, V2 defaultValue) {
            void var2_2;
            V1 value = this.fromMap.get(key);
            if (value != null || this.fromMap.containsKey(key)) {
                void var3_3;
                void var1_1;
                return this.transformer.transformEntry(var1_1, NullnessCasts.uncheckedCastNullableTToT(var3_3));
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V2 remove(Object key) {
            if (this.fromMap.containsKey(key)) {
                void var1_1;
                return this.transformer.transformEntry(key, NullnessCasts.uncheckedCastNullableTToT(this.fromMap.remove(var1_1)));
            }
            return null;
        }

        @Override
        public void clear() {
            this.fromMap.clear();
        }

        @Override
        public Set<K> keySet() {
            return this.fromMap.keySet();
        }

        @Override
        Iterator<Map.Entry<K, V2>> entryIterator() {
            return Iterators.transform(this.fromMap.entrySet().iterator(), Maps.asEntryToEntryFunction(this.transformer));
        }

        @Override
        Spliterator<Map.Entry<K, V2>> entrySpliterator() {
            return CollectSpliterators.map(this.fromMap.entrySet().spliterator(), Maps.asEntryToEntryFunction(this.transformer));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(BiConsumer<? super K, ? super V2> action) {
            void var1_1;
            Preconditions.checkNotNull(action);
            this.fromMap.forEach((arg_0, arg_1) -> this.lambda$forEach$0((BiConsumer)var1_1, arg_0, arg_1));
        }

        @Override
        public Collection<V2> values() {
            return new Values(this);
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$forEach$0(BiConsumer action, Object k, Object v1) {
            void var3_3;
            void var2_2;
            action.accept(k, this.transformer.transformEntry(var2_2, var3_3));
        }
    }

    @FunctionalInterface
    public static interface EntryTransformer<K, V1, V2> {
        public V2 transformEntry(@ParametricNullness K var1, @ParametricNullness V1 var2);
    }

    private static class UnmodifiableBiMap<K, V>
    extends ForwardingMap<K, V>
    implements BiMap<K, V>,
    Serializable {
        final Map<K, V> unmodifiableMap;
        final BiMap<? extends K, ? extends V> delegate;
        BiMap<V, K> inverse;
        transient Set<V> values;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        UnmodifiableBiMap(BiMap<? extends K, ? extends V> delegate, BiMap<V, K> inverse) {
            void var2_2;
            void var1_1;
            this.unmodifiableMap = Collections.unmodifiableMap(delegate);
            this.delegate = var1_1;
            this.inverse = var2_2;
        }

        @Override
        protected Map<K, V> delegate() {
            return this.unmodifiableMap;
        }

        @Override
        public V forcePut(@ParametricNullness K key, @ParametricNullness V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V putIfAbsent(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean replace(K key, V oldValue, V newValue) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V replace(K key, V value) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfAbsent(K key, java.util.function.Function<? super K, ? extends V> mappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        @Override
        public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public BiMap<V, K> inverse() {
            void var1_1;
            BiMap<V, K> result = this.inverse;
            if (result == null) {
                this.inverse = new UnmodifiableBiMap<K, V>(this.delegate.inverse(), this);
                return this.inverse;
            }
            return var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Set<V> values() {
            void var1_1;
            Set<V> result = this.values;
            if (result == null) {
                this.values = Collections.unmodifiableSet(this.delegate.values());
                return this.values;
            }
            return var1_1;
        }
    }

    private static final class BiMapConverter<A, B>
    extends Converter<A, B>
    implements Serializable {
        private final BiMap<A, B> bimap;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        BiMapConverter(BiMap<A, B> bimap) {
            void var1_1;
            this.bimap = (BiMap)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final B doForward(A a) {
            void var1_1;
            return BiMapConverter.convert(this.bimap, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected final A doBackward(B b) {
            void var1_1;
            return BiMapConverter.convert(this.bimap.inverse(), var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private static <X, Y> Y convert(BiMap<X, Y> bimap, X input) {
            BiMap<Object, Object> biMap;
            void var1_1;
            BiMap<Object, Object> output = bimap.get(input);
            Preconditions.checkArgument(output != null, "No non-null mapping present for input: %s", (Object)var1_1);
            return (Y)biMap;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            if (object instanceof BiMapConverter) {
                void var1_1;
                BiMapConverter that = (BiMapConverter)object;
                return this.bimap.equals(var1_1.bimap);
            }
            return false;
        }

        public final int hashCode() {
            return this.bimap.hashCode();
        }

        public final String toString() {
            String string = String.valueOf(this.bimap);
            return new StringBuilder(18 + String.valueOf(string).length()).append("Maps.asConverter(").append(string).append(")").toString();
        }
    }

    static class UnmodifiableEntrySet<K, V>
    extends UnmodifiableEntries<K, V>
    implements Set<Map.Entry<K, V>> {
        /*
         * WARNING - void declaration
         */
        UnmodifiableEntrySet(Set<Map.Entry<K, V>> entries) {
            super(var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            void var1_1;
            return Sets.equalsImpl(this, var1_1);
        }

        @Override
        public int hashCode() {
            return Sets.hashCodeImpl(this);
        }
    }

    static class UnmodifiableEntries<K, V>
    extends ForwardingCollection<Map.Entry<K, V>> {
        private final Collection<Map.Entry<K, V>> entries;

        /*
         * WARNING - void declaration
         */
        UnmodifiableEntries(Collection<Map.Entry<K, V>> entries) {
            void var1_1;
            this.entries = var1_1;
        }

        @Override
        protected Collection<Map.Entry<K, V>> delegate() {
            return this.entries;
        }

        @Override
        public Iterator<Map.Entry<K, V>> iterator() {
            return Maps.unmodifiableEntryIterator(this.entries.iterator());
        }

        @Override
        public Object[] toArray() {
            Object[] objectArray = this.standardToArray();
            return objectArray;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] array) {
            void var1_1;
            return this.standardToArray((T[])var1_1);
        }
    }

    @GwtIncompatible
    private static final class NavigableAsMapView<K, V>
    extends AbstractNavigableMap<K, V> {
        private final NavigableSet<K> set;
        private final Function<? super K, V> function;

        /*
         * WARNING - void declaration
         */
        NavigableAsMapView(NavigableSet<K> ks, Function<? super K, V> vFunction) {
            void var2_2;
            void var1_1;
            this.set = (NavigableSet)Preconditions.checkNotNull(var1_1);
            this.function = (Function)Preconditions.checkNotNull(var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<K, V> subMap(@ParametricNullness K fromKey, boolean fromInclusive, @ParametricNullness K toKey, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            return Maps.asMap(this.set.subSet(var1_1, (boolean)var2_2, var3_3, toInclusive), this.function);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<K, V> headMap(@ParametricNullness K toKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Maps.asMap(this.set.headSet(var1_1, (boolean)var2_2), this.function);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final NavigableMap<K, V> tailMap(@ParametricNullness K fromKey, boolean inclusive) {
            void var2_2;
            void var1_1;
            return Maps.asMap(this.set.tailSet(var1_1, (boolean)var2_2), this.function);
        }

        @Override
        public final Comparator<? super K> comparator() {
            return this.set.comparator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V get(Object key) {
            void var1_1;
            return this.getOrDefault(var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V getOrDefault(Object key, V defaultValue) {
            void var2_2;
            if (Collections2.safeContains(this.set, key)) {
                void var1_1;
                return this.function.apply(var1_1);
            }
            return var2_2;
        }

        @Override
        public final void clear() {
            this.set.clear();
        }

        @Override
        final Iterator<Map.Entry<K, V>> entryIterator() {
            return Maps.asMapEntryIterator(this.set, this.function);
        }

        @Override
        final Spliterator<Map.Entry<K, V>> entrySpliterator() {
            return CollectSpliterators.map(this.set.spliterator(), e -> {
                void var1_1;
                return Maps.immutableEntry(e, this.function.apply(var1_1));
            });
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void forEach(BiConsumer<? super K, ? super V> action) {
            void var1_1;
            this.set.forEach(arg_0 -> this.lambda$forEach$1((BiConsumer)var1_1, arg_0));
        }

        @Override
        final Iterator<Map.Entry<K, V>> descendingEntryIterator() {
            return this.descendingMap().entrySet().iterator();
        }

        @Override
        public final NavigableSet<K> navigableKeySet() {
            return Maps.removeOnlyNavigableSet(this.set);
        }

        @Override
        public final int size() {
            return this.set.size();
        }

        @Override
        public final NavigableMap<K, V> descendingMap() {
            return Maps.asMap(this.set.descendingSet(), this.function);
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$forEach$1(BiConsumer action, Object k) {
            void var2_2;
            action.accept(k, this.function.apply(var2_2));
        }
    }

    private static class SortedAsMapView<K, V>
    extends AsMapView<K, V>
    implements SortedMap<K, V> {
        /*
         * WARNING - void declaration
         */
        SortedAsMapView(SortedSet<K> set, Function<? super K, V> function) {
            super(var1_1, var2_2);
            void var2_2;
            void var1_1;
        }

        @Override
        SortedSet<K> backingSet() {
            return (SortedSet)super.backingSet();
        }

        @Override
        public Comparator<? super K> comparator() {
            return this.backingSet().comparator();
        }

        @Override
        public Set<K> keySet() {
            return Maps.removeOnlySortedSet((SortedSet)this.backingSet());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
            void var2_2;
            void var1_1;
            return Maps.asMap(this.backingSet().subSet(var1_1, var2_2), this.function);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> headMap(@ParametricNullness K toKey) {
            void var1_1;
            return Maps.asMap(this.backingSet().headSet(var1_1), this.function);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public SortedMap<K, V> tailMap(@ParametricNullness K fromKey) {
            void var1_1;
            return Maps.asMap(this.backingSet().tailSet(var1_1), this.function);
        }

        @Override
        @ParametricNullness
        public K firstKey() {
            return (K)this.backingSet().first();
        }

        @Override
        @ParametricNullness
        public K lastKey() {
            return (K)this.backingSet().last();
        }
    }

    private static class AsMapView<K, V>
    extends ViewCachingAbstractMap<K, V> {
        private final Set<K> set;
        final Function<? super K, V> function;

        Set<K> backingSet() {
            return this.set;
        }

        /*
         * WARNING - void declaration
         */
        AsMapView(Set<K> set, Function<? super K, V> function) {
            void var2_2;
            void var1_1;
            this.set = (Set)Preconditions.checkNotNull(var1_1);
            this.function = (Function)Preconditions.checkNotNull(var2_2);
        }

        @Override
        public Set<K> createKeySet() {
            return Maps.removeOnlySet(this.backingSet());
        }

        @Override
        Collection<V> createValues() {
            return Collections2.transform(this.set, this.function);
        }

        @Override
        public int size() {
            return this.backingSet().size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean containsKey(Object key) {
            void var1_1;
            return this.backingSet().contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V get(Object key) {
            void var1_1;
            return this.getOrDefault(var1_1, null);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V getOrDefault(Object key, V defaultValue) {
            void var2_2;
            if (Collections2.safeContains(this.backingSet(), key)) {
                void var1_1;
                return this.function.apply(var1_1);
            }
            return var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public V remove(Object key) {
            if (this.backingSet().remove(key)) {
                void var1_1;
                return this.function.apply(var1_1);
            }
            return null;
        }

        @Override
        public void clear() {
            this.backingSet().clear();
        }

        @Override
        protected Set<Map.Entry<K, V>> createEntrySet() {
            class EntrySetImpl
            extends EntrySet<K, V> {
                final /* synthetic */ AsMapView this$0;

                /*
                 * WARNING - void declaration
                 */
                EntrySetImpl(AsMapView this$0) {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                Map<K, V> map() {
                    return this.this$0;
                }

                @Override
                public Iterator<Map.Entry<K, V>> iterator() {
                    return Maps.asMapEntryIterator(this.this$0.backingSet(), this.this$0.function);
                }
            }
            return new EntrySetImpl(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void forEach(BiConsumer<? super K, ? super V> action) {
            void var1_1;
            Preconditions.checkNotNull(action);
            this.backingSet().forEach(arg_0 -> this.lambda$forEach$0((BiConsumer)var1_1, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ void lambda$forEach$0(BiConsumer action, Object k) {
            void var2_2;
            action.accept(k, this.function.apply(var2_2));
        }
    }

    static class SortedMapDifferenceImpl<K, V>
    extends MapDifferenceImpl<K, V>
    implements SortedMapDifference<K, V> {
        /*
         * WARNING - void declaration
         */
        SortedMapDifferenceImpl(SortedMap<K, V> onlyOnLeft, SortedMap<K, V> onlyOnRight, SortedMap<K, V> onBoth, SortedMap<K, MapDifference.ValueDifference<V>> differences) {
            super(var1_1, var2_2, var3_3, differences);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public SortedMap<K, MapDifference.ValueDifference<V>> entriesDiffering() {
            return (SortedMap)super.entriesDiffering();
        }

        @Override
        public SortedMap<K, V> entriesInCommon() {
            return (SortedMap)super.entriesInCommon();
        }

        @Override
        public SortedMap<K, V> entriesOnlyOnLeft() {
            return (SortedMap)super.entriesOnlyOnLeft();
        }

        @Override
        public SortedMap<K, V> entriesOnlyOnRight() {
            return (SortedMap)super.entriesOnlyOnRight();
        }
    }

    static class ValueDifferenceImpl<V>
    implements MapDifference.ValueDifference<V> {
        @ParametricNullness
        private final V left;
        @ParametricNullness
        private final V right;

        /*
         * WARNING - void declaration
         */
        static <V> MapDifference.ValueDifference<V> create(@ParametricNullness V left, @ParametricNullness V right) {
            void var1_1;
            V v;
            return new ValueDifferenceImpl<void>((void)v, var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private ValueDifferenceImpl(@ParametricNullness V left, @ParametricNullness V right) {
            void var2_2;
            void var1_1;
            this.left = var1_1;
            this.right = var2_2;
        }

        @Override
        @ParametricNullness
        public V leftValue() {
            return this.left;
        }

        @Override
        @ParametricNullness
        public V rightValue() {
            return this.right;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            if (object instanceof MapDifference.ValueDifference) {
                void var1_1;
                MapDifference.ValueDifference that = (MapDifference.ValueDifference)object;
                return com.google.common.base.Objects.equal(this.left, that.leftValue()) && com.google.common.base.Objects.equal(this.right, var1_1.rightValue());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.left, this.right);
        }

        public String toString() {
            String string = String.valueOf(this.left);
            String string2 = String.valueOf(this.right);
            return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length()).append("(").append(string).append(", ").append(string2).append(")").toString();
        }
    }

    static class MapDifferenceImpl<K, V>
    implements MapDifference<K, V> {
        final Map<K, V> onlyOnLeft;
        final Map<K, V> onlyOnRight;
        final Map<K, V> onBoth;
        final Map<K, MapDifference.ValueDifference<V>> differences;

        /*
         * WARNING - void declaration
         */
        MapDifferenceImpl(Map<K, V> onlyOnLeft, Map<K, V> onlyOnRight, Map<K, V> onBoth, Map<K, MapDifference.ValueDifference<V>> differences) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.onlyOnLeft = Maps.unmodifiableMap((Map)var1_1);
            this.onlyOnRight = Maps.unmodifiableMap((Map)var2_2);
            this.onBoth = Maps.unmodifiableMap((Map)var3_3);
            this.differences = Maps.unmodifiableMap(differences);
        }

        @Override
        public boolean areEqual() {
            return this.onlyOnLeft.isEmpty() && this.onlyOnRight.isEmpty() && this.differences.isEmpty();
        }

        @Override
        public Map<K, V> entriesOnlyOnLeft() {
            return this.onlyOnLeft;
        }

        @Override
        public Map<K, V> entriesOnlyOnRight() {
            return this.onlyOnRight;
        }

        @Override
        public Map<K, V> entriesInCommon() {
            return this.onBoth;
        }

        @Override
        public Map<K, MapDifference.ValueDifference<V>> entriesDiffering() {
            return this.differences;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (object instanceof MapDifference) {
                void var1_1;
                MapDifference other = (MapDifference)object;
                return this.entriesOnlyOnLeft().equals(other.entriesOnlyOnLeft()) && this.entriesOnlyOnRight().equals(other.entriesOnlyOnRight()) && this.entriesInCommon().equals(other.entriesInCommon()) && this.entriesDiffering().equals(var1_1.entriesDiffering());
            }
            return false;
        }

        @Override
        public int hashCode() {
            return com.google.common.base.Objects.hashCode(this.entriesOnlyOnLeft(), this.entriesOnlyOnRight(), this.entriesInCommon(), this.entriesDiffering());
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            if (this.areEqual()) {
                return "equal";
            }
            StringBuilder result = new StringBuilder("not equal");
            if (!this.onlyOnLeft.isEmpty()) {
                result.append(": only on left=").append(this.onlyOnLeft);
            }
            if (!this.onlyOnRight.isEmpty()) {
                result.append(": only on right=").append(this.onlyOnRight);
            }
            if (!this.differences.isEmpty()) {
                result.append(": value differences=").append(this.differences);
            }
            return var1_1.toString();
        }
    }

    private static enum EntryFunction implements Function<Map.Entry<?, ?>, Object>
    {
        KEY{

            @Override
            public final Object apply(Map.Entry<?, ?> entry) {
                return entry.getKey();
            }
        }
        ,
        VALUE{

            @Override
            public final Object apply(Map.Entry<?, ?> entry) {
                return entry.getValue();
            }
        };

    }
}

