/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ForwardingConcurrentMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.MapMaker;
import com.google.common.primitives.Ints;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReferenceArray;
import java.util.concurrent.locks.ReentrantLock;

@GwtIncompatible
class MapMakerInternalMap<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>>
extends AbstractMap<K, V>
implements Serializable,
ConcurrentMap<K, V> {
    static final int MAXIMUM_CAPACITY = 0x40000000;
    static final int MAX_SEGMENTS = 65536;
    static final int CONTAINS_VALUE_RETRIES = 3;
    static final int DRAIN_THRESHOLD = 63;
    static final int DRAIN_MAX = 16;
    static final long CLEANUP_EXECUTOR_DELAY_SECS = 60L;
    final transient int segmentMask;
    final transient int segmentShift;
    final transient Segment<K, V, E, S>[] segments;
    final int concurrencyLevel;
    final Equivalence<Object> keyEquivalence;
    final transient InternalEntryHelper<K, V, E, S> entryHelper;
    static final WeakValueReference<Object, Object, DummyInternalEntry> UNSET_WEAK_VALUE_REFERENCE = new WeakValueReference<Object, Object, DummyInternalEntry>(){

        @Override
        public DummyInternalEntry getEntry() {
            return null;
        }

        @Override
        public void clear() {
        }

        @Override
        public Object get() {
            return null;
        }

        @Override
        public WeakValueReference<Object, Object, DummyInternalEntry> copyFor(ReferenceQueue<Object> queue, DummyInternalEntry entry) {
            return this;
        }
    };
    transient Set<K> keySet;
    transient Collection<V> values;
    transient Set<Map.Entry<K, V>> entrySet;
    private static final long serialVersionUID = 5L;

    /*
     * WARNING - void declaration
     */
    private MapMakerInternalMap(MapMaker builder, InternalEntryHelper<K, V, E, S> entryHelper) {
        int segmentSize;
        void var3_5;
        int segmentCount;
        this.concurrencyLevel = Math.min(builder.getConcurrencyLevel(), 65536);
        this.keyEquivalence = builder.getKeyEquivalence();
        this.entryHelper = entryHelper;
        int initialCapacity = Math.min(builder.getInitialCapacity(), 0x40000000);
        int segmentShift = 0;
        for (segmentCount = 1; segmentCount < this.concurrencyLevel; segmentCount <<= 1) {
            ++segmentShift;
        }
        this.segmentShift = 32 - segmentShift;
        this.segmentMask = segmentCount - 1;
        this.segments = this.newSegmentArray(segmentCount);
        int segmentCapacity = initialCapacity / segmentCount;
        if (segmentCapacity * var3_5 < initialCapacity) {
            ++segmentCapacity;
        }
        for (segmentSize = 1; segmentSize < segmentCapacity; segmentSize <<= 1) {
        }
        for (int i = 0; i < this.segments.length; ++i) {
            this.segments[i] = this.createSegment(segmentSize, -1);
        }
    }

    static <K, V> MapMakerInternalMap<K, V, ? extends InternalEntry<K, V, ?>, ?> create(MapMaker builder) {
        if (builder.getKeyStrength() == Strength.STRONG && builder.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(builder, StrongKeyStrongValueEntry.Helper.instance());
        }
        if (builder.getKeyStrength() == Strength.STRONG && builder.getValueStrength() == Strength.WEAK) {
            return new MapMakerInternalMap(builder, StrongKeyWeakValueEntry.Helper.instance());
        }
        if (builder.getKeyStrength() == Strength.WEAK && builder.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(builder, WeakKeyStrongValueEntry.Helper.instance());
        }
        if (builder.getKeyStrength() == Strength.WEAK && builder.getValueStrength() == Strength.WEAK) {
            MapMaker mapMaker;
            return new MapMakerInternalMap(mapMaker, WeakKeyWeakValueEntry.Helper.instance());
        }
        throw new AssertionError();
    }

    static <K> MapMakerInternalMap<K, MapMaker.Dummy, ? extends InternalEntry<K, MapMaker.Dummy, ?>, ?> createWithDummyValues(MapMaker builder) {
        MapMaker mapMaker;
        if (builder.getKeyStrength() == Strength.STRONG && builder.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(builder, StrongKeyDummyValueEntry.Helper.instance());
        }
        if (builder.getKeyStrength() == Strength.WEAK && builder.getValueStrength() == Strength.STRONG) {
            return new MapMakerInternalMap(builder, WeakKeyDummyValueEntry.Helper.instance());
        }
        if (mapMaker.getValueStrength() == Strength.WEAK) {
            throw new IllegalArgumentException("Map cannot have both weak and dummy values");
        }
        throw new AssertionError();
    }

    static <K, V, E extends InternalEntry<K, V, E>> WeakValueReference<K, V, E> unsetWeakValueReference() {
        return UNSET_WEAK_VALUE_REFERENCE;
    }

    static int rehash(int h) {
        int n;
        int n2 = h;
        h = n2 + (n2 << 15 ^ 0xFFFFCD7D);
        h ^= h >>> 10;
        h += h << 3;
        h ^= h >>> 6;
        h += (h << 2) + (h << 14);
        return h ^ n >>> 16;
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    E copyEntry(E original, E newNext) {
        void var2_2;
        void var1_1;
        void var3_3;
        int hash = original.getHash();
        return this.segmentFor((int)var3_3).copyEntry(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    int hash(Object key) {
        void var1_1;
        int n = this.keyEquivalence.hash(var1_1);
        return MapMakerInternalMap.rehash(n);
    }

    /*
     * WARNING - void declaration
     */
    void reclaimValue(WeakValueReference<K, V, E> valueReference) {
        void var1_1;
        void var3_3;
        void var2_2;
        E entry = valueReference.getEntry();
        int hash = entry.getHash();
        this.segmentFor(hash).reclaimValue(var2_2.getKey(), (int)var3_3, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    void reclaimKey(E entry) {
        void var2_2;
        void var1_1;
        int hash = entry.getHash();
        this.segmentFor(hash).reclaimKey(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    boolean isLiveForTesting(InternalEntry<K, V, ?> entry) {
        void var1_1;
        return this.segmentFor(entry.getHash()).getLiveValueForTesting((InternalEntry<K, V, ?>)var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    Segment<K, V, E, S> segmentFor(int hash) {
        void var1_1;
        return this.segments[var1_1 >>> this.segmentShift & this.segmentMask];
    }

    /*
     * WARNING - void declaration
     */
    Segment<K, V, E, S> createSegment(int initialCapacity, int maxSegmentSize) {
        void var2_2;
        void var1_1;
        return this.entryHelper.newSegment(this, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    V getLiveValue(E entry) {
        void var1_1;
        if (entry.getKey() == null) {
            return null;
        }
        return var1_1.getValue();
    }

    final Segment<K, V, E, S>[] newSegmentArray(int ssize) {
        return new Segment[ssize];
    }

    @VisibleForTesting
    Strength keyStrength() {
        return this.entryHelper.keyStrength();
    }

    @VisibleForTesting
    Strength valueStrength() {
        return this.entryHelper.valueStrength();
    }

    @VisibleForTesting
    Equivalence<Object> valueEquivalence() {
        return this.entryHelper.valueStrength().defaultEquivalence();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isEmpty() {
        int i;
        long sum = 0L;
        Segment<K, V, E, S>[] segments = this.segments;
        for (i = 0; i < segments.length; ++i) {
            if (segments[i].count != 0) {
                return false;
            }
            sum += (long)segments[i].modCount;
        }
        if (sum != 0L) {
            void var1_1;
            for (i = 0; i < segments.length; ++i) {
                if (segments[i].count != 0) {
                    return false;
                }
                sum -= (long)segments[i].modCount;
            }
            return var1_1 == 0L;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int size() {
        void var2_2;
        Segment<K, V, E, S>[] segments = this.segments;
        long sum = 0L;
        for (int i = 0; i < segments.length; ++i) {
            sum += (long)segments[i].count;
        }
        return Ints.saturatedCast((long)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).get(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    E getEntry(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).getEntry(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).containsKey(var1_1, (int)var2_2);
    }

    @Override
    public boolean containsValue(Object value) {
        if (value == null) {
            return false;
        }
        Segment<K, V, E, S>[] segments = this.segments;
        long last = -1L;
        for (int i = 0; i < 3; ++i) {
            long sum = 0L;
            Segment<K, V, E, S>[] segmentArray = segments;
            int n = segments.length;
            for (int j = 0; j < n; ++j) {
                Segment<K, V, InternalEntry, S> segment = segmentArray[j];
                int cfr_ignored_0 = segment.count;
                AtomicReferenceArray table = segment.table;
                for (int j2 = 0; j2 < table.length(); ++j2) {
                    for (InternalEntry e = (InternalEntry)table.get(j2); e != null; e = e.getNext()) {
                        V v = segment.getLiveValue(e);
                        if (v == null || !this.valueEquivalence().equivalent(value, v)) continue;
                        return true;
                    }
                }
                sum += (long)segment.modCount;
            }
            if (sum == last) break;
            last = sum;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(var1_1, (int)var3_3, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V putIfAbsent(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).put(var1_1, (int)var3_3, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> m) {
        for (Map.Entry<K, V> e : m.entrySet()) {
            void var2_2;
            this.put(e.getKey(), var2_2.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object key) {
        void var2_2;
        void var1_1;
        if (key == null) {
            return null;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object key, Object value) {
        void var2_2;
        void var3_3;
        void var1_1;
        if (key == null || value == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).remove(var1_1, (int)var3_3, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean replace(K key, V oldValue, V newValue) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(newValue);
        if (oldValue == null) {
            return false;
        }
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(var1_1, hash, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V replace(K key, V value) {
        void var2_2;
        void var3_3;
        void var1_1;
        Preconditions.checkNotNull(key);
        Preconditions.checkNotNull(value);
        int hash = this.hash(key);
        return this.segmentFor(hash).replace(var1_1, (int)var3_3, var2_2);
    }

    @Override
    public void clear() {
        Segment<K, V, E, S>[] segmentArray = this.segments;
        int n = this.segments.length;
        for (int i = 0; i < n; ++i) {
            Segment<K, V, E, S> segment = segmentArray[i];
            segment.clear();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<K> keySet() {
        Set<K> ks = this.keySet;
        if (ks != null) {
            void var1_1;
            return var1_1;
        }
        this.keySet = new KeySet(this);
        return this.keySet;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Collection<V> values() {
        Collection<V> vs = this.values;
        if (vs != null) {
            void var1_1;
            return var1_1;
        }
        this.values = new Values(this);
        return this.values;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        Set<Map.Entry<K, V>> es = this.entrySet;
        if (es != null) {
            void var1_1;
            return var1_1;
        }
        this.entrySet = new EntrySet(this);
        return this.entrySet;
    }

    /*
     * WARNING - void declaration
     */
    private static <E> ArrayList<E> toArrayList(Collection<E> c) {
        void var1_1;
        Collection<E> collection;
        ArrayList result = new ArrayList(c.size());
        Iterators.addAll(result, collection.iterator());
        return var1_1;
    }

    Object writeReplace() {
        return new SerializationProxy(this.entryHelper.keyStrength(), this.entryHelper.valueStrength(), this.keyEquivalence, this.entryHelper.valueStrength().defaultEquivalence(), this.concurrencyLevel, this);
    }

    private static final class SerializationProxy<K, V>
    extends AbstractSerializationProxy<K, V> {
        private static final long serialVersionUID = 3L;

        /*
         * WARNING - void declaration
         */
        SerializationProxy(Strength keyStrength, Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, int concurrencyLevel, ConcurrentMap<K, V> delegate) {
            super((Strength)var1_1, (Strength)var2_2, (Equivalence<Object>)var3_3, valueEquivalence, concurrencyLevel, delegate);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private void writeObject(ObjectOutputStream out) throws IOException {
            void var1_1;
            out.defaultWriteObject();
            this.writeMapTo((ObjectOutputStream)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
            void var1_1;
            void var2_2;
            in.defaultReadObject();
            MapMaker mapMaker = this.readMapMaker(in);
            this.delegate = var2_2.makeMap();
            this.readEntries((ObjectInputStream)var1_1);
        }

        private Object readResolve() {
            return this.delegate;
        }
    }

    static abstract class AbstractSerializationProxy<K, V>
    extends ForwardingConcurrentMap<K, V>
    implements Serializable {
        private static final long serialVersionUID = 3L;
        final Strength keyStrength;
        final Strength valueStrength;
        final Equivalence<Object> keyEquivalence;
        final Equivalence<Object> valueEquivalence;
        final int concurrencyLevel;
        transient ConcurrentMap<K, V> delegate;

        /*
         * WARNING - void declaration
         */
        AbstractSerializationProxy(Strength keyStrength, Strength valueStrength, Equivalence<Object> keyEquivalence, Equivalence<Object> valueEquivalence, int concurrencyLevel, ConcurrentMap<K, V> delegate) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.keyStrength = var1_1;
            this.valueStrength = var2_2;
            this.keyEquivalence = var3_3;
            this.valueEquivalence = valueEquivalence;
            this.concurrencyLevel = concurrencyLevel;
            this.delegate = delegate;
        }

        @Override
        protected ConcurrentMap<K, V> delegate() {
            return this.delegate;
        }

        /*
         * WARNING - void declaration
         */
        void writeMapTo(ObjectOutputStream out) throws IOException {
            void var1_1;
            out.writeInt(this.delegate.size());
            for (Map.Entry entry : this.delegate.entrySet()) {
                void var3_3;
                out.writeObject(entry.getKey());
                out.writeObject(var3_3.getValue());
            }
            var1_1.writeObject(null);
        }

        /*
         * WARNING - void declaration
         */
        MapMaker readMapMaker(ObjectInputStream in) throws IOException {
            void var1_2;
            int size = in.readInt();
            return new MapMaker().initialCapacity((int)var1_2).setKeyStrength(this.keyStrength).setValueStrength(this.valueStrength).keyEquivalence(this.keyEquivalence).concurrencyLevel(this.concurrencyLevel);
        }

        /*
         * WARNING - void declaration
         */
        void readEntries(ObjectInputStream in) throws IOException, ClassNotFoundException {
            Object key;
            while ((key = in.readObject()) != null) {
                void var3_3;
                void var2_2;
                Object value = in.readObject();
                this.delegate.put(var2_2, var3_3);
            }
        }
    }

    private static abstract class SafeToArraySet<E>
    extends AbstractSet<E> {
        private SafeToArraySet() {
        }

        @Override
        public Object[] toArray() {
            return MapMakerInternalMap.toArrayList(this).toArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public <T> T[] toArray(T[] a) {
            void var1_1;
            return MapMakerInternalMap.toArrayList(this).toArray((T[])var1_1);
        }
    }

    final class EntrySet
    extends SafeToArraySet<Map.Entry<K, V>> {
        final /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        EntrySet(MapMakerInternalMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final Iterator<Map.Entry<K, V>> iterator() {
            return new EntryIterator(this.this$0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var2_2;
            void var1_1;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            if (key == null) {
                return false;
            }
            Object v = this.this$0.get(key);
            return v != null && this.this$0.valueEquivalence().equivalent(var1_1.getValue(), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            void var2_2;
            if (!(o instanceof Map.Entry)) {
                return false;
            }
            Map.Entry e = (Map.Entry)o;
            Object key = e.getKey();
            return key != null && this.this$0.remove(var2_2, var1_1.getValue());
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class Values
    extends AbstractCollection<V> {
        final /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        Values(MapMakerInternalMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final Iterator<V> iterator() {
            return new ValueIterator(this.this$0);
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.this$0.containsValue(var1_1);
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }

        @Override
        public final Object[] toArray() {
            return MapMakerInternalMap.toArrayList(this).toArray();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final <T> T[] toArray(T[] a) {
            void var1_1;
            return MapMakerInternalMap.toArrayList(this).toArray((T[])var1_1);
        }
    }

    final class KeySet
    extends SafeToArraySet<K> {
        final /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        KeySet(MapMakerInternalMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        public final Iterator<K> iterator() {
            return new KeyIterator(this.this$0);
        }

        @Override
        public final int size() {
            return this.this$0.size();
        }

        @Override
        public final boolean isEmpty() {
            return this.this$0.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            void var1_1;
            return this.this$0.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean remove(Object o) {
            void var1_1;
            return this.this$0.remove(var1_1) != null;
        }

        @Override
        public final void clear() {
            this.this$0.clear();
        }
    }

    final class EntryIterator
    extends HashIterator<Map.Entry<K, V>> {
        /*
         * WARNING - void declaration
         */
        EntryIterator(MapMakerInternalMap this$0) {
            void var1_1;
        }

        @Override
        public final Map.Entry<K, V> next() {
            return this.nextEntry();
        }
    }

    final class WriteThroughEntry
    extends AbstractMapEntry<K, V> {
        final K key;
        V value;
        final /* synthetic */ MapMakerInternalMap this$0;

        /*
         * WARNING - void declaration
         */
        WriteThroughEntry(MapMakerInternalMap this$0, K key, V value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.key = var2_2;
            this.value = var3_3;
        }

        @Override
        public final K getKey() {
            return this.key;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean equals(Object object) {
            if (object instanceof Map.Entry) {
                void var1_1;
                Map.Entry that = (Map.Entry)object;
                return this.key.equals(that.getKey()) && this.value.equals(var1_1.getValue());
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return this.key.hashCode() ^ this.value.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final V setValue(V newValue) {
            void var2_2;
            void var1_1;
            Object oldValue = this.this$0.put(this.key, newValue);
            this.value = var1_1;
            return var2_2;
        }
    }

    final class ValueIterator
    extends HashIterator<V> {
        /*
         * WARNING - void declaration
         */
        ValueIterator(MapMakerInternalMap this$0) {
            void var1_1;
        }

        @Override
        public final V next() {
            return this.nextEntry().getValue();
        }
    }

    final class KeyIterator
    extends HashIterator<K> {
        /*
         * WARNING - void declaration
         */
        KeyIterator(MapMakerInternalMap this$0) {
            void var1_1;
        }

        @Override
        public final K next() {
            return this.nextEntry().getKey();
        }
    }

    abstract class HashIterator<T>
    implements Iterator<T> {
        int nextSegmentIndex;
        int nextTableIndex;
        Segment<K, V, E, S> currentSegment;
        AtomicReferenceArray<E> currentTable;
        E nextEntry;
        WriteThroughEntry nextExternal;
        WriteThroughEntry lastReturned;

        /*
         * WARNING - void declaration
         */
        HashIterator() {
            void var1_1;
            this.nextSegmentIndex = var1_1.segments.length - 1;
            this.nextTableIndex = -1;
            this.advance();
        }

        @Override
        public abstract T next();

        final void advance() {
            this.nextExternal = null;
            if (this.nextInChain()) {
                return;
            }
            if (this.nextInTable()) {
                return;
            }
            while (this.nextSegmentIndex >= 0) {
                this.currentSegment = MapMakerInternalMap.this.segments[this.nextSegmentIndex--];
                if (this.currentSegment.count == 0) continue;
                this.currentTable = this.currentSegment.table;
                this.nextTableIndex = this.currentTable.length() - 1;
                if (!this.nextInTable()) continue;
                return;
            }
        }

        boolean nextInChain() {
            if (this.nextEntry != null) {
                this.nextEntry = this.nextEntry.getNext();
                while (this.nextEntry != null) {
                    HashIterator hashIterator = this;
                    if (hashIterator.advanceTo(hashIterator.nextEntry)) {
                        return true;
                    }
                    this.nextEntry = this.nextEntry.getNext();
                }
            }
            return false;
        }

        boolean nextInTable() {
            while (this.nextTableIndex >= 0) {
                if ((this.nextEntry = (InternalEntry)this.currentTable.get(this.nextTableIndex--)) == null) continue;
                HashIterator hashIterator = this;
                if (!hashIterator.advanceTo(hashIterator.nextEntry) && !this.nextInChain()) continue;
                return true;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        boolean advanceTo(E entry) {
            try {
                Object key = entry.getKey();
                Object value = MapMakerInternalMap.this.getLiveValue(entry);
                if (value != null) {
                    void var1_1;
                    void var2_3;
                    this.nextExternal = new WriteThroughEntry(MapMakerInternalMap.this, var2_3, var1_1);
                    return true;
                }
                return false;
            }
            finally {
                this.currentSegment.postReadCleanup();
            }
        }

        @Override
        public boolean hasNext() {
            return this.nextExternal != null;
        }

        WriteThroughEntry nextEntry() {
            if (this.nextExternal == null) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextExternal;
            this.advance();
            return this.lastReturned;
        }

        @Override
        public void remove() {
            CollectPreconditions.checkRemove(this.lastReturned != null);
            MapMakerInternalMap.this.remove(this.lastReturned.getKey());
            this.lastReturned = null;
        }
    }

    static final class CleanupMapTask
    implements Runnable {
        final WeakReference<MapMakerInternalMap<?, ?, ?, ?>> mapReference;

        /*
         * WARNING - void declaration
         */
        public CleanupMapTask(MapMakerInternalMap<?, ?, ?, ?> map) {
            void var1_1;
            this.mapReference = new WeakReference<void>(var1_1);
        }

        @Override
        public final void run() {
            Segment<K, V, E, S>[] segmentArray;
            MapMakerInternalMap map = (MapMakerInternalMap)this.mapReference.get();
            if (map == null) {
                throw new CancellationException();
            }
            segmentArray = segmentArray.segments;
            int n = segmentArray.segments.length;
            for (int i = 0; i < n; ++i) {
                Segment segment = segmentArray[i];
                segment.runCleanup();
            }
        }
    }

    static final class WeakKeyDummyValueSegment<K>
    extends Segment<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();

        /*
         * WARNING - void declaration
         */
        WeakKeyDummyValueSegment(MapMakerInternalMap<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> map, int initialCapacity, int maxSegmentSize) {
            super(var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        final WeakKeyDummyValueSegment<K> self() {
            return this;
        }

        @Override
        final ReferenceQueue<K> getKeyReferenceQueueForTesting() {
            return this.queueForKeys;
        }

        @Override
        public final WeakKeyDummyValueEntry<K> castForTesting(InternalEntry<K, MapMaker.Dummy, ?> entry) {
            return (WeakKeyDummyValueEntry)entry;
        }

        @Override
        final void maybeDrainReferenceQueues() {
            WeakKeyDummyValueSegment weakKeyDummyValueSegment = this;
            weakKeyDummyValueSegment.drainKeyReferenceQueue(weakKeyDummyValueSegment.queueForKeys);
        }

        @Override
        final void maybeClearReferenceQueues() {
            WeakKeyDummyValueSegment weakKeyDummyValueSegment = this;
            weakKeyDummyValueSegment.clearReferenceQueue(weakKeyDummyValueSegment.queueForKeys);
        }
    }

    static final class WeakKeyWeakValueSegment<K, V>
    extends Segment<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();
        private final ReferenceQueue<V> queueForValues = new ReferenceQueue();

        /*
         * WARNING - void declaration
         */
        WeakKeyWeakValueSegment(MapMakerInternalMap<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> map, int initialCapacity, int maxSegmentSize) {
            super(var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        final WeakKeyWeakValueSegment<K, V> self() {
            return this;
        }

        @Override
        final ReferenceQueue<K> getKeyReferenceQueueForTesting() {
            return this.queueForKeys;
        }

        @Override
        final ReferenceQueue<V> getValueReferenceQueueForTesting() {
            return this.queueForValues;
        }

        @Override
        public final WeakKeyWeakValueEntry<K, V> castForTesting(InternalEntry<K, V, ?> entry) {
            return (WeakKeyWeakValueEntry)entry;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> getWeakValueReferenceForTesting(InternalEntry<K, V, ?> e) {
            void var1_1;
            return ((WeakKeyWeakValueEntry)this.castForTesting((InternalEntry)var1_1)).getValueReference();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> newWeakValueReferenceForTesting(InternalEntry<K, V, ?> e, V value) {
            void var1_1;
            void var2_2;
            return new WeakValueReferenceImpl(this.queueForValues, var2_2, this.castForTesting((InternalEntry)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setWeakValueReferenceForTesting(InternalEntry<K, V, ?> e, WeakValueReference<K, V, ? extends InternalEntry<K, V, ?>> valueReference) {
            void var3_3;
            void var2_2;
            void var1_1;
            InternalEntry entry = this.castForTesting((InternalEntry)e);
            WeakValueReference previous = ((WeakKeyWeakValueEntry)entry).valueReference;
            WeakKeyWeakValueEntry.access$702((WeakKeyWeakValueEntry)var1_1, (WeakValueReference)var2_2);
            var3_3.clear();
        }

        @Override
        final void maybeDrainReferenceQueues() {
            WeakKeyWeakValueSegment weakKeyWeakValueSegment = this;
            weakKeyWeakValueSegment.drainKeyReferenceQueue(weakKeyWeakValueSegment.queueForKeys);
            WeakKeyWeakValueSegment weakKeyWeakValueSegment2 = this;
            weakKeyWeakValueSegment2.drainValueReferenceQueue(weakKeyWeakValueSegment2.queueForValues);
        }

        @Override
        final void maybeClearReferenceQueues() {
            WeakKeyWeakValueSegment weakKeyWeakValueSegment = this;
            weakKeyWeakValueSegment.clearReferenceQueue(weakKeyWeakValueSegment.queueForKeys);
        }
    }

    static final class WeakKeyStrongValueSegment<K, V>
    extends Segment<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> {
        private final ReferenceQueue<K> queueForKeys = new ReferenceQueue();

        /*
         * WARNING - void declaration
         */
        WeakKeyStrongValueSegment(MapMakerInternalMap<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> map, int initialCapacity, int maxSegmentSize) {
            super(var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        final WeakKeyStrongValueSegment<K, V> self() {
            return this;
        }

        @Override
        final ReferenceQueue<K> getKeyReferenceQueueForTesting() {
            return this.queueForKeys;
        }

        @Override
        public final WeakKeyStrongValueEntry<K, V> castForTesting(InternalEntry<K, V, ?> entry) {
            return (WeakKeyStrongValueEntry)entry;
        }

        @Override
        final void maybeDrainReferenceQueues() {
            WeakKeyStrongValueSegment weakKeyStrongValueSegment = this;
            weakKeyStrongValueSegment.drainKeyReferenceQueue(weakKeyStrongValueSegment.queueForKeys);
        }

        @Override
        final void maybeClearReferenceQueues() {
            WeakKeyStrongValueSegment weakKeyStrongValueSegment = this;
            weakKeyStrongValueSegment.clearReferenceQueue(weakKeyStrongValueSegment.queueForKeys);
        }
    }

    static final class StrongKeyDummyValueSegment<K>
    extends Segment<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> {
        /*
         * WARNING - void declaration
         */
        StrongKeyDummyValueSegment(MapMakerInternalMap<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> map, int initialCapacity, int maxSegmentSize) {
            super(var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        final StrongKeyDummyValueSegment<K> self() {
            return this;
        }

        @Override
        public final StrongKeyDummyValueEntry<K> castForTesting(InternalEntry<K, MapMaker.Dummy, ?> entry) {
            return (StrongKeyDummyValueEntry)entry;
        }
    }

    static final class StrongKeyWeakValueSegment<K, V>
    extends Segment<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> {
        private final ReferenceQueue<V> queueForValues = new ReferenceQueue();

        /*
         * WARNING - void declaration
         */
        StrongKeyWeakValueSegment(MapMakerInternalMap<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> map, int initialCapacity, int maxSegmentSize) {
            super(var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        final StrongKeyWeakValueSegment<K, V> self() {
            return this;
        }

        @Override
        final ReferenceQueue<V> getValueReferenceQueueForTesting() {
            return this.queueForValues;
        }

        @Override
        public final StrongKeyWeakValueEntry<K, V> castForTesting(InternalEntry<K, V, ?> entry) {
            return (StrongKeyWeakValueEntry)entry;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> getWeakValueReferenceForTesting(InternalEntry<K, V, ?> e) {
            void var1_1;
            return ((StrongKeyWeakValueEntry)this.castForTesting((InternalEntry)var1_1)).getValueReference();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> newWeakValueReferenceForTesting(InternalEntry<K, V, ?> e, V value) {
            void var1_1;
            void var2_2;
            return new WeakValueReferenceImpl(this.queueForValues, var2_2, this.castForTesting((InternalEntry)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setWeakValueReferenceForTesting(InternalEntry<K, V, ?> e, WeakValueReference<K, V, ? extends InternalEntry<K, V, ?>> valueReference) {
            void var3_3;
            void var2_2;
            void var1_1;
            InternalEntry entry = this.castForTesting((InternalEntry)e);
            WeakValueReference previous = ((StrongKeyWeakValueEntry)entry).valueReference;
            StrongKeyWeakValueEntry.access$602((StrongKeyWeakValueEntry)var1_1, (WeakValueReference)var2_2);
            var3_3.clear();
        }

        @Override
        final void maybeDrainReferenceQueues() {
            StrongKeyWeakValueSegment strongKeyWeakValueSegment = this;
            strongKeyWeakValueSegment.drainValueReferenceQueue(strongKeyWeakValueSegment.queueForValues);
        }

        @Override
        final void maybeClearReferenceQueues() {
            StrongKeyWeakValueSegment strongKeyWeakValueSegment = this;
            strongKeyWeakValueSegment.clearReferenceQueue(strongKeyWeakValueSegment.queueForValues);
        }
    }

    static final class StrongKeyStrongValueSegment<K, V>
    extends Segment<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> {
        /*
         * WARNING - void declaration
         */
        StrongKeyStrongValueSegment(MapMakerInternalMap<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> map, int initialCapacity, int maxSegmentSize) {
            super(var1_1, (int)var2_2, (int)var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        final StrongKeyStrongValueSegment<K, V> self() {
            return this;
        }

        @Override
        public final StrongKeyStrongValueEntry<K, V> castForTesting(InternalEntry<K, V, ?> entry) {
            return (StrongKeyStrongValueEntry)entry;
        }
    }

    static abstract class Segment<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>>
    extends ReentrantLock {
        final MapMakerInternalMap<K, V, E, S> map;
        volatile int count;
        int modCount;
        int threshold;
        volatile AtomicReferenceArray<E> table;
        final int maxSegmentSize;
        final AtomicInteger readCount = new AtomicInteger();

        /*
         * WARNING - void declaration
         */
        Segment(MapMakerInternalMap<K, V, E, S> map, int initialCapacity, int maxSegmentSize) {
            void var2_2;
            void var3_3;
            void var1_1;
            this.map = var1_1;
            this.maxSegmentSize = var3_3;
            Segment segment = this;
            segment.initTable(segment.newEntryArray((int)var2_2));
        }

        abstract S self();

        void maybeDrainReferenceQueues() {
        }

        void maybeClearReferenceQueues() {
        }

        /*
         * WARNING - void declaration
         */
        void setValue(E entry, V value) {
            void var2_2;
            void var1_1;
            this.map.entryHelper.setValue(this.self(), var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        E copyEntry(E original, E newNext) {
            void var2_2;
            void var1_1;
            return this.map.entryHelper.copy(this.self(), var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        AtomicReferenceArray<E> newEntryArray(int size) {
            void var1_1;
            return new AtomicReferenceArray((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        void initTable(AtomicReferenceArray<E> newTable) {
            void var1_1;
            this.threshold = newTable.length() * 3 / 4;
            if (this.threshold == this.maxSegmentSize) {
                ++this.threshold;
            }
            this.table = var1_1;
        }

        abstract E castForTesting(InternalEntry<K, V, ?> var1);

        ReferenceQueue<K> getKeyReferenceQueueForTesting() {
            throw new AssertionError();
        }

        ReferenceQueue<V> getValueReferenceQueueForTesting() {
            throw new AssertionError();
        }

        WeakValueReference<K, V, E> getWeakValueReferenceForTesting(InternalEntry<K, V, ?> entry) {
            throw new AssertionError();
        }

        WeakValueReference<K, V, E> newWeakValueReferenceForTesting(InternalEntry<K, V, ?> entry, V value) {
            throw new AssertionError();
        }

        void setWeakValueReferenceForTesting(InternalEntry<K, V, ?> entry, WeakValueReference<K, V, ? extends InternalEntry<K, V, ?>> valueReference) {
            throw new AssertionError();
        }

        /*
         * WARNING - void declaration
         */
        void setTableEntryForTesting(int i, InternalEntry<K, V, ?> entry) {
            void var2_2;
            void var1_1;
            this.table.set((int)var1_1, this.castForTesting((InternalEntry<K, V, ?>)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        E copyForTesting(InternalEntry<K, V, ?> entry, InternalEntry<K, V, ?> newNext) {
            void var2_2;
            void var1_1;
            return this.map.entryHelper.copy(this.self(), this.castForTesting((InternalEntry<K, V, ?>)var1_1), this.castForTesting((InternalEntry<K, V, ?>)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        void setValueForTesting(InternalEntry<K, V, ?> entry, V value) {
            void var2_2;
            void var1_1;
            this.map.entryHelper.setValue(this.self(), this.castForTesting((InternalEntry<K, V, ?>)var1_1), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        E newEntryForTesting(K key, int hash, InternalEntry<K, V, ?> next) {
            void var3_3;
            void var2_2;
            void var1_1;
            return this.map.entryHelper.newEntry(this.self(), var1_1, (int)var2_2, this.castForTesting((InternalEntry<K, V, ?>)var3_3));
        }

        /*
         * WARNING - void declaration
         */
        boolean removeTableEntryForTesting(InternalEntry<K, V, ?> entry) {
            void var1_1;
            Segment segment = this;
            return segment.removeEntryForTesting(segment.castForTesting((InternalEntry<K, V, ?>)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        E removeFromChainForTesting(InternalEntry<K, V, ?> first, InternalEntry<K, V, ?> entry) {
            void var2_2;
            void var1_1;
            Segment segment = this;
            return segment.removeFromChain(segment.castForTesting((InternalEntry<K, V, ?>)var1_1), this.castForTesting((InternalEntry<K, V, ?>)var2_2));
        }

        /*
         * WARNING - void declaration
         */
        V getLiveValueForTesting(InternalEntry<K, V, ?> entry) {
            void var1_1;
            Segment segment = this;
            return segment.getLiveValue(segment.castForTesting((InternalEntry<K, V, ?>)var1_1));
        }

        void tryDrainReferenceQueues() {
            if (this.tryLock()) {
                try {
                    this.maybeDrainReferenceQueues();
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        void drainKeyReferenceQueue(ReferenceQueue<K> keyReferenceQueue) {
            Reference<K> ref;
            int i = 0;
            while ((ref = keyReferenceQueue.poll()) != null) {
                void var2_3;
                InternalEntry entry = (InternalEntry)((Object)ref);
                this.map.reclaimKey(var2_3);
                if (++i != 16) continue;
            }
        }

        /*
         * WARNING - void declaration
         */
        void drainValueReferenceQueue(ReferenceQueue<V> valueReferenceQueue) {
            Reference<V> ref;
            int i = 0;
            while ((ref = valueReferenceQueue.poll()) != null) {
                void var2_3;
                WeakValueReference valueReference = (WeakValueReference)((Object)ref);
                this.map.reclaimValue((WeakValueReference<K, V, E>)var2_3);
                if (++i != 16) continue;
            }
        }

        <T> void clearReferenceQueue(ReferenceQueue<T> referenceQueue) {
            while (referenceQueue.poll() != null) {
            }
        }

        /*
         * WARNING - void declaration
         */
        E getFirst(int hash) {
            void var2_2;
            void var1_1;
            AtomicReferenceArray<E> table = this.table;
            return (E)((InternalEntry)table.get(var1_1 & var2_2.length() - 1));
        }

        E getEntry(Object key, int hash) {
            if (this.count != 0) {
                for (E e = this.getFirst(hash); e != null; e = e.getNext()) {
                    if (e.getHash() != hash) continue;
                    Object entryKey = e.getKey();
                    if (entryKey == null) {
                        this.tryDrainReferenceQueues();
                        continue;
                    }
                    if (!this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    return e;
                }
            }
            return null;
        }

        /*
         * WARNING - void declaration
         */
        E getLiveEntry(Object key, int hash) {
            void var2_2;
            void var1_1;
            return this.getEntry(var1_1, (int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        V get(Object key, int hash) {
            try {
                void var1_1;
                void var2_3;
                E e = this.getLiveEntry(key, (int)var2_3);
                if (e == null) {
                    return null;
                }
                Object value = e.getValue();
                if (value == null) {
                    this.tryDrainReferenceQueues();
                }
                return var1_1;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - void declaration
         */
        boolean containsKey(Object key, int hash) {
            try {
                if (this.count != 0) {
                    void var1_1;
                    void var2_4;
                    E e = this.getLiveEntry(key, (int)var2_4);
                    boolean bl = e != null && var1_1.getValue() != null;
                    return bl;
                }
                return false;
            }
            finally {
                this.postReadCleanup();
            }
        }

        @VisibleForTesting
        boolean containsValue(Object value) {
            try {
                if (this.count != 0) {
                    AtomicReferenceArray<E> table = this.table;
                    int length = table.length();
                    for (int i = 0; i < length; ++i) {
                        for (InternalEntry e = (InternalEntry)table.get(i); e != null; e = e.getNext()) {
                            V entryValue = this.getLiveValue(e);
                            if (entryValue == null || !this.map.valueEquivalence().equivalent(value, entryValue)) continue;
                            return true;
                        }
                    }
                }
                return false;
            }
            finally {
                this.postReadCleanup();
            }
        }

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Unable to fully structure code
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        V put(K key, int hash, V value, boolean onlyIfAbsent) {
            block9: {
                block10: {
                    this.lock();
                    this.preWriteCleanup();
                    newCount = this.count + 1;
                    if (newCount > this.threshold) {
                        this.expand();
                        newCount = this.count + 1;
                    }
                    table = this.table;
                    index = hash & table.length() - 1;
                    first = (InternalEntry)table.get(index);
                    e = first;
lbl12:
                    // 2 sources

                    while (e != null) {
                        entryKey = e.getKey();
                        if (e.getHash() == hash && entryKey != null && this.map.keyEquivalence.equivalent(key, entryKey)) {
                            entryValue = e.getValue();
                            if (entryValue != null) break block9;
                            ++this.modCount;
                            this.setValue(e, value);
                            this.count = newCount = this.count;
                            break block10;
                        }
                        ** GOTO lbl-1000
                    }
                    ** GOTO lbl38
                }
                this.unlock();
                return null;
            }
            if (onlyIfAbsent) {
                this.unlock();
                return entryValue;
            }
            ** try [egrp 1[TRYBLOCK] [1 : 174->193)] { 
lbl33:
            // 1 sources

            ++this.modCount;
            this.setValue(e, value);
            return var1_1;
lbl-1000:
            // 1 sources

            {
                e = e.getNext();
                ** GOTO lbl12
lbl38:
                // 1 sources

                ++this.modCount;
                newEntry = this.map.entryHelper.newEntry(this.self(), var1_1, (int)var2_3, first);
                this.setValue(newEntry, var3_4);
                table.set(index, newEntry);
                this.count = newCount;
            }
            this.unlock();
            return null;
lbl45:
            // 1 sources

            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        void expand() {
            void var3_3;
            AtomicReferenceArray<E> oldTable = this.table;
            int oldCapacity = oldTable.length();
            if (oldCapacity >= 0x40000000) {
                return;
            }
            int newCount = this.count;
            AtomicReferenceArray<InternalEntry> newTable = this.newEntryArray(oldCapacity << 1);
            this.threshold = newTable.length() * 3 / 4;
            int newMask = newTable.length() - 1;
            for (int oldIndex = 0; oldIndex < oldCapacity; ++oldIndex) {
                int newIndex;
                Object e;
                InternalEntry head = (InternalEntry)oldTable.get(oldIndex);
                if (head == null) continue;
                Object next = head.getNext();
                int headIndex = head.getHash() & newMask;
                if (next == null) {
                    newTable.set(headIndex, head);
                    continue;
                }
                Object tail = head;
                int tailIndex = headIndex;
                for (e = next; e != null; e = e.getNext()) {
                    newIndex = e.getHash() & newMask;
                    if (newIndex == tailIndex) continue;
                    tailIndex = newIndex;
                    tail = e;
                }
                newTable.set(tailIndex, (InternalEntry)tail);
                for (e = head; e != tail; e = e.getNext()) {
                    newIndex = e.getHash() & newMask;
                    InternalEntry newNext = (InternalEntry)newTable.get(newIndex);
                    InternalEntry newFirst = this.copyEntry(e, newNext);
                    if (newFirst != null) {
                        newTable.set(newIndex, newFirst);
                        continue;
                    }
                    --newCount;
                }
            }
            this.table = newTable;
            this.count = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        boolean replace(K key, int hash, V oldValue, V newValue) {
            this.lock();
            try {
                this.preWriteCleanup();
                AtomicReferenceArray<void> table = this.table;
                int index = hash & table.length() - 1;
                InternalEntry first = (InternalEntry)table.get(index);
                for (InternalEntry e = first; e != null; e = e.getNext()) {
                    void var1_1;
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValue();
                    if (entryValue == null) {
                        if (Segment.isCollected(e)) {
                            void var1_2;
                            void var2_5;
                            ++this.modCount;
                            InternalEntry newFirst = this.removeFromChain(first, e);
                            int newCount = this.count - 1;
                            table.set(index, var2_5);
                            this.count = var1_2;
                        }
                        return false;
                    }
                    if (this.map.valueEquivalence().equivalent(oldValue, var1_1)) {
                        ++this.modCount;
                        this.setValue(e, newValue);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        V replace(K key, int hash, V newValue) {
            this.lock();
            try {
                this.preWriteCleanup();
                AtomicReferenceArray<void> table = this.table;
                int index = hash & table.length() - 1;
                InternalEntry first = (InternalEntry)table.get(index);
                for (InternalEntry e = first; e != null; e = e.getNext()) {
                    void var1_1;
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValue();
                    if (entryValue == null) {
                        if (Segment.isCollected(e)) {
                            void var1_2;
                            void var2_5;
                            ++this.modCount;
                            InternalEntry newFirst = this.removeFromChain(first, e);
                            int newCount = this.count - 1;
                            table.set(index, var2_5);
                            this.count = var1_2;
                        }
                        return null;
                    }
                    ++this.modCount;
                    this.setValue(e, newValue);
                    return var1_1;
                }
                return null;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        V remove(Object key, int hash) {
            this.lock();
            try {
                this.preWriteCleanup();
                AtomicReferenceArray table = this.table;
                int index = hash & table.length() - 1;
                InternalEntry first = (InternalEntry)table.get(index);
                for (InternalEntry e = first; e != null; e = e.getNext()) {
                    void var2_6;
                    void var1_2;
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValue();
                    if (entryValue == null && !Segment.isCollected(e)) {
                        return null;
                    }
                    ++this.modCount;
                    InternalEntry newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = var1_2;
                    void var1_3 = var2_6;
                    return var1_3;
                }
                return null;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        boolean remove(Object key, int hash, Object value) {
            this.lock();
            try {
                this.preWriteCleanup();
                AtomicReferenceArray<void> table = this.table;
                int index = hash & table.length() - 1;
                InternalEntry first = (InternalEntry)table.get(index);
                for (InternalEntry e = first; e != null; e = e.getNext()) {
                    void var2_4;
                    void var1_2;
                    void var3_5;
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    Object entryValue = e.getValue();
                    boolean explicitRemoval = false;
                    if (this.map.valueEquivalence().equivalent(value, entryValue)) {
                        explicitRemoval = true;
                    } else if (!Segment.isCollected(e)) {
                        return false;
                    }
                    ++this.modCount;
                    InternalEntry newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    table.set(index, var3_5);
                    this.count = var1_2;
                    var1_2 = var2_4;
                    return (boolean)var1_2;
                }
                return false;
            }
            finally {
                this.unlock();
            }
        }

        void clear() {
            if (this.count != 0) {
                this.lock();
                try {
                    AtomicReferenceArray<E> table = this.table;
                    for (int i = 0; i < table.length(); ++i) {
                        table.set(i, null);
                    }
                    this.maybeClearReferenceQueues();
                    this.readCount.set(0);
                    ++this.modCount;
                    this.count = 0;
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }

        /*
         * WARNING - void declaration
         */
        E removeFromChain(E first, E entry) {
            void var3_3;
            Object e;
            int newCount = this.count;
            Object newFirst = entry.getNext();
            while (e != entry) {
                void next = this.copyEntry(e, newFirst);
                if (next != null) {
                    newFirst = next;
                } else {
                    --newCount;
                }
                e = e.getNext();
            }
            this.count = var3_3;
            return newFirst;
        }

        /*
         * WARNING - void declaration
         */
        boolean reclaimKey(E entry, int hash) {
            this.lock();
            try {
                InternalEntry first;
                AtomicReferenceArray<InternalEntry> table = this.table;
                int index = hash & table.length() - 1;
                for (InternalEntry e = first = (InternalEntry)table.get(index); e != null; e = e.getNext()) {
                    void var1_2;
                    if (e != entry) continue;
                    ++this.modCount;
                    InternalEntry newFirst = this.removeFromChain(first, e);
                    int newCount = this.count - 1;
                    table.set(index, newFirst);
                    this.count = var1_2;
                    return true;
                }
                return false;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        boolean reclaimValue(K key, int hash, WeakValueReference<K, V, E> valueReference) {
            this.lock();
            try {
                InternalEntry first;
                AtomicReferenceArray<void> table = this.table;
                int index = hash & table.length() - 1;
                for (InternalEntry e = first = (InternalEntry)table.get(index); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    key = ((WeakValueEntry)e).getValueReference();
                    if (key == valueReference) {
                        void var1_2;
                        void var2_5;
                        ++this.modCount;
                        InternalEntry newFirst = this.removeFromChain(first, e);
                        int newCount = this.count - 1;
                        table.set(index, var2_5);
                        this.count = var1_2;
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        boolean clearValueForTesting(K key, int hash, WeakValueReference<K, V, ? extends InternalEntry<K, V, ?>> valueReference) {
            this.lock();
            try {
                InternalEntry first;
                AtomicReferenceArray<void> table = this.table;
                int index = hash & table.length() - 1;
                for (InternalEntry e = first = (InternalEntry)table.get(index); e != null; e = e.getNext()) {
                    Object entryKey = e.getKey();
                    if (e.getHash() != hash || entryKey == null || !this.map.keyEquivalence.equivalent(key, entryKey)) continue;
                    key = ((WeakValueEntry)e).getValueReference();
                    if (key == valueReference) {
                        void var1_1;
                        InternalEntry newFirst = this.removeFromChain(first, e);
                        table.set(index, var1_1);
                        return true;
                    }
                    return false;
                }
                return false;
            }
            finally {
                this.unlock();
            }
        }

        /*
         * WARNING - void declaration
         */
        boolean removeEntryForTesting(E entry) {
            InternalEntry first;
            int hash = entry.getHash();
            AtomicReferenceArray<InternalEntry> table = this.table;
            int index = hash & table.length() - 1;
            for (InternalEntry e = first = (InternalEntry)table.get(index); e != null; e = e.getNext()) {
                void var1_2;
                if (e != entry) continue;
                ++this.modCount;
                InternalEntry newFirst = this.removeFromChain(first, e);
                int newCount = this.count - 1;
                table.set(index, newFirst);
                this.count = var1_2;
                return true;
            }
            return false;
        }

        static <K, V, E extends InternalEntry<K, V, E>> boolean isCollected(E entry) {
            return entry.getValue() == null;
        }

        /*
         * WARNING - void declaration
         */
        V getLiveValue(E entry) {
            void var1_1;
            if (entry.getKey() == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            Object value = entry.getValue();
            if (value == null) {
                this.tryDrainReferenceQueues();
                return null;
            }
            return var1_1;
        }

        void postReadCleanup() {
            if ((this.readCount.incrementAndGet() & 0x3F) == 0) {
                this.runCleanup();
            }
        }

        void preWriteCleanup() {
            this.runLockedCleanup();
        }

        void runCleanup() {
            this.runLockedCleanup();
        }

        void runLockedCleanup() {
            if (this.tryLock()) {
                try {
                    this.maybeDrainReferenceQueues();
                    this.readCount.set(0);
                    return;
                }
                finally {
                    this.unlock();
                }
            }
        }
    }

    static final class WeakValueReferenceImpl<K, V, E extends InternalEntry<K, V, E>>
    extends WeakReference<V>
    implements WeakValueReference<K, V, E> {
        final E entry;

        /*
         * WARNING - void declaration
         */
        WeakValueReferenceImpl(ReferenceQueue<V> queue, V referent, E entry) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.entry = var3_3;
        }

        @Override
        public final E getEntry() {
            return this.entry;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final WeakValueReference<K, V, E> copyFor(ReferenceQueue<V> queue, E entry) {
            void var2_2;
            void var1_1;
            return new WeakValueReferenceImpl(var1_1, this.get(), var2_2);
        }
    }

    static final class DummyInternalEntry
    implements InternalEntry<Object, Object, DummyInternalEntry> {
        private DummyInternalEntry() {
            throw new AssertionError();
        }

        @Override
        public final DummyInternalEntry getNext() {
            throw new AssertionError();
        }

        @Override
        public final int getHash() {
            throw new AssertionError();
        }

        @Override
        public final Object getKey() {
            throw new AssertionError();
        }

        @Override
        public final Object getValue() {
            throw new AssertionError();
        }
    }

    static interface WeakValueReference<K, V, E extends InternalEntry<K, V, E>> {
        public V get();

        public E getEntry();

        public void clear();

        public WeakValueReference<K, V, E> copyFor(ReferenceQueue<V> var1, E var2);
    }

    static final class WeakKeyWeakValueEntry<K, V>
    extends AbstractWeakKeyEntry<K, V, WeakKeyWeakValueEntry<K, V>>
    implements WeakValueEntry<K, V, WeakKeyWeakValueEntry<K, V>> {
        private volatile WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> valueReference = MapMakerInternalMap.unsetWeakValueReference();

        /*
         * WARNING - void declaration
         */
        WeakKeyWeakValueEntry(ReferenceQueue<K> queue, K key, int hash, WeakKeyWeakValueEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final V getValue() {
            return this.valueReference.get();
        }

        /*
         * WARNING - void declaration
         */
        final WeakKeyWeakValueEntry<K, V> copy(ReferenceQueue<K> queueForKeys, ReferenceQueue<V> queueForValues, WeakKeyWeakValueEntry<K, V> newNext) {
            void var1_1;
            void var2_2;
            void var3_3;
            WeakKeyWeakValueEntry<K, V> newEntry = new WeakKeyWeakValueEntry<K, V>(queueForKeys, this.getKey(), this.hash, var3_3);
            new WeakKeyWeakValueEntry<K, V>(queueForKeys, this.getKey(), this.hash, var3_3).valueReference = this.valueReference.copyFor((ReferenceQueue<V>)var2_2, newEntry);
            return var1_1;
        }

        @Override
        public final void clearValue() {
            this.valueReference.clear();
        }

        /*
         * WARNING - void declaration
         */
        final void setValue(V value, ReferenceQueue<V> queueForValues) {
            void var3_3;
            void var1_1;
            void var2_2;
            WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> previous = this.valueReference;
            this.valueReference = new WeakValueReferenceImpl((ReferenceQueue<void>)var2_2, var1_1, this);
            var3_3.clear();
        }

        @Override
        public final WeakValueReference<K, V, WeakKeyWeakValueEntry<K, V>> getValueReference() {
            return this.valueReference;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ WeakValueReference access$702(WeakKeyWeakValueEntry x0, WeakValueReference x1) {
            void var1_1;
            x0.valueReference = var1_1;
            return x0.valueReference;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public final Strength keyStrength() {
                return Strength.WEAK;
            }

            @Override
            public final Strength valueStrength() {
                return Strength.WEAK;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final WeakKeyWeakValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, WeakKeyWeakValueEntry<K, V>, WeakKeyWeakValueSegment<K, V>> map, int initialCapacity, int maxSegmentSize) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakKeyWeakValueSegment(var1_1, (int)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final WeakKeyWeakValueEntry<K, V> copy(WeakKeyWeakValueSegment<K, V> segment, WeakKeyWeakValueEntry<K, V> entry, WeakKeyWeakValueEntry<K, V> newNext) {
                void var3_3;
                void var1_1;
                void var2_2;
                if (entry.getKey() == null) {
                    return null;
                }
                if (Segment.isCollected(entry)) {
                    return null;
                }
                return var2_2.copy(((WeakKeyWeakValueSegment)segment).queueForKeys, ((WeakKeyWeakValueSegment)var1_1).queueForValues, var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setValue(WeakKeyWeakValueSegment<K, V> segment, WeakKeyWeakValueEntry<K, V> entry, V value) {
                void var1_1;
                void var3_3;
                entry.setValue(var3_3, ((WeakKeyWeakValueSegment)var1_1).queueForValues);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final WeakKeyWeakValueEntry<K, V> newEntry(WeakKeyWeakValueSegment<K, V> segment, K key, int hash, WeakKeyWeakValueEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakKeyWeakValueEntry<void, V>(((WeakKeyWeakValueSegment)var1_1).queueForKeys, var2_2, (int)var3_3, next);
            }
        }
    }

    static final class WeakKeyStrongValueEntry<K, V>
    extends AbstractWeakKeyEntry<K, V, WeakKeyStrongValueEntry<K, V>>
    implements StrongValueEntry<K, V, WeakKeyStrongValueEntry<K, V>> {
        private volatile V value = null;

        /*
         * WARNING - void declaration
         */
        WeakKeyStrongValueEntry(ReferenceQueue<K> queue, K key, int hash, WeakKeyStrongValueEntry<K, V> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        final void setValue(V value) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final WeakKeyStrongValueEntry<K, V> copy(ReferenceQueue<K> queueForKeys, WeakKeyStrongValueEntry<K, V> newNext) {
            void var1_1;
            void var2_2;
            WeakKeyStrongValueEntry<K, V> newEntry = new WeakKeyStrongValueEntry<K, V>(queueForKeys, this.getKey(), this.hash, var2_2);
            newEntry.setValue(this.value);
            return var1_1;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public final Strength keyStrength() {
                return Strength.WEAK;
            }

            @Override
            public final Strength valueStrength() {
                return Strength.STRONG;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final WeakKeyStrongValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, WeakKeyStrongValueEntry<K, V>, WeakKeyStrongValueSegment<K, V>> map, int initialCapacity, int maxSegmentSize) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakKeyStrongValueSegment(var1_1, (int)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final WeakKeyStrongValueEntry<K, V> copy(WeakKeyStrongValueSegment<K, V> segment, WeakKeyStrongValueEntry<K, V> entry, WeakKeyStrongValueEntry<K, V> newNext) {
                void var3_3;
                void var1_1;
                void var2_2;
                if (entry.getKey() == null) {
                    return null;
                }
                return var2_2.copy(((WeakKeyStrongValueSegment)var1_1).queueForKeys, var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setValue(WeakKeyStrongValueSegment<K, V> segment, WeakKeyStrongValueEntry<K, V> entry, V value) {
                void var3_3;
                entry.setValue(var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final WeakKeyStrongValueEntry<K, V> newEntry(WeakKeyStrongValueSegment<K, V> segment, K key, int hash, WeakKeyStrongValueEntry<K, V> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakKeyStrongValueEntry<void, V>(((WeakKeyStrongValueSegment)var1_1).queueForKeys, var2_2, (int)var3_3, next);
            }
        }
    }

    static final class WeakKeyDummyValueEntry<K>
    extends AbstractWeakKeyEntry<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>>
    implements StrongValueEntry<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>> {
        /*
         * WARNING - void declaration
         */
        WeakKeyDummyValueEntry(ReferenceQueue<K> queue, K key, int hash, WeakKeyDummyValueEntry<K> next) {
            super(var1_1, var2_2, (int)var3_3, next);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final MapMaker.Dummy getValue() {
            return MapMaker.Dummy.VALUE;
        }

        final void setValue(MapMaker.Dummy value) {
        }

        /*
         * WARNING - void declaration
         */
        final WeakKeyDummyValueEntry<K> copy(ReferenceQueue<K> queueForKeys, WeakKeyDummyValueEntry<K> newNext) {
            void var2_2;
            void var1_1;
            return new WeakKeyDummyValueEntry(var1_1, this.getKey(), this.hash, var2_2);
        }

        static final class Helper<K>
        implements InternalEntryHelper<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> {
            private static final Helper<?> INSTANCE = new Helper();

            Helper() {
            }

            static <K> Helper<K> instance() {
                return INSTANCE;
            }

            @Override
            public final Strength keyStrength() {
                return Strength.WEAK;
            }

            @Override
            public final Strength valueStrength() {
                return Strength.STRONG;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final WeakKeyDummyValueSegment<K> newSegment(MapMakerInternalMap<K, MapMaker.Dummy, WeakKeyDummyValueEntry<K>, WeakKeyDummyValueSegment<K>> map, int initialCapacity, int maxSegmentSize) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakKeyDummyValueSegment(var1_1, (int)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final WeakKeyDummyValueEntry<K> copy(WeakKeyDummyValueSegment<K> segment, WeakKeyDummyValueEntry<K> entry, WeakKeyDummyValueEntry<K> newNext) {
                void var3_3;
                void var1_1;
                void var2_2;
                if (entry.getKey() == null) {
                    return null;
                }
                return var2_2.copy(((WeakKeyDummyValueSegment)var1_1).queueForKeys, var3_3);
            }

            @Override
            public final void setValue(WeakKeyDummyValueSegment<K> segment, WeakKeyDummyValueEntry<K> entry, MapMaker.Dummy value) {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final WeakKeyDummyValueEntry<K> newEntry(WeakKeyDummyValueSegment<K> segment, K key, int hash, WeakKeyDummyValueEntry<K> next) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new WeakKeyDummyValueEntry<void>(((WeakKeyDummyValueSegment)var1_1).queueForKeys, var2_2, (int)var3_3, next);
            }
        }
    }

    static abstract class AbstractWeakKeyEntry<K, V, E extends InternalEntry<K, V, E>>
    extends WeakReference<K>
    implements InternalEntry<K, V, E> {
        final int hash;
        final E next;

        /*
         * WARNING - void declaration
         */
        AbstractWeakKeyEntry(ReferenceQueue<K> queue, K key, int hash, E next) {
            super(var2_2, var1_1);
            void var3_3;
            void var1_1;
            void var2_2;
            this.hash = var3_3;
            this.next = next;
        }

        @Override
        public K getKey() {
            return (K)this.get();
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public E getNext() {
            return this.next;
        }
    }

    static final class StrongKeyDummyValueEntry<K>
    extends AbstractStrongKeyEntry<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>>
    implements StrongValueEntry<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>> {
        /*
         * WARNING - void declaration
         */
        StrongKeyDummyValueEntry(K key, int hash, StrongKeyDummyValueEntry<K> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final MapMaker.Dummy getValue() {
            return MapMaker.Dummy.VALUE;
        }

        final void setValue(MapMaker.Dummy value) {
        }

        /*
         * WARNING - void declaration
         */
        final StrongKeyDummyValueEntry<K> copy(StrongKeyDummyValueEntry<K> newNext) {
            void var1_1;
            return new StrongKeyDummyValueEntry(this.key, this.hash, var1_1);
        }

        static final class Helper<K>
        implements InternalEntryHelper<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> {
            private static final Helper<?> INSTANCE = new Helper();

            Helper() {
            }

            static <K> Helper<K> instance() {
                return INSTANCE;
            }

            @Override
            public final Strength keyStrength() {
                return Strength.STRONG;
            }

            @Override
            public final Strength valueStrength() {
                return Strength.STRONG;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final StrongKeyDummyValueSegment<K> newSegment(MapMakerInternalMap<K, MapMaker.Dummy, StrongKeyDummyValueEntry<K>, StrongKeyDummyValueSegment<K>> map, int initialCapacity, int maxSegmentSize) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new StrongKeyDummyValueSegment(var1_1, (int)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final StrongKeyDummyValueEntry<K> copy(StrongKeyDummyValueSegment<K> segment, StrongKeyDummyValueEntry<K> entry, StrongKeyDummyValueEntry<K> newNext) {
                void var3_3;
                return entry.copy((StrongKeyDummyValueEntry<K>)var3_3);
            }

            @Override
            public final void setValue(StrongKeyDummyValueSegment<K> segment, StrongKeyDummyValueEntry<K> entry, MapMaker.Dummy value) {
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final StrongKeyDummyValueEntry<K> newEntry(StrongKeyDummyValueSegment<K> segment, K key, int hash, StrongKeyDummyValueEntry<K> next) {
                void var3_3;
                void var2_2;
                return new StrongKeyDummyValueEntry<void>(var2_2, (int)var3_3, next);
            }
        }
    }

    static final class StrongKeyWeakValueEntry<K, V>
    extends AbstractStrongKeyEntry<K, V, StrongKeyWeakValueEntry<K, V>>
    implements WeakValueEntry<K, V, StrongKeyWeakValueEntry<K, V>> {
        private volatile WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> valueReference = MapMakerInternalMap.unsetWeakValueReference();

        /*
         * WARNING - void declaration
         */
        StrongKeyWeakValueEntry(K key, int hash, StrongKeyWeakValueEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final V getValue() {
            return this.valueReference.get();
        }

        @Override
        public final void clearValue() {
            this.valueReference.clear();
        }

        /*
         * WARNING - void declaration
         */
        final void setValue(V value, ReferenceQueue<V> queueForValues) {
            void var3_3;
            void var1_1;
            void var2_2;
            WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> previous = this.valueReference;
            this.valueReference = new WeakValueReferenceImpl((ReferenceQueue<void>)var2_2, var1_1, this);
            var3_3.clear();
        }

        /*
         * WARNING - void declaration
         */
        final StrongKeyWeakValueEntry<K, V> copy(ReferenceQueue<V> queueForValues, StrongKeyWeakValueEntry<K, V> newNext) {
            void var2_2;
            void var1_1;
            StrongKeyWeakValueEntry newEntry = new StrongKeyWeakValueEntry(this.key, this.hash, newNext);
            new StrongKeyWeakValueEntry(this.key, this.hash, newNext).valueReference = this.valueReference.copyFor((ReferenceQueue<V>)var1_1, newEntry);
            return var2_2;
        }

        @Override
        public final WeakValueReference<K, V, StrongKeyWeakValueEntry<K, V>> getValueReference() {
            return this.valueReference;
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ WeakValueReference access$602(StrongKeyWeakValueEntry x0, WeakValueReference x1) {
            void var1_1;
            x0.valueReference = var1_1;
            return x0.valueReference;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public final Strength keyStrength() {
                return Strength.STRONG;
            }

            @Override
            public final Strength valueStrength() {
                return Strength.WEAK;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final StrongKeyWeakValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, StrongKeyWeakValueEntry<K, V>, StrongKeyWeakValueSegment<K, V>> map, int initialCapacity, int maxSegmentSize) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new StrongKeyWeakValueSegment(var1_1, (int)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final StrongKeyWeakValueEntry<K, V> copy(StrongKeyWeakValueSegment<K, V> segment, StrongKeyWeakValueEntry<K, V> entry, StrongKeyWeakValueEntry<K, V> newNext) {
                void var3_3;
                void var1_1;
                void var2_2;
                if (Segment.isCollected(entry)) {
                    return null;
                }
                return var2_2.copy(((StrongKeyWeakValueSegment)var1_1).queueForValues, var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setValue(StrongKeyWeakValueSegment<K, V> segment, StrongKeyWeakValueEntry<K, V> entry, V value) {
                void var1_1;
                void var3_3;
                entry.setValue(var3_3, ((StrongKeyWeakValueSegment)var1_1).queueForValues);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final StrongKeyWeakValueEntry<K, V> newEntry(StrongKeyWeakValueSegment<K, V> segment, K key, int hash, StrongKeyWeakValueEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongKeyWeakValueEntry<void, V>(var2_2, (int)var3_3, next);
            }
        }
    }

    static final class StrongKeyStrongValueEntry<K, V>
    extends AbstractStrongKeyEntry<K, V, StrongKeyStrongValueEntry<K, V>>
    implements StrongValueEntry<K, V, StrongKeyStrongValueEntry<K, V>> {
        private volatile V value = null;

        /*
         * WARNING - void declaration
         */
        StrongKeyStrongValueEntry(K key, int hash, StrongKeyStrongValueEntry<K, V> next) {
            super(var1_1, (int)var2_2, var3_3);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        @Override
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        final void setValue(V value) {
            void var1_1;
            this.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        final StrongKeyStrongValueEntry<K, V> copy(StrongKeyStrongValueEntry<K, V> newNext) {
            void var1_1;
            StrongKeyStrongValueEntry newEntry = new StrongKeyStrongValueEntry(this.key, this.hash, newNext);
            new StrongKeyStrongValueEntry(this.key, this.hash, newNext).value = this.value;
            return var1_1;
        }

        static final class Helper<K, V>
        implements InternalEntryHelper<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> {
            private static final Helper<?, ?> INSTANCE = new Helper();

            Helper() {
            }

            static <K, V> Helper<K, V> instance() {
                return INSTANCE;
            }

            @Override
            public final Strength keyStrength() {
                return Strength.STRONG;
            }

            @Override
            public final Strength valueStrength() {
                return Strength.STRONG;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final StrongKeyStrongValueSegment<K, V> newSegment(MapMakerInternalMap<K, V, StrongKeyStrongValueEntry<K, V>, StrongKeyStrongValueSegment<K, V>> map, int initialCapacity, int maxSegmentSize) {
                void var3_3;
                void var2_2;
                void var1_1;
                return new StrongKeyStrongValueSegment(var1_1, (int)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final StrongKeyStrongValueEntry<K, V> copy(StrongKeyStrongValueSegment<K, V> segment, StrongKeyStrongValueEntry<K, V> entry, StrongKeyStrongValueEntry<K, V> newNext) {
                void var3_3;
                return entry.copy((StrongKeyStrongValueEntry<K, V>)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final void setValue(StrongKeyStrongValueSegment<K, V> segment, StrongKeyStrongValueEntry<K, V> entry, V value) {
                void var3_3;
                entry.setValue(var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final StrongKeyStrongValueEntry<K, V> newEntry(StrongKeyStrongValueSegment<K, V> segment, K key, int hash, StrongKeyStrongValueEntry<K, V> next) {
                void var3_3;
                void var2_2;
                return new StrongKeyStrongValueEntry<void, V>(var2_2, (int)var3_3, next);
            }
        }
    }

    static interface WeakValueEntry<K, V, E extends InternalEntry<K, V, E>>
    extends InternalEntry<K, V, E> {
        public WeakValueReference<K, V, E> getValueReference();

        public void clearValue();
    }

    static interface StrongValueEntry<K, V, E extends InternalEntry<K, V, E>>
    extends InternalEntry<K, V, E> {
    }

    static abstract class AbstractStrongKeyEntry<K, V, E extends InternalEntry<K, V, E>>
    implements InternalEntry<K, V, E> {
        final K key;
        final int hash;
        final E next;

        /*
         * WARNING - void declaration
         */
        AbstractStrongKeyEntry(K key, int hash, E next) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.hash = var2_2;
            this.next = var3_3;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public int getHash() {
            return this.hash;
        }

        @Override
        public E getNext() {
            return this.next;
        }
    }

    static interface InternalEntry<K, V, E extends InternalEntry<K, V, E>> {
        public E getNext();

        public int getHash();

        public K getKey();

        public V getValue();
    }

    static interface InternalEntryHelper<K, V, E extends InternalEntry<K, V, E>, S extends Segment<K, V, E, S>> {
        public Strength keyStrength();

        public Strength valueStrength();

        public S newSegment(MapMakerInternalMap<K, V, E, S> var1, int var2, int var3);

        public E newEntry(S var1, K var2, int var3, E var4);

        public E copy(S var1, E var2, E var3);

        public void setValue(S var1, E var2, V var3);
    }

    static enum Strength {
        STRONG{

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.equals();
            }
        }
        ,
        WEAK{

            @Override
            final Equivalence<Object> defaultEquivalence() {
                return Equivalence.identity();
            }
        };


        abstract Equivalence<Object> defaultEquivalence();
    }
}

