/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.CartesianList;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.TransformedListIterator;
import com.google.common.math.IntMath;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.AbstractList;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.RandomAccess;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.Predicate;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Lists {
    private Lists() {
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList() {
        return new ArrayList();
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(E ... elements) {
        void var1_2;
        E[] EArray;
        Preconditions.checkNotNull(elements);
        int capacity = Lists.computeArrayListCapacity(elements.length);
        ArrayList list = new ArrayList(capacity);
        Collections.addAll(list, EArray);
        return var1_2;
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(Iterable<? extends E> elements) {
        Iterable<E> iterable;
        Preconditions.checkNotNull(elements);
        if (elements instanceof Collection) {
            return new ArrayList((Collection)elements);
        }
        return Lists.newArrayList(iterable.iterator());
    }

    /*
     * WARNING - void declaration
     */
    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayList(Iterator<? extends E> elements) {
        void var1_1;
        Iterator<? extends E> iterator;
        ArrayList<E> list = Lists.newArrayList();
        Iterators.addAll(list, iterator);
        return var1_1;
    }

    @VisibleForTesting
    static int computeArrayListCapacity(int arraySize) {
        int n;
        CollectPreconditions.checkNonnegative(arraySize, "arraySize");
        return Ints.saturatedCast(5L + (long)arraySize + (long)(n / 10));
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayListWithCapacity(int initialArraySize) {
        int n;
        CollectPreconditions.checkNonnegative(initialArraySize, "initialArraySize");
        return new ArrayList(n);
    }

    @GwtCompatible(serializable=true)
    public static <E> ArrayList<E> newArrayListWithExpectedSize(int estimatedSize) {
        int n;
        return new ArrayList(Lists.computeArrayListCapacity(n));
    }

    @GwtCompatible(serializable=true)
    public static <E> LinkedList<E> newLinkedList() {
        return new LinkedList();
    }

    /*
     * WARNING - void declaration
     */
    @GwtCompatible(serializable=true)
    public static <E> LinkedList<E> newLinkedList(Iterable<? extends E> elements) {
        void var1_1;
        Iterable<? extends E> iterable;
        LinkedList<E> list = Lists.newLinkedList();
        Iterables.addAll(list, iterable);
        return var1_1;
    }

    @GwtIncompatible
    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList() {
        return new CopyOnWriteArrayList();
    }

    @GwtIncompatible
    public static <E> CopyOnWriteArrayList<E> newCopyOnWriteArrayList(Iterable<? extends E> elements) {
        Iterable<? extends E> iterable;
        Iterable<? extends E> elementsCollection = elements instanceof Collection ? (ArrayList<? extends E>)elements : Lists.newArrayList(elements);
        return new CopyOnWriteArrayList<E>(iterable);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> List<E> asList(@ParametricNullness E first, E[] rest) {
        void var1_1;
        E e;
        return new OnePlusArrayList<E>(e, (E[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> List<E> asList(@ParametricNullness E first, @ParametricNullness E second, E[] rest) {
        void var2_2;
        void var1_1;
        E e;
        return new TwoPlusArrayList<void>((void)e, var1_1, (E[])var2_2);
    }

    public static <B> List<List<B>> cartesianProduct(List<? extends List<? extends B>> lists) {
        return CartesianList.create(lists);
    }

    @SafeVarargs
    public static <B> List<List<B>> cartesianProduct(List<? extends B> ... lists) {
        return Lists.cartesianProduct(Arrays.asList(lists));
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> List<T> transform(List<F> fromList, Function<? super F, ? extends T> function) {
        void var1_1;
        List<F> list;
        if (fromList instanceof RandomAccess) {
            return new TransformingRandomAccessList<F, T>(fromList, function);
        }
        return new TransformingSequentialList(list, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> List<List<T>> partition(List<T> list, int size) {
        void var1_1;
        List<T> list2;
        Preconditions.checkNotNull(list);
        Preconditions.checkArgument(size > 0);
        if (list instanceof RandomAccess) {
            return new RandomAccessPartition<T>(list, size);
        }
        return new Partition<T>(list2, (int)var1_1);
    }

    public static ImmutableList<Character> charactersOf(String string) {
        String string2;
        return new StringAsImmutableList(Preconditions.checkNotNull(string2));
    }

    @Beta
    public static List<Character> charactersOf(CharSequence sequence) {
        CharSequence charSequence;
        return new CharSequenceAsList(Preconditions.checkNotNull(charSequence));
    }

    public static <T> List<T> reverse(List<T> list) {
        List<T> list2;
        if (list instanceof ImmutableList) {
            ImmutableList<T> immutableList = ((ImmutableList)list).reverse();
            list = immutableList;
            list = immutableList;
            return immutableList;
        }
        if (list instanceof ReverseList) {
            return ((ReverseList)list).getForwardList();
        }
        if (list instanceof RandomAccess) {
            return new RandomAccessReverseList<T>(list);
        }
        return new ReverseList<T>(list2);
    }

    /*
     * WARNING - void declaration
     */
    static int hashCodeImpl(List<?> list) {
        void var1_1;
        Iterator<?> iterator;
        int hashCode = 1;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object o = iterator.next();
            hashCode = hashCode * 31 + (o == null ? 0 : var2_2.hashCode());
            hashCode = ~(~hashCode);
        }
        return (int)var1_1;
    }

    /*
     * WARNING - void declaration
     */
    static boolean equalsImpl(List<?> thisList, Object other) {
        void var1_1;
        List<?> list;
        if (other == Preconditions.checkNotNull(thisList)) {
            return true;
        }
        if (!(other instanceof List)) {
            return false;
        }
        List otherList = (List)other;
        int size = thisList.size();
        if (size != otherList.size()) {
            return false;
        }
        if (thisList instanceof RandomAccess && otherList instanceof RandomAccess) {
            for (int i = 0; i < size; ++i) {
                if (Objects.equal(thisList.get(i), otherList.get(i))) continue;
                return false;
            }
            return true;
        }
        return Iterators.elementsEqual(list.iterator(), var1_1.iterator());
    }

    /*
     * WARNING - void declaration
     */
    static <E> boolean addAllImpl(List<E> list, int index, Iterable<? extends E> elements) {
        void var3_4;
        void var1_1;
        boolean changed = false;
        ListIterator<E> listIterator = list.listIterator((int)var1_1);
        for (E e : elements) {
            void var2_3;
            listIterator.add(var2_3);
            changed = true;
        }
        return (boolean)var3_4;
    }

    static int indexOfImpl(List<?> list, Object element) {
        if (list instanceof RandomAccess) {
            return Lists.indexOfRandomAccess(list, element);
        }
        ListIterator<?> listIterator = list.listIterator();
        while (listIterator.hasNext()) {
            ListIterator<?> listIterator2;
            if (!Objects.equal(element, listIterator.next())) continue;
            return listIterator2.previousIndex();
        }
        return -1;
    }

    private static int indexOfRandomAccess(List<?> list, Object element) {
        int size = list.size();
        if (element == null) {
            for (int i = 0; i < size; ++i) {
                if (list.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = 0; i < size; ++i) {
                if (!element.equals(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    static int lastIndexOfImpl(List<?> list, Object element) {
        if (list instanceof RandomAccess) {
            return Lists.lastIndexOfRandomAccess(list, element);
        }
        List<?> list2 = list;
        ListIterator<?> listIterator = list2.listIterator(list2.size());
        while (listIterator.hasPrevious()) {
            ListIterator<?> listIterator2;
            if (!Objects.equal(element, listIterator.previous())) continue;
            return listIterator2.nextIndex();
        }
        return -1;
    }

    private static int lastIndexOfRandomAccess(List<?> list, Object element) {
        if (element == null) {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (list.get(i) != null) continue;
                return i;
            }
        } else {
            for (int i = list.size() - 1; i >= 0; --i) {
                if (!element.equals(list.get(i))) continue;
                return i;
            }
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    static <E> ListIterator<E> listIteratorImpl(List<E> list, int index) {
        void var1_1;
        List<E> list2;
        return new AbstractListWrapper<E>(list2).listIterator((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <E> List<E> subListImpl(List<E> list, int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        AbstractListWrapper abstractListWrapper;
        AbstractListWrapper wrapper;
        wrapper = list instanceof RandomAccess ? new RandomAccessListWrapper<E>((List)list){
            private static final long serialVersionUID = 0L;
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListIterator<E> listIterator(int index) {
                void var1_1;
                return this.backingList.listIterator((int)var1_1);
            }
        } : new AbstractListWrapper<E>((List)wrapper){
            private static final long serialVersionUID = 0L;
            {
                void var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListIterator<E> listIterator(int index) {
                void var1_1;
                return this.backingList.listIterator((int)var1_1);
            }
        };
        return abstractListWrapper.subList((int)var1_1, (int)var2_2);
    }

    static <T> List<T> cast(Iterable<T> iterable) {
        return (List)iterable;
    }

    private static class RandomAccessListWrapper<E>
    extends AbstractListWrapper<E>
    implements RandomAccess {
        /*
         * WARNING - void declaration
         */
        RandomAccessListWrapper(List<E> backingList) {
            super(var1_1);
            void var1_1;
        }
    }

    private static class AbstractListWrapper<E>
    extends AbstractList<E> {
        final List<E> backingList;

        /*
         * WARNING - void declaration
         */
        AbstractListWrapper(List<E> backingList) {
            void var1_1;
            this.backingList = (List)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void add(int index, @ParametricNullness E element) {
            void var2_2;
            void var1_1;
            this.backingList.add((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean addAll(int index, Collection<? extends E> c) {
            void var2_2;
            void var1_1;
            return this.backingList.addAll((int)var1_1, (Collection<E>)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public E get(int index) {
            void var1_1;
            return this.backingList.get((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public E remove(int index) {
            void var1_1;
            return this.backingList.remove((int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public E set(int index, @ParametricNullness E element) {
            void var2_2;
            void var1_1;
            return this.backingList.set((int)var1_1, var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object o) {
            void var1_1;
            return this.backingList.contains(var1_1);
        }

        @Override
        public int size() {
            return this.backingList.size();
        }
    }

    private static class RandomAccessReverseList<T>
    extends ReverseList<T>
    implements RandomAccess {
        /*
         * WARNING - void declaration
         */
        RandomAccessReverseList(List<T> forwardList) {
            super(var1_1);
            void var1_1;
        }
    }

    private static class ReverseList<T>
    extends AbstractList<T> {
        private final List<T> forwardList;

        /*
         * WARNING - void declaration
         */
        ReverseList(List<T> forwardList) {
            void var1_1;
            this.forwardList = (List)Preconditions.checkNotNull(var1_1);
        }

        List<T> getForwardList() {
            return this.forwardList;
        }

        /*
         * WARNING - void declaration
         */
        private int reverseIndex(int index) {
            void var1_1;
            void var2_2;
            int size = this.size();
            Preconditions.checkElementIndex(index, size);
            return (int)(var2_2 - true - var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private int reversePosition(int index) {
            void var1_1;
            void var2_2;
            int size = this.size();
            Preconditions.checkPositionIndex(index, size);
            return (int)(var2_2 - var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void add(int index, @ParametricNullness T element) {
            void var2_2;
            void var1_1;
            this.forwardList.add(this.reversePosition((int)var1_1), var2_2);
        }

        @Override
        public void clear() {
            this.forwardList.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public T remove(int index) {
            void var1_1;
            return this.forwardList.remove(this.reverseIndex((int)var1_1));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        protected void removeRange(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            this.subList((int)var1_1, (int)var2_2).clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public T set(int index, @ParametricNullness T element) {
            void var2_2;
            void var1_1;
            return this.forwardList.set(this.reverseIndex((int)var1_1), var2_2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public T get(int index) {
            void var1_1;
            return this.forwardList.get(this.reverseIndex((int)var1_1));
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<T> subList(int fromIndex, int toIndex) {
            void var1_1;
            void var2_2;
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
            return Lists.reverse(this.forwardList.subList(this.reversePosition((int)var2_2), this.reversePosition((int)var1_1)));
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ListIterator<T> listIterator(int index) {
            void var1_2;
            int start = this.reversePosition(index);
            ListIterator<T> forwardIterator = this.forwardList.listIterator(start);
            return new ListIterator<T>(this, (ListIterator)var1_2){
                boolean canRemoveOrSet;
                final /* synthetic */ ListIterator val$forwardIterator;
                final /* synthetic */ ReverseList this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                    this.val$forwardIterator = listIterator;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void add(@ParametricNullness T e) {
                    void var1_1;
                    this.val$forwardIterator.add(var1_1);
                    this.val$forwardIterator.previous();
                    this.canRemoveOrSet = false;
                }

                @Override
                public boolean hasNext() {
                    return this.val$forwardIterator.hasPrevious();
                }

                @Override
                public boolean hasPrevious() {
                    return this.val$forwardIterator.hasNext();
                }

                @Override
                @ParametricNullness
                public T next() {
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemoveOrSet = true;
                    return this.val$forwardIterator.previous();
                }

                @Override
                public int nextIndex() {
                    return ReverseList.access$000(this.this$0, this.val$forwardIterator.nextIndex());
                }

                @Override
                @ParametricNullness
                public T previous() {
                    if (!this.hasPrevious()) {
                        throw new NoSuchElementException();
                    }
                    this.canRemoveOrSet = true;
                    return this.val$forwardIterator.next();
                }

                @Override
                public int previousIndex() {
                    return this.nextIndex() - 1;
                }

                @Override
                public void remove() {
                    CollectPreconditions.checkRemove(this.canRemoveOrSet);
                    this.val$forwardIterator.remove();
                    this.canRemoveOrSet = false;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public void set(@ParametricNullness T e) {
                    void var1_1;
                    Preconditions.checkState(this.canRemoveOrSet);
                    this.val$forwardIterator.set(var1_1);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        static /* synthetic */ int access$000(ReverseList x0, int x1) {
            void var1_1;
            return x0.reversePosition((int)var1_1);
        }
    }

    private static final class CharSequenceAsList
    extends AbstractList<Character> {
        private final CharSequence sequence;

        /*
         * WARNING - void declaration
         */
        CharSequenceAsList(CharSequence sequence) {
            void var1_1;
            this.sequence = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Character get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return Character.valueOf(this.sequence.charAt((int)var1_1));
        }

        @Override
        public final int size() {
            return this.sequence.length();
        }
    }

    private static final class StringAsImmutableList
    extends ImmutableList<Character> {
        private final String string;

        /*
         * WARNING - void declaration
         */
        StringAsImmutableList(String string) {
            void var1_1;
            this.string = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int indexOf(Object object) {
            if (object instanceof Character) {
                void var1_1;
                return this.string.indexOf(((Character)var1_1).charValue());
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int lastIndexOf(Object object) {
            if (object instanceof Character) {
                void var1_1;
                return this.string.lastIndexOf(((Character)var1_1).charValue());
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ImmutableList<Character> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
            return Lists.charactersOf(this.string.substring((int)var1_1, (int)var2_2));
        }

        @Override
        final boolean isPartialView() {
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Character get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return Character.valueOf(this.string.charAt((int)var1_1));
        }

        @Override
        public final int size() {
            return this.string.length();
        }
    }

    private static class RandomAccessPartition<T>
    extends Partition<T>
    implements RandomAccess {
        /*
         * WARNING - void declaration
         */
        RandomAccessPartition(List<T> list, int size) {
            super(var1_1, (int)var2_2);
            void var2_2;
            void var1_1;
        }
    }

    private static class Partition<T>
    extends AbstractList<List<T>> {
        final List<T> list;
        final int size;

        /*
         * WARNING - void declaration
         */
        Partition(List<T> list, int size) {
            void var2_2;
            void var1_1;
            this.list = var1_1;
            this.size = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public List<T> get(int index) {
            void var2_2;
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            int start = index * this.size;
            int end = Math.min(start + this.size, this.list.size());
            return this.list.subList((int)var1_1, (int)var2_2);
        }

        @Override
        public int size() {
            return IntMath.divide(this.list.size(), this.size, RoundingMode.CEILING);
        }

        @Override
        public boolean isEmpty() {
            return this.list.isEmpty();
        }
    }

    private static class TransformingRandomAccessList<F, T>
    extends AbstractList<T>
    implements Serializable,
    RandomAccess {
        final List<F> fromList;
        final Function<? super F, ? extends T> function;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        TransformingRandomAccessList(List<F> fromList, Function<? super F, ? extends T> function) {
            void var2_2;
            void var1_1;
            this.fromList = (List)Preconditions.checkNotNull(var1_1);
            this.function = (Function)Preconditions.checkNotNull(var2_2);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public T get(int index) {
            void var1_1;
            return this.function.apply(this.fromList.get((int)var1_1));
        }

        @Override
        public Iterator<T> iterator() {
            return this.listIterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ListIterator<T> listIterator(int index) {
            void var1_1;
            TransformingRandomAccessList transformingRandomAccessList = this;
            return new TransformedListIterator<F, T>(transformingRandomAccessList, transformingRandomAccessList.fromList.listIterator((int)var1_1)){
                final /* synthetic */ TransformingRandomAccessList this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                T transform(F from) {
                    void var1_1;
                    return this.this$0.function.apply(var1_1);
                }
            };
        }

        @Override
        public boolean isEmpty() {
            return this.fromList.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            void var1_1;
            Preconditions.checkNotNull(filter);
            return this.fromList.removeIf(arg_0 -> this.lambda$removeIf$0((Predicate)var1_1, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public T remove(int index) {
            void var1_1;
            return this.function.apply(this.fromList.remove((int)var1_1));
        }

        @Override
        public int size() {
            return this.fromList.size();
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ boolean lambda$removeIf$0(Predicate filter, Object element) {
            void var2_2;
            return filter.test(this.function.apply(var2_2));
        }
    }

    private static class TransformingSequentialList<F, T>
    extends AbstractSequentialList<T>
    implements Serializable {
        final List<F> fromList;
        final Function<? super F, ? extends T> function;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        TransformingSequentialList(List<F> fromList, Function<? super F, ? extends T> function) {
            void var2_2;
            void var1_1;
            this.fromList = (List)Preconditions.checkNotNull(var1_1);
            this.function = (Function)Preconditions.checkNotNull(var2_2);
        }

        @Override
        public void clear() {
            this.fromList.clear();
        }

        @Override
        public int size() {
            return this.fromList.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ListIterator<T> listIterator(int index) {
            void var1_1;
            TransformingSequentialList transformingSequentialList = this;
            return new TransformedListIterator<F, T>(transformingSequentialList, transformingSequentialList.fromList.listIterator((int)var1_1)){
                final /* synthetic */ TransformingSequentialList this$0;
                {
                    void var2_2;
                    void var1_1;
                    this.this$0 = var1_1;
                    super(var2_2);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @ParametricNullness
                T transform(@ParametricNullness F from) {
                    void var1_1;
                    return this.this$0.function.apply(var1_1);
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean removeIf(Predicate<? super T> filter) {
            void var1_1;
            Preconditions.checkNotNull(filter);
            return this.fromList.removeIf(arg_0 -> this.lambda$removeIf$0((Predicate)var1_1, arg_0));
        }

        /*
         * WARNING - void declaration
         */
        private /* synthetic */ boolean lambda$removeIf$0(Predicate filter, Object element) {
            void var2_2;
            return filter.test(this.function.apply(var2_2));
        }
    }

    private static class TwoPlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        @ParametricNullness
        final E first;
        @ParametricNullness
        final E second;
        final E[] rest;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        TwoPlusArrayList(@ParametricNullness E first, @ParametricNullness E second, E[] rest) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.first = var1_1;
            this.second = var2_2;
            this.rest = (Object[])Preconditions.checkNotNull(var3_3);
        }

        @Override
        public int size() {
            return IntMath.saturatedAdd(this.rest.length, 2);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public E get(int index) {
            void var1_1;
            switch (index) {
                case 0: {
                    return this.first;
                }
                case 1: {
                    return this.second;
                }
            }
            Preconditions.checkElementIndex(index, this.size());
            return this.rest[var1_1 - 2];
        }
    }

    private static class OnePlusArrayList<E>
    extends AbstractList<E>
    implements Serializable,
    RandomAccess {
        @ParametricNullness
        final E first;
        final E[] rest;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        OnePlusArrayList(@ParametricNullness E first, E[] rest) {
            void var2_2;
            void var1_1;
            this.first = var1_1;
            this.rest = (Object[])Preconditions.checkNotNull(var2_2);
        }

        @Override
        public int size() {
            return IntMath.saturatedAdd(this.rest.length, 1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public E get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            if (index == 0) {
                return this.first;
            }
            return this.rest[var1_1 - true];
        }
    }
}

