/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.AbstractMultimap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterators;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Multiset;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Platform;
import com.google.common.collect.Sets;
import com.google.common.collect.TransformedListIterator;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractSequentialList;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public class LinkedListMultimap<K, V>
extends AbstractMultimap<K, V>
implements ListMultimap<K, V>,
Serializable {
    private transient Node<K, V> head;
    private transient Node<K, V> tail;
    private transient Map<K, KeyList<K, V>> keyToKeyList;
    private transient int size;
    private transient int modCount;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <K, V> LinkedListMultimap<K, V> create() {
        return new LinkedListMultimap<K, V>();
    }

    public static <K, V> LinkedListMultimap<K, V> create(int expectedKeys) {
        int n;
        return new LinkedListMultimap<K, V>(n);
    }

    public static <K, V> LinkedListMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        Multimap<? extends K, ? extends V> multimap2;
        return new LinkedListMultimap<K, V>(multimap2);
    }

    LinkedListMultimap() {
        this(12);
    }

    /*
     * WARNING - void declaration
     */
    private LinkedListMultimap(int expectedKeys) {
        void var1_1;
        this.keyToKeyList = Platform.newHashMapWithExpectedSize((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private LinkedListMultimap(Multimap<? extends K, ? extends V> multimap) {
        this(multimap.keySet().size());
        void var1_1;
        this.putAll((Multimap)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private Node<K, V> addNode(@ParametricNullness K key, @ParametricNullness V value, Node<K, V> nextSibling) {
        void var2_2;
        void var1_1;
        Node<K, V> node = new Node<K, V>(key, value);
        if (this.head == null) {
            this.tail = node;
            this.head = this.tail;
            this.keyToKeyList.put(key, new KeyList<K, V>(node));
            ++this.modCount;
        } else if (nextSibling == null) {
            Objects.requireNonNull(this.tail).next = node;
            node.previous = this.tail;
            this.tail = node;
            KeyList<K, V> keyList = this.keyToKeyList.get(key);
            if (keyList == null) {
                this.keyToKeyList.put(key, new KeyList<K, V>(node));
                ++this.modCount;
            } else {
                ++keyList.count;
                Node keyTail = keyList.tail;
                keyList.tail.nextSibling = node;
                node.previousSibling = var1_1;
                keyList.tail = node;
            }
        } else {
            KeyList<K, V> keyList = Objects.requireNonNull(this.keyToKeyList.get(var1_1));
            ++keyList.count;
            node.previous = nextSibling.previous;
            node.previousSibling = nextSibling.previousSibling;
            node.next = nextSibling;
            node.nextSibling = nextSibling;
            if (nextSibling.previousSibling == null) {
                keyList.head = node;
            } else {
                nextSibling.previousSibling.nextSibling = node;
            }
            if (nextSibling.previous == null) {
                this.head = node;
            } else {
                nextSibling.previous.next = node;
            }
            nextSibling.previous = node;
            var3_3.previousSibling = node;
        }
        ++this.size;
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private void removeNode(Node<K, V> node) {
        if (node.previous != null) {
            node.previous.next = node.next;
        } else {
            this.head = node.next;
        }
        if (node.next != null) {
            node.next.previous = node.previous;
        } else {
            this.tail = node.previous;
        }
        if (node.previousSibling == null && node.nextSibling == null) {
            KeyList<K, V> keyList = Objects.requireNonNull(this.keyToKeyList.remove(node.key));
            Objects.requireNonNull(this.keyToKeyList.remove(node.key)).count = 0;
            ++this.modCount;
        } else {
            KeyList<K, V> keyList = Objects.requireNonNull(this.keyToKeyList.get(node.key));
            --keyList.count;
            if (node.previousSibling == null) {
                keyList.head = Objects.requireNonNull(node.nextSibling);
            } else {
                node.previousSibling.nextSibling = node.nextSibling;
            }
            if (node.nextSibling == null) {
                var2_3.tail = Objects.requireNonNull(node.previousSibling);
            } else {
                void var1_1;
                node.nextSibling.previousSibling = var1_1.previousSibling;
            }
        }
        --this.size;
    }

    /*
     * WARNING - void declaration
     */
    private void removeAllNodes(@ParametricNullness K key) {
        void var1_1;
        Iterators.clear(new ValueForKeyIterator(var1_1));
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.keyToKeyList.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return this.values().contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean put(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        this.addNode(var1_1, var2_2, null);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        void var3_3;
        List<V> oldValues = this.getCopy(key);
        ValueForKeyIterator keyValues = new ValueForKeyIterator(key);
        Iterator<V> newValues = values.iterator();
        while (keyValues.hasNext() && newValues.hasNext()) {
            keyValues.next();
            keyValues.set(newValues.next());
        }
        while (keyValues.hasNext()) {
            keyValues.next();
            keyValues.remove();
        }
        while (newValues.hasNext()) {
            keyValues.add(newValues.next());
        }
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private List<V> getCopy(@ParametricNullness K key) {
        void var1_1;
        return Collections.unmodifiableList(Lists.newArrayList(new ValueForKeyIterator(var1_1)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<V> removeAll(Object key) {
        void var2_2;
        void var1_1;
        Object castKey = key;
        List<V> oldValues = this.getCopy(castKey);
        this.removeAllNodes(var1_1);
        return var2_2;
    }

    @Override
    public void clear() {
        this.head = null;
        this.tail = null;
        this.keyToKeyList.clear();
        this.size = 0;
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<V> get(@ParametricNullness K key) {
        void var1_1;
        return new AbstractSequentialList<V>(this, var1_1){
            final /* synthetic */ Object val$key;
            final /* synthetic */ LinkedListMultimap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$key = object;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public int size() {
                void var1_1;
                KeyList keyList = (KeyList)this.this$0.keyToKeyList.get(this.val$key);
                if (keyList == null) {
                    return 0;
                }
                return var1_1.count;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListIterator<V> listIterator(int index) {
                void var1_1;
                return this.this$0.new ValueForKeyIterator(this.val$key, (int)var1_1);
            }
        };
    }

    @Override
    Set<K> createKeySet() {
        class KeySetImpl
        extends Sets.ImprovedAbstractSet<K> {
            final /* synthetic */ LinkedListMultimap this$0;

            /*
             * WARNING - void declaration
             */
            KeySetImpl(LinkedListMultimap this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public int size() {
                return this.this$0.keyToKeyList.size();
            }

            @Override
            public Iterator<K> iterator() {
                return this.this$0.new DistinctKeyIterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean contains(Object key) {
                void var1_1;
                return this.this$0.containsKey(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean remove(Object o) {
                void var1_1;
                return !this.this$0.removeAll(var1_1).isEmpty();
            }
        }
        return new KeySetImpl(this);
    }

    @Override
    Multiset<K> createKeys() {
        return new Multimaps.Keys(this);
    }

    @Override
    public List<V> values() {
        return (List)super.values();
    }

    @Override
    List<V> createValues() {
        class ValuesImpl
        extends AbstractSequentialList<V> {
            final /* synthetic */ LinkedListMultimap this$0;

            /*
             * WARNING - void declaration
             */
            ValuesImpl(LinkedListMultimap this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public int size() {
                return this.this$0.size;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListIterator<V> listIterator(int index) {
                void var1_2;
                NodeIterator nodeItr = this.this$0.new NodeIterator(index);
                void v0 = var1_2;
                return new TransformedListIterator<Map.Entry<K, V>, V>(this, (ListIterator)v0, (NodeIterator)v0){
                    final /* synthetic */ NodeIterator val$nodeItr;
                    {
                        void var2_2;
                        this.val$nodeItr = nodeIterator;
                        super(var2_2);
                    }

                    @Override
                    @ParametricNullness
                    V transform(Map.Entry<K, V> entry) {
                        return entry.getValue();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public void set(@ParametricNullness V value) {
                        void var1_1;
                        this.val$nodeItr.setValue(var1_1);
                    }
                };
            }
        }
        return new ValuesImpl(this);
    }

    @Override
    public List<Map.Entry<K, V>> entries() {
        return (List)super.entries();
    }

    @Override
    List<Map.Entry<K, V>> createEntries() {
        class EntriesImpl
        extends AbstractSequentialList<Map.Entry<K, V>> {
            final /* synthetic */ LinkedListMultimap this$0;

            /*
             * WARNING - void declaration
             */
            EntriesImpl(LinkedListMultimap this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public int size() {
                return this.this$0.size;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ListIterator<Map.Entry<K, V>> listIterator(int index) {
                void var1_1;
                return this.this$0.new NodeIterator((int)var1_1);
            }

            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> action) {
                Preconditions.checkNotNull(action);
                Node node = this.this$0.head;
                while (node != null) {
                    action.accept(node);
                    node = node.next;
                }
            }
        }
        return new EntriesImpl(this);
    }

    @Override
    Iterator<Map.Entry<K, V>> entryIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        return new Multimaps.AsMap(this);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.size());
        for (Map.Entry entry : this.entries()) {
            void var3_3;
            stream.writeObject(entry.getKey());
            stream.writeObject(var3_3.getValue());
        }
    }

    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
        this.keyToKeyList = Maps.newLinkedHashMap();
        int size = stream.readInt();
        for (int i = 0; i < size; ++i) {
            Object key = stream.readObject();
            Object value = stream.readObject();
            this.put(key, value);
        }
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$300(LinkedListMultimap x0, Node x1) {
        void var1_1;
        x0.removeNode((Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(LinkedListMultimap x0, Object x1) {
        void var1_1;
        x0.removeAllNodes(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Node access$600(LinkedListMultimap x0, Object x1, Object x2, Node x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.addNode(var1_1, var2_2, (Node)var3_3);
    }

    private class ValueForKeyIterator
    implements ListIterator<V> {
        @ParametricNullness
        final K key;
        int nextIndex;
        Node<K, V> next;
        Node<K, V> current;
        Node<K, V> previous;

        /*
         * WARNING - void declaration
         */
        ValueForKeyIterator(K key) {
            void var2_2;
            this.key = key;
            KeyList keyList = (KeyList)LinkedListMultimap.this.keyToKeyList.get(var2_2);
            this.next = keyList == null ? null : ((KeyList)((Object)LinkedListMultimap.this)).head;
        }

        /*
         * WARNING - void declaration
         */
        public ValueForKeyIterator(K key, int index) {
            void var2_2;
            KeyList keyList = (KeyList)LinkedListMultimap.this.keyToKeyList.get(key);
            int size = keyList == null ? 0 : keyList.count;
            Preconditions.checkPositionIndex(index, size);
            if (index >= size / 2) {
                this.previous = keyList == null ? null : keyList.tail;
                this.nextIndex = size;
                while (index++ < size) {
                    this.previous();
                }
            } else {
                Node node = this.next = keyList == null ? null : ((KeyList)((Object)LinkedListMultimap.this)).head;
                while (index-- > 0) {
                    this.next();
                }
            }
            this.key = var2_2;
            this.current = null;
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        @ParametricNullness
        public V next() {
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.previous = this.current;
            this.next = this.next.nextSibling;
            ++this.nextIndex;
            return this.current.value;
        }

        @Override
        public boolean hasPrevious() {
            return this.previous != null;
        }

        @Override
        @ParametricNullness
        public V previous() {
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.current = this.previous;
            this.next = this.current;
            this.previous = this.previous.previousSibling;
            --this.nextIndex;
            return this.current.value;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void remove() {
            Preconditions.checkState(this.current != null, "no calls to next() since the last call to remove()");
            if (this.current != this.next) {
                this.previous = this.current.previousSibling;
                --this.nextIndex;
            } else {
                this.next = this.current.nextSibling;
            }
            LinkedListMultimap.access$300(LinkedListMultimap.this, this.current);
            this.current = null;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void set(@ParametricNullness V value) {
            void var1_1;
            Preconditions.checkState(this.current != null);
            this.current.value = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void add(@ParametricNullness V value) {
            void var1_1;
            this.previous = LinkedListMultimap.access$600(LinkedListMultimap.this, this.key, var1_1, this.next);
            ++this.nextIndex;
            this.current = null;
        }
    }

    private class DistinctKeyIterator
    implements Iterator<K> {
        final Set<K> seenKeys;
        Node<K, V> next;
        Node<K, V> current;
        int expectedModCount;

        private DistinctKeyIterator() {
            this.seenKeys = Sets.newHashSetWithExpectedSize(LinkedListMultimap.this.keySet().size());
            this.next = LinkedListMultimap.this.head;
            this.expectedModCount = LinkedListMultimap.this.modCount;
        }

        private void checkForConcurrentModification() {
            if (LinkedListMultimap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkForConcurrentModification();
            return this.next != null;
        }

        @Override
        @ParametricNullness
        public K next() {
            this.checkForConcurrentModification();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.seenKeys.add(this.current.key);
            do {
                this.next = this.next.next;
            } while (this.next != null && !this.seenKeys.add(this.next.key));
            return this.current.key;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            Preconditions.checkState(this.current != null, "no calls to next() since the last call to remove()");
            LinkedListMultimap.access$400(LinkedListMultimap.this, this.current.key);
            this.current = null;
            this.expectedModCount = LinkedListMultimap.this.modCount;
        }
    }

    private class NodeIterator
    implements ListIterator<Map.Entry<K, V>> {
        int nextIndex;
        Node<K, V> next;
        Node<K, V> current;
        Node<K, V> previous;
        int expectedModCount;

        NodeIterator(int index) {
            this.expectedModCount = LinkedListMultimap.this.modCount;
            int size = LinkedListMultimap.this.size();
            Preconditions.checkPositionIndex(index, size);
            if (index >= size / 2) {
                this.previous = LinkedListMultimap.this.tail;
                this.nextIndex = size;
                while (index++ < size) {
                    this.previous();
                }
            } else {
                this.next = LinkedListMultimap.this.head;
                while (index-- > 0) {
                    this.next();
                }
            }
            this.current = null;
        }

        private void checkForConcurrentModification() {
            if (LinkedListMultimap.this.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public boolean hasNext() {
            this.checkForConcurrentModification();
            return this.next != null;
        }

        @Override
        public Node<K, V> next() {
            this.checkForConcurrentModification();
            if (this.next == null) {
                throw new NoSuchElementException();
            }
            this.current = this.next;
            this.previous = this.current;
            this.next = this.next.next;
            ++this.nextIndex;
            return this.current;
        }

        @Override
        public void remove() {
            this.checkForConcurrentModification();
            Preconditions.checkState(this.current != null, "no calls to next() since the last call to remove()");
            if (this.current != this.next) {
                this.previous = this.current.previous;
                --this.nextIndex;
            } else {
                this.next = this.current.next;
            }
            LinkedListMultimap.access$300(LinkedListMultimap.this, this.current);
            this.current = null;
            this.expectedModCount = LinkedListMultimap.this.modCount;
        }

        @Override
        public boolean hasPrevious() {
            this.checkForConcurrentModification();
            return this.previous != null;
        }

        @Override
        public Node<K, V> previous() {
            this.checkForConcurrentModification();
            if (this.previous == null) {
                throw new NoSuchElementException();
            }
            this.current = this.previous;
            this.next = this.current;
            this.previous = this.previous.previous;
            --this.nextIndex;
            return this.current;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void set(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void add(Map.Entry<K, V> e) {
            throw new UnsupportedOperationException();
        }

        /*
         * WARNING - void declaration
         */
        void setValue(@ParametricNullness V value) {
            void var1_1;
            Preconditions.checkState(this.current != null);
            this.current.value = var1_1;
        }
    }

    private static class KeyList<K, V> {
        Node<K, V> head;
        Node<K, V> tail;
        int count;

        KeyList(Node<K, V> firstNode) {
            this.head = firstNode;
            this.tail = firstNode;
            firstNode.previousSibling = null;
            var1_1.nextSibling = null;
            this.count = 1;
        }
    }

    private static final class Node<K, V>
    extends AbstractMapEntry<K, V> {
        @ParametricNullness
        final K key;
        @ParametricNullness
        V value;
        Node<K, V> next;
        Node<K, V> previous;
        Node<K, V> nextSibling;
        Node<K, V> previousSibling;

        /*
         * WARNING - void declaration
         */
        Node(@ParametricNullness K key, @ParametricNullness V value) {
            void var2_2;
            void var1_1;
            this.key = var1_1;
            this.value = var2_2;
        }

        @Override
        @ParametricNullness
        public final K getKey() {
            return this.key;
        }

        @Override
        @ParametricNullness
        public final V getValue() {
            return this.value;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public final V setValue(@ParametricNullness V newValue) {
            void var2_2;
            void var1_1;
            V result = this.value;
            this.value = var1_1;
            return var2_2;
        }
    }
}

