/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.AbstractMapBasedMultiset;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Multisets;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.LinkedHashMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class LinkedHashMultiset<E>
extends AbstractMapBasedMultiset<E> {
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <E> LinkedHashMultiset<E> create() {
        return new LinkedHashMultiset<E>();
    }

    public static <E> LinkedHashMultiset<E> create(int distinctElements) {
        int n;
        return new LinkedHashMultiset<E>(n);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> LinkedHashMultiset<E> create(Iterable<? extends E> elements) {
        void var1_1;
        Iterable<? extends E> iterable;
        LinkedHashMultiset<E> multiset = LinkedHashMultiset.create(Multisets.inferDistinctElements(elements));
        Iterables.addAll(multiset, iterable);
        return var1_1;
    }

    private LinkedHashMultiset() {
        super(new LinkedHashMap());
    }

    /*
     * WARNING - void declaration
     */
    private LinkedHashMultiset(int distinctElements) {
        super(Maps.newLinkedHashMapWithExpectedSize((int)var1_1));
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        Serialization.writeMultiset(this, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var2_2;
        void var1_1;
        stream.defaultReadObject();
        int distinctElements = Serialization.readCount(stream);
        this.setBackingMap(new LinkedHashMap());
        Serialization.populateMultiset(this, (ObjectInputStream)var1_1, (int)var2_2);
    }
}

