/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.LinkedHashMultimapGwtSerializationDependencies;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Platform;
import com.google.common.collect.Sets;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class LinkedHashMultimap<K, V>
extends LinkedHashMultimapGwtSerializationDependencies<K, V> {
    private static final int DEFAULT_KEY_CAPACITY = 16;
    private static final int DEFAULT_VALUE_SET_CAPACITY = 2;
    @VisibleForTesting
    static final double VALUE_SET_LOAD_FACTOR = 1.0;
    @VisibleForTesting
    transient int valueSetCapacity = 2;
    private transient ValueEntry<K, V> multimapHeaderEntry;
    @GwtIncompatible
    private static final long serialVersionUID = 1L;

    public static <K, V> LinkedHashMultimap<K, V> create() {
        return new LinkedHashMultimap<K, V>(16, 2);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> LinkedHashMultimap<K, V> create(int expectedKeys, int expectedValuesPerKey) {
        void var1_1;
        int n;
        return new LinkedHashMultimap<K, V>(Maps.capacity(n), Maps.capacity((int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> LinkedHashMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        void var1_1;
        Multimap<? extends K, ? extends V> multimap2;
        LinkedHashMultimap<K, V> result = LinkedHashMultimap.create(multimap.keySet().size(), 2);
        result.putAll((Multimap)multimap2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> void succeedsInValueSet(ValueSetLink<K, V> pred, ValueSetLink<K, V> succ) {
        ValueSetLink<K, V> valueSetLink;
        void var1_1;
        pred.setSuccessorInValueSet(succ);
        var1_1.setPredecessorInValueSet(valueSetLink);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> void succeedsInMultimap(ValueEntry<K, V> pred, ValueEntry<K, V> succ) {
        ValueEntry<K, V> valueEntry;
        void var1_1;
        pred.setSuccessorInMultimap(succ);
        var1_1.setPredecessorInMultimap(valueEntry);
    }

    private static <K, V> void deleteFromValueSet(ValueSetLink<K, V> entry) {
        ValueSetLink<K, V> valueSetLink;
        LinkedHashMultimap.succeedsInValueSet(entry.getPredecessorInValueSet(), valueSetLink.getSuccessorInValueSet());
    }

    private static <K, V> void deleteFromMultimap(ValueEntry<K, V> entry) {
        ValueEntry<K, V> valueEntry;
        LinkedHashMultimap.succeedsInMultimap(entry.getPredecessorInMultimap(), valueEntry.getSuccessorInMultimap());
    }

    /*
     * WARNING - void declaration
     */
    private LinkedHashMultimap(int keyCapacity, int valueSetCapacity) {
        super(Platform.newLinkedHashMapWithExpectedSize((int)var1_1));
        void var2_2;
        void var1_1;
        CollectPreconditions.checkNonnegative(valueSetCapacity, "expectedValuesPerKey");
        this.valueSetCapacity = var2_2;
        this.multimapHeaderEntry = ValueEntry.newHeader();
        LinkedHashMultimap.succeedsInMultimap(this.multimapHeaderEntry, this.multimapHeaderEntry);
    }

    @Override
    final Set<V> createCollection() {
        return Platform.newLinkedHashSetWithExpectedSize(this.valueSetCapacity);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final Collection<V> createCollection(@ParametricNullness K key) {
        void var1_1;
        return new ValueSet(var1_1, this.valueSetCapacity);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Set<V> replaceValues(@ParametricNullness K key, Iterable<? extends V> values) {
        void var2_2;
        void var1_1;
        return super.replaceValues((Object)var1_1, (Iterable)var2_2);
    }

    @Override
    public final Set<Map.Entry<K, V>> entries() {
        return super.entries();
    }

    @Override
    public final Set<K> keySet() {
        return super.keySet();
    }

    @Override
    public final Collection<V> values() {
        return super.values();
    }

    @Override
    final Iterator<Map.Entry<K, V>> entryIterator() {
        return new Iterator<Map.Entry<K, V>>(this){
            ValueEntry<K, V> nextEntry;
            ValueEntry<K, V> toRemove;
            final /* synthetic */ LinkedHashMultimap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.nextEntry = this.this$0.multimapHeaderEntry.getSuccessorInMultimap();
            }

            @Override
            public boolean hasNext() {
                return this.nextEntry != this.this$0.multimapHeaderEntry;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Map.Entry<K, V> next() {
                void var1_1;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ValueEntry result = this.nextEntry;
                this.toRemove = result;
                this.nextEntry = this.nextEntry.getSuccessorInMultimap();
                return var1_1;
            }

            @Override
            public void remove() {
                Preconditions.checkState(this.toRemove != null, "no calls to next() since the last call to remove()");
                this.this$0.remove(this.toRemove.getKey(), this.toRemove.getValue());
                this.toRemove = null;
            }
        };
    }

    @Override
    final Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return Spliterators.spliterator(this.entries(), 17);
    }

    @Override
    final Iterator<V> valueIterator() {
        return Maps.valueIterator(this.entryIterator());
    }

    @Override
    final Spliterator<V> valueSpliterator() {
        return CollectSpliterators.map(this.entrySpliterator(), Map.Entry::getValue);
    }

    @Override
    public final void clear() {
        super.clear();
        LinkedHashMultimap.succeedsInMultimap(this.multimapHeaderEntry, this.multimapHeaderEntry);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
        stream.writeInt(this.keySet().size());
        for (K key : this.keySet()) {
            stream.writeObject(key);
        }
        stream.writeInt(this.size());
        for (Map.Entry entry : this.entries()) {
            void var3_3;
            stream.writeObject(entry.getKey());
            stream.writeObject(var3_3.getValue());
        }
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var3_4;
        stream.defaultReadObject();
        this.multimapHeaderEntry = ValueEntry.newHeader();
        LinkedHashMultimap.succeedsInMultimap(this.multimapHeaderEntry, this.multimapHeaderEntry);
        this.valueSetCapacity = 2;
        int distinctKeys = stream.readInt();
        Map<Object, Collection<V>> map = Platform.newLinkedHashMapWithExpectedSize(12);
        for (int i = 0; i < distinctKeys; ++i) {
            Object key = stream.readObject();
            map.put(key, this.createCollection(key));
        }
        int entries = stream.readInt();
        for (int i = 0; i < entries; ++i) {
            void var2_3;
            Object key = stream.readObject();
            Object value = stream.readObject();
            Objects.requireNonNull((Collection)map.get(var2_3)).add(value);
        }
        this.setMap(var3_4);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(ValueSetLink x0, ValueSetLink x1) {
        void var1_1;
        LinkedHashMultimap.succeedsInValueSet(x0, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$400(ValueEntry x0, ValueEntry x1) {
        void var1_1;
        LinkedHashMultimap.succeedsInMultimap(x0, var1_1);
    }

    @VisibleForTesting
    final class ValueSet
    extends Sets.ImprovedAbstractSet<V>
    implements ValueSetLink<K, V> {
        @ParametricNullness
        private final K key;
        @VisibleForTesting
        ValueEntry<K, V>[] hashTable;
        private int size = 0;
        private int modCount = 0;
        private ValueSetLink<K, V> firstEntry;
        private ValueSetLink<K, V> lastEntry;

        /*
         * WARNING - void declaration
         */
        ValueSet(K key, int expectedValues) {
            void var1_3;
            void var3_5;
            void var2_4;
            this.key = var2_4;
            this.firstEntry = this;
            this.lastEntry = this;
            int this$02 = Hashing.closedTableSize((int)var3_5, 1.0);
            ValueEntry[] hashTable = new ValueEntry[this$02];
            this.hashTable = var1_3;
        }

        private int mask() {
            return this.hashTable.length - 1;
        }

        @Override
        public final ValueSetLink<K, V> getPredecessorInValueSet() {
            return this.lastEntry;
        }

        @Override
        public final ValueSetLink<K, V> getSuccessorInValueSet() {
            return this.firstEntry;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPredecessorInValueSet(ValueSetLink<K, V> entry) {
            void var1_1;
            this.lastEntry = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setSuccessorInValueSet(ValueSetLink<K, V> entry) {
            void var1_1;
            this.firstEntry = var1_1;
        }

        @Override
        public final Iterator<V> iterator() {
            return new Iterator<V>(this){
                ValueSetLink<K, V> nextEntry;
                ValueEntry<K, V> toRemove;
                int expectedModCount;
                final /* synthetic */ ValueSet this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.nextEntry = this.this$1.firstEntry;
                    this.expectedModCount = this.this$1.modCount;
                }

                private void checkForComodification() {
                    if (this.this$1.modCount != this.expectedModCount) {
                        throw new ConcurrentModificationException();
                    }
                }

                @Override
                public boolean hasNext() {
                    this.checkForComodification();
                    return this.nextEntry != this.this$1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @ParametricNullness
                public V next() {
                    void var2_2;
                    void var1_1;
                    if (!this.hasNext()) {
                        throw new NoSuchElementException();
                    }
                    ValueEntry entry = (ValueEntry)this.nextEntry;
                    Object result = entry.getValue();
                    this.toRemove = entry;
                    this.nextEntry = var1_1.getSuccessorInValueSet();
                    return var2_2;
                }

                @Override
                public void remove() {
                    this.checkForComodification();
                    Preconditions.checkState(this.toRemove != null, "no calls to next() since the last call to remove()");
                    this.this$1.remove(this.toRemove.getValue());
                    this.expectedModCount = this.this$1.modCount;
                    this.toRemove = null;
                }
            };
        }

        @Override
        public final void forEach(Consumer<? super V> action) {
            Preconditions.checkNotNull(action);
            for (ValueSetLink entry = this.firstEntry; entry != this; entry = entry.getSuccessorInValueSet()) {
                action.accept(((ValueEntry)entry).getValue());
            }
        }

        @Override
        public final int size() {
            return this.size;
        }

        @Override
        public final boolean contains(Object o) {
            int smearedHash = Hashing.smearedHash(o);
            ValueEntry entry = this.hashTable[smearedHash & this.mask()];
            while (entry != null) {
                if (entry.matchesValue(o, smearedHash)) {
                    return true;
                }
                entry = entry.nextInValueBucket;
            }
            return false;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean add(@ParametricNullness V value) {
            void var2_2;
            void var1_1;
            ValueEntry rowHead;
            int smearedHash = Hashing.smearedHash(value);
            int bucket = smearedHash & this.mask();
            ValueEntry entry = rowHead = this.hashTable[bucket];
            while (entry != null) {
                if (entry.matchesValue(value, smearedHash)) {
                    return false;
                }
                entry = entry.nextInValueBucket;
            }
            ValueEntry newEntry = new ValueEntry(this.key, var1_1, (int)var2_2, rowHead);
            LinkedHashMultimap.access$200(this.lastEntry, newEntry);
            LinkedHashMultimap.access$200(newEntry, this);
            LinkedHashMultimap.access$400(LinkedHashMultimap.this.multimapHeaderEntry.getPredecessorInMultimap(), newEntry);
            LinkedHashMultimap.access$400(newEntry, LinkedHashMultimap.this.multimapHeaderEntry);
            this.hashTable[var3_3] = newEntry;
            ++this.size;
            ++this.modCount;
            this.rehashIfNecessary();
            return true;
        }

        private void rehashIfNecessary() {
            if (Hashing.needsResizing(this.size, this.hashTable.length, 1.0)) {
                ValueEntry[] hashTable = new ValueEntry[this.hashTable.length << 1];
                this.hashTable = hashTable;
                int mask = hashTable.length - 1;
                for (ValueSetLink entry = this.firstEntry; entry != this; entry = entry.getSuccessorInValueSet()) {
                    ValueEntry valueEntry = (ValueEntry)entry;
                    int bucket = valueEntry.smearedValueHash & mask;
                    valueEntry.nextInValueBucket = hashTable[bucket];
                    hashTable[bucket] = valueEntry;
                }
            }
        }

        @Override
        public final boolean remove(Object o) {
            int smearedHash = Hashing.smearedHash(o);
            int bucket = smearedHash & this.mask();
            ValueEntry prev = null;
            ValueEntry entry = this.hashTable[bucket];
            while (entry != null) {
                if (entry.matchesValue(o, smearedHash)) {
                    if (prev == null) {
                        this.hashTable[bucket] = entry.nextInValueBucket;
                    } else {
                        prev.nextInValueBucket = entry.nextInValueBucket;
                    }
                    LinkedHashMultimap.deleteFromValueSet(entry);
                    LinkedHashMultimap.deleteFromMultimap(entry);
                    --this.size;
                    ++this.modCount;
                    return true;
                }
                prev = entry;
                entry = entry.nextInValueBucket;
            }
            return false;
        }

        @Override
        public final void clear() {
            Arrays.fill(this.hashTable, null);
            this.size = 0;
            for (ValueSetLink entry = this.firstEntry; entry != this; entry = entry.getSuccessorInValueSet()) {
                ValueEntry valueEntry = (ValueEntry)entry;
                LinkedHashMultimap.deleteFromMultimap(valueEntry);
            }
            ValueSet valueSet = this;
            LinkedHashMultimap.access$200(valueSet, valueSet);
            ++this.modCount;
        }
    }

    @VisibleForTesting
    static final class ValueEntry<K, V>
    extends ImmutableEntry<K, V>
    implements ValueSetLink<K, V> {
        final int smearedValueHash;
        ValueEntry<K, V> nextInValueBucket;
        ValueSetLink<K, V> predecessorInValueSet;
        ValueSetLink<K, V> successorInValueSet;
        ValueEntry<K, V> predecessorInMultimap;
        ValueEntry<K, V> successorInMultimap;

        /*
         * WARNING - void declaration
         */
        ValueEntry(@ParametricNullness K key, @ParametricNullness V value, int smearedValueHash, ValueEntry<K, V> nextInValueBucket) {
            super(var1_1, var2_2);
            void var3_3;
            void var2_2;
            void var1_1;
            this.smearedValueHash = var3_3;
            this.nextInValueBucket = nextInValueBucket;
        }

        static <K, V> ValueEntry<K, V> newHeader() {
            return new ValueEntry<Object, Object>(null, null, 0, null);
        }

        /*
         * WARNING - void declaration
         */
        final boolean matchesValue(Object v, int smearedVHash) {
            void var1_1;
            void var2_2;
            return this.smearedValueHash == var2_2 && com.google.common.base.Objects.equal(this.getValue(), var1_1);
        }

        @Override
        public final ValueSetLink<K, V> getPredecessorInValueSet() {
            return Objects.requireNonNull(this.predecessorInValueSet);
        }

        @Override
        public final ValueSetLink<K, V> getSuccessorInValueSet() {
            return Objects.requireNonNull(this.successorInValueSet);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setPredecessorInValueSet(ValueSetLink<K, V> entry) {
            void var1_1;
            this.predecessorInValueSet = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void setSuccessorInValueSet(ValueSetLink<K, V> entry) {
            void var1_1;
            this.successorInValueSet = var1_1;
        }

        public final ValueEntry<K, V> getPredecessorInMultimap() {
            return Objects.requireNonNull(this.predecessorInMultimap);
        }

        public final ValueEntry<K, V> getSuccessorInMultimap() {
            return Objects.requireNonNull(this.successorInMultimap);
        }

        /*
         * WARNING - void declaration
         */
        public final void setSuccessorInMultimap(ValueEntry<K, V> multimapSuccessor) {
            void var1_1;
            this.successorInMultimap = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public final void setPredecessorInMultimap(ValueEntry<K, V> multimapPredecessor) {
            void var1_1;
            this.predecessorInMultimap = var1_1;
        }
    }

    private static interface ValueSetLink<K, V> {
        public ValueSetLink<K, V> getPredecessorInValueSet();

        public ValueSetLink<K, V> getSuccessorInValueSet();

        public void setPredecessorInValueSet(ValueSetLink<K, V> var1);

        public void setSuccessorInValueSet(ValueSetLink<K, V> var1);
    }
}

