/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Ordering;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class LexicographicalOrdering<T>
extends Ordering<Iterable<T>>
implements Serializable {
    final Comparator<? super T> elementOrder;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    LexicographicalOrdering(Comparator<? super T> elementOrder) {
        void var1_1;
        this.elementOrder = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int compare(Iterable<T> leftIterable, Iterable<T> rightIterable) {
        void var2_2;
        Iterator<T> left = leftIterable.iterator();
        Iterator<T> right = rightIterable.iterator();
        while (left.hasNext()) {
            void var3_3;
            if (!right.hasNext()) {
                return 1;
            }
            int result = this.elementOrder.compare(left.next(), right.next());
            if (result == 0) continue;
            return (int)var3_3;
        }
        if (var2_2.hasNext()) {
            return -1;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof LexicographicalOrdering) {
            void var1_1;
            LexicographicalOrdering that = (LexicographicalOrdering)object;
            return this.elementOrder.equals(var1_1.elementOrder);
        }
        return false;
    }

    public final int hashCode() {
        return this.elementOrder.hashCode() ^ 0x7BB78CF5;
    }

    public final String toString() {
        String string = String.valueOf(this.elementOrder);
        return new StringBuilder(18 + String.valueOf(string).length()).append(string).append(".lexicographical()").toString();
    }
}

