/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.primitives.Ints;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class JdkBackedImmutableMultiset<E>
extends ImmutableMultiset<E> {
    private final Map<E, Integer> delegateMap;
    private final ImmutableList<Multiset.Entry<E>> entries;
    private final long size;
    private transient ImmutableSet<E> elementSet;

    /*
     * WARNING - void declaration
     */
    static <E> ImmutableMultiset<E> create(Collection<? extends Multiset.Entry<? extends E>> entries) {
        void var3_2;
        Object[] objectArray;
        void var1_1;
        Object[] entriesArray = entries.toArray(new Multiset.Entry[0]);
        HashMap delegateMap = Maps.newHashMapWithExpectedSize(entriesArray.length);
        long size = 0L;
        for (int i = 0; i < entriesArray.length; ++i) {
            Multiset.Entry entry = entriesArray[i];
            int count = entry.getCount();
            size += (long)count;
            Object element = Preconditions.checkNotNull(entry.getElement());
            delegateMap.put(element, count);
            if (entry instanceof Multisets.ImmutableEntry) continue;
            entriesArray[i] = Multisets.immutableEntry(element, count);
        }
        return new JdkBackedImmutableMultiset<E>(var1_1, ImmutableList.asImmutableList(objectArray), (long)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    private JdkBackedImmutableMultiset(Map<E, Integer> delegateMap, ImmutableList<Multiset.Entry<E>> entries, long size) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.delegateMap = var1_1;
        this.entries = var2_2;
        this.size = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int count(Object element) {
        void var1_1;
        return this.delegateMap.getOrDefault(var1_1, 0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSet<E> elementSet() {
        void var1_1;
        ImmutableSet<E> result = this.elementSet;
        if (result == null) {
            this.elementSet = new ImmutableMultiset.ElementSet<E>(this.entries, this);
            return this.elementSet;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    final Multiset.Entry<E> getEntry(int index) {
        void var1_1;
        return (Multiset.Entry)this.entries.get((int)var1_1);
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    public final int size() {
        return Ints.saturatedCast(this.size);
    }
}

