/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableMapKeySet;
import com.google.common.collect.ImmutableMapValues;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class JdkBackedImmutableMap<K, V>
extends ImmutableMap<K, V> {
    private final transient Map<K, V> delegateMap;
    private final transient ImmutableList<Map.Entry<K, V>> entries;

    /*
     * WARNING - void declaration
     */
    static <K, V> ImmutableMap<K, V> create(int n, Map.Entry<K, V>[] entryArray, boolean throwIfDuplicateKeys2) {
        int n2;
        void var1_1;
        void var3_5;
        HashMap<K, V> delegateMap = Maps.newHashMapWithExpectedSize(n);
        HashMap<void, Object> duplicates = null;
        int dupCount2 = 0;
        for (int i = 0; i < n; ++i) {
            V value;
            entryArray[i] = RegularImmutableMap.makeImmutable(Objects.requireNonNull(entryArray[i]));
            K key = entryArray[i].getKey();
            V oldValue = delegateMap.put(key, value = entryArray[i].getValue());
            if (oldValue == null) continue;
            if (throwIfDuplicateKeys2) {
                String throwIfDuplicateKeys2 = String.valueOf(entryArray[i].getKey());
                String dupCount2 = String.valueOf(oldValue);
                throw JdkBackedImmutableMap.conflictException("key", entryArray[i], new StringBuilder(1 + String.valueOf(throwIfDuplicateKeys2).length() + String.valueOf(dupCount2).length()).append(throwIfDuplicateKeys2).append("=").append(dupCount2).toString());
            }
            if (duplicates == null) {
                duplicates = new HashMap<void, Object>();
            }
            duplicates.put((void)key, value);
            ++dupCount2;
        }
        if (duplicates != null) {
            Map.Entry[] newEntryArray = new Map.Entry[n - dupCount2];
            int outI = 0;
            for (int inI = 0; inI < n; ++inI) {
                Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[inI]);
                K key = entry.getKey();
                if (duplicates.containsKey(key)) {
                    void var2_4;
                    Object value = duplicates.get(key);
                    if (value == null) continue;
                    entry = new ImmutableMapEntry(key, value);
                    duplicates.put(var2_4, null);
                }
                newEntryArray[outI++] = entry;
            }
            entryArray = newEntryArray;
        }
        return new JdkBackedImmutableMap<K, V>(var3_5, ImmutableList.asImmutableList((Object[])var1_1, n2));
    }

    /*
     * WARNING - void declaration
     */
    JdkBackedImmutableMap(Map<K, V> delegateMap, ImmutableList<Map.Entry<K, V>> entries) {
        void var2_2;
        void var1_1;
        this.delegateMap = var1_1;
        this.entries = var2_2;
    }

    @Override
    public final int size() {
        return this.entries.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object key) {
        void var1_1;
        return this.delegateMap.get(var1_1);
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        JdkBackedImmutableMap jdkBackedImmutableMap = this;
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(jdkBackedImmutableMap, jdkBackedImmutableMap.entries);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void forEach(BiConsumer<? super K, ? super V> action) {
        void var1_1;
        Preconditions.checkNotNull(action);
        this.entries.forEach((Consumer<Map.Entry<K, V>>)((Consumer<Map.Entry>)arg_0 -> JdkBackedImmutableMap.lambda$forEach$0((BiConsumer)var1_1, arg_0)));
    }

    @Override
    final ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    final ImmutableCollection<V> createValues() {
        return new ImmutableMapValues(this);
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$forEach$0(BiConsumer action, Map.Entry e) {
        void var1_1;
        action.accept(e.getKey(), var1_1.getValue());
    }
}

