/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableMapKeySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Maps;
import com.google.common.collect.RegularImmutableMap;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class JdkBackedImmutableBiMap<K, V>
extends ImmutableBiMap<K, V> {
    private final transient ImmutableList<Map.Entry<K, V>> entries;
    private final Map<K, V> forwardDelegate;
    private final Map<V, K> backwardDelegate;
    private transient JdkBackedImmutableBiMap<V, K> inverse;

    /*
     * WARNING - void declaration
     */
    @VisibleForTesting
    static <K, V> ImmutableBiMap<K, V> create(int n3, Map.Entry<K, V>[] entryArray) {
        void var3_5;
        void var2_4;
        int n2;
        void var1_3;
        Object forwardDelegate = Maps.newHashMapWithExpectedSize(n3);
        HashMap backwardDelegate = Maps.newHashMapWithExpectedSize(n3);
        for (int i = 0; i < n3; ++i) {
            ImmutableMapEntry<K, V> e = RegularImmutableMap.makeImmutable(Objects.requireNonNull(entryArray[i]));
            entryArray[i] = e;
            Object oldValue = forwardDelegate.putIfAbsent(e.getKey(), e.getValue());
            if (oldValue != null) {
                String string = String.valueOf(e.getKey());
                String n3 = String.valueOf(oldValue);
                throw JdkBackedImmutableBiMap.conflictException("key", new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(n3).length()).append(string).append("=").append(n3).toString(), entryArray[i]);
            }
            Object oldKey = backwardDelegate.putIfAbsent(e.getValue(), e.getKey());
            if (oldKey == null) continue;
            String n3 = String.valueOf(oldKey);
            forwardDelegate = String.valueOf(e.getValue());
            throw JdkBackedImmutableBiMap.conflictException("value", new StringBuilder(1 + String.valueOf(n3).length() + String.valueOf(forwardDelegate).length()).append(n3).append("=").append((String)forwardDelegate).toString(), entryArray[i]);
        }
        ImmutableList<Map.Entry<K, V>> entryList = ImmutableList.asImmutableList((Object[])var1_3, n2);
        return new JdkBackedImmutableBiMap<K, V>(entryList, var2_4, var3_5);
    }

    /*
     * WARNING - void declaration
     */
    private JdkBackedImmutableBiMap(ImmutableList<Map.Entry<K, V>> entries, Map<K, V> forwardDelegate, Map<V, K> backwardDelegate) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.entries = var1_1;
        this.forwardDelegate = var2_2;
        this.backwardDelegate = var3_3;
    }

    @Override
    public final int size() {
        return this.entries.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableBiMap<V, K> inverse() {
        void var1_1;
        JdkBackedImmutableBiMap<K, V> result = this.inverse;
        if (result == null) {
            this.inverse = result = new JdkBackedImmutableBiMap<K, V>(new InverseEntries(), this.backwardDelegate, this.forwardDelegate);
            result.inverse = this;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object key) {
        void var1_1;
        return this.forwardDelegate.get(var1_1);
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        JdkBackedImmutableBiMap jdkBackedImmutableBiMap = this;
        return new ImmutableMapEntrySet.RegularEntrySet<K, V>(jdkBackedImmutableBiMap, jdkBackedImmutableBiMap.entries);
    }

    @Override
    final ImmutableSet<K> createKeySet() {
        return new ImmutableMapKeySet(this);
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    private final class InverseEntries
    extends ImmutableList<Map.Entry<V, K>> {
        private InverseEntries() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Map.Entry<V, K> get(int index) {
            void var1_2;
            Map.Entry entry = (Map.Entry)JdkBackedImmutableBiMap.this.entries.get(index);
            return Maps.immutableEntry(entry.getValue(), var1_2.getKey());
        }

        @Override
        final boolean isPartialView() {
            return false;
        }

        @Override
        public final int size() {
            return JdkBackedImmutableBiMap.this.entries.size();
        }
    }
}

