/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.TransformedIterator;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import com.google.common.primitives.Ints;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Deque;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.PriorityQueue;
import java.util.Queue;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Iterators {
    private Iterators() {
    }

    static <T> UnmodifiableIterator<T> emptyIterator() {
        return Iterators.emptyListIterator();
    }

    static <T> UnmodifiableListIterator<T> emptyListIterator() {
        return ArrayItr.EMPTY;
    }

    static <T> Iterator<T> emptyModifiableIterator() {
        return EmptyModifiableIterator.INSTANCE;
    }

    public static <T> UnmodifiableIterator<T> unmodifiableIterator(Iterator<? extends T> iterator) {
        Iterator<? extends T> iterator2;
        Preconditions.checkNotNull(iterator);
        if (iterator instanceof UnmodifiableIterator) {
            iterator = iterator;
            return iterator;
        }
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            @Override
            @ParametricNullness
            public T next() {
                return iterator2.next();
            }
        };
    }

    @Deprecated
    public static <T> UnmodifiableIterator<T> unmodifiableIterator(UnmodifiableIterator<T> iterator) {
        return Preconditions.checkNotNull(iterator);
    }

    /*
     * WARNING - void declaration
     */
    public static int size(Iterator<?> iterator) {
        void var1_1;
        long count = 0L;
        while (iterator.hasNext()) {
            iterator.next();
            ++count;
        }
        return Ints.saturatedCast((long)var1_1);
    }

    public static boolean contains(Iterator<?> iterator, Object element) {
        if (element == null) {
            while (iterator.hasNext()) {
                if (iterator.next() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                if (!element.equals(iterator.next())) continue;
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean removeAll(Iterator<?> removeFrom, Collection<?> elementsToRemove) {
        void var2_2;
        Preconditions.checkNotNull(elementsToRemove);
        boolean result = false;
        while (removeFrom.hasNext()) {
            if (!elementsToRemove.contains(removeFrom.next())) continue;
            removeFrom.remove();
            result = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean removeIf(Iterator<T> removeFrom, Predicate<? super T> predicate) {
        void var2_2;
        Preconditions.checkNotNull(predicate);
        boolean modified = false;
        while (removeFrom.hasNext()) {
            if (!predicate.apply(removeFrom.next())) continue;
            removeFrom.remove();
            modified = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean retainAll(Iterator<?> removeFrom, Collection<?> elementsToRetain) {
        void var2_2;
        Preconditions.checkNotNull(elementsToRetain);
        boolean result = false;
        while (removeFrom.hasNext()) {
            if (elementsToRetain.contains(removeFrom.next())) continue;
            removeFrom.remove();
            result = true;
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean elementsEqual(Iterator<?> iterator1, Iterator<?> iterator2) {
        void var1_1;
        while (iterator1.hasNext()) {
            void var3_3;
            void var2_2;
            if (!iterator2.hasNext()) {
                return false;
            }
            Object o1 = iterator1.next();
            Object o2 = iterator2.next();
            if (com.google.common.base.Objects.equal(var2_2, var3_3)) continue;
            return false;
        }
        return !var1_1.hasNext();
    }

    /*
     * WARNING - void declaration
     */
    public static String toString(Iterator<?> iterator) {
        void var1_1;
        StringBuilder sb = new StringBuilder("[");
        boolean first = true;
        while (iterator.hasNext()) {
            if (!first) {
                sb.append(", ");
            }
            first = false;
            sb.append(iterator.next());
        }
        return var1_1.append(']').toString();
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T getOnlyElement(Iterator<T> iterator) {
        void var1_1;
        Iterator<T> iterator2;
        T first = iterator.next();
        if (!iterator.hasNext()) {
            return first;
        }
        StringBuilder sb = new StringBuilder("expected one element but was: <").append(first);
        for (int i = 0; i < 4 && iterator.hasNext(); ++i) {
            sb.append(", ").append(iterator.next());
        }
        if (iterator2.hasNext()) {
            sb.append(", ...");
        }
        sb.append('>');
        throw new IllegalArgumentException(var1_1.toString());
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T getOnlyElement(Iterator<? extends T> iterator, @ParametricNullness T defaultValue) {
        void var1_1;
        if (iterator.hasNext()) {
            Iterator<? extends T> iterator2;
            return Iterators.getOnlyElement(iterator2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <T> T[] toArray(Iterator<? extends T> iterator, Class<T> type) {
        void var1_1;
        ArrayList<? extends T> arrayList = Lists.newArrayList(iterator);
        return Iterables.toArray(arrayList, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean addAll(Collection<T> addTo, Iterator<? extends T> iterator) {
        void var2_2;
        Preconditions.checkNotNull(addTo);
        Preconditions.checkNotNull(iterator);
        boolean wasModified = false;
        while (iterator.hasNext()) {
            wasModified |= addTo.add(iterator.next());
        }
        return (boolean)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static int frequency(Iterator<?> iterator, Object element) {
        void var2_2;
        int count = 0;
        while (Iterators.contains(iterator, element)) {
            ++count;
        }
        return (int)var2_2;
    }

    public static <T> Iterator<T> cycle(Iterable<T> iterable) {
        Iterable<T> iterable2;
        Preconditions.checkNotNull(iterable);
        return new Iterator<T>(){
            Iterator<T> iterator = Iterators.emptyModifiableIterator();

            @Override
            public boolean hasNext() {
                return this.iterator.hasNext() || iterable2.iterator().hasNext();
            }

            @Override
            @ParametricNullness
            public T next() {
                if (!this.iterator.hasNext()) {
                    this.iterator = iterable2.iterator();
                    if (!this.iterator.hasNext()) {
                        throw new NoSuchElementException();
                    }
                }
                return this.iterator.next();
            }

            @Override
            public void remove() {
                this.iterator.remove();
            }
        };
    }

    @SafeVarargs
    public static <T> Iterator<T> cycle(T ... elements) {
        return Iterators.cycle(Lists.newArrayList(elements));
    }

    private static <I extends Iterator<?>> Iterator<I> consumingForArray(I ... elements) {
        I[] IArray;
        return new UnmodifiableIterator<I>((Iterator[])IArray){
            int index = 0;
            final /* synthetic */ Iterator[] val$elements;
            {
                this.val$elements = iteratorArray;
            }

            @Override
            public boolean hasNext() {
                return this.index < this.val$elements.length;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public I next() {
                void var1_1;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Iterator result = Objects.requireNonNull(this.val$elements[this.index]);
                this.val$elements[this.index] = null;
                ++this.index;
                return var1_1;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b) {
        void var1_1;
        Iterator<? extends T> iterator;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        return Iterators.concat(Iterators.consumingForArray((Iterator[])new Iterator[]{iterator, var1_1}));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b, Iterator<? extends T> c) {
        void var2_2;
        void var1_1;
        Iterator<? extends T> iterator;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        Preconditions.checkNotNull(c);
        return Iterators.concat(Iterators.consumingForArray((Iterator[])new Iterator[]{iterator, var1_1, var2_2}));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterator<T> concat(Iterator<? extends T> a, Iterator<? extends T> b, Iterator<? extends T> c, Iterator<? extends T> d) {
        void var3_3;
        void var2_2;
        void var1_1;
        Iterator<? extends T> iterator;
        Preconditions.checkNotNull(a);
        Preconditions.checkNotNull(b);
        Preconditions.checkNotNull(c);
        Preconditions.checkNotNull(d);
        return Iterators.concat(Iterators.consumingForArray((Iterator[])new Iterator[]{iterator, var1_1, var2_2, var3_3}));
    }

    public static <T> Iterator<T> concat(Iterator<? extends T> ... inputs) {
        return Iterators.concatNoDefensiveCopy(Arrays.copyOf(inputs, inputs.length));
    }

    public static <T> Iterator<T> concat(Iterator<? extends Iterator<? extends T>> inputs) {
        Iterator<? extends Iterator<? extends T>> iterator;
        return new ConcatenatedIterator(iterator);
    }

    static <T> Iterator<T> concatNoDefensiveCopy(Iterator<? extends T> ... inputs) {
        Iterator<? extends T>[] iteratorArray;
        for (Iterator<? extends T> iterator : Preconditions.checkNotNull(inputs)) {
            Preconditions.checkNotNull(iterator);
        }
        return Iterators.concat(Iterators.consumingForArray((Iterator[])iteratorArray));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> UnmodifiableIterator<List<T>> partition(Iterator<T> iterator, int size) {
        void var1_1;
        return Iterators.partitionImpl(iterator, (int)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> UnmodifiableIterator<List<T>> paddedPartition(Iterator<T> iterator, int size) {
        void var1_1;
        return Iterators.partitionImpl(iterator, (int)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    private static <T> UnmodifiableIterator<List<T>> partitionImpl(Iterator<T> iterator, int size, boolean pad) {
        void var2_2;
        void var1_1;
        Iterator<T> iterator2;
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(size > 0);
        return new UnmodifiableIterator<List<T>>((int)var1_1, (boolean)var2_2){
            final /* synthetic */ int val$size;
            final /* synthetic */ boolean val$pad;
            {
                this.val$size = n;
                this.val$pad = bl;
            }

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public List<T> next() {
                void var2_2;
                void var3_4;
                void var1_1;
                int count;
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                Object[] array = new Object[this.val$size];
                for (count = 0; count < this.val$size && iterator2.hasNext(); ++count) {
                    array[count] = iterator2.next();
                }
                for (int i = count; i < this.val$size; ++i) {
                    array[i] = null;
                }
                List list = Collections.unmodifiableList(Arrays.asList(var1_1));
                if (this.val$pad || count == this.val$size) {
                    return list;
                }
                return var3_4.subList(0, (int)var2_2);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> UnmodifiableIterator<T> filter(Iterator<T> unfiltered, Predicate<? super T> retainIfTrue) {
        void var1_1;
        Iterator<T> iterator;
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(retainIfTrue);
        return new AbstractIterator<T>((Predicate)var1_1){
            final /* synthetic */ Predicate val$retainIfTrue;
            {
                this.val$retainIfTrue = predicate;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected T computeNext() {
                while (iterator.hasNext()) {
                    void var1_1;
                    Object element = iterator.next();
                    if (!this.val$retainIfTrue.apply(element)) continue;
                    return var1_1;
                }
                return this.endOfData();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <T> UnmodifiableIterator<T> filter(Iterator<?> unfiltered, Class<T> desiredType) {
        void var1_1;
        return Iterators.filter(unfiltered, Predicates.instanceOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean any(Iterator<T> iterator, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.indexOf(iterator, var1_1) != -1;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean all(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            void var2_2;
            T element = iterator.next();
            if (predicate.apply(var2_2)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T find(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            void var2_2;
            T t = iterator.next();
            if (!predicate.apply(t)) continue;
            return var2_2;
        }
        throw new NoSuchElementException();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T find(Iterator<? extends T> iterator, Predicate<? super T> predicate, T defaultValue) {
        void var2_2;
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            void var3_3;
            T t = iterator.next();
            if (!predicate.apply(t)) continue;
            return var3_3;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Optional<T> tryFind(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(iterator);
        Preconditions.checkNotNull(predicate);
        while (iterator.hasNext()) {
            void var2_2;
            T t = iterator.next();
            if (!predicate.apply(t)) continue;
            return Optional.of(var2_2);
        }
        return Optional.absent();
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int indexOf(Iterator<T> iterator, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate, "predicate");
        int i = 0;
        while (iterator.hasNext()) {
            void var3_3;
            T current = iterator.next();
            if (predicate.apply(var3_3)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> Iterator<T> transform(Iterator<F> fromIterator, Function<? super F, ? extends T> function) {
        void var1_1;
        Iterator<F> iterator;
        Preconditions.checkNotNull(function);
        return new TransformedIterator<F, T>(iterator, (Function)var1_1){
            final /* synthetic */ Function val$function;
            {
                void var1_1;
                this.val$function = function;
                super(var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @ParametricNullness
            T transform(@ParametricNullness F from) {
                void var1_1;
                return this.val$function.apply(var1_1);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T get(Iterator<T> iterator, int position) {
        Iterator<T> iterator2;
        Iterators.checkNonnegative(position);
        int skipped = Iterators.advance(iterator, position);
        if (!iterator.hasNext()) {
            void var2_2;
            void var1_1;
            throw new IndexOutOfBoundsException(new StringBuilder(91).append("position (").append((int)var1_1).append(") must be less than the number of elements that remained (").append((int)var2_2).append(")").toString());
        }
        return iterator2.next();
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T get(Iterator<? extends T> iterator, int position, @ParametricNullness T defaultValue) {
        void var2_2;
        Iterator<? extends T> iterator2;
        void var1_1;
        Iterators.checkNonnegative(position);
        Iterators.advance(iterator, (int)var1_1);
        return Iterators.getNext(iterator2, var2_2);
    }

    static void checkNonnegative(int position) {
        if (position < 0) {
            int n;
            throw new IndexOutOfBoundsException(new StringBuilder(43).append("position (").append(n).append(") must not be negative").toString());
        }
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T getNext(Iterator<? extends T> iterator, @ParametricNullness T defaultValue) {
        void var1_1;
        if (iterator.hasNext()) {
            Iterator<T> iterator2;
            return iterator2.next();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T getLast(Iterator<T> iterator) {
        void var1_1;
        do {
            T current = iterator.next();
        } while (iterator.hasNext());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T getLast(Iterator<? extends T> iterator, @ParametricNullness T defaultValue) {
        void var1_1;
        if (iterator.hasNext()) {
            Iterator<? extends T> iterator2;
            return Iterators.getLast(iterator2);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public static int advance(Iterator<?> iterator, int numberToAdvance) {
        void var2_2;
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(numberToAdvance >= 0, "numberToAdvance must be nonnegative");
        for (int i = 0; i < numberToAdvance && iterator.hasNext(); ++i) {
            iterator.next();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterator<T> limit(Iterator<T> iterator, int limitSize) {
        Iterator<T> iterator2;
        void var1_1;
        Preconditions.checkNotNull(iterator);
        Preconditions.checkArgument(limitSize >= 0, "limit is negative");
        return new Iterator<T>((int)var1_1, iterator2){
            private int count;
            final /* synthetic */ int val$limitSize;
            final /* synthetic */ Iterator val$iterator;
            {
                this.val$limitSize = n;
                this.val$iterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.count < this.val$limitSize && this.val$iterator.hasNext();
            }

            @Override
            @ParametricNullness
            public T next() {
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                ++this.count;
                return this.val$iterator.next();
            }

            @Override
            public void remove() {
                this.val$iterator.remove();
            }
        };
    }

    public static <T> Iterator<T> consumingIterator(Iterator<T> iterator) {
        Iterator<T> iterator2;
        Preconditions.checkNotNull(iterator);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return iterator2.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            @ParametricNullness
            public T next() {
                void var1_1;
                Object next = iterator2.next();
                iterator2.remove();
                return var1_1;
            }

            public String toString() {
                return "Iterators.consumingIterator(...)";
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    static <T> T pollNext(Iterator<T> iterator) {
        if (iterator.hasNext()) {
            void var1_1;
            Iterator<T> iterator2;
            T result = iterator.next();
            iterator2.remove();
            return var1_1;
        }
        return null;
    }

    static void clear(Iterator<?> iterator) {
        Preconditions.checkNotNull(iterator);
        while (iterator.hasNext()) {
            iterator.next();
            iterator.remove();
        }
    }

    @SafeVarargs
    public static <T> UnmodifiableIterator<T> forArray(T ... array) {
        T[] TArray;
        return Iterators.forArray(array, 0, TArray.length, 0);
    }

    /*
     * WARNING - void declaration
     */
    static <T> UnmodifiableListIterator<T> forArray(T[] array, int offset, int length, int index) {
        void var3_3;
        void var2_2;
        void var1_1;
        T[] TArray;
        Preconditions.checkArgument(length >= 0);
        int end = offset + length;
        Preconditions.checkPositionIndexes(offset, end, array.length);
        Preconditions.checkPositionIndex(index, length);
        if (length == 0) {
            return Iterators.emptyListIterator();
        }
        return new ArrayItr<T>(TArray, (int)var1_1, (int)var2_2, (int)var3_3);
    }

    public static <T> UnmodifiableIterator<T> singletonIterator(@ParametricNullness T value) {
        T t;
        return new UnmodifiableIterator<T>(){
            boolean done;

            @Override
            public boolean hasNext() {
                return !this.done;
            }

            @Override
            @ParametricNullness
            public T next() {
                if (this.done) {
                    throw new NoSuchElementException();
                }
                this.done = true;
                return t;
            }
        };
    }

    public static <T> UnmodifiableIterator<T> forEnumeration(Enumeration<T> enumeration) {
        Enumeration<T> enumeration2;
        Preconditions.checkNotNull(enumeration);
        return new UnmodifiableIterator<T>(){

            @Override
            public boolean hasNext() {
                return enumeration2.hasMoreElements();
            }

            @Override
            @ParametricNullness
            public T next() {
                return enumeration2.nextElement();
            }
        };
    }

    public static <T> Enumeration<T> asEnumeration(Iterator<T> iterator) {
        Iterator<T> iterator2;
        Preconditions.checkNotNull(iterator);
        return new Enumeration<T>(){

            @Override
            public boolean hasMoreElements() {
                return iterator2.hasNext();
            }

            @Override
            @ParametricNullness
            public T nextElement() {
                return iterator2.next();
            }
        };
    }

    public static <T> PeekingIterator<T> peekingIterator(Iterator<? extends T> iterator) {
        Iterator<? extends T> iterator2;
        if (iterator instanceof PeekingImpl) {
            iterator = iterator;
            return iterator;
        }
        return new PeekingImpl<T>(iterator2);
    }

    @Deprecated
    public static <T> PeekingIterator<T> peekingIterator(PeekingIterator<T> iterator) {
        return Preconditions.checkNotNull(iterator);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <T> UnmodifiableIterator<T> mergeSorted(Iterable<? extends Iterator<? extends T>> iterators, Comparator<? super T> comparator) {
        void var1_1;
        Iterable<? extends Iterator<? extends T>> iterable;
        Preconditions.checkNotNull(iterators, "iterators");
        Preconditions.checkNotNull(comparator, "comparator");
        return new MergingIterator(iterable, var1_1);
    }

    static <T> ListIterator<T> cast(Iterator<T> iterator) {
        return (ListIterator)iterator;
    }

    private static class ConcatenatedIterator<T>
    implements Iterator<T> {
        private Iterator<? extends T> toRemove;
        private Iterator<? extends T> iterator = Iterators.emptyIterator();
        private Iterator<? extends Iterator<? extends T>> topMetaIterator;
        private Deque<Iterator<? extends Iterator<? extends T>>> metaIterators;

        /*
         * WARNING - void declaration
         */
        ConcatenatedIterator(Iterator<? extends Iterator<? extends T>> metaIterator) {
            void var1_1;
            this.topMetaIterator = (Iterator)Preconditions.checkNotNull(var1_1);
        }

        private Iterator<? extends Iterator<? extends T>> getTopMetaIterator() {
            while (this.topMetaIterator == null || !this.topMetaIterator.hasNext()) {
                if (this.metaIterators != null && !this.metaIterators.isEmpty()) {
                    this.topMetaIterator = this.metaIterators.removeFirst();
                    continue;
                }
                return null;
            }
            return this.topMetaIterator;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean hasNext() {
            while (!Preconditions.checkNotNull(this.iterator).hasNext()) {
                void var1_1;
                this.topMetaIterator = this.getTopMetaIterator();
                if (this.topMetaIterator == null) {
                    return false;
                }
                this.iterator = this.topMetaIterator.next();
                if (!(this.iterator instanceof ConcatenatedIterator)) continue;
                ConcatenatedIterator topConcat = (ConcatenatedIterator)this.iterator;
                this.iterator = topConcat.iterator;
                if (this.metaIterators == null) {
                    this.metaIterators = new ArrayDeque<Iterator<? extends Iterator<? extends T>>>();
                }
                this.metaIterators.addFirst(this.topMetaIterator);
                if (topConcat.metaIterators != null) {
                    while (!topConcat.metaIterators.isEmpty()) {
                        this.metaIterators.addFirst(topConcat.metaIterators.removeLast());
                    }
                }
                this.topMetaIterator = var1_1.topMetaIterator;
            }
            return true;
        }

        @Override
        @ParametricNullness
        public T next() {
            if (this.hasNext()) {
                this.toRemove = this.iterator;
                return this.iterator.next();
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            if (this.toRemove == null) {
                throw new IllegalStateException("no calls to next() since the last call to remove()");
            }
            this.toRemove.remove();
            this.toRemove = null;
        }
    }

    private static class MergingIterator<T>
    extends UnmodifiableIterator<T> {
        final Queue<PeekingIterator<T>> queue;

        /*
         * WARNING - void declaration
         */
        public MergingIterator(Iterable<? extends Iterator<? extends T>> iterators, Comparator<? super T> itemComparator) {
            Iterator iterator;
            Comparator heapComparator = (o1, o2) -> {
                void var2_2;
                void var1_1;
                return itemComparator.compare((Object)var1_1.peek(), (Object)var2_2.peek());
            };
            this.queue = new PriorityQueue<PeekingIterator<T>>(2, heapComparator);
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Iterator iterator2 = (Iterator)iterator.next();
                if (!iterator2.hasNext()) continue;
                this.queue.add(Iterators.peekingIterator(var2_2));
            }
        }

        @Override
        public boolean hasNext() {
            return !this.queue.isEmpty();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public T next() {
            void var2_2;
            PeekingIterator<T> nextIter = this.queue.remove();
            T next = nextIter.next();
            if (nextIter.hasNext()) {
                void var1_1;
                this.queue.add((PeekingIterator<T>)var1_1);
            }
            return var2_2;
        }
    }

    private static class PeekingImpl<E>
    implements PeekingIterator<E> {
        private final Iterator<? extends E> iterator;
        private boolean hasPeeked;
        private E peekedElement;

        /*
         * WARNING - void declaration
         */
        public PeekingImpl(Iterator<? extends E> iterator) {
            void var1_1;
            this.iterator = (Iterator)Preconditions.checkNotNull(var1_1);
        }

        @Override
        public boolean hasNext() {
            return this.hasPeeked || this.iterator.hasNext();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        public E next() {
            void var1_1;
            if (!this.hasPeeked) {
                return this.iterator.next();
            }
            E result = NullnessCasts.uncheckedCastNullableTToT(this.peekedElement);
            this.hasPeeked = false;
            this.peekedElement = null;
            return var1_1;
        }

        @Override
        public void remove() {
            Preconditions.checkState(!this.hasPeeked, "Can't remove after you've peeked at next");
            this.iterator.remove();
        }

        @Override
        @ParametricNullness
        public E peek() {
            if (!this.hasPeeked) {
                this.peekedElement = this.iterator.next();
                this.hasPeeked = true;
            }
            return NullnessCasts.uncheckedCastNullableTToT(this.peekedElement);
        }
    }

    private static final class ArrayItr<T>
    extends AbstractIndexedListIterator<T> {
        static final UnmodifiableListIterator<Object> EMPTY = new ArrayItr<Object>(new Object[0], 0, 0, 0);
        private final T[] array;
        private final int offset;

        /*
         * WARNING - void declaration
         */
        ArrayItr(T[] array, int offset, int length, int index) {
            super((int)var3_3, index);
            void var2_2;
            void var1_1;
            void var3_3;
            this.array = var1_1;
            this.offset = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @ParametricNullness
        protected final T get(int index) {
            void var1_1;
            return this.array[this.offset + var1_1];
        }
    }

    private static enum EmptyModifiableIterator implements Iterator<Object>
    {
        INSTANCE;


        @Override
        public final boolean hasNext() {
            return false;
        }

        @Override
        public final Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public final void remove() {
            CollectPreconditions.checkRemove(false);
        }
    }
}

