/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.Collections2;
import com.google.common.collect.ConsumingQueueIterator;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Streams;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Queue;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class Iterables {
    private Iterables() {
    }

    public static <T> Iterable<T> unmodifiableIterable(Iterable<? extends T> iterable) {
        Iterable<? extends T> iterable2;
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof UnmodifiableIterable || iterable instanceof ImmutableCollection) {
            return iterable;
        }
        return new UnmodifiableIterable(iterable2);
    }

    @Deprecated
    public static <E> Iterable<E> unmodifiableIterable(ImmutableCollection<E> iterable) {
        return Preconditions.checkNotNull(iterable);
    }

    public static int size(Iterable<?> iterable) {
        Iterable<?> iterable2;
        if (iterable instanceof Collection) {
            return ((Collection)iterable).size();
        }
        return Iterators.size(iterable2.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static boolean contains(Iterable<? extends Object> iterable, Object element) {
        void var1_1;
        Iterable<? extends Object> iterable2;
        if (iterable instanceof Collection) {
            iterable = iterable;
            return Collections2.safeContains(iterable, element);
        }
        return Iterators.contains(iterable2.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean removeAll(Iterable<?> removeFrom, Collection<?> elementsToRemove) {
        void var1_1;
        Iterable<?> iterable;
        if (removeFrom instanceof Collection) {
            return ((Collection)removeFrom).removeAll(Preconditions.checkNotNull(elementsToRemove));
        }
        return Iterators.removeAll(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static boolean retainAll(Iterable<?> removeFrom, Collection<?> elementsToRetain) {
        void var1_1;
        Iterable<?> iterable;
        if (removeFrom instanceof Collection) {
            return ((Collection)removeFrom).retainAll(Preconditions.checkNotNull(elementsToRetain));
        }
        return Iterators.retainAll(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean removeIf(Iterable<T> removeFrom, Predicate<? super T> predicate) {
        void var1_1;
        Iterable<T> iterable;
        if (removeFrom instanceof Collection) {
            return ((Collection)removeFrom).removeIf(predicate);
        }
        return Iterators.removeIf(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <T> T removeFirstMatching(Iterable<T> removeFrom, Predicate<? super T> predicate) {
        Preconditions.checkNotNull(predicate);
        Iterator<T> iterator = removeFrom.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Object next = iterator.next();
            if (!predicate.apply(next)) continue;
            iterator.remove();
            return var2_2;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static boolean elementsEqual(Iterable<?> iterable1, Iterable<?> iterable2) {
        void var1_1;
        Iterable<?> iterable;
        if (iterable1 instanceof Collection && iterable2 instanceof Collection) {
            void var3_3;
            void var2_2;
            Collection collection1 = (Collection)iterable1;
            Collection collection2 = (Collection)iterable2;
            if (var2_2.size() != var3_3.size()) {
                return false;
            }
        }
        return Iterators.elementsEqual(iterable.iterator(), var1_1.iterator());
    }

    public static String toString(Iterable<?> iterable) {
        return Iterators.toString(iterable.iterator());
    }

    @ParametricNullness
    public static <T> T getOnlyElement(Iterable<T> iterable) {
        return Iterators.getOnlyElement(iterable.iterator());
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T getOnlyElement(Iterable<? extends T> iterable, @ParametricNullness T defaultValue) {
        void var1_1;
        return Iterators.getOnlyElement(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <T> T[] toArray(Iterable<? extends T> iterable, Class<T> type) {
        void var1_1;
        return Iterables.toArray(iterable, ObjectArrays.newArray(var1_1, 0));
    }

    /*
     * WARNING - void declaration
     */
    static <T> T[] toArray(Iterable<? extends T> iterable, T[] array) {
        void var1_1;
        Iterable<? extends T> iterable2 = Iterables.castOrCopyToCollection(iterable);
        return iterable2.toArray((T[])var1_1);
    }

    static Object[] toArray(Iterable<?> iterable) {
        return Iterables.castOrCopyToCollection(iterable).toArray();
    }

    private static <E> Collection<E> castOrCopyToCollection(Iterable<E> iterable) {
        Iterable<E> iterable2;
        if (iterable instanceof Collection) {
            return (Collection)iterable;
        }
        return Lists.newArrayList(iterable2.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean addAll(Collection<T> addTo, Iterable<? extends T> elementsToAdd) {
        Collection<T> collection;
        void var1_1;
        if (elementsToAdd instanceof Collection) {
            Collection c = (Collection)elementsToAdd;
            return addTo.addAll((Collection<T>)var1_1);
        }
        return Iterators.addAll(collection, ((Iterable)Preconditions.checkNotNull(var1_1)).iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static int frequency(Iterable<?> iterable, Object element) {
        void var1_1;
        Iterable<?> iterable2;
        if (iterable instanceof Multiset) {
            return ((Multiset)iterable).count(element);
        }
        if (iterable instanceof Set) {
            if (((Set)iterable).contains(element)) {
                return 1;
            }
            return 0;
        }
        return Iterators.frequency(iterable2.iterator(), var1_1);
    }

    public static <T> Iterable<T> cycle(Iterable<T> iterable) {
        Iterable<T> iterable2;
        Preconditions.checkNotNull(iterable);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.cycle(iterable2);
            }

            @Override
            public Spliterator<T> spliterator() {
                return Stream.generate(() -> iterable2).flatMap(Streams::stream).spliterator();
            }

            @Override
            public String toString() {
                return String.valueOf(iterable2.toString()).concat(" (cycled)");
            }
        };
    }

    @SafeVarargs
    public static <T> Iterable<T> cycle(T ... elements) {
        return Iterables.cycle(Lists.newArrayList(elements));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        void var1_1;
        return FluentIterable.concat(a, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b, Iterable<? extends T> c) {
        void var2_2;
        void var1_1;
        return FluentIterable.concat(a, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b, Iterable<? extends T> c, Iterable<? extends T> d) {
        void var3_3;
        void var2_2;
        void var1_1;
        return FluentIterable.concat(a, var1_1, var2_2, var3_3);
    }

    @SafeVarargs
    public static <T> Iterable<T> concat(Iterable<? extends T> ... inputs) {
        return FluentIterable.concat(inputs);
    }

    public static <T> Iterable<T> concat(Iterable<? extends Iterable<? extends T>> inputs) {
        return FluentIterable.concat(inputs);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<List<T>> partition(Iterable<T> iterable, int size) {
        void var1_1;
        Iterable<T> iterable2;
        Preconditions.checkNotNull(iterable);
        Preconditions.checkArgument(size > 0);
        return new FluentIterable<List<T>>((int)var1_1){
            final /* synthetic */ int val$size;
            {
                this.val$size = n;
            }

            @Override
            public Iterator<List<T>> iterator() {
                return Iterators.partition(iterable2.iterator(), this.val$size);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<List<T>> paddedPartition(Iterable<T> iterable, int size) {
        void var1_1;
        Iterable<T> iterable2;
        Preconditions.checkNotNull(iterable);
        Preconditions.checkArgument(size > 0);
        return new FluentIterable<List<T>>((int)var1_1){
            final /* synthetic */ int val$size;
            {
                this.val$size = n;
            }

            @Override
            public Iterator<List<T>> iterator() {
                return Iterators.paddedPartition(iterable2.iterator(), this.val$size);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> filter(Iterable<T> unfiltered, Predicate<? super T> retainIfTrue) {
        void var1_1;
        Iterable<T> iterable;
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(retainIfTrue);
        return new FluentIterable<T>((Predicate)var1_1){
            final /* synthetic */ Predicate val$retainIfTrue;
            {
                this.val$retainIfTrue = predicate;
            }

            @Override
            public Iterator<T> iterator() {
                return Iterators.filter(iterable.iterator(), this.val$retainIfTrue);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void forEach(Consumer<? super T> action) {
                void var1_1;
                Preconditions.checkNotNull(action);
                iterable.forEach(arg_0 -> 4.lambda$forEach$0(this.val$retainIfTrue, (Consumer)var1_1, arg_0));
            }

            @Override
            public Spliterator<T> spliterator() {
                return CollectSpliterators.filter(iterable.spliterator(), this.val$retainIfTrue);
            }

            /*
             * WARNING - void declaration
             */
            private static /* synthetic */ void lambda$forEach$0(Predicate retainIfTrue, Consumer action, Object a) {
                if (retainIfTrue.test(a)) {
                    void var2_2;
                    void var1_1;
                    var1_1.accept(var2_2);
                }
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public static <T> Iterable<T> filter(Iterable<?> unfiltered, Class<T> desiredType) {
        void var1_1;
        Iterable<?> iterable;
        Preconditions.checkNotNull(unfiltered);
        Preconditions.checkNotNull(desiredType);
        return Iterables.filter(iterable, Predicates.instanceOf(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean any(Iterable<T> iterable, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.any(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> boolean all(Iterable<T> iterable, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.all(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T find(Iterable<T> iterable, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.find(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> T find(Iterable<? extends T> iterable, Predicate<? super T> predicate, T defaultValue) {
        void var2_2;
        void var1_1;
        return Iterators.find(iterable.iterator(), var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Optional<T> tryFind(Iterable<T> iterable, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.tryFind(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> int indexOf(Iterable<T> iterable, Predicate<? super T> predicate) {
        void var1_1;
        return Iterators.indexOf(iterable.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <F, T> Iterable<T> transform(Iterable<F> fromIterable, Function<? super F, ? extends T> function) {
        void var1_1;
        Iterable<F> iterable;
        Preconditions.checkNotNull(fromIterable);
        Preconditions.checkNotNull(function);
        return new FluentIterable<T>((Function)var1_1){
            final /* synthetic */ Function val$function;
            {
                this.val$function = function;
            }

            @Override
            public Iterator<T> iterator() {
                return Iterators.transform(iterable.iterator(), this.val$function);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void forEach(Consumer<? super T> action) {
                void var1_1;
                Preconditions.checkNotNull(action);
                iterable.forEach(arg_0 -> 5.lambda$forEach$0((Consumer)var1_1, this.val$function, arg_0));
            }

            @Override
            public Spliterator<T> spliterator() {
                return CollectSpliterators.map(iterable.spliterator(), this.val$function);
            }

            /*
             * WARNING - void declaration
             */
            private static /* synthetic */ void lambda$forEach$0(Consumer action, Function function, Object f) {
                void var2_2;
                void var1_1;
                action.accept(var1_1.apply(var2_2));
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T get(Iterable<T> iterable, int position) {
        void var1_1;
        Iterable<T> iterable2;
        Preconditions.checkNotNull(iterable);
        if (iterable instanceof List) {
            return (T)((List)iterable).get(position);
        }
        return Iterators.get(iterable2.iterator(), (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T get(Iterable<? extends T> iterable, int position, @ParametricNullness T defaultValue) {
        void var2_2;
        List<T> list;
        void var1_1;
        List<T> list2;
        Preconditions.checkNotNull(iterable);
        Iterators.checkNonnegative(position);
        if (iterable instanceof List) {
            list2 = Lists.cast(iterable);
            if (position < list2.size()) {
                return (T)list2.get(position);
            }
            return defaultValue;
        }
        List<T> iterator = list2.iterator();
        Iterators.advance(iterator, (int)var1_1);
        return Iterators.getNext(list, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T getFirst(Iterable<? extends T> iterable, @ParametricNullness T defaultValue) {
        void var1_1;
        return Iterators.getNext(iterable.iterator(), var1_1);
    }

    @ParametricNullness
    public static <T> T getLast(Iterable<T> iterable) {
        List list;
        if (iterable instanceof List) {
            List list2 = (List)iterable;
            if (list2.isEmpty()) {
                throw new NoSuchElementException();
            }
            return Iterables.getLastInNonemptyList(list);
        }
        return Iterators.getLast(list.iterator());
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public static <T> T getLast(Iterable<? extends T> iterable, @ParametricNullness T defaultValue) {
        void var1_1;
        Iterable<T> iterable2;
        if (iterable instanceof Collection) {
            Collection collection = (Collection)iterable;
            if (collection.isEmpty()) {
                return defaultValue;
            }
            if (iterable instanceof List) {
                return Iterables.getLastInNonemptyList(Lists.cast(iterable));
            }
        }
        return Iterators.getLast(iterable2.iterator(), var1_1);
    }

    @ParametricNullness
    private static <T> T getLastInNonemptyList(List<T> list) {
        List<T> list2 = list;
        return list2.get(list2.size() - 1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> skip(Iterable<T> iterable, int numberToSkip) {
        void var1_1;
        Iterable<T> iterable2;
        Preconditions.checkNotNull(iterable);
        Preconditions.checkArgument(numberToSkip >= 0, "number to skip cannot be negative");
        return new FluentIterable<T>((int)var1_1){
            final /* synthetic */ int val$numberToSkip;
            {
                this.val$numberToSkip = n;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Iterator<T> iterator() {
                void var1_2;
                if (iterable2 instanceof List) {
                    void var2_3;
                    List list = (List)iterable2;
                    int toSkip = Math.min(list.size(), this.val$numberToSkip);
                    return list.subList((int)var2_3, list.size()).iterator();
                }
                Iterator iterator = iterable2.iterator();
                Iterators.advance(iterator, this.val$numberToSkip);
                return new Iterator<T>(this, (Iterator)var1_2){
                    boolean atStart = true;
                    final /* synthetic */ Iterator val$iterator;
                    {
                        this.val$iterator = iterator;
                    }

                    @Override
                    public boolean hasNext() {
                        return this.val$iterator.hasNext();
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    @ParametricNullness
                    public T next() {
                        void var1_1;
                        Object result = this.val$iterator.next();
                        this.atStart = false;
                        return var1_1;
                    }

                    @Override
                    public void remove() {
                        CollectPreconditions.checkRemove(!this.atStart);
                        this.val$iterator.remove();
                    }
                };
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Spliterator<T> spliterator() {
                if (iterable2 instanceof List) {
                    void var1_1;
                    void var2_2;
                    List list = (List)iterable2;
                    int toSkip = Math.min(list.size(), this.val$numberToSkip);
                    return list.subList((int)var2_2, var1_1.size()).spliterator();
                }
                return Streams.stream(iterable2).skip(this.val$numberToSkip).spliterator();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public static <T> Iterable<T> limit(Iterable<T> iterable, int limitSize) {
        void var1_1;
        Iterable<T> iterable2;
        Preconditions.checkNotNull(iterable);
        Preconditions.checkArgument(limitSize >= 0, "limit is negative");
        return new FluentIterable<T>((int)var1_1){
            final /* synthetic */ int val$limitSize;
            {
                this.val$limitSize = n;
            }

            @Override
            public Iterator<T> iterator() {
                return Iterators.limit(iterable2.iterator(), this.val$limitSize);
            }

            @Override
            public Spliterator<T> spliterator() {
                return Streams.stream(iterable2).limit(this.val$limitSize).spliterator();
            }
        };
    }

    public static <T> Iterable<T> consumingIterable(Iterable<T> iterable) {
        Iterable<T> iterable2;
        Preconditions.checkNotNull(iterable);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                if (iterable2 instanceof Queue) {
                    return new ConsumingQueueIterator((Queue)iterable2);
                }
                return Iterators.consumingIterator(iterable2.iterator());
            }

            @Override
            public String toString() {
                return "Iterables.consumingIterable(...)";
            }
        };
    }

    public static boolean isEmpty(Iterable<?> iterable) {
        Iterable<?> iterable2;
        if (iterable instanceof Collection) {
            return ((Collection)iterable).isEmpty();
        }
        return !iterable2.iterator().hasNext();
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <T> Iterable<T> mergeSorted(final Iterable<? extends Iterable<? extends T>> iterables, Comparator<? super T> comparator) {
        FluentIterable fluentIterable;
        void var1_1;
        Preconditions.checkNotNull(iterables, "iterables");
        Preconditions.checkNotNull(comparator, "comparator");
        FluentIterable iterable = new FluentIterable<T>((Comparator)var1_1){
            final /* synthetic */ Comparator val$comparator;
            {
                this.val$comparator = comparator;
            }

            @Override
            public Iterator<T> iterator() {
                return Iterators.mergeSorted(Iterables.transform(iterables, Iterables.toIterator()), this.val$comparator);
            }
        };
        return new UnmodifiableIterable(fluentIterable);
    }

    static <T> Function<Iterable<? extends T>, Iterator<? extends T>> toIterator() {
        return new Function<Iterable<? extends T>, Iterator<? extends T>>(){

            @Override
            public Iterator<? extends T> apply(Iterable<? extends T> iterable) {
                return iterable.iterator();
            }
        };
    }

    private static final class UnmodifiableIterable<T>
    extends FluentIterable<T> {
        private final Iterable<? extends T> iterable;

        /*
         * WARNING - void declaration
         */
        private UnmodifiableIterable(Iterable<? extends T> iterable) {
            void var1_1;
            this.iterable = var1_1;
        }

        @Override
        public final Iterator<T> iterator() {
            return Iterators.unmodifiableIterator(this.iterable.iterator());
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void forEach(Consumer<? super T> action) {
            void var1_1;
            this.iterable.forEach((Consumer<T>)var1_1);
        }

        @Override
        public final Spliterator<T> spliterator() {
            return this.iterable.spliterator();
        }

        @Override
        public final String toString() {
            return this.iterable.toString();
        }
    }
}

