/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Equivalence;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Interner;
import com.google.common.collect.MapMaker;
import com.google.common.collect.MapMakerInternalMap;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class Interners {
    private Interners() {
    }

    public static InternerBuilder newBuilder() {
        return new InternerBuilder();
    }

    public static <E> Interner<E> newStrongInterner() {
        return Interners.newBuilder().strong().build();
    }

    @GwtIncompatible(value="java.lang.ref.WeakReference")
    public static <E> Interner<E> newWeakInterner() {
        return Interners.newBuilder().weak().build();
    }

    public static <E> Function<E, E> asFunction(Interner<E> interner) {
        Interner<E> interner2;
        return new InternerFunction<E>(Preconditions.checkNotNull(interner2));
    }

    private static class InternerFunction<E>
    implements Function<E, E> {
        private final Interner<E> interner;

        /*
         * WARNING - void declaration
         */
        public InternerFunction(Interner<E> interner) {
            void var1_1;
            this.interner = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E apply(E input) {
            void var1_1;
            return this.interner.intern(var1_1);
        }

        public int hashCode() {
            return this.interner.hashCode();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean equals(Object other) {
            if (other instanceof InternerFunction) {
                void var1_1;
                InternerFunction that = (InternerFunction)other;
                return this.interner.equals(var1_1.interner);
            }
            return false;
        }
    }

    @VisibleForTesting
    static final class InternerImpl<E>
    implements Interner<E> {
        @VisibleForTesting
        final MapMakerInternalMap<E, MapMaker.Dummy, ?, ?> map;

        /*
         * WARNING - void declaration
         */
        private InternerImpl(MapMaker mapMaker) {
            void var1_1;
            this.map = MapMakerInternalMap.createWithDummyValues(var1_1.keyEquivalence(Equivalence.equals()));
        }

        @Override
        public final E intern(E sample) {
            MapMaker.Dummy dummy;
            do {
                Object canonical;
                Object entry;
                if ((entry = this.map.getEntry(sample)) == null || (canonical = entry.getKey()) == null) continue;
                sample = dummy;
                return sample;
            } while ((dummy = this.map.putIfAbsent(sample, MapMaker.Dummy.VALUE)) != null);
            return sample;
        }
    }

    public static class InternerBuilder {
        private final MapMaker mapMaker = new MapMaker();
        private boolean strong = true;

        private InternerBuilder() {
        }

        public InternerBuilder strong() {
            this.strong = true;
            return this;
        }

        @GwtIncompatible(value="java.lang.ref.WeakReference")
        public InternerBuilder weak() {
            this.strong = false;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public InternerBuilder concurrencyLevel(int concurrencyLevel) {
            void var1_1;
            this.mapMaker.concurrencyLevel((int)var1_1);
            return this;
        }

        public <E> Interner<E> build() {
            if (!this.strong) {
                this.mapMaker.weakKeys();
            }
            return new InternerImpl(this.mapMaker);
        }
    }
}

