/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.Spliterator;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
abstract class IndexedImmutableSet<E>
extends ImmutableSet.CachingAsList<E> {
    IndexedImmutableSet() {
    }

    abstract E get(int var1);

    @Override
    public UnmodifiableIterator<E> iterator() {
        return ((ImmutableCollection)((ImmutableCollection)this).asList()).iterator();
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1297, this::get);
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        void var1_1;
        return ((ImmutableCollection)this).asList().copyIntoArray((Object[])var1_1, (int)var2_2);
    }

    @Override
    ImmutableList<E> createAsList() {
        return new ImmutableAsList<E>(this){
            final /* synthetic */ IndexedImmutableSet this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public E get(int index) {
                void var1_1;
                return this.this$0.get((int)var1_1);
            }

            @Override
            boolean isPartialView() {
                return this.this$0.isPartialView();
            }

            @Override
            public int size() {
                return this.this$0.size();
            }

            @Override
            ImmutableCollection<E> delegateCollection() {
                return this.this$0;
            }
        };
    }
}

