/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractTable;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.RegularImmutableTable;
import com.google.common.collect.SingletonImmutableTable;
import com.google.common.collect.SparseImmutableTable;
import com.google.common.collect.Table;
import com.google.common.collect.TableCollectors;
import com.google.common.collect.Tables;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ImmutableTable<R, C, V>
extends AbstractTable<R, C, V>
implements Serializable {
    /*
     * WARNING - void declaration
     */
    public static <T, R, C, V> Collector<T, ?, ImmutableTable<R, C, V>> toImmutableTable(Function<? super T, ? extends R> rowFunction, Function<? super T, ? extends C> columnFunction, Function<? super T, ? extends V> valueFunction) {
        void var2_2;
        void var1_1;
        return TableCollectors.toImmutableTable(rowFunction, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, R, C, V> Collector<T, ?, ImmutableTable<R, C, V>> toImmutableTable(Function<? super T, ? extends R> rowFunction, Function<? super T, ? extends C> columnFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        void var3_3;
        void var2_2;
        void var1_1;
        return TableCollectors.toImmutableTable(rowFunction, var1_1, var2_2, var3_3);
    }

    public static <R, C, V> ImmutableTable<R, C, V> of() {
        return SparseImmutableTable.EMPTY;
    }

    /*
     * WARNING - void declaration
     */
    public static <R, C, V> ImmutableTable<R, C, V> of(R rowKey, C columnKey, V value) {
        void var2_2;
        void var1_1;
        R r;
        return new SingletonImmutableTable<R, void, void>(r, var1_1, var2_2);
    }

    public static <R, C, V> ImmutableTable<R, C, V> copyOf(Table<? extends R, ? extends C, ? extends V> table) {
        Table<R, C, V> table2;
        if (table instanceof ImmutableTable) {
            table = table;
            return table;
        }
        return ImmutableTable.copyOf(table2.cellSet());
    }

    /*
     * WARNING - void declaration
     */
    static <R, C, V> ImmutableTable<R, C, V> copyOf(Iterable<? extends Table.Cell<? extends R, ? extends C, ? extends V>> cells) {
        void var1_1;
        Iterator<? extends Table.Cell<? extends R, ? extends C, ? extends V>> iterator;
        Builder<R, C, V> builder = ImmutableTable.builder();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            Table.Cell cell = (Table.Cell)iterator.next();
            builder.put((Table.Cell<R, C, V>)var2_2);
        }
        return var1_1.build();
    }

    public static <R, C, V> Builder<R, C, V> builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    static <R, C, V> Table.Cell<R, C, V> cellOf(R rowKey, C columnKey, V value) {
        void var2_2;
        void var1_1;
        return Tables.immutableCell(Preconditions.checkNotNull(rowKey, "rowKey"), Preconditions.checkNotNull(var1_1, "columnKey"), Preconditions.checkNotNull(var2_2, "value"));
    }

    ImmutableTable() {
    }

    @Override
    public ImmutableSet<Table.Cell<R, C, V>> cellSet() {
        return (ImmutableSet)super.cellSet();
    }

    @Override
    abstract ImmutableSet<Table.Cell<R, C, V>> createCellSet();

    @Override
    final UnmodifiableIterator<Table.Cell<R, C, V>> cellIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    final Spliterator<Table.Cell<R, C, V>> cellSpliterator() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableCollection<V> values() {
        return (ImmutableCollection)super.values();
    }

    @Override
    abstract ImmutableCollection<V> createValues();

    @Override
    final Iterator<V> valuesIterator() {
        throw new AssertionError((Object)"should never be called");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableMap<R, V> column(C columnKey) {
        void var1_1;
        Preconditions.checkNotNull(columnKey, "columnKey");
        return MoreObjects.firstNonNull((ImmutableMap)((ImmutableMap)this.columnMap()).get(var1_1), ImmutableMap.of());
    }

    @Override
    public ImmutableSet<C> columnKeySet() {
        return ((ImmutableMap)this.columnMap()).keySet();
    }

    @Override
    public abstract ImmutableMap<C, Map<R, V>> columnMap();

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableMap<C, V> row(R rowKey) {
        void var1_1;
        Preconditions.checkNotNull(rowKey, "rowKey");
        return MoreObjects.firstNonNull((ImmutableMap)((ImmutableMap)this.rowMap()).get(var1_1), ImmutableMap.of());
    }

    @Override
    public ImmutableSet<R> rowKeySet() {
        return ((ImmutableMap)this.rowMap()).keySet();
    }

    @Override
    public abstract ImmutableMap<R, Map<C, V>> rowMap();

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object rowKey, Object columnKey) {
        void var2_2;
        void var1_1;
        return this.get(var1_1, var2_2) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return ((ImmutableCollection)this.values()).contains(var1_1);
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V put(R rowKey, C columnKey, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Table<? extends R, ? extends C, ? extends V> table) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object rowKey, Object columnKey) {
        throw new UnsupportedOperationException();
    }

    abstract SerializedForm createSerializedForm();

    final Object writeReplace() {
        return this.createSerializedForm();
    }

    static final class SerializedForm
    implements Serializable {
        private final Object[] rowKeys;
        private final Object[] columnKeys;
        private final Object[] cellValues;
        private final int[] cellRowIndices;
        private final int[] cellColumnIndices;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        private SerializedForm(Object[] rowKeys, Object[] columnKeys, Object[] cellValues, int[] cellRowIndices, int[] cellColumnIndices) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.rowKeys = var1_1;
            this.columnKeys = var2_2;
            this.cellValues = var3_3;
            this.cellRowIndices = cellRowIndices;
            this.cellColumnIndices = cellColumnIndices;
        }

        /*
         * WARNING - void declaration
         */
        static SerializedForm create(ImmutableTable<?, ?, ?> table, int[] cellRowIndices, int[] cellColumnIndices) {
            void var2_2;
            void var1_1;
            ImmutableTable<?, ?, ?> immutableTable;
            return new SerializedForm(((ImmutableCollection)((Object)table.rowKeySet())).toArray(), ((ImmutableCollection)((Object)table.columnKeySet())).toArray(), ((ImmutableCollection)immutableTable.values()).toArray(), (int[])var1_1, (int[])var2_2);
        }

        /*
         * WARNING - void declaration
         */
        final Object readResolve() {
            void var1_1;
            if (this.cellValues.length == 0) {
                return ImmutableTable.of();
            }
            if (this.cellValues.length == 1) {
                return ImmutableTable.of(this.rowKeys[0], this.columnKeys[0], this.cellValues[0]);
            }
            ImmutableList.Builder cellListBuilder = new ImmutableList.Builder(this.cellValues.length);
            for (int i = 0; i < this.cellValues.length; ++i) {
                cellListBuilder.add(ImmutableTable.cellOf(this.rowKeys[this.cellRowIndices[i]], this.columnKeys[this.cellColumnIndices[i]], this.cellValues[i]));
            }
            return RegularImmutableTable.forOrderedComponents(var1_1.build(), ImmutableSet.copyOf(this.rowKeys), ImmutableSet.copyOf(this.columnKeys));
        }
    }

    public static final class Builder<R, C, V> {
        private final List<Table.Cell<R, C, V>> cells = Lists.newArrayList();
        private Comparator<? super R> rowComparator;
        private Comparator<? super C> columnComparator;

        /*
         * WARNING - void declaration
         */
        public final Builder<R, C, V> orderRowsBy(Comparator<? super R> rowComparator) {
            void var1_1;
            this.rowComparator = (Comparator)Preconditions.checkNotNull(var1_1, "rowComparator");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<R, C, V> orderColumnsBy(Comparator<? super C> columnComparator) {
            void var1_1;
            this.columnComparator = (Comparator)Preconditions.checkNotNull(var1_1, "columnComparator");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<R, C, V> put(R rowKey, C columnKey, V value) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.cells.add(ImmutableTable.cellOf(var1_1, var2_2, var3_3));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<R, C, V> put(Table.Cell<? extends R, ? extends C, ? extends V> cell) {
            void var1_1;
            if (cell instanceof Tables.ImmutableCell) {
                Preconditions.checkNotNull(cell.getRowKey(), "row");
                Preconditions.checkNotNull(cell.getColumnKey(), "column");
                Preconditions.checkNotNull(cell.getValue(), "value");
                this.cells.add((Table.Cell<R, C, V>)var1_1);
            } else {
                this.put(var1_1.getRowKey(), var1_1.getColumnKey(), var1_1.getValue());
            }
            return this;
        }

        public final Builder<R, C, V> putAll(Table<? extends R, ? extends C, ? extends V> table) {
            for (Table.Cell<R, C, V> cell : table.cellSet()) {
                this.put(cell);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final Builder<R, C, V> combine(Builder<R, C, V> other) {
            void var1_1;
            this.cells.addAll(var1_1.cells);
            return this;
        }

        public final ImmutableTable<R, C, V> build() {
            return this.buildOrThrow();
        }

        public final ImmutableTable<R, C, V> buildOrThrow() {
            int n = this.cells.size();
            switch (n) {
                case 0: {
                    return ImmutableTable.of();
                }
                case 1: {
                    return new SingletonImmutableTable<R, C, V>(Iterables.getOnlyElement(this.cells));
                }
            }
            return RegularImmutableTable.forCells(this.cells, this.rowComparator, this.columnComparator);
        }
    }
}

