/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSetFauxverideShim;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedIterable;
import com.google.common.collect.SortedIterables;
import com.google.common.collect.UnmodifiableIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SequencedCollection;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Consumer;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSortedSet<E>
extends ImmutableSortedSetFauxverideShim<E>
implements SortedIterable<E>,
NavigableSet<E> {
    static final int SPLITERATOR_CHARACTERISTICS = 1301;
    final transient Comparator<? super E> comparator;
    @GwtIncompatible
    transient ImmutableSortedSet<E> descendingSet;

    public static <E> Collector<E, ?, ImmutableSortedSet<E>> toImmutableSortedSet(Comparator<? super E> comparator) {
        return CollectCollectors.toImmutableSortedSet(comparator);
    }

    static <E> RegularImmutableSortedSet<E> emptySet(Comparator<? super E> comparator) {
        Comparator<? super E> comparator2;
        if (Ordering.natural().equals(comparator)) {
            return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
        }
        return new RegularImmutableSortedSet<E>(ImmutableList.of(), comparator2);
    }

    public static <E> ImmutableSortedSet<E> of() {
        return RegularImmutableSortedSet.NATURAL_EMPTY_SET;
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E element) {
        E e;
        return new RegularImmutableSortedSet<E>(ImmutableList.of(e), Ordering.natural());
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2) {
        void var1_1;
        E e;
        return ImmutableSortedSet.construct(Ordering.natural(), 2, e, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3) {
        void var2_2;
        void var1_1;
        E e;
        return ImmutableSortedSet.construct(Ordering.natural(), 3, e, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableSortedSet.construct(Ordering.natural(), 4, e, var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableSortedSet.construct(Ordering.natural(), 5, e, var1_1, var2_2, var3_3, e5);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... remaining) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        Comparable[] comparableArray = new Comparable[6 + remaining.length];
        Comparable[] contents = comparableArray;
        comparableArray[0] = e;
        contents[1] = var1_1;
        contents[2] = var2_2;
        contents[3] = var3_3;
        contents[4] = e5;
        contents[5] = e6;
        System.arraycopy(remaining, 0, contents, 6, remaining.length);
        return ImmutableSortedSet.construct(Ordering.natural(), contents.length, contents);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedSet<E> copyOf(E[] elements) {
        E[] EArray;
        return ImmutableSortedSet.construct(Ordering.natural(), elements.length, (Comparable[])EArray.clone());
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterable<? extends E> elements) {
        Iterable<? extends E> iterable;
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, iterable);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Collection<? extends E> elements) {
        Collection<? extends E> collection;
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, collection);
    }

    public static <E> ImmutableSortedSet<E> copyOf(Iterator<? extends E> elements) {
        Iterator<? extends E> iterator;
        Ordering ordering = Ordering.natural();
        return ImmutableSortedSet.copyOf(ordering, iterator);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> elements) {
        void var1_1;
        Comparator<? super E> comparator2;
        return ((Builder)new Builder<E>(comparator2).addAll((Iterator)var1_1)).build();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> elements) {
        void var2_4;
        Comparator<? super E> comparator2;
        void var1_1;
        ImmutableSortedSet original;
        Preconditions.checkNotNull(comparator);
        boolean bl = SortedIterables.hasSameComparator(comparator, elements);
        if (bl && elements instanceof ImmutableSortedSet && !(original = (ImmutableSortedSet)elements).isPartialView()) {
            return original;
        }
        Object[] array = Iterables.toArray(var1_1);
        return ImmutableSortedSet.construct(comparator2, array.length, var2_4);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSortedSet<E> copyOf(Comparator<? super E> comparator, Collection<? extends E> elements) {
        void var1_1;
        return ImmutableSortedSet.copyOf(comparator, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSortedSet<E> copyOfSorted(SortedSet<E> sortedSet) {
        void var1_1;
        SequencedCollection<E> sequencedCollection;
        Comparator<E> comparator = SortedIterables.comparator(sortedSet);
        SequencedCollection<E> list = ImmutableList.copyOf(sortedSet);
        if (((AbstractCollection)((Object)list)).isEmpty()) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        return new RegularImmutableSortedSet<E>(sequencedCollection, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static <E> ImmutableSortedSet<E> construct(Comparator<? super E> comparator, int n, E ... contents) {
        Comparator<? super E> comparator2;
        void var3_3;
        void var2_2;
        void var1_1;
        if (n == 0) {
            return ImmutableSortedSet.emptySet(comparator);
        }
        ObjectArrays.checkElementsNotNull((Object[])contents, n);
        Arrays.sort(contents, 0, n, comparator);
        int uniques = 1;
        for (int i = 1; i < n; ++i) {
            E cur = contents[i];
            E prev = contents[uniques - 1];
            if (comparator.compare(cur, prev) == 0) continue;
            contents[uniques++] = cur;
        }
        Arrays.fill(contents, uniques, (int)var1_1, null);
        return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList((Object[])var2_2, (int)var3_3), comparator2);
    }

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        Comparator<E> comparator2;
        return new Builder<E>(comparator2);
    }

    public static <E extends Comparable<?>> Builder<E> reverseOrder() {
        return new Builder(Collections.reverseOrder());
    }

    public static <E extends Comparable<?>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    /*
     * WARNING - void declaration
     */
    int unsafeCompare(Object a, Object b) {
        void var2_2;
        void var1_1;
        return ImmutableSortedSet.unsafeCompare(this.comparator, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static int unsafeCompare(Comparator<?> comparator, Object a, Object b) {
        void var2_2;
        void var1_1;
        Comparator<?> comparator2 = comparator;
        return comparator2.compare(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableSortedSet(Comparator<? super E> comparator) {
        void var1_1;
        this.comparator = var1_1;
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.comparator;
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> headSet(E toElement) {
        void var1_1;
        return this.headSet((Object)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> headSet(E toElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.headSetImpl(Preconditions.checkNotNull(var1_1), (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> subSet(E fromElement, E toElement) {
        void var2_2;
        void var1_1;
        return this.subSet((Object)var1_1, true, (Object)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    public ImmutableSortedSet<E> subSet(E fromElement, boolean fromInclusive, E toElement, boolean toInclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(fromElement);
        Preconditions.checkNotNull(toElement);
        Preconditions.checkArgument(this.comparator.compare(fromElement, toElement) <= 0);
        return this.subSetImpl(var1_1, (boolean)var2_2, var3_3, toInclusive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> tailSet(E fromElement) {
        void var1_1;
        return this.tailSet((Object)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedSet<E> tailSet(E fromElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.tailSetImpl(Preconditions.checkNotNull(var1_1), (boolean)var2_2);
    }

    abstract ImmutableSortedSet<E> headSetImpl(E var1, boolean var2);

    abstract ImmutableSortedSet<E> subSetImpl(E var1, boolean var2, E var3, boolean var4);

    abstract ImmutableSortedSet<E> tailSetImpl(E var1, boolean var2);

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    public E lower(E e) {
        void var1_1;
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)var1_1, false)).descendingIterator(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E floor(E e) {
        void var1_1;
        return Iterators.getNext(((ImmutableSortedSet)this.headSet((Object)var1_1, true)).descendingIterator(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E ceiling(E e) {
        void var1_1;
        return Iterables.getFirst(this.tailSet((Object)var1_1, true), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    public E higher(E e) {
        void var1_1;
        return Iterables.getFirst(this.tailSet((Object)var1_1, false), null);
    }

    @Override
    public E first() {
        return ((ImmutableCollection)this).iterator().next();
    }

    @Override
    public E last() {
        return this.descendingIterator().next();
    }

    @Override
    @Deprecated
    @GwtIncompatible
    public final E pollFirst() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    @GwtIncompatible
    public final E pollLast() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    public ImmutableSortedSet<E> descendingSet() {
        void var1_1;
        ImmutableSortedSet<E> result = this.descendingSet;
        if (result == null) {
            result = this.descendingSet = this.createDescendingSet();
            this.descendingSet.descendingSet = this;
        }
        return var1_1;
    }

    @GwtIncompatible
    abstract ImmutableSortedSet<E> createDescendingSet();

    @Override
    public Spliterator<E> spliterator() {
        ImmutableSortedSet immutableSortedSet = this;
        return new Spliterators.AbstractSpliterator<E>(immutableSortedSet, immutableSortedSet.size(), 1365){
            final UnmodifiableIterator<E> iterator;
            final /* synthetic */ ImmutableSortedSet this$0;
            {
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((long)var2_2, arg1);
                this.iterator = ((ImmutableCollection)this.this$0).iterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public boolean tryAdvance(Consumer<? super E> action) {
                if (this.iterator.hasNext()) {
                    void var1_1;
                    var1_1.accept(this.iterator.next());
                    return true;
                }
                return false;
            }

            @Override
            public Comparator<? super E> getComparator() {
                return this.this$0.comparator;
            }
        };
    }

    @Override
    @GwtIncompatible
    public abstract UnmodifiableIterator<E> descendingIterator();

    abstract int indexOf(Object var1);

    private void readObject(ObjectInputStream unused) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm<E>(this.comparator, this.toArray());
    }

    private static class SerializedForm<E>
    implements Serializable {
        final Comparator<? super E> comparator;
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        public SerializedForm(Comparator<? super E> comparator, Object[] elements) {
            void var2_2;
            void var1_1;
            this.comparator = var1_1;
            this.elements = var2_2;
        }

        Object readResolve() {
            return ((Builder)new Builder<E>(this.comparator).add(this.elements)).build();
        }
    }

    public static final class Builder<E>
    extends ImmutableSet.Builder<E> {
        private final Comparator<? super E> comparator;
        private E[] elements;
        private int n;

        /*
         * WARNING - void declaration
         */
        public Builder(Comparator<? super E> comparator) {
            super(true);
            void var1_1;
            this.comparator = (Comparator)Preconditions.checkNotNull(var1_1);
            this.elements = new Object[4];
            this.n = 0;
        }

        @Override
        final void copy() {
            this.elements = Arrays.copyOf(this.elements, this.elements.length);
        }

        /*
         * WARNING - void declaration
         */
        private void sortAndDedup() {
            void var1_1;
            if (this.n == 0) {
                return;
            }
            Arrays.sort(this.elements, 0, this.n, this.comparator);
            int unique2 = 1;
            for (int i = 1; i < this.n; ++i) {
                void var3_4;
                int cmp = this.comparator.compare(this.elements[unique2 - 1], this.elements[i]);
                if (cmp < 0) {
                    this.elements[unique2++] = this.elements[i];
                    continue;
                }
                if (var3_4 <= 0) continue;
                String unique2 = String.valueOf(this.comparator);
                throw new AssertionError((Object)new StringBuilder(48 + String.valueOf(unique2).length()).append("Comparator ").append(unique2).append(" compare method violates its contract").toString());
            }
            Arrays.fill(this.elements, unique2, this.n, null);
            this.n = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> add(E element) {
            void var1_1;
            Preconditions.checkNotNull(element);
            this.copyIfNecessary();
            if (this.n == this.elements.length) {
                this.sortAndDedup();
                int newLength = ImmutableCollection.Builder.expandedCapacity(this.n, this.n + 1);
                if (newLength > this.elements.length) {
                    void var2_2;
                    this.elements = Arrays.copyOf(this.elements, (int)var2_2);
                }
            }
            this.elements[this.n++] = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> add(E ... elements) {
            void var1_1;
            ObjectArrays.checkElementsNotNull((Object[])elements);
            for (void e : var1_1) {
                this.add((Object)e);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> addAll(Iterable<? extends E> elements) {
            void var1_1;
            super.addAll((Iterable)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> addAll(Iterator<? extends E> elements) {
            void var1_1;
            super.addAll((Iterator)var1_1);
            return this;
        }

        @Override
        final Builder<E> combine(ImmutableSet.Builder<E> builder) {
            this.copyIfNecessary();
            Builder other = (Builder)builder;
            for (int i = 0; i < other.n; ++i) {
                this.add((Object)other.elements[i]);
            }
            return this;
        }

        @Override
        public final ImmutableSortedSet<E> build() {
            this.sortAndDedup();
            if (this.n == 0) {
                return ImmutableSortedSet.emptySet(this.comparator);
            }
            this.forceCopy = true;
            return new RegularImmutableSortedSet<E>(ImmutableList.asImmutableList(this.elements, this.n), this.comparator);
        }
    }
}

