/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.DescendingImmutableSortedMultiset;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSortedMultisetFauxverideShim;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Multiset;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableSortedMultiset;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.TreeMultiset;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class ImmutableSortedMultiset<E>
extends ImmutableSortedMultisetFauxverideShim<E>
implements SortedMultiset<E> {
    transient ImmutableSortedMultiset<E> descendingMultiset;

    public static <E> Collector<E, ?, ImmutableSortedMultiset<E>> toImmutableSortedMultiset(Comparator<? super E> comparator) {
        return ImmutableSortedMultiset.toImmutableSortedMultiset(comparator, Function.identity(), e -> 1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, E> Collector<T, ?, ImmutableSortedMultiset<E>> toImmutableSortedMultiset(Comparator<? super E> comparator, Function<? super T, ? extends E> elementFunction, ToIntFunction<? super T> countFunction) {
        Comparator comparator2;
        void var2_2;
        void var1_1;
        Preconditions.checkNotNull(comparator);
        Preconditions.checkNotNull(elementFunction);
        Preconditions.checkNotNull(countFunction);
        return Collector.of(() -> TreeMultiset.create(comparator), (arg_0, arg_1) -> ImmutableSortedMultiset.lambda$toImmutableSortedMultiset$2((Function)var1_1, (ToIntFunction)var2_2, arg_0, arg_1), (multiset1, multiset2) -> {
            Multiset multiset;
            void var1_1;
            multiset1.addAll(var1_1);
            return multiset;
        }, multiset -> {
            void var1_1;
            return ImmutableSortedMultiset.copyOfSortedEntries(comparator2, var1_1.entrySet());
        }, new Collector.Characteristics[0]);
    }

    public static <E> ImmutableSortedMultiset<E> of() {
        return RegularImmutableSortedMultiset.NATURAL_EMPTY_MULTISET;
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E element) {
        void var1_1;
        Object object;
        Object elementSet = (RegularImmutableSortedSet)ImmutableSortedSet.of(element);
        long[] cumulativeCounts = new long[]{0L, 1L};
        return new RegularImmutableSortedMultiset(object, (long[])var1_1, 0, 1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e1, E e2) {
        void var1_1;
        E e;
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e, var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e1, E e2, E e3) {
        void var2_2;
        void var1_1;
        E e;
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e, var1_1, var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e1, E e2, E e3, E e4) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e, var1_1, var2_2, var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e1, E e2, E e3, E e4, E e5) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(e, var1_1, var2_2, var3_3, e5));
    }

    /*
     * WARNING - void declaration
     */
    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... remaining) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        int n = remaining.length + 6;
        ArrayList all = Lists.newArrayListWithCapacity(n);
        Collections.addAll(all, e, var1_1, var2_2, var3_3, e5, e6);
        Collections.addAll(all, remaining);
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), all);
    }

    public static <E extends Comparable<? super E>> ImmutableSortedMultiset<E> copyOf(E[] elements) {
        E[] EArray;
        return ImmutableSortedMultiset.copyOf(Ordering.natural(), Arrays.asList(EArray));
    }

    public static <E> ImmutableSortedMultiset<E> copyOf(Iterable<? extends E> elements) {
        Iterable<? extends E> iterable;
        Ordering ordering = Ordering.natural();
        return ImmutableSortedMultiset.copyOf(ordering, iterable);
    }

    public static <E> ImmutableSortedMultiset<E> copyOf(Iterator<? extends E> elements) {
        Iterator<? extends E> iterator;
        Ordering ordering = Ordering.natural();
        return ImmutableSortedMultiset.copyOf(ordering, iterator);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSortedMultiset<E> copyOf(Comparator<? super E> comparator, Iterator<? extends E> elements) {
        void var1_1;
        Comparator<? super E> comparator2;
        Preconditions.checkNotNull(comparator);
        return ((Builder)new Builder<E>(comparator2).addAll((Iterator)var1_1)).build();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSortedMultiset<E> copyOf(Comparator<? super E> comparator, Iterable<? extends E> elements) {
        void var2_2;
        Comparator<? super E> comparator2;
        void var1_1;
        ImmutableSortedMultiset multiset;
        if (elements instanceof ImmutableSortedMultiset && comparator.equals((multiset = (ImmutableSortedMultiset)elements).comparator())) {
            if (multiset.isPartialView()) {
                return ImmutableSortedMultiset.copyOfSortedEntries(comparator, ((ImmutableCollection)((Object)multiset.entrySet())).asList());
            }
            return multiset;
        }
        elements = Lists.newArrayList(elements);
        TreeMultiset<? super E> sortedCopy = TreeMultiset.create(Preconditions.checkNotNull(comparator));
        Iterables.addAll(sortedCopy, var1_1);
        return ImmutableSortedMultiset.copyOfSortedEntries(comparator2, var2_2.entrySet());
    }

    public static <E> ImmutableSortedMultiset<E> copyOfSorted(SortedMultiset<E> sortedMultiset) {
        SortedMultiset<E> sortedMultiset2;
        return ImmutableSortedMultiset.copyOfSortedEntries(sortedMultiset.comparator(), Lists.newArrayList(sortedMultiset2.entrySet()));
    }

    /*
     * WARNING - void declaration
     */
    private static <E> ImmutableSortedMultiset<E> copyOfSortedEntries(Comparator<? super E> comparator, Collection<Multiset.Entry<E>> entries) {
        void var1_1;
        void var3_3;
        Comparator<? super E> comparator2;
        void var2_2;
        if (entries.isEmpty()) {
            return ImmutableSortedMultiset.emptyMultiset(comparator);
        }
        ImmutableList.Builder elementsBuilder = new ImmutableList.Builder(entries.size());
        long[] cumulativeCounts = new long[entries.size() + 1];
        int i = 0;
        for (Multiset.Entry<E> entry : entries) {
            elementsBuilder.add((Object)entry.getElement());
            cumulativeCounts[i + 1] = cumulativeCounts[i] + (long)entry.getCount();
            ++i;
        }
        return new RegularImmutableSortedMultiset<E>(new RegularImmutableSortedSet<E>(var2_2.build(), comparator2), (long[])var3_3, 0, var1_1.size());
    }

    static <E> ImmutableSortedMultiset<E> emptyMultiset(Comparator<? super E> comparator) {
        Comparator<? super E> comparator2;
        if (Ordering.natural().equals(comparator)) {
            return RegularImmutableSortedMultiset.NATURAL_EMPTY_MULTISET;
        }
        return new RegularImmutableSortedMultiset<E>(comparator2);
    }

    ImmutableSortedMultiset() {
    }

    @Override
    public final Comparator<? super E> comparator() {
        return ((ImmutableSortedSet)this.elementSet()).comparator();
    }

    @Override
    public abstract ImmutableSortedSet<E> elementSet();

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedMultiset<E> descendingMultiset() {
        void var1_1;
        ImmutableSortedMultiset<E> result = this.descendingMultiset;
        if (result == null) {
            this.descendingMultiset = this.isEmpty() ? ImmutableSortedMultiset.emptyMultiset(Ordering.from(this.comparator()).reverse()) : new DescendingImmutableSortedMultiset(this);
            return this.descendingMultiset;
        }
        return var1_1;
    }

    @Override
    @Deprecated
    public final Multiset.Entry<E> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final Multiset.Entry<E> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract ImmutableSortedMultiset<E> headMultiset(E var1, BoundType var2);

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSortedMultiset<E> subMultiset(E lowerBound, BoundType lowerBoundType, E upperBound, BoundType upperBoundType) {
        void var3_3;
        void var2_2;
        void var1_1;
        Preconditions.checkArgument(this.comparator().compare(lowerBound, upperBound) <= 0, "Expected lowerBound <= upperBound but %s > %s", lowerBound, upperBound);
        return ((ImmutableSortedMultiset)this.tailMultiset((Object)var1_1, (BoundType)var2_2)).headMultiset((Object)var3_3, upperBoundType);
    }

    @Override
    public abstract ImmutableSortedMultiset<E> tailMultiset(E var1, BoundType var2);

    public static <E> Builder<E> orderedBy(Comparator<E> comparator) {
        Comparator<E> comparator2;
        return new Builder<E>(comparator2);
    }

    public static <E extends Comparable<?>> Builder<E> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    public static <E extends Comparable<?>> Builder<E> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$toImmutableSortedMultiset$2(Function elementFunction, ToIntFunction countFunction, Multiset multiset, Object t) {
        void var3_3;
        void var1_1;
        Function function;
        multiset.add(Preconditions.checkNotNull(function.apply(t)), var1_1.applyAsInt(var3_3));
    }

    private static final class SerializedForm<E>
    implements Serializable {
        final Comparator<? super E> comparator;
        final E[] elements;
        final int[] counts;

        /*
         * WARNING - void declaration
         */
        SerializedForm(SortedMultiset<E> multiset) {
            Iterator iterator;
            this.comparator = multiset.comparator();
            int n = multiset.entrySet().size();
            this.elements = new Object[n];
            this.counts = new int[n];
            int i = 0;
            for (Multiset.Entry entry : iterator.entrySet()) {
                void var3_3;
                this.elements[i] = entry.getElement();
                this.counts[i] = var3_3.getCount();
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        final Object readResolve() {
            void var2_2;
            int n = this.elements.length;
            Builder<E> builder = new Builder<E>(this.comparator);
            for (int i = 0; i < n; ++i) {
                builder.addCopies((Object)this.elements[i], this.counts[i]);
            }
            return var2_2.build();
        }
    }

    public static class Builder<E>
    extends ImmutableMultiset.Builder<E> {
        /*
         * WARNING - void declaration
         */
        public Builder(Comparator<? super E> comparator) {
            super(TreeMultiset.create((Comparator)Preconditions.checkNotNull(var1_1)));
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> add(E element) {
            void var1_1;
            super.add((Object)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> add(E ... elements) {
            void var1_1;
            super.add((Object[])var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> addCopies(E element, int occurrences) {
            void var2_2;
            void var1_1;
            super.addCopies(var1_1, (int)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> setCount(E element, int count) {
            void var2_2;
            void var1_1;
            super.setCount(var1_1, (int)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> addAll(Iterable<? extends E> elements) {
            void var1_1;
            super.addAll((Iterable)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> addAll(Iterator<? extends E> elements) {
            void var1_1;
            super.addAll((Iterator)var1_1);
            return this;
        }

        @Override
        public ImmutableSortedMultiset<E> build() {
            return ImmutableSortedMultiset.copyOfSorted((SortedMultiset)this.contents);
        }
    }
}

