/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedMapFauxverideShim;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.UnmodifiableIterator;
import java.util.AbstractMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.Objects;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class ImmutableSortedMap<K, V>
extends ImmutableSortedMapFauxverideShim<K, V>
implements NavigableMap<K, V> {
    private static final Comparator<Comparable> NATURAL_ORDER = Ordering.natural();
    private static final ImmutableSortedMap<Comparable, Object> NATURAL_EMPTY_MAP = new ImmutableSortedMap(ImmutableSortedSet.emptySet(Ordering.natural()), ImmutableList.of());
    private final transient RegularImmutableSortedSet<K> keySet;
    private final transient ImmutableList<V> valueList;
    private transient ImmutableSortedMap<K, V> descendingMap;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Collector<T, ?, ImmutableSortedMap<K, V>> toImmutableSortedMap(Comparator<? super K> comparator, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var2_2;
        void var1_1;
        return CollectCollectors.toImmutableSortedMap(comparator, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Collector<T, ?, ImmutableSortedMap<K, V>> toImmutableSortedMap(Comparator<? super K> comparator, Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        void var3_3;
        void var2_2;
        void var1_1;
        return CollectCollectors.toImmutableSortedMap(comparator, var1_1, var2_2, var3_3);
    }

    static <K, V> ImmutableSortedMap<K, V> emptyMap(Comparator<? super K> comparator) {
        Comparator<? super K> comparator2;
        if (Ordering.natural().equals(comparator)) {
            return ImmutableSortedMap.of();
        }
        return new ImmutableSortedMap(ImmutableSortedSet.emptySet(comparator2), ImmutableList.of());
    }

    public static <K, V> ImmutableSortedMap<K, V> of() {
        return NATURAL_EMPTY_MAP;
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1) {
        void var1_1;
        K k;
        return ImmutableSortedMap.of(Ordering.natural(), k, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> ImmutableSortedMap<K, V> of(Comparator<? super K> comparator, K k1, V v1) {
        void var2_2;
        Comparator<? super K> comparator2;
        void var1_1;
        return new ImmutableSortedMap<K, void>(new RegularImmutableSortedSet<K>(ImmutableList.of(var1_1), Preconditions.checkNotNull(comparator2)), ImmutableList.of(var2_2));
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, var1_1), ImmutableSortedMap.entryOf(var2_2, var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, var1_1), ImmutableSortedMap.entryOf(var2_2, var3_3), ImmutableSortedMap.entryOf(k3, v3));
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, var1_1), ImmutableSortedMap.entryOf(var2_2, var3_3), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4));
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, var1_1), ImmutableSortedMap.entryOf(var2_2, var3_3), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5));
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, var1_1), ImmutableSortedMap.entryOf(var2_2, var3_3), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6));
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, var1_1), ImmutableSortedMap.entryOf(var2_2, var3_3), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6), ImmutableSortedMap.entryOf(k7, v7));
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, var1_1), ImmutableSortedMap.entryOf(var2_2, var3_3), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6), ImmutableSortedMap.entryOf(k7, v7), ImmutableSortedMap.entryOf(k8, v8));
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, var1_1), ImmutableSortedMap.entryOf(var2_2, var3_3), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6), ImmutableSortedMap.entryOf(k7, v7), ImmutableSortedMap.entryOf(k8, v8), ImmutableSortedMap.entryOf(k9, v9));
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return ImmutableSortedMap.fromEntries(ImmutableSortedMap.entryOf(k, var1_1), ImmutableSortedMap.entryOf(var2_2, var3_3), ImmutableSortedMap.entryOf(k3, v3), ImmutableSortedMap.entryOf(k4, v4), ImmutableSortedMap.entryOf(k5, v5), ImmutableSortedMap.entryOf(k6, v6), ImmutableSortedMap.entryOf(k7, v7), ImmutableSortedMap.entryOf(k8, v8), ImmutableSortedMap.entryOf(k9, v9), ImmutableSortedMap.entryOf(k10, v10));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        void var1_1;
        Map<? extends K, ? extends V> map2;
        Ordering naturalOrder = (Ordering)NATURAL_ORDER;
        return ImmutableSortedMap.copyOfInternal(map2, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableSortedMap<K, V> copyOf(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        void var1_1;
        return ImmutableSortedMap.copyOfInternal(map, (Comparator)Preconditions.checkNotNull(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <K, V> ImmutableSortedMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        void var1_1;
        Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable;
        Ordering naturalOrder = (Ordering)NATURAL_ORDER;
        return ImmutableSortedMap.copyOf(iterable, var1_1);
    }

    @Beta
    public static <K, V> ImmutableSortedMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries, Comparator<? super K> comparator) {
        Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable;
        return ImmutableSortedMap.fromEntries(Preconditions.checkNotNull(comparator), false, iterable);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableSortedMap<K, V> copyOfSorted(SortedMap<K, ? extends V> map) {
        SortedMap<K, V> sortedMap;
        void var1_1;
        ImmutableSortedMap kvMap;
        Comparator<Object> comparator = map.comparator();
        if (comparator == null) {
            comparator = NATURAL_ORDER;
        }
        if (map instanceof ImmutableSortedMap && !(kvMap = (ImmutableSortedMap)map).isPartialView()) {
            void var2_2;
            return var2_2;
        }
        return ImmutableSortedMap.fromEntries(var1_1, true, sortedMap.entrySet());
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> ImmutableSortedMap<K, V> copyOfInternal(Map<? extends K, ? extends V> map, Comparator<? super K> comparator) {
        Map<K, V> map2;
        void var1_1;
        ImmutableSortedMap kvMap;
        boolean bl;
        SortedMap sortedMap;
        boolean sameComparator = false;
        if (map instanceof SortedMap) {
            void var2_3;
            sortedMap = (SortedMap)map;
            Comparator comparator2 = sortedMap.comparator();
            boolean bl2 = comparator2 == null ? comparator == NATURAL_ORDER : (bl = comparator.equals(var2_3));
        }
        if (bl && map instanceof ImmutableSortedMap && !(kvMap = (ImmutableSortedMap)map).isPartialView()) {
            return sortedMap;
        }
        return ImmutableSortedMap.fromEntries(var1_1, bl, map2.entrySet());
    }

    private static <K extends Comparable<? super K>, V> ImmutableSortedMap<K, V> fromEntries(Map.Entry<K, V> ... entries) {
        Map.Entry<K, V>[] entryArray;
        return ImmutableSortedMap.fromEntries(Ordering.natural(), false, entryArray, entryArray.length);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> ImmutableSortedMap<K, V> fromEntries(Comparator<? super K> comparator, boolean sameComparator, Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        void var1_1;
        Comparator<? super K> comparator2;
        void var2_2;
        Map.Entry[] entryArray = Iterables.toArray(entries, EMPTY_ENTRY_ARRAY);
        void v0 = var2_2;
        return ImmutableSortedMap.fromEntries(comparator2, (boolean)var1_1, v0, ((void)v0).length);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> ImmutableSortedMap<K, V> fromEntries(final Comparator<? super K> comparator, boolean sameComparator, Map.Entry<K, V>[] entryArray, int size) {
        Comparator<? super K> comparator2;
        void onlyEntry2;
        switch (size) {
            case 0: {
                return ImmutableSortedMap.emptyMap(comparator);
            }
            case 1: {
                Map.Entry<K, V> onlyEntry2 = Objects.requireNonNull(entryArray[0]);
                return ImmutableSortedMap.of(comparator, onlyEntry2.getKey(), onlyEntry2.getValue());
            }
        }
        Object[] keys = new Object[size];
        Object[] values = new Object[size];
        if (onlyEntry2 != false) {
            for (int i = 0; i < size; ++i) {
                Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[i]);
                K key = entry.getKey();
                V value = entry.getValue();
                CollectPreconditions.checkEntryNotNull(key, value);
                keys[i] = key;
                values[i] = value;
            }
        } else {
            Arrays.sort(entryArray, 0, size, new Comparator<Map.Entry<K, V>>(){

                /*
                 * WARNING - void declaration
                 */
                @Override
                public int compare(Map.Entry<K, V> e1, Map.Entry<K, V> e2) {
                    void var2_2;
                    void var1_1;
                    Objects.requireNonNull(e1);
                    Objects.requireNonNull(e2);
                    return comparator.compare(var1_1.getKey(), var2_2.getKey());
                }
            });
            Map.Entry<K, V> firstEntry = Objects.requireNonNull(entryArray[0]);
            K prevKey = firstEntry.getKey();
            keys[0] = prevKey;
            values[0] = firstEntry.getValue();
            CollectPreconditions.checkEntryNotNull(keys[0], values[0]);
            for (int i = 1; i < size; ++i) {
                void var1_3;
                Map.Entry<K, V> prevEntry = Objects.requireNonNull(entryArray[i - 1]);
                Map.Entry<K, V> entry = Objects.requireNonNull(entryArray[i]);
                K key = entry.getKey();
                V value = entry.getValue();
                CollectPreconditions.checkEntryNotNull(key, value);
                keys[i] = key;
                values[i] = value;
                ImmutableSortedMap.checkNoConflict(comparator.compare(prevKey, key) != 0, "key", prevEntry, var1_3);
                prevKey = key;
            }
        }
        return new ImmutableSortedMap(new RegularImmutableSortedSet<K>(new RegularImmutableList(keys), comparator2), new RegularImmutableList(values));
    }

    public static <K extends Comparable<?>, V> Builder<K, V> naturalOrder() {
        return new Builder(Ordering.natural());
    }

    public static <K, V> Builder<K, V> orderedBy(Comparator<K> comparator) {
        Comparator<K> comparator2;
        return new Builder(comparator2);
    }

    public static <K extends Comparable<?>, V> Builder<K, V> reverseOrder() {
        return new Builder(Ordering.natural().reverse());
    }

    /*
     * WARNING - void declaration
     */
    ImmutableSortedMap(RegularImmutableSortedSet<K> keySet, ImmutableList<V> valueList) {
        this((RegularImmutableSortedSet<K>)var1_1, (ImmutableList<V>)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ImmutableSortedMap(RegularImmutableSortedSet<K> keySet, ImmutableList<V> valueList, ImmutableSortedMap<K, V> descendingMap) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.keySet = var1_1;
        this.valueList = var2_2;
        this.descendingMap = var3_3;
    }

    @Override
    public final int size() {
        return this.valueList.size();
    }

    @Override
    public final void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        ImmutableList keyList = ((ImmutableCollection)this.keySet).asList();
        for (int i = 0; i < this.size(); ++i) {
            action.accept(keyList.get(i), this.valueList.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object key) {
        void var1_2;
        int index = this.keySet.indexOf(key);
        if (index == -1) {
            return null;
        }
        return (V)this.valueList.get((int)var1_2);
    }

    @Override
    final boolean isPartialView() {
        return this.keySet.isPartialView() || this.valueList.isPartialView();
    }

    @Override
    public final ImmutableSet<Map.Entry<K, V>> entrySet() {
        return super.entrySet();
    }

    @Override
    final ImmutableSet<Map.Entry<K, V>> createEntrySet() {
        if (this.isEmpty()) {
            return ImmutableSet.of();
        }
        class EntrySet
        extends ImmutableMapEntrySet<K, V> {
            final /* synthetic */ ImmutableSortedMap this$0;

            /*
             * WARNING - void declaration
             */
            EntrySet(ImmutableSortedMap this$0) {
                void var1_1;
                this.this$0 = var1_1;
            }

            @Override
            public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                return ((ImmutableCollection)((ImmutableCollection)this).asList()).iterator();
            }

            @Override
            public Spliterator<Map.Entry<K, V>> spliterator() {
                return ((ImmutableCollection)((ImmutableCollection)this).asList()).spliterator();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void forEach(Consumer<? super Map.Entry<K, V>> action) {
                void var1_1;
                ((ImmutableCollection)this).asList().forEach(var1_1);
            }

            @Override
            ImmutableList<Map.Entry<K, V>> createAsList() {
                return new ImmutableAsList<Map.Entry<K, V>>(this){
                    final /* synthetic */ EntrySet this$1;
                    {
                        void var1_1;
                        this.this$1 = var1_1;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Map.Entry<K, V> get(int index) {
                        void var1_1;
                        return new AbstractMap.SimpleImmutableEntry(((ImmutableCollection)this.this$1.this$0.keySet).asList().get(index), this.this$1.this$0.valueList.get((int)var1_1));
                    }

                    @Override
                    public Spliterator<Map.Entry<K, V>> spliterator() {
                        return CollectSpliterators.indexed(this.size(), 1297, n -> this.get(n));
                    }

                    @Override
                    ImmutableCollection<Map.Entry<K, V>> delegateCollection() {
                        return this.this$1;
                    }
                };
            }

            @Override
            ImmutableMap<K, V> map() {
                return this.this$0;
            }
        }
        return new EntrySet(this);
    }

    @Override
    public final ImmutableSortedSet<K> keySet() {
        return this.keySet;
    }

    @Override
    final ImmutableSet<K> createKeySet() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public final ImmutableCollection<V> values() {
        return this.valueList;
    }

    @Override
    final ImmutableCollection<V> createValues() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public final Comparator<? super K> comparator() {
        return ((ImmutableSortedSet)this.keySet()).comparator();
    }

    @Override
    public final K firstKey() {
        return (K)((ImmutableSortedSet)this.keySet()).first();
    }

    @Override
    public final K lastKey() {
        return (K)((ImmutableSortedSet)this.keySet()).last();
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableSortedMap<K, V> getSubMap(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        if (fromIndex == 0 && toIndex == this.size()) {
            return this;
        }
        if (fromIndex == toIndex) {
            return ImmutableSortedMap.emptyMap(this.comparator());
        }
        return new ImmutableSortedMap<K, V>(this.keySet.getSubSet(fromIndex, toIndex), this.valueList.subList((int)var1_1, (int)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSortedMap<K, V> headMap(K toKey) {
        void var1_1;
        return this.headMap((Object)var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSortedMap<K, V> headMap(K toKey, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.getSubMap(0, this.keySet.headIndex(Preconditions.checkNotNull(var1_1), (boolean)var2_2));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSortedMap<K, V> subMap(K fromKey, K toKey) {
        void var2_2;
        void var1_1;
        return this.subMap((Object)var1_1, true, (Object)var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSortedMap<K, V> subMap(K fromKey, boolean fromInclusive, K toKey, boolean toInclusive) {
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkNotNull(fromKey);
        Preconditions.checkNotNull(toKey);
        Preconditions.checkArgument(this.comparator().compare(fromKey, toKey) <= 0, "expected fromKey <= toKey but %s > %s", fromKey, toKey);
        return ((ImmutableSortedMap)this.headMap((Object)var3_3, toInclusive)).tailMap((Object)var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSortedMap<K, V> tailMap(K fromKey) {
        void var1_1;
        return this.tailMap((Object)var1_1, true);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSortedMap<K, V> tailMap(K fromKey, boolean inclusive) {
        void var2_2;
        void var1_1;
        ImmutableSortedMap immutableSortedMap = this;
        return immutableSortedMap.getSubMap(immutableSortedMap.keySet.tailIndex(Preconditions.checkNotNull(var1_1), (boolean)var2_2), this.size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map.Entry<K, V> lowerEntry(K key) {
        void var1_1;
        return ((ImmutableSortedMap)this.headMap((Object)var1_1, false)).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final K lowerKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.lowerEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map.Entry<K, V> floorEntry(K key) {
        void var1_1;
        return ((ImmutableSortedMap)this.headMap((Object)var1_1, true)).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final K floorKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.floorEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map.Entry<K, V> ceilingEntry(K key) {
        void var1_1;
        return ((ImmutableSortedMap)this.tailMap((Object)var1_1, true)).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final K ceilingKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.ceilingEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Map.Entry<K, V> higherEntry(K key) {
        void var1_1;
        return ((ImmutableSortedMap)this.tailMap((Object)var1_1, false)).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final K higherKey(K key) {
        void var1_1;
        return Maps.keyOrNull(this.higherEntry(var1_1));
    }

    @Override
    public final Map.Entry<K, V> firstEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return (Map.Entry)((ImmutableCollection)((Object)((ImmutableMap)this).entrySet())).asList().get(0);
    }

    @Override
    public final Map.Entry<K, V> lastEntry() {
        if (this.isEmpty()) {
            return null;
        }
        return (Map.Entry)((ImmutableCollection)((Object)((ImmutableMap)this).entrySet())).asList().get(this.size() - 1);
    }

    @Override
    @Deprecated
    public final Map.Entry<K, V> pollFirstEntry() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final Map.Entry<K, V> pollLastEntry() {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableSortedMap<K, V> descendingMap() {
        void var1_1;
        ImmutableSortedMap<K, V> result = this.descendingMap;
        if (result == null) {
            if (this.isEmpty()) {
                return ImmutableSortedMap.emptyMap(Ordering.from(this.comparator()).reverse());
            }
            return new ImmutableSortedMap<K, V>((RegularImmutableSortedSet)this.keySet.descendingSet(), this.valueList.reverse(), this);
        }
        return var1_1;
    }

    @Override
    public final ImmutableSortedSet<K> navigableKeySet() {
        return this.keySet;
    }

    @Override
    public final ImmutableSortedSet<K> descendingKeySet() {
        return this.keySet.descendingSet();
    }

    @Override
    final Object writeReplace() {
        return new SerializedForm(this);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ImmutableSortedMap access$000(Comparator x0, Object x1, Object x2) {
        void var2_2;
        void var1_1;
        return ImmutableSortedMap.of(x0, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ ImmutableSortedMap access$100(Comparator x0, boolean x1, Map.Entry[] x2, int x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ImmutableSortedMap.fromEntries(x0, (boolean)var1_1, var2_2, (int)var3_3);
    }

    private static class SerializedForm<K, V>
    extends ImmutableMap.SerializedForm<K, V> {
        private final Comparator<? super K> comparator;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SerializedForm(ImmutableSortedMap<K, V> sortedMap) {
            super(sortedMap);
            void var1_1;
            this.comparator = var1_1.comparator();
        }

        @Override
        Builder<K, V> makeBuilder(int size) {
            return new Builder(this.comparator);
        }
    }

    public static class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        private final Comparator<? super K> comparator;

        /*
         * WARNING - void declaration
         */
        public Builder(Comparator<? super K> comparator) {
            void var1_1;
            this.comparator = (Comparator)Preconditions.checkNotNull(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<K, V> put(K key, V value) {
            void var2_2;
            void var1_1;
            super.put(var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            void var1_1;
            super.put(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            void var1_1;
            super.putAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Beta
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            void var1_1;
            super.putAll(var1_1);
            return this;
        }

        @Override
        @Deprecated
        @Beta
        public final Builder<K, V> orderEntriesByValue(Comparator<? super V> valueComparator) {
            throw new UnsupportedOperationException("Not available on ImmutableSortedMap.Builder");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Builder<K, V> combine(ImmutableMap.Builder<K, V> other) {
            void var1_1;
            super.combine(var1_1);
            return this;
        }

        @Override
        public ImmutableSortedMap<K, V> build() {
            return this.buildOrThrow();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ImmutableSortedMap<K, V> buildOrThrow() {
            switch (this.size) {
                case 0: {
                    return ImmutableSortedMap.emptyMap(this.comparator);
                }
                case 1: {
                    void var1_1;
                    Map.Entry onlyEntry = Objects.requireNonNull(this.entries[0]);
                    return ImmutableSortedMap.access$000(this.comparator, onlyEntry.getKey(), var1_1.getValue());
                }
            }
            return ImmutableSortedMap.access$100(this.comparator, false, this.entries, this.size);
        }

        @Override
        @Deprecated
        public final ImmutableSortedMap<K, V> buildKeepingLast() {
            throw new UnsupportedOperationException("ImmutableSortedMap.Builder does not yet implement buildKeepingLast()");
        }
    }
}

