/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.EmptyImmutableSetMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Multimap;
import com.google.common.collect.Ordering;
import com.google.common.collect.Platform;
import com.google.common.collect.Serialization;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.UnmodifiableIterator;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public class ImmutableSetMultimap<K, V>
extends ImmutableMultimap<K, V>
implements SetMultimap<K, V> {
    private final transient ImmutableSet<V> emptySet;
    private transient ImmutableSetMultimap<V, K> inverse;
    private transient ImmutableSet<Map.Entry<K, V>> entries;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Collector<T, ?, ImmutableSetMultimap<K, V>> toImmutableSetMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        return CollectCollectors.toImmutableSetMultimap(keyFunction, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Collector<T, ?, ImmutableSetMultimap<K, V>> flatteningToImmutableSetMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends Stream<? extends V>> valuesFunction) {
        void var1_1;
        return CollectCollectors.flatteningToImmutableSetMultimap(keyFunction, var1_1);
    }

    public static <K, V> ImmutableSetMultimap<K, V> of() {
        return EmptyImmutableSetMultimap.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableSetMultimap<K, V> of(K k1, V v1) {
        void var2_2;
        void var1_1;
        K k;
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put((Object)k, (Object)var1_1);
        return var2_2.build();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableSetMultimap<K, V> of(K k1, V v1, K k2, V v2) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put((Object)k, (Object)var1_1);
        builder.put((Object)var2_2, (Object)var3_3);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableSetMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put((Object)k, (Object)var1_1);
        builder.put((Object)var2_2, (Object)var3_3);
        builder.put((Object)k3, (Object)v3);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableSetMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put((Object)k, (Object)var1_1);
        builder.put((Object)var2_2, (Object)var3_3);
        builder.put((Object)k3, (Object)v3);
        builder.put((Object)k4, (Object)v4);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableSetMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        builder.put((Object)k, (Object)var1_1);
        builder.put((Object)var2_2, (Object)var3_3);
        builder.put((Object)k3, (Object)v3);
        builder.put((Object)k4, (Object)v4);
        builder.put((Object)k5, (Object)v5);
        return builder.build();
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    public static <K, V> ImmutableSetMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap) {
        return ImmutableSetMultimap.copyOf(multimap, null);
    }

    /*
     * WARNING - void declaration
     */
    private static <K, V> ImmutableSetMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap, Comparator<? super V> valueComparator) {
        void var1_1;
        Multimap<K, V> multimap2;
        ImmutableSetMultimap kvMultimap;
        Preconditions.checkNotNull(multimap);
        if (multimap.isEmpty() && valueComparator == null) {
            return ImmutableSetMultimap.of();
        }
        if (multimap instanceof ImmutableSetMultimap && !(kvMultimap = (ImmutableSetMultimap)multimap).isPartialView()) {
            void var2_2;
            return var2_2;
        }
        return ImmutableSetMultimap.fromMapEntries(multimap2.asMap().entrySet(), var1_1);
    }

    @Beta
    public static <K, V> ImmutableSetMultimap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable;
        return ((Builder)new Builder().putAll((Iterable)iterable)).build();
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> ImmutableSetMultimap<K, V> fromMapEntries(Collection<? extends Map.Entry<? extends K, ? extends Collection<? extends V>>> mapEntries, Comparator<? super V> valueComparator) {
        void var1_1;
        void var3_3;
        void var2_2;
        Iterator<? extends Map.Entry<? extends K, ? extends Collection<? extends V>>> iterator;
        if (mapEntries.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder(mapEntries.size());
        int size = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object key = entry.getKey();
            Collection values = (Collection)entry.getValue();
            ImmutableSet<V> set = ImmutableSetMultimap.valueSet(valueComparator, values);
            if (set.isEmpty()) continue;
            builder.put(key, set);
            size += set.size();
        }
        return new ImmutableSetMultimap(var2_2.buildOrThrow(), (int)var3_3, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableSetMultimap(ImmutableMap<K, ImmutableSet<V>> map, int size, Comparator<? super V> valueComparator) {
        super(var1_1, (int)var2_2);
        void var3_3;
        void var2_2;
        void var1_1;
        this.emptySet = ImmutableSetMultimap.emptySet(var3_3);
    }

    @Override
    public ImmutableSet<V> get(K key) {
        ImmutableSet immutableSet;
        immutableSet = (ImmutableSet)this.map.get(immutableSet);
        return MoreObjects.firstNonNull(immutableSet, this.emptySet);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSetMultimap<V, K> inverse() {
        void var1_1;
        ImmutableSetMultimap<V, K> result = this.inverse;
        if (result == null) {
            this.inverse = this.invert();
            return this.inverse;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableSetMultimap<V, K> invert() {
        void var1_1;
        Builder<K, V> builder = ImmutableSetMultimap.builder();
        Iterator iterator = this.entries().iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Map.Entry entry = (Map.Entry)iterator.next();
            builder.put(entry.getValue(), var3_3.getKey());
        }
        ImmutableMultimap invertedMultimap = var1_1.build();
        ((ImmutableSetMultimap)var1_1.build()).inverse = this;
        return iterator;
    }

    @Override
    @Deprecated
    public final ImmutableSet<V> removeAll(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final ImmutableSet<V> replaceValues(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSet<Map.Entry<K, V>> entries() {
        void var1_1;
        ImmutableSet<Map.Entry<K, V>> result = this.entries;
        if (result == null) {
            this.entries = new EntrySet(this);
            return this.entries;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static <V> ImmutableSet<V> valueSet(Comparator<? super V> valueComparator, Collection<? extends V> values) {
        void var1_1;
        Comparator<? super V> comparator;
        if (valueComparator == null) {
            return ImmutableSet.copyOf(values);
        }
        return ImmutableSortedSet.copyOf(comparator, var1_1);
    }

    private static <V> ImmutableSet<V> emptySet(Comparator<? super V> valueComparator) {
        Comparator<? super V> comparator;
        if (valueComparator == null) {
            return ImmutableSet.of();
        }
        return ImmutableSortedSet.emptySet(comparator);
    }

    private static <V> ImmutableSet.Builder<V> valuesBuilder(Comparator<? super V> valueComparator) {
        Comparator<? super V> comparator;
        if (valueComparator == null) {
            return new ImmutableSet.Builder();
        }
        return new ImmutableSortedSet.Builder<V>(comparator);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        stream.writeObject(this.valueComparator());
        Serialization.writeMultimap(this, (ObjectOutputStream)var1_1);
    }

    Comparator<? super V> valueComparator() {
        if (this.emptySet instanceof ImmutableSortedSet) {
            return ((ImmutableSortedSet)this.emptySet).comparator();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var2_2;
        ImmutableMap tmpMap;
        ((ObjectInputStream)stream).defaultReadObject();
        Comparator valueComparator = (Comparator)((ObjectInputStream)stream).readObject();
        int keyCount = ((ObjectInputStream)stream).readInt();
        if (keyCount < 0) {
            throw new InvalidObjectException(new StringBuilder(29).append("Invalid key count ").append(keyCount).toString());
        }
        ImmutableMap.Builder<Object, ImmutableCollection> builder = ImmutableMap.builder();
        int tmpSize = 0;
        for (int i = 0; i < keyCount; ++i) {
            Object key = ((ObjectInputStream)stream).readObject();
            int valueCount = ((ObjectInputStream)stream).readInt();
            if (valueCount <= 0) {
                throw new InvalidObjectException(new StringBuilder(31).append("Invalid value count ").append(valueCount).toString());
            }
            ImmutableSet.Builder<V> valuesBuilder = ImmutableSetMultimap.valuesBuilder(valueComparator);
            for (int j = 0; j < valueCount; ++j) {
                valuesBuilder.add(((ObjectInputStream)stream).readObject());
            }
            ImmutableCollection valueSet = valuesBuilder.build();
            if (valueSet.size() != valueCount) {
                stream = String.valueOf(key);
                throw new InvalidObjectException(new StringBuilder(40 + String.valueOf(stream).length()).append("Duplicate key-value pairs exist for key ").append((String)stream).toString());
            }
            builder.put(key, valueSet);
            tmpSize += valueCount;
        }
        try {
            tmpMap = builder.buildOrThrow();
        }
        catch (IllegalArgumentException e) {
            throw (InvalidObjectException)new InvalidObjectException(e.getMessage()).initCause(e);
        }
        ImmutableMultimap.FieldSettersHolder.MAP_FIELD_SETTER.set((ImmutableMultimap)this, tmpMap);
        ImmutableMultimap.FieldSettersHolder.SIZE_FIELD_SETTER.set((ImmutableMultimap)this, tmpSize);
        SetFieldSettersHolder.EMPTY_SET_FIELD_SETTER.set(this, ImmutableSetMultimap.emptySet(var2_2));
    }

    @GwtIncompatible
    private static final class SetFieldSettersHolder {
        static final Serialization.FieldSetter<ImmutableSetMultimap> EMPTY_SET_FIELD_SETTER = Serialization.getFieldSetter(ImmutableSetMultimap.class, "emptySet");

        private SetFieldSettersHolder() {
        }
    }

    private static final class EntrySet<K, V>
    extends ImmutableSet<Map.Entry<K, V>> {
        private final transient ImmutableSetMultimap<K, V> multimap;

        /*
         * WARNING - void declaration
         */
        EntrySet(ImmutableSetMultimap<K, V> multimap) {
            void var1_1;
            this.multimap = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                void var1_1;
                Map.Entry entry = (Map.Entry)object;
                return this.multimap.containsEntry(entry.getKey(), var1_1.getValue());
            }
            return false;
        }

        @Override
        public final int size() {
            return this.multimap.size();
        }

        @Override
        public final UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.multimap.entryIterator();
        }

        @Override
        final boolean isPartialView() {
            return false;
        }
    }

    public static final class Builder<K, V>
    extends ImmutableMultimap.Builder<K, V> {
        @Override
        final Collection<V> newMutableValueCollection() {
            return Platform.preservesInsertionOrderOnAddsSet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> put(K key, V value) {
            void var2_2;
            void var1_1;
            super.put(var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            void var1_1;
            super.put(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Beta
        public final Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            void var1_1;
            super.putAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> putAll(K key, Iterable<? extends V> values) {
            void var2_2;
            void var1_1;
            super.putAll(var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> putAll(K key, V ... values) {
            void var2_2;
            void var1_1;
            return this.putAll((Object)var1_1, (Iterable)Arrays.asList(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> putAll(Multimap<? extends K, ? extends V> multimap) {
            for (Map.Entry<K, Collection<V>> entry : multimap.asMap().entrySet()) {
                void var2_2;
                this.putAll((Object)entry.getKey(), (Iterable)var2_2.getValue());
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Builder<K, V> combine(ImmutableMultimap.Builder<K, V> other) {
            void var1_1;
            super.combine(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> orderKeysBy(Comparator<? super K> keyComparator) {
            void var1_1;
            super.orderKeysBy(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> orderValuesBy(Comparator<? super V> valueComparator) {
            void var1_1;
            super.orderValuesBy(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ImmutableSetMultimap<K, V> build() {
            void var1_1;
            Collection mapEntries = this.builderMap.entrySet();
            if (this.keyComparator != null) {
                mapEntries = Ordering.from(this.keyComparator).onKeys().immutableSortedCopy(mapEntries);
            }
            return ImmutableSetMultimap.fromMapEntries(var1_1, this.valueComparator);
        }
    }
}

