/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableEnumSet;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.JdkBackedImmutableSet;
import com.google.common.collect.RegularImmutableAsList;
import com.google.common.collect.RegularImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.collect.SingletonImmutableSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.math.IntMath;
import java.io.Serializable;
import java.math.RoundingMode;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableSet<E>
extends ImmutableCollection<E>
implements Set<E> {
    static final int SPLITERATOR_CHARACTERISTICS = 1297;
    static final int MAX_TABLE_SIZE = 0x40000000;
    private static final double DESIRED_LOAD_FACTOR = 0.7;
    private static final int CUTOFF = 0x2CCCCCCC;

    public static <E> Collector<E, ?, ImmutableSet<E>> toImmutableSet() {
        return CollectCollectors.toImmutableSet();
    }

    public static <E> ImmutableSet<E> of() {
        return RegularImmutableSet.EMPTY;
    }

    public static <E> ImmutableSet<E> of(E element) {
        E e;
        return new SingletonImmutableSet<E>(e);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSet<E> of(E e1, E e2) {
        void var1_1;
        E e;
        return ImmutableSet.construct(2, 2, e, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSet<E> of(E e1, E e2, E e3) {
        void var2_2;
        void var1_1;
        E e;
        return ImmutableSet.construct(3, 3, e, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableSet.construct(4, 4, e, var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4, E e5) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableSet.construct(5, 5, e, var1_1, var2_2, var3_3, e5);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <E> ImmutableSet<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        Preconditions.checkArgument(others.length <= 0x7FFFFFF9, "the total number of elements must fit in an int");
        Object[] objectArray = new Object[6 + others.length];
        Object[] elements = objectArray;
        objectArray[0] = e;
        elements[1] = var1_1;
        elements[2] = var2_2;
        elements[3] = var3_3;
        elements[4] = e5;
        elements[5] = e6;
        System.arraycopy(others, 0, elements, 6, others.length);
        return ImmutableSet.construct(elements.length, elements.length, elements);
    }

    /*
     * WARNING - void declaration
     */
    private static <E> ImmutableSet<E> constructUnknownDuplication(int n, Object ... elements) {
        void var1_1;
        int n2;
        return ImmutableSet.construct(n, Math.max(4, IntMath.sqrt(n2, RoundingMode.CEILING)), (Object[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private static <E> ImmutableSet<E> construct(int n22, int expectedSize, Object ... elements) {
        void var1_3;
        int n22;
        switch (n22) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                Object n22 = elements[0];
                return ImmutableSet.of(n22);
            }
        }
        SetBuilderImpl builder = new RegularSetBuilderImpl<Object>(expectedSize);
        for (int i = 0; i < n22; ++i) {
            Object e = Preconditions.checkNotNull(elements[i]);
            builder = ((SetBuilderImpl)builder).add(e);
        }
        return var1_3.review().build();
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSet<E> copyOf(Collection<? extends E> elements) {
        void var1_1;
        Collection<? extends E> collection;
        if (elements instanceof ImmutableSet && !(elements instanceof SortedSet)) {
            ImmutableSet set = (ImmutableSet)elements;
            if (!set.isPartialView()) {
                return set;
            }
        } else if (elements instanceof EnumSet) {
            return ImmutableSet.copyOfEnumSet((EnumSet)elements);
        }
        Object[] array = elements.toArray();
        if (collection instanceof Set) {
            return ImmutableSet.construct(array.length, array.length, array);
        }
        return ImmutableSet.constructUnknownDuplication(array.length, (Object[])var1_1);
    }

    public static <E> ImmutableSet<E> copyOf(Iterable<? extends E> elements) {
        Iterable<E> iterable;
        if (elements instanceof Collection) {
            return ImmutableSet.copyOf((Collection)elements);
        }
        return ImmutableSet.copyOf(iterable.iterator());
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableSet<E> copyOf(Iterator<? extends E> elements) {
        Iterator<? extends E> iterator;
        void var1_1;
        if (!elements.hasNext()) {
            return ImmutableSet.of();
        }
        E first = elements.next();
        if (!elements.hasNext()) {
            return ImmutableSet.of(first);
        }
        return ((Builder)((Builder)new Builder().add((Object)var1_1)).addAll((Iterator)iterator)).build();
    }

    public static <E> ImmutableSet<E> copyOf(E[] elements) {
        E[] EArray;
        switch (elements.length) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(elements[0]);
            }
        }
        return ImmutableSet.constructUnknownDuplication(elements.length, (Object[])EArray.clone());
    }

    private static ImmutableSet copyOfEnumSet(EnumSet enumSet) {
        return ImmutableEnumSet.asImmutable(EnumSet.copyOf(enumSet));
    }

    ImmutableSet() {
    }

    boolean isHashCodeFast() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableSet && this.isHashCodeFast() && ((ImmutableSet)object).isHashCodeFast() && this.hashCode() != object.hashCode()) {
            return false;
        }
        return Sets.equalsImpl(this, var1_1);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this);
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    @Beta
    public static <E> Builder<E> builderWithExpectedSize(int expectedSize) {
        int n;
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        return new Builder(n);
    }

    /*
     * WARNING - void declaration
     */
    static int chooseTableSize(int setSize) {
        int n;
        if ((setSize = Math.max(setSize, 2)) < 0x2CCCCCCC) {
            void var1_1;
            int tableSize = Integer.highestOneBit(setSize - 1) << 1;
            while ((double)tableSize * 0.7 < (double)setSize) {
                tableSize <<= 1;
            }
            return (int)var1_1;
        }
        Preconditions.checkArgument(n < 0x40000000, "collection too large");
        return 0x40000000;
    }

    private static final class JdkBackedSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private final Set<Object> delegate;

        JdkBackedSetBuilderImpl(SetBuilderImpl<E> toCopy) {
            super(toCopy);
            this.delegate = Sets.newHashSetWithExpectedSize(this.distinct);
            for (int i = 0; i < this.distinct; ++i) {
                this.delegate.add(Objects.requireNonNull(this.dedupedElements[i]));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final SetBuilderImpl<E> add(E e) {
            Preconditions.checkNotNull(e);
            if (this.delegate.add(e)) {
                void var1_1;
                this.addDedupedElement(var1_1);
            }
            return this;
        }

        @Override
        final SetBuilderImpl<E> copy() {
            return new JdkBackedSetBuilderImpl<E>(this);
        }

        @Override
        final ImmutableSet<E> build() {
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(Objects.requireNonNull(this.dedupedElements[0]));
                }
            }
            return new JdkBackedImmutableSet(this.delegate, ImmutableList.asImmutableList(this.dedupedElements, this.distinct));
        }
    }

    private static final class RegularSetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private Object[] hashTable;
        private int maxRunBeforeFallback;
        private int expandTableThreshold;
        private int hashCode;
        static final int MAX_RUN_MULTIPLIER = 13;

        /*
         * WARNING - void declaration
         */
        RegularSetBuilderImpl(int expectedCapacity) {
            super((int)var1_1);
            void var1_1;
            this.hashTable = null;
            this.maxRunBeforeFallback = 0;
            this.expandTableThreshold = 0;
        }

        /*
         * WARNING - void declaration
         */
        RegularSetBuilderImpl(RegularSetBuilderImpl<E> toCopy) {
            super(toCopy);
            void var1_1;
            this.hashTable = toCopy.hashTable == null ? null : (Object[])toCopy.hashTable.clone();
            this.maxRunBeforeFallback = toCopy.maxRunBeforeFallback;
            this.expandTableThreshold = toCopy.expandTableThreshold;
            this.hashCode = var1_1.hashCode;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final SetBuilderImpl<E> add(E e) {
            void var1_1;
            Preconditions.checkNotNull(e);
            if (this.hashTable == null) {
                void var2_2;
                if (this.distinct == 0) {
                    this.addDedupedElement(e);
                    return this;
                }
                RegularSetBuilderImpl regularSetBuilderImpl = this;
                regularSetBuilderImpl.ensureTableCapacity(regularSetBuilderImpl.dedupedElements.length);
                Object elem = this.dedupedElements[0];
                --this.distinct;
                return this.insertInHashTable(var2_2).add((void)e);
            }
            return this.insertInHashTable(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        private SetBuilderImpl<E> insertInHashTable(E e) {
            void var1_1;
            Objects.requireNonNull(this.hashTable);
            int eHash = e.hashCode();
            int i0 = Hashing.smear(eHash);
            int mask = this.hashTable.length - 1;
            int i = i0;
            while (i - i0 < this.maxRunBeforeFallback) {
                int index = i & mask;
                Object tableEntry = this.hashTable[index];
                if (tableEntry == null) {
                    this.addDedupedElement(e);
                    this.hashTable[index] = e;
                    this.hashCode += eHash;
                    RegularSetBuilderImpl regularSetBuilderImpl = this;
                    regularSetBuilderImpl.ensureTableCapacity(regularSetBuilderImpl.distinct);
                    return this;
                }
                if (tableEntry.equals(e)) {
                    return this;
                }
                ++i;
            }
            return new JdkBackedSetBuilderImpl<void>(this).add(var1_1);
        }

        @Override
        final SetBuilderImpl<E> copy() {
            return new RegularSetBuilderImpl<E>(this);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final SetBuilderImpl<E> review() {
            if (this.hashTable == null) {
                return this;
            }
            int targetTableSize = ImmutableSet.chooseTableSize(this.distinct);
            if (targetTableSize << 1 < this.hashTable.length) {
                void var1_1;
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(targetTableSize, this.dedupedElements, this.distinct);
                this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(targetTableSize);
                this.expandTableThreshold = (int)(0.7 * (double)var1_1);
            }
            if (RegularSetBuilderImpl.hashFloodingDetected(this.hashTable)) {
                return new JdkBackedSetBuilderImpl(this);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ImmutableSet<E> build() {
            void var1_1;
            switch (this.distinct) {
                case 0: {
                    return ImmutableSet.of();
                }
                case 1: {
                    return ImmutableSet.of(Objects.requireNonNull(this.dedupedElements[0]));
                }
            }
            E[] elements = this.distinct == this.dedupedElements.length ? this.dedupedElements : Arrays.copyOf(this.dedupedElements, this.distinct);
            return new RegularImmutableSet((Object[])var1_1, this.hashCode, Objects.requireNonNull(this.hashTable), this.hashTable.length - 1);
        }

        /*
         * WARNING - void declaration
         */
        static Object[] rebuildHashTable(int newTableSize, Object[] elements, int n) {
            void var0_1;
            Object[] hashTable = new Object[newTableSize];
            int mask = hashTable.length - 1;
            for (int i = 0; i < n; ++i) {
                int n2;
                Object e = Objects.requireNonNull(elements[i]);
                int j = n2 = Hashing.smear(e.hashCode());
                while (true) {
                    int index;
                    if (hashTable[index = j & mask] == null) break;
                    ++j;
                }
                hashTable[index] = e;
            }
            return var0_1;
        }

        /*
         * WARNING - void declaration
         */
        final void ensureTableCapacity(int minCapacity) {
            void var1_1;
            int newTableSize;
            if (this.hashTable == null) {
                newTableSize = ImmutableSet.chooseTableSize(minCapacity);
                this.hashTable = new Object[newTableSize];
            } else if (newTableSize > this.expandTableThreshold && this.hashTable.length < 0x40000000) {
                newTableSize = this.hashTable.length << 1;
                this.hashTable = RegularSetBuilderImpl.rebuildHashTable(newTableSize, this.dedupedElements, this.distinct);
            } else {
                return;
            }
            this.maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(newTableSize);
            this.expandTableThreshold = (int)(0.7 * (double)var1_1);
        }

        static boolean hashFloodingDetected(Object[] hashTable) {
            int maxRunBeforeFallback = RegularSetBuilderImpl.maxRunBeforeFallback(hashTable.length);
            int mask = hashTable.length - 1;
            int knownRunStart = 0;
            int knownRunEnd = 0;
            block0: while (knownRunStart < hashTable.length) {
                if (knownRunStart == knownRunEnd && hashTable[knownRunStart] == null) {
                    if (hashTable[knownRunStart + maxRunBeforeFallback - 1 & mask] == null) {
                        knownRunStart += maxRunBeforeFallback;
                    }
                    knownRunEnd = ++knownRunStart;
                    continue;
                }
                for (int j = knownRunStart + maxRunBeforeFallback - 1; j >= knownRunEnd; --j) {
                    if (hashTable[j & mask] != null) continue;
                    knownRunEnd = knownRunStart + maxRunBeforeFallback;
                    knownRunStart = j + 1;
                    continue block0;
                }
                return true;
            }
            return false;
        }

        static int maxRunBeforeFallback(int tableSize) {
            int n;
            return 13 * IntMath.log2(n, RoundingMode.UNNECESSARY);
        }
    }

    private static final class EmptySetBuilderImpl<E>
    extends SetBuilderImpl<E> {
        private static final EmptySetBuilderImpl<Object> INSTANCE = new EmptySetBuilderImpl();

        static <E> SetBuilderImpl<E> instance() {
            return INSTANCE;
        }

        private EmptySetBuilderImpl() {
            super(0);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final SetBuilderImpl<E> add(E e) {
            void var1_1;
            return new RegularSetBuilderImpl<void>(4).add(var1_1);
        }

        @Override
        final SetBuilderImpl<E> copy() {
            return this;
        }

        @Override
        final ImmutableSet<E> build() {
            return ImmutableSet.of();
        }
    }

    private static abstract class SetBuilderImpl<E> {
        E[] dedupedElements;
        int distinct;

        /*
         * WARNING - void declaration
         */
        SetBuilderImpl(int expectedCapacity) {
            void var1_1;
            this.dedupedElements = new Object[var1_1];
            this.distinct = 0;
        }

        /*
         * WARNING - void declaration
         */
        SetBuilderImpl(SetBuilderImpl<E> toCopy) {
            void var1_1;
            this.dedupedElements = Arrays.copyOf(toCopy.dedupedElements, toCopy.dedupedElements.length);
            this.distinct = var1_1.distinct;
        }

        /*
         * WARNING - void declaration
         */
        private void ensureCapacity(int minCapacity) {
            if (minCapacity > this.dedupedElements.length) {
                void var1_1;
                int newCapacity = ImmutableCollection.Builder.expandedCapacity(this.dedupedElements.length, minCapacity);
                this.dedupedElements = Arrays.copyOf(this.dedupedElements, (int)var1_1);
            }
        }

        /*
         * WARNING - void declaration
         */
        final void addDedupedElement(E e) {
            void var1_1;
            SetBuilderImpl setBuilderImpl = this;
            setBuilderImpl.ensureCapacity(setBuilderImpl.distinct + 1);
            this.dedupedElements[this.distinct++] = var1_1;
        }

        abstract SetBuilderImpl<E> add(E var1);

        /*
         * WARNING - void declaration
         */
        final SetBuilderImpl<E> combine(SetBuilderImpl<E> other) {
            void var2_2;
            SetBuilderImpl<E> result = this;
            for (int i = 0; i < other.distinct; ++i) {
                result = result.add(Objects.requireNonNull(other.dedupedElements[i]));
            }
            return var2_2;
        }

        abstract SetBuilderImpl<E> copy();

        SetBuilderImpl<E> review() {
            return this;
        }

        abstract ImmutableSet<E> build();
    }

    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        private SetBuilderImpl<E> impl;
        boolean forceCopy;

        public Builder() {
            this(0);
        }

        /*
         * WARNING - void declaration
         */
        Builder(int capacity) {
            if (capacity > 0) {
                void var1_1;
                this.impl = new RegularSetBuilderImpl((int)var1_1);
                return;
            }
            this.impl = EmptySetBuilderImpl.instance();
        }

        Builder(boolean subclass) {
            this.impl = null;
        }

        @VisibleForTesting
        void forceJdk() {
            Objects.requireNonNull(this.impl);
            this.impl = new JdkBackedSetBuilderImpl<E>(this.impl);
        }

        final void copyIfNecessary() {
            if (this.forceCopy) {
                this.copy();
                this.forceCopy = false;
            }
        }

        void copy() {
            Objects.requireNonNull(this.impl);
            this.impl = this.impl.copy();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> add(E element) {
            void var1_1;
            Objects.requireNonNull(this.impl);
            Preconditions.checkNotNull(element);
            this.copyIfNecessary();
            this.impl = this.impl.add(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> add(E ... elements) {
            void var1_1;
            super.add(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> addAll(Iterable<? extends E> elements) {
            void var1_1;
            super.addAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> addAll(Iterator<? extends E> elements) {
            void var1_1;
            super.addAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder<E> combine(Builder<E> other) {
            void var1_1;
            Objects.requireNonNull(this.impl);
            Objects.requireNonNull(other.impl);
            this.copyIfNecessary();
            this.impl = this.impl.combine(var1_1.impl);
            return this;
        }

        @Override
        public ImmutableSet<E> build() {
            Objects.requireNonNull(this.impl);
            this.forceCopy = true;
            this.impl = this.impl.review();
            return this.impl.build();
        }
    }

    private static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SerializedForm(Object[] elements) {
            void var1_1;
            this.elements = var1_1;
        }

        Object readResolve() {
            return ImmutableSet.copyOf(this.elements);
        }
    }

    static abstract class Indexed<E>
    extends CachingAsList<E> {
        Indexed() {
        }

        abstract E get(int var1);

        @Override
        public UnmodifiableIterator<E> iterator() {
            return ((ImmutableCollection)((ImmutableCollection)this).asList()).iterator();
        }

        @Override
        public Spliterator<E> spliterator() {
            return CollectSpliterators.indexed(this.size(), 1297, this::get);
        }

        @Override
        public void forEach(Consumer<? super E> consumer) {
            Preconditions.checkNotNull(consumer);
            int n = this.size();
            for (int i = 0; i < n; ++i) {
                consumer.accept(this.get(i));
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        int copyIntoArray(Object[] dst, int offset) {
            void var2_2;
            void var1_1;
            return ((ImmutableCollection)this).asList().copyIntoArray((Object[])var1_1, (int)var2_2);
        }

        @Override
        ImmutableList<E> createAsList() {
            return new ImmutableAsList<E>(this){
                final /* synthetic */ Indexed this$0;
                {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public E get(int index) {
                    void var1_1;
                    return this.this$0.get((int)var1_1);
                }

                @Override
                Indexed<E> delegateCollection() {
                    return this.this$0;
                }
            };
        }
    }

    @GwtCompatible
    static abstract class CachingAsList<E>
    extends ImmutableSet<E> {
        private transient ImmutableList<E> asList;

        CachingAsList() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ImmutableList<E> asList() {
            void var1_1;
            ImmutableList<E> result = this.asList;
            if (result == null) {
                this.asList = this.createAsList();
                return this.asList;
            }
            return var1_1;
        }

        ImmutableList<E> createAsList() {
            CachingAsList cachingAsList = this;
            return new RegularImmutableAsList(cachingAsList, cachingAsList.toArray());
        }
    }
}

