/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIterator;
import com.google.common.collect.AbstractRangeSet;
import com.google.common.collect.BoundType;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.ContiguousSet;
import com.google.common.collect.Cut;
import com.google.common.collect.DescendingImmutableSortedSet;
import com.google.common.collect.DiscreteDomain;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Ordering;
import com.google.common.collect.PeekingIterator;
import com.google.common.collect.Range;
import com.google.common.collect.RangeSet;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedLists;
import com.google.common.collect.TreeRangeSet;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.primitives.Ints;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public final class ImmutableRangeSet<C extends Comparable>
extends AbstractRangeSet<C>
implements Serializable {
    private static final ImmutableRangeSet<Comparable<?>> EMPTY = new ImmutableRangeSet(ImmutableList.of());
    private static final ImmutableRangeSet<Comparable<?>> ALL = new ImmutableRangeSet(ImmutableList.of(Range.all()));
    private final transient ImmutableList<Range<C>> ranges;
    private transient ImmutableRangeSet<C> complement;

    public static <E extends Comparable<? super E>> Collector<Range<E>, ?, ImmutableRangeSet<E>> toImmutableRangeSet() {
        return CollectCollectors.toImmutableRangeSet();
    }

    public static <C extends Comparable> ImmutableRangeSet<C> of() {
        return EMPTY;
    }

    public static <C extends Comparable> ImmutableRangeSet<C> of(Range<C> range) {
        Range<C> range2;
        Preconditions.checkNotNull(range);
        if (range.isEmpty()) {
            return ImmutableRangeSet.of();
        }
        if (range.equals(Range.all())) {
            return ImmutableRangeSet.all();
        }
        return new ImmutableRangeSet<C>(ImmutableList.of(range2));
    }

    static <C extends Comparable> ImmutableRangeSet<C> all() {
        return ALL;
    }

    /*
     * WARNING - void declaration
     */
    public static <C extends Comparable> ImmutableRangeSet<C> copyOf(RangeSet<C> rangeSet) {
        RangeSet<C> rangeSet2;
        ImmutableRangeSet immutableRangeSet;
        Preconditions.checkNotNull(rangeSet);
        if (rangeSet.isEmpty()) {
            return ImmutableRangeSet.of();
        }
        if (rangeSet.encloses(Range.all())) {
            return ImmutableRangeSet.all();
        }
        if (rangeSet instanceof ImmutableRangeSet && !(immutableRangeSet = (ImmutableRangeSet)rangeSet).isPartialView()) {
            void var1_1;
            return var1_1;
        }
        return new ImmutableRangeSet<C>(ImmutableList.copyOf(rangeSet2.asRanges()));
    }

    public static <C extends Comparable<?>> ImmutableRangeSet<C> copyOf(Iterable<Range<C>> ranges) {
        Iterable<Range<C>> iterable;
        return new Builder<C>().addAll(iterable).build();
    }

    public static <C extends Comparable<?>> ImmutableRangeSet<C> unionOf(Iterable<Range<C>> ranges) {
        return ImmutableRangeSet.copyOf(TreeRangeSet.create(ranges));
    }

    /*
     * WARNING - void declaration
     */
    ImmutableRangeSet(ImmutableList<Range<C>> ranges) {
        void var1_1;
        this.ranges = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableRangeSet(ImmutableList<Range<C>> ranges, ImmutableRangeSet<C> complement) {
        void var2_2;
        void var1_1;
        this.ranges = var1_1;
        this.complement = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean intersects(Range<C> otherRange) {
        void var1_1;
        void var2_2;
        int ceilingIndex = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), otherRange.lowerBound, Ordering.natural(), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
        if (ceilingIndex < this.ranges.size() && ((Range)this.ranges.get(ceilingIndex)).isConnected(otherRange) && !((Range)this.ranges.get(ceilingIndex)).intersection(otherRange).isEmpty()) {
            return true;
        }
        return ceilingIndex > 0 && ((Range)this.ranges.get(ceilingIndex - 1)).isConnected(otherRange) && !((Range)this.ranges.get((int)(var2_2 - true))).intersection(var1_1).isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean encloses(Range<C> otherRange) {
        void var1_1;
        void var2_2;
        int index = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), otherRange.lowerBound, Ordering.natural(), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_LOWER);
        return index != -1 && ((Range)this.ranges.get((int)var2_2)).encloses(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final Range<C> rangeContaining(C value) {
        int index = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), Cut.belowValue(value), Ordering.natural(), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_LOWER);
        if (index != -1) {
            void var1_1;
            Range range = (Range)this.ranges.get(index);
            if (range.contains(var1_1)) {
                void var2_3;
                return var2_3;
            }
            return null;
        }
        return null;
    }

    @Override
    public final Range<C> span() {
        if (this.ranges.isEmpty()) {
            throw new NoSuchElementException();
        }
        return Range.create(((Range)this.ranges.get((int)0)).lowerBound, ((Range)this.ranges.get((int)(this.ranges.size() - 1))).upperBound);
    }

    @Override
    public final boolean isEmpty() {
        return this.ranges.isEmpty();
    }

    @Override
    @Deprecated
    public final void add(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void addAll(RangeSet<C> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void addAll(Iterable<Range<C>> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void remove(Range<C> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void removeAll(RangeSet<C> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void removeAll(Iterable<Range<C>> other) {
        throw new UnsupportedOperationException();
    }

    @Override
    public final ImmutableSet<Range<C>> asRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableSet.of();
        }
        return new RegularImmutableSortedSet(this.ranges, Range.rangeLexOrdering());
    }

    @Override
    public final ImmutableSet<Range<C>> asDescendingSetOfRanges() {
        if (this.ranges.isEmpty()) {
            return ImmutableSet.of();
        }
        return new RegularImmutableSortedSet<Range<C>>(this.ranges.reverse(), Range.rangeLexOrdering().reverse());
    }

    @Override
    public final ImmutableRangeSet<C> complement() {
        ImmutableRangeSet<C> immutableRangeSet;
        ImmutableRangeSet<C> result = this.complement;
        if (result != null) {
            return result;
        }
        if (this.ranges.isEmpty()) {
            this.complement = ImmutableRangeSet.all();
            return this.complement;
        }
        if (this.ranges.size() == 1 && ((Range)this.ranges.get(0)).equals(Range.all())) {
            this.complement = ImmutableRangeSet.of();
            return this.complement;
        }
        ComplementRanges complementRanges = new ComplementRanges();
        this.complement = new ImmutableRangeSet<C>(immutableRangeSet, this);
        immutableRangeSet = this.complement;
        return this.complement;
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableRangeSet<C> union(RangeSet<C> other) {
        void var1_1;
        return ImmutableRangeSet.unionOf(Iterables.concat(this.asRanges(), var1_1.asRanges()));
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableRangeSet<C> intersection(RangeSet<C> other) {
        void var2_2;
        void var1_1;
        TreeRangeSet copy = TreeRangeSet.create(this);
        copy.removeAll(var1_1.complement());
        return ImmutableRangeSet.copyOf(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableRangeSet<C> difference(RangeSet<C> other) {
        void var2_2;
        void var1_1;
        TreeRangeSet copy = TreeRangeSet.create(this);
        copy.removeAll(var1_1);
        return ImmutableRangeSet.copyOf(var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableList<Range<C>> intersectRanges(Range<C> range) {
        void var1_1;
        void var2_2;
        void var3_3;
        if (this.ranges.isEmpty() || range.isEmpty()) {
            return ImmutableList.of();
        }
        if (range.encloses(this.span())) {
            return this.ranges;
        }
        int fromIndex = range.hasLowerBound() ? SortedLists.binarySearch(this.ranges, Range.upperBoundFn(), range.lowerBound, SortedLists.KeyPresentBehavior.FIRST_AFTER, SortedLists.KeyAbsentBehavior.NEXT_HIGHER) : 0;
        int toIndex = range.hasUpperBound() ? SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), range.upperBound, SortedLists.KeyPresentBehavior.FIRST_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_HIGHER) : this.ranges.size();
        int length = toIndex - fromIndex;
        if (length == 0) {
            return ImmutableList.of();
        }
        return new ImmutableList<Range<C>>(this, (int)var3_3, (int)var2_2, (Range)var1_1){
            final /* synthetic */ int val$length;
            final /* synthetic */ int val$fromIndex;
            final /* synthetic */ Range val$range;
            final /* synthetic */ ImmutableRangeSet this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$length = n;
                this.val$fromIndex = n2;
                this.val$range = range;
            }

            @Override
            public int size() {
                return this.val$length;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Range<C> get(int index) {
                void var1_1;
                Preconditions.checkElementIndex(index, this.val$length);
                if (index == 0 || index == this.val$length - 1) {
                    return ((Range)this.this$0.ranges.get(index + this.val$fromIndex)).intersection(this.val$range);
                }
                return (Range)this.this$0.ranges.get((int)(var1_1 + this.val$fromIndex));
            }

            @Override
            boolean isPartialView() {
                return true;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableRangeSet<C> subRangeSet(Range<C> range) {
        if (!this.isEmpty()) {
            void var2_2;
            Range<C> span = this.span();
            if (range.encloses(span)) {
                return this;
            }
            if (range.isConnected((Range<C>)var2_2)) {
                void var1_1;
                return new ImmutableRangeSet<C>(this.intersectRanges((Range<C>)var1_1));
            }
        }
        return ImmutableRangeSet.of();
    }

    /*
     * WARNING - void declaration
     */
    public final ImmutableSortedSet<C> asSet(DiscreteDomain<C> domain) {
        void var1_1;
        void var2_2;
        Preconditions.checkNotNull(domain);
        if (this.isEmpty()) {
            return ImmutableSortedSet.of();
        }
        Range<C> span = this.span().canonical(domain);
        if (!span.hasLowerBound()) {
            throw new IllegalArgumentException("Neither the DiscreteDomain nor this range set are bounded below");
        }
        if (!var2_2.hasUpperBound()) {
            try {
                domain.maxValue();
            }
            catch (NoSuchElementException noSuchElementException) {
                throw new IllegalArgumentException("Neither the DiscreteDomain nor this range set are bounded above");
            }
        }
        return new AsSet(var1_1);
    }

    final boolean isPartialView() {
        return this.ranges.isPartialView();
    }

    public static <C extends Comparable<?>> Builder<C> builder() {
        return new Builder();
    }

    final Object writeReplace() {
        return new SerializedForm<C>(this.ranges);
    }

    private static final class SerializedForm<C extends Comparable>
    implements Serializable {
        private final ImmutableList<Range<C>> ranges;

        /*
         * WARNING - void declaration
         */
        SerializedForm(ImmutableList<Range<C>> ranges) {
            void var1_1;
            this.ranges = var1_1;
        }

        final Object readResolve() {
            if (this.ranges.isEmpty()) {
                return ImmutableRangeSet.of();
            }
            if (this.ranges.equals(ImmutableList.of(Range.all()))) {
                return ImmutableRangeSet.all();
            }
            return new ImmutableRangeSet<C>(this.ranges);
        }
    }

    public static class Builder<C extends Comparable<?>> {
        private final List<Range<C>> ranges = Lists.newArrayList();

        /*
         * WARNING - void declaration
         */
        public Builder<C> add(Range<C> range) {
            void var1_1;
            Preconditions.checkArgument(!range.isEmpty(), "range must not be empty, but was %s", range);
            this.ranges.add((Range<C>)var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<C> addAll(RangeSet<C> ranges) {
            void var1_1;
            return this.addAll(var1_1.asRanges());
        }

        /*
         * WARNING - void declaration
         */
        public Builder<C> addAll(Iterable<Range<C>> ranges) {
            for (Range<C> range : ranges) {
                void var2_2;
                this.add((Range<C>)var2_2);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder<C> combine(Builder<C> builder) {
            void var1_1;
            this.addAll(var1_1.ranges);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public ImmutableRangeSet<C> build() {
            void var3_3;
            void var1_1;
            ImmutableList.Builder mergedRangesBuilder = new ImmutableList.Builder(this.ranges.size());
            Collections.sort(this.ranges, Range.rangeLexOrdering());
            PeekingIterator<Range<C>> peekingItr = Iterators.peekingIterator(this.ranges.iterator());
            while (peekingItr.hasNext()) {
                Range<C> nextRange;
                Range<C> range = peekingItr.next();
                while (peekingItr.hasNext() && range.isConnected(nextRange = peekingItr.peek())) {
                    Preconditions.checkArgument(range.intersection(nextRange).isEmpty(), "Overlapping ranges not permitted but found %s overlapping %s", range, nextRange);
                    range = range.span(peekingItr.next());
                }
                mergedRangesBuilder.add(range);
            }
            ImmutableCollection mergedRanges = var1_1.build();
            if (mergedRanges.isEmpty()) {
                return ImmutableRangeSet.of();
            }
            if (mergedRanges.size() == 1 && ((Range)Iterables.getOnlyElement(mergedRanges)).equals(Range.all())) {
                return ImmutableRangeSet.all();
            }
            return new ImmutableRangeSet(var3_3);
        }
    }

    private static class AsSetSerializedForm<C extends Comparable>
    implements Serializable {
        private final ImmutableList<Range<C>> ranges;
        private final DiscreteDomain<C> domain;

        /*
         * WARNING - void declaration
         */
        AsSetSerializedForm(ImmutableList<Range<C>> ranges, DiscreteDomain<C> domain) {
            void var2_2;
            void var1_1;
            this.ranges = var1_1;
            this.domain = var2_2;
        }

        Object readResolve() {
            return new ImmutableRangeSet<C>(this.ranges).asSet(this.domain);
        }
    }

    private final class AsSet
    extends ImmutableSortedSet<C> {
        private final DiscreteDomain<C> domain;
        private transient Integer size;

        /*
         * WARNING - void declaration
         */
        AsSet(DiscreteDomain<C> domain) {
            void var2_2;
            super(Ordering.natural());
            this.domain = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final int size() {
            void var1_1;
            Object result = this.size;
            if (result == null) {
                void var2_2;
                Range range;
                long total = 0L;
                result = ((ImmutableCollection)ImmutableRangeSet.this.ranges).iterator();
                while (result.hasNext() && (total += (long)ContiguousSet.create(range = (Range)result.next(), this.domain).size()) < Integer.MAX_VALUE) {
                }
                this.size = Ints.saturatedCast((long)var2_2);
                result = this.size;
            }
            return var1_1.intValue();
        }

        @Override
        public final UnmodifiableIterator<C> iterator() {
            return new AbstractIterator<C>(this){
                final Iterator<Range<C>> rangeItr;
                Iterator<C> elemItr;
                final /* synthetic */ AsSet this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.rangeItr = ((ImmutableCollection)this.this$1.ImmutableRangeSet.this.ranges).iterator();
                    this.elemItr = Iterators.emptyIterator();
                }

                @Override
                protected C computeNext() {
                    while (!this.elemItr.hasNext()) {
                        if (this.rangeItr.hasNext()) {
                            this.elemItr = ((ImmutableCollection)ContiguousSet.create(this.rangeItr.next(), this.this$1.domain)).iterator();
                            continue;
                        }
                        return (Comparable)this.endOfData();
                    }
                    return (Comparable)this.elemItr.next();
                }
            };
        }

        @Override
        @GwtIncompatible(value="NavigableSet")
        public final UnmodifiableIterator<C> descendingIterator() {
            return new AbstractIterator<C>(this){
                final Iterator<Range<C>> rangeItr;
                Iterator<C> elemItr;
                final /* synthetic */ AsSet this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                    this.rangeItr = ((ImmutableCollection)this.this$1.ImmutableRangeSet.this.ranges.reverse()).iterator();
                    this.elemItr = Iterators.emptyIterator();
                }

                @Override
                protected C computeNext() {
                    while (!this.elemItr.hasNext()) {
                        if (this.rangeItr.hasNext()) {
                            this.elemItr = ContiguousSet.create(this.rangeItr.next(), this.this$1.domain).descendingIterator();
                            continue;
                        }
                        return (Comparable)this.endOfData();
                    }
                    return (Comparable)this.elemItr.next();
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        final ImmutableSortedSet<C> subSet(Range<C> range) {
            void var1_1;
            return ((ImmutableRangeSet)ImmutableRangeSet.this.subRangeSet((Range)var1_1)).asSet(this.domain);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ImmutableSortedSet<C> headSetImpl(C toElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.subSet(Range.upTo(var1_1, BoundType.forBoolean((boolean)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ImmutableSortedSet<C> subSetImpl(C fromElement, boolean fromInclusive, C toElement, boolean toInclusive) {
            void var3_3;
            void var2_2;
            void var1_1;
            if (!fromInclusive && !toInclusive && Range.compareOrThrow(fromElement, toElement) == 0) {
                return ImmutableSortedSet.of();
            }
            return this.subSet(Range.range(var1_1, BoundType.forBoolean((boolean)var2_2), var3_3, BoundType.forBoolean(toInclusive)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final ImmutableSortedSet<C> tailSetImpl(C fromElement, boolean inclusive) {
            void var2_2;
            void var1_1;
            return this.subSet(Range.downTo(var1_1, BoundType.forBoolean((boolean)var2_2)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            if (o == null) {
                return false;
            }
            try {
                void var1_1;
                Comparable c = (Comparable)o;
                return ImmutableRangeSet.this.contains((Comparable)var1_1);
            }
            catch (ClassCastException classCastException) {
                return false;
            }
        }

        @Override
        final int indexOf(Object target) {
            if (((ImmutableCollection)this).contains(target)) {
                Comparable c = (Comparable)Objects.requireNonNull(target);
                long total = 0L;
                for (Range range : ImmutableRangeSet.this.ranges) {
                    if (range.contains(c)) {
                        return Ints.saturatedCast(total + (long)ContiguousSet.create(range, this.domain).indexOf(c));
                    }
                    total += (long)ContiguousSet.create(range, this.domain).size();
                }
                throw new AssertionError((Object)"impossible");
            }
            return -1;
        }

        @Override
        final ImmutableSortedSet<C> createDescendingSet() {
            return new DescendingImmutableSortedSet(this);
        }

        @Override
        final boolean isPartialView() {
            return ImmutableRangeSet.this.ranges.isPartialView();
        }

        @Override
        public final String toString() {
            return ImmutableRangeSet.this.ranges.toString();
        }

        @Override
        final Object writeReplace() {
            return new AsSetSerializedForm(ImmutableRangeSet.this.ranges, this.domain);
        }
    }

    private final class ComplementRanges
    extends ImmutableList<Range<C>> {
        private final boolean positiveBoundedBelow;
        private final boolean positiveBoundedAbove;
        private final int size;

        /*
         * WARNING - void declaration
         */
        ComplementRanges() {
            void var1_2;
            this.positiveBoundedBelow = ((Range)ImmutableRangeSet.this.ranges.get(0)).hasLowerBound();
            this.positiveBoundedAbove = ((Range)Iterables.getLast(ImmutableRangeSet.this.ranges)).hasUpperBound();
            int size = ImmutableRangeSet.this.ranges.size() - 1;
            if (this.positiveBoundedBelow) {
                ++size;
            }
            if (this.positiveBoundedAbove) {
                ++size;
            }
            this.size = var1_2;
        }

        @Override
        public final int size() {
            return this.size;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Range<C> get(int index) {
            void var1_2;
            void var2_3;
            void upperBound22;
            Preconditions.checkElementIndex(index, this.size);
            Cut lowerBound = this.positiveBoundedBelow ? (index == 0 ? Cut.belowAll() : ((Range)((ImmutableRangeSet)ImmutableRangeSet.this).ranges.get((int)(index - 1))).upperBound) : ((Range)((ImmutableRangeSet)ImmutableRangeSet.this).ranges.get((int)index)).upperBound;
            Cut upperBound22 = this.positiveBoundedAbove && index == this.size - 1 ? Cut.aboveAll() : ((Range)((ImmutableRangeSet)ImmutableRangeSet.this).ranges.get((int)(upperBound22 + (this.positiveBoundedBelow ? false : true)))).lowerBound;
            return Range.create(var2_3, var1_2);
        }

        @Override
        final boolean isPartialView() {
            return true;
        }
    }
}

