/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.Cut;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSortedMap;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Range;
import com.google.common.collect.RangeMap;
import com.google.common.collect.RegularImmutableSortedSet;
import com.google.common.collect.SortedLists;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@Beta
@GwtIncompatible
public class ImmutableRangeMap<K extends Comparable<?>, V>
implements RangeMap<K, V>,
Serializable {
    private static final ImmutableRangeMap<Comparable<?>, Object> EMPTY = new ImmutableRangeMap(ImmutableList.of(), ImmutableList.of());
    private final transient ImmutableList<Range<K>> ranges;
    private final transient ImmutableList<V> values;
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    public static <T, K extends Comparable<? super K>, V> Collector<T, ?, ImmutableRangeMap<K, V>> toImmutableRangeMap(Function<? super T, Range<K>> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        return CollectCollectors.toImmutableRangeMap(keyFunction, var1_1);
    }

    public static <K extends Comparable<?>, V> ImmutableRangeMap<K, V> of() {
        return EMPTY;
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<?>, V> ImmutableRangeMap<K, V> of(Range<K> range, V value) {
        void var1_1;
        Range<K> range2;
        return new ImmutableRangeMap<K, void>(ImmutableList.of(range2), ImmutableList.of(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public static <K extends Comparable<?>, V> ImmutableRangeMap<K, V> copyOf(RangeMap<K, ? extends V> rangeMap) {
        void var2_2;
        void var1_1;
        Iterator iterator;
        if (rangeMap instanceof ImmutableRangeMap) {
            return (ImmutableRangeMap)rangeMap;
        }
        Iterator map = rangeMap.asMapOfRanges();
        ImmutableList.Builder rangesBuilder = new ImmutableList.Builder(map.size());
        ImmutableList.Builder valuesBuilder = new ImmutableList.Builder(map.size());
        for (Map.Entry entry : iterator.entrySet()) {
            void var3_3;
            rangesBuilder.add((Range)entry.getKey());
            valuesBuilder.add(var3_3.getValue());
        }
        return new ImmutableRangeMap<K, V>(var1_1.build(), var2_2.build());
    }

    public static <K extends Comparable<?>, V> Builder<K, V> builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    ImmutableRangeMap(ImmutableList<Range<K>> ranges, ImmutableList<V> values) {
        void var2_2;
        void var1_1;
        this.ranges = var1_1;
        this.values = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(K key) {
        void var1_1;
        int index = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), Cut.belowValue(key), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_LOWER);
        if (index == -1) {
            return null;
        }
        Range range = (Range)this.ranges.get(index);
        if (range.contains(var1_1)) {
            void var2_2;
            return (V)this.values.get((int)var2_2);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<Range<K>, V> getEntry(K key) {
        void var1_1;
        int index = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), Cut.belowValue(key), SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_LOWER);
        if (index == -1) {
            return null;
        }
        Range range = (Range)this.ranges.get(index);
        if (range.contains(var1_1)) {
            void var2_2;
            void var3_3;
            return Maps.immutableEntry(var3_3, this.values.get((int)var2_2));
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Range<K> span() {
        void var2_2;
        void var1_1;
        if (this.ranges.isEmpty()) {
            throw new NoSuchElementException();
        }
        Range firstRange = (Range)this.ranges.get(0);
        Range lastRange = (Range)this.ranges.get(this.ranges.size() - 1);
        return Range.create(var1_1.lowerBound, var2_2.upperBound);
    }

    @Override
    @Deprecated
    public final void put(Range<K> range, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putCoalescing(Range<K> range, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(RangeMap<K, V> rangeMap) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void remove(Range<K> range) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void merge(Range<K> range, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableMap<Range<K>, V> asMapOfRanges() {
        void var1_1;
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        RegularImmutableSortedSet rangeSet = new RegularImmutableSortedSet(this.ranges, Range.rangeLexOrdering());
        return new ImmutableSortedMap(var1_1, this.values);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableMap<Range<K>, V> asDescendingMapOfRanges() {
        void var1_1;
        if (this.ranges.isEmpty()) {
            return ImmutableMap.of();
        }
        RegularImmutableSortedSet<Range<K>> rangeSet = new RegularImmutableSortedSet<Range<K>>(this.ranges.reverse(), Range.rangeLexOrdering().reverse());
        return new ImmutableSortedMap(var1_1, this.values.reverse());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableRangeMap<K, V> subRangeMap(Range<K> range) {
        void var1_1;
        void var3_3;
        void var2_2;
        int upperIndex;
        if (Preconditions.checkNotNull(range).isEmpty()) {
            return ImmutableRangeMap.of();
        }
        if (this.ranges.isEmpty() || range.encloses(this.span())) {
            return this;
        }
        int lowerIndex = SortedLists.binarySearch(this.ranges, Range.upperBoundFn(), range.lowerBound, SortedLists.KeyPresentBehavior.FIRST_AFTER, SortedLists.KeyAbsentBehavior.NEXT_HIGHER);
        if (lowerIndex >= (upperIndex = SortedLists.binarySearch(this.ranges, Range.lowerBoundFn(), range.upperBound, SortedLists.KeyPresentBehavior.ANY_PRESENT, SortedLists.KeyAbsentBehavior.NEXT_HIGHER))) {
            return ImmutableRangeMap.of();
        }
        int off = lowerIndex;
        int len = upperIndex - lowerIndex;
        ImmutableList subRanges = new ImmutableList<Range<K>>(this, len, off, range){
            final /* synthetic */ int val$len;
            final /* synthetic */ int val$off;
            final /* synthetic */ Range val$range;
            final /* synthetic */ ImmutableRangeMap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$len = n;
                this.val$off = n2;
                this.val$range = range;
            }

            @Override
            public int size() {
                return this.val$len;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Range<K> get(int index) {
                void var1_1;
                Preconditions.checkElementIndex(index, this.val$len);
                if (index == 0 || index == this.val$len - 1) {
                    return ((Range)this.this$0.ranges.get(index + this.val$off)).intersection(this.val$range);
                }
                return (Range)this.this$0.ranges.get((int)(var1_1 + this.val$off));
            }

            @Override
            boolean isPartialView() {
                return true;
            }
        };
        ImmutableRangeMap outer = this;
        return new ImmutableRangeMap<K, V>(this, subRanges, (ImmutableList)this.values.subList((int)var2_2, (int)var3_3), (Range)var1_1, outer){
            final /* synthetic */ Range val$range;
            final /* synthetic */ ImmutableRangeMap val$outer;
            {
                void var3_3;
                void var2_2;
                this.val$range = range;
                this.val$outer = immutableRangeMap;
                super(var2_2, var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ImmutableRangeMap<K, V> subRangeMap(Range<K> subRange) {
                if (this.val$range.isConnected(subRange)) {
                    void var1_1;
                    return this.val$outer.subRangeMap(var1_1.intersection(this.val$range));
                }
                return ImmutableRangeMap.of();
            }
        };
    }

    @Override
    public int hashCode() {
        return ((ImmutableMap)this.asMapOfRanges()).hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object o) {
        if (o instanceof RangeMap) {
            void var1_1;
            RangeMap rangeMap = (RangeMap)o;
            return ((ImmutableMap)this.asMapOfRanges()).equals(var1_1.asMapOfRanges());
        }
        return false;
    }

    @Override
    public String toString() {
        return ((ImmutableMap)this.asMapOfRanges()).toString();
    }

    Object writeReplace() {
        return new SerializedForm(this.asMapOfRanges());
    }

    private static class SerializedForm<K extends Comparable<?>, V>
    implements Serializable {
        private final ImmutableMap<Range<K>, V> mapOfRanges;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SerializedForm(ImmutableMap<Range<K>, V> mapOfRanges) {
            void var1_1;
            this.mapOfRanges = var1_1;
        }

        Object readResolve() {
            if (this.mapOfRanges.isEmpty()) {
                return ImmutableRangeMap.of();
            }
            return this.createRangeMap();
        }

        /*
         * WARNING - void declaration
         */
        Object createRangeMap() {
            void var1_1;
            Builder builder = new Builder();
            for (Map.Entry entry : this.mapOfRanges.entrySet()) {
                void var3_3;
                builder.put((Range)entry.getKey(), var3_3.getValue());
            }
            return var1_1.build();
        }
    }

    public static final class Builder<K extends Comparable<?>, V> {
        private final List<Map.Entry<Range<K>, V>> entries = Lists.newArrayList();

        /*
         * WARNING - void declaration
         */
        public final Builder<K, V> put(Range<K> range, V value) {
            void var2_2;
            void var1_1;
            Preconditions.checkNotNull(range);
            Preconditions.checkNotNull(value);
            Preconditions.checkArgument(!range.isEmpty(), "Range must not be empty, but was %s", range);
            this.entries.add(Maps.immutableEntry(var1_1, var2_2));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final Builder<K, V> putAll(RangeMap<K, ? extends V> rangeMap) {
            for (Map.Entry<Range<K>, V> entry : rangeMap.asMapOfRanges().entrySet()) {
                void var2_2;
                this.put(entry.getKey(), var2_2.getValue());
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final Builder<K, V> combine(Builder<K, V> builder) {
            void var1_1;
            this.entries.addAll(var1_1.entries);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final ImmutableRangeMap<K, V> build() {
            void var2_2;
            void var1_1;
            Collections.sort(this.entries, Range.rangeLexOrdering().onKeys());
            Object rangesBuilder = new ImmutableList.Builder(this.entries.size());
            Object valuesBuilder = new ImmutableList.Builder(this.entries.size());
            for (int i = 0; i < this.entries.size(); ++i) {
                Range<K> prevRange;
                Range<K> range = this.entries.get(i).getKey();
                if (i > 0 && range.isConnected(prevRange = this.entries.get(i - 1).getKey()) && !range.intersection(prevRange).isEmpty()) {
                    rangesBuilder = String.valueOf(prevRange);
                    valuesBuilder = String.valueOf(range);
                    throw new IllegalArgumentException(new StringBuilder(47 + String.valueOf(rangesBuilder).length() + String.valueOf(valuesBuilder).length()).append("Overlapping ranges: range ").append((String)rangesBuilder).append(" overlaps with entry ").append((String)valuesBuilder).toString());
                }
                ((ImmutableList.Builder)rangesBuilder).add(range);
                ((ImmutableList.Builder)valuesBuilder).add(this.entries.get(i).getValue());
            }
            return new ImmutableRangeMap(var1_1.build(), var2_2.build());
        }
    }
}

