/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMultisetGwtSerializationDependencies;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.IndexedImmutableSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.JdkBackedImmutableMultiset;
import com.google.common.collect.LinkedHashMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.RegularImmutableMultiset;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.ToIntFunction;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableMultiset<E>
extends ImmutableMultisetGwtSerializationDependencies<E>
implements Multiset<E> {
    private transient ImmutableList<E> asList;
    private transient ImmutableSet<Multiset.Entry<E>> entrySet;

    public static <E> Collector<E, ?, ImmutableMultiset<E>> toImmutableMultiset() {
        return CollectCollectors.toImmutableMultiset(Function.identity(), e -> 1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, E> Collector<T, ?, ImmutableMultiset<E>> toImmutableMultiset(Function<? super T, ? extends E> elementFunction, ToIntFunction<? super T> countFunction) {
        void var1_1;
        return CollectCollectors.toImmutableMultiset(elementFunction, var1_1);
    }

    public static <E> ImmutableMultiset<E> of() {
        return RegularImmutableMultiset.EMPTY;
    }

    public static <E> ImmutableMultiset<E> of(E element) {
        E e;
        return ImmutableMultiset.copyFromElements(e);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableMultiset<E> of(E e1, E e2) {
        void var1_1;
        E e;
        return ImmutableMultiset.copyFromElements(e, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3) {
        void var2_2;
        void var1_1;
        E e;
        return ImmutableMultiset.copyFromElements(e, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3, E e4) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableMultiset.copyFromElements(e, var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3, E e4, E e5) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableMultiset.copyFromElements(e, var1_1, var2_2, var3_3, e5);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableMultiset<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E ... others) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)((Builder)new Builder().add((Object)e)).add((Object)var1_1)).add((Object)var2_2)).add((Object)var3_3)).add((Object)e5)).add((Object)e6)).add((Object[])others)).build();
    }

    public static <E> ImmutableMultiset<E> copyOf(E[] elements) {
        return ImmutableMultiset.copyFromElements(elements);
    }

    public static <E> ImmutableMultiset<E> copyOf(Iterable<? extends E> elements) {
        Iterable<? extends E> iterable;
        Multiset<E> multiset;
        ImmutableMultiset result;
        if (elements instanceof ImmutableMultiset && !(result = (ImmutableMultiset)elements).isPartialView()) {
            return multiset;
        }
        multiset = elements instanceof Multiset ? Multisets.cast(elements) : LinkedHashMultiset.create(iterable);
        return ImmutableMultiset.copyFromEntries(multiset.entrySet());
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableMultiset<E> copyOf(Iterator<? extends E> elements) {
        void var1_1;
        Iterator<? extends E> iterator;
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        Iterators.addAll(multiset, iterator);
        return ImmutableMultiset.copyFromEntries(var1_1.entrySet());
    }

    /*
     * WARNING - void declaration
     */
    private static <E> ImmutableMultiset<E> copyFromElements(E ... elements) {
        void var1_1;
        E[] EArray;
        LinkedHashMultiset multiset = LinkedHashMultiset.create();
        Collections.addAll(multiset, EArray);
        return ImmutableMultiset.copyFromEntries(var1_1.entrySet());
    }

    static <E> ImmutableMultiset<E> copyFromEntries(Collection<? extends Multiset.Entry<? extends E>> entries) {
        Collection<? extends Multiset.Entry<? extends E>> collection;
        if (entries.isEmpty()) {
            return ImmutableMultiset.of();
        }
        return RegularImmutableMultiset.create(collection);
    }

    ImmutableMultiset() {
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UnmodifiableIterator<E> iterator() {
        void var1_1;
        Iterator entryIterator = ((ImmutableCollection)((Object)this.entrySet())).iterator();
        return new UnmodifiableIterator<E>(this, (Iterator)var1_1){
            int remaining;
            E element;
            final /* synthetic */ Iterator val$entryIterator;
            {
                this.val$entryIterator = iterator;
            }

            @Override
            public boolean hasNext() {
                return this.remaining > 0 || this.val$entryIterator.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public E next() {
                if (this.remaining <= 0) {
                    void var1_1;
                    Multiset.Entry entry = (Multiset.Entry)this.val$entryIterator.next();
                    this.element = entry.getElement();
                    this.remaining = var1_1.getCount();
                }
                --this.remaining;
                return Objects.requireNonNull(this.element);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableList<E> asList() {
        void var1_1;
        ImmutableList<E> result = this.asList;
        if (result == null) {
            this.asList = super.asList();
            return this.asList;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object object) {
        void var1_1;
        return this.count(var1_1) > 0;
    }

    @Override
    @Deprecated
    public final int add(E element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final int remove(Object element, int occurrences) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final int setCount(E element, int count) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean setCount(E element, int oldCount, int newCount) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        for (Multiset.Entry entry : this.entrySet()) {
            int n = offset;
            Arrays.fill(dst, n, n + entry.getCount(), entry.getElement());
            offset += entry.getCount();
        }
        return (int)var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        return Multisets.equalsImpl(this, var1_1);
    }

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    @Override
    public String toString() {
        return ((AbstractCollection)((Object)this.entrySet())).toString();
    }

    @Override
    public abstract ImmutableSet<E> elementSet();

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSet<Multiset.Entry<E>> entrySet() {
        void var1_1;
        ImmutableSet<Multiset.Entry<E>> es = this.entrySet;
        if (es == null) {
            this.entrySet = this.createEntrySet();
            return this.entrySet;
        }
        return var1_1;
    }

    private ImmutableSet<Multiset.Entry<E>> createEntrySet() {
        if (this.isEmpty()) {
            return ImmutableSet.of();
        }
        return new EntrySet();
    }

    abstract Multiset.Entry<E> getEntry(int var1);

    @Override
    @GwtIncompatible
    Object writeReplace() {
        return new SerializedForm(this);
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    static final class SerializedForm
    implements Serializable {
        final Object[] elements;
        final int[] counts;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SerializedForm(Multiset<? extends Object> multiset) {
            Iterator iterator;
            int distinct = multiset.entrySet().size();
            this.elements = new Object[distinct];
            this.counts = new int[distinct];
            int i = 0;
            for (Multiset.Entry entry : iterator.entrySet()) {
                void var3_3;
                this.elements[i] = entry.getElement();
                this.counts[i] = var3_3.getCount();
                ++i;
            }
        }

        /*
         * WARNING - void declaration
         */
        final Object readResolve() {
            void var1_1;
            LinkedHashMultiset multiset = LinkedHashMultiset.create(this.elements.length);
            for (int i = 0; i < this.elements.length; ++i) {
                multiset.add(this.elements[i], this.counts[i]);
            }
            return ImmutableMultiset.copyOf(var1_1);
        }
    }

    static final class ElementSet<E>
    extends ImmutableSet.Indexed<E> {
        private final List<Multiset.Entry<E>> entries;
        private final Multiset<E> delegate;

        /*
         * WARNING - void declaration
         */
        ElementSet(List<Multiset.Entry<E>> entries, Multiset<E> delegate) {
            void var2_2;
            void var1_1;
            this.entries = var1_1;
            this.delegate = var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final E get(int index) {
            void var1_1;
            return this.entries.get((int)var1_1).getElement();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object object) {
            void var1_1;
            return this.delegate.contains(var1_1);
        }

        @Override
        final boolean isPartialView() {
            return true;
        }

        @Override
        public final int size() {
            return this.entries.size();
        }
    }

    public static class Builder<E>
    extends ImmutableCollection.Builder<E> {
        final Multiset<E> contents;

        public Builder() {
            this(LinkedHashMultiset.create());
        }

        /*
         * WARNING - void declaration
         */
        Builder(Multiset<E> contents) {
            void var1_1;
            this.contents = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> add(E element) {
            void var1_1;
            this.contents.add(Preconditions.checkNotNull(var1_1));
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> add(E ... elements) {
            void var1_1;
            super.add(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<E> addCopies(E element, int occurrences) {
            void var2_2;
            void var1_1;
            this.contents.add(Preconditions.checkNotNull(var1_1), (int)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<E> setCount(E element, int count) {
            void var2_2;
            void var1_1;
            this.contents.setCount(Preconditions.checkNotNull(var1_1), (int)var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> addAll(Iterable<? extends E> elements) {
            if (elements instanceof Multiset) {
                elements = Multisets.cast(elements);
                elements.forEachEntry((e, n) -> {
                    void var2_2;
                    void var1_1;
                    this.contents.add(Preconditions.checkNotNull(var1_1), (int)var2_2);
                });
            } else {
                void var1_1;
                super.addAll(var1_1);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Builder<E> addAll(Iterator<? extends E> elements) {
            void var1_1;
            super.addAll(var1_1);
            return this;
        }

        @Override
        public ImmutableMultiset<E> build() {
            return ImmutableMultiset.copyOf(this.contents);
        }

        @VisibleForTesting
        ImmutableMultiset<E> buildJdkBacked() {
            if (this.contents.isEmpty()) {
                return ImmutableMultiset.of();
            }
            return JdkBackedImmutableMultiset.create(this.contents.entrySet());
        }
    }

    @GwtIncompatible
    static class EntrySetSerializedForm<E>
    implements Serializable {
        final ImmutableMultiset<E> multiset;

        /*
         * WARNING - void declaration
         */
        EntrySetSerializedForm(ImmutableMultiset<E> multiset) {
            void var1_1;
            this.multiset = var1_1;
        }

        Object readResolve() {
            return this.multiset.entrySet();
        }
    }

    private final class EntrySet
    extends IndexedImmutableSet<Multiset.Entry<E>> {
        private static final long serialVersionUID = 0L;

        private EntrySet() {
        }

        @Override
        final boolean isPartialView() {
            return ImmutableMultiset.this.isPartialView();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Multiset.Entry<E> get(int index) {
            void var1_1;
            return ImmutableMultiset.this.getEntry((int)var1_1);
        }

        @Override
        public final int size() {
            return ((AbstractCollection)((Object)ImmutableMultiset.this.elementSet())).size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object o) {
            if (o instanceof Multiset.Entry) {
                void var1_1;
                Multiset.Entry entry = (Multiset.Entry)o;
                if (entry.getCount() <= 0) {
                    return false;
                }
                int n = ImmutableMultiset.this.count(entry.getElement());
                return n == var1_1.getCount();
            }
            return false;
        }

        @Override
        public final int hashCode() {
            return ImmutableMultiset.this.hashCode();
        }

        @Override
        @GwtIncompatible
        final Object writeReplace() {
            return new EntrySetSerializedForm(ImmutableMultiset.this);
        }
    }
}

