/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.BaseImmutableMultimap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimap;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.collect.Platform;
import com.google.common.collect.Serialization;
import com.google.common.collect.SetMultimap;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.BiConsumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class ImmutableMultimap<K, V>
extends BaseImmutableMultimap<K, V>
implements Serializable {
    final transient ImmutableMap<K, ? extends ImmutableCollection<V>> map;
    final transient int size;
    private static final long serialVersionUID = 0L;

    public static <K, V> ImmutableMultimap<K, V> of() {
        return ImmutableListMultimap.of();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMultimap<K, V> of(K k1, V v1) {
        void var1_1;
        return ImmutableListMultimap.of(k1, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMultimap<K, V> of(K k1, V v1, K k2, V v2) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ImmutableListMultimap.of(k1, var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ImmutableListMultimap.of(k1, var1_1, var2_2, var3_3, k3, v3);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ImmutableListMultimap.of(k1, var1_1, var2_2, var3_3, k3, v3, k4, v4);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        void var3_3;
        void var2_2;
        void var1_1;
        return ImmutableListMultimap.of(k1, var1_1, var2_2, var3_3, k3, v3, k4, v4, k5, v5);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap) {
        Multimap<? extends K, ? extends V> multimap2;
        ImmutableMultimap kvMultimap;
        if (multimap instanceof ImmutableMultimap && !(kvMultimap = (ImmutableMultimap)multimap).isPartialView()) {
            void var1_1;
            return var1_1;
        }
        return ImmutableListMultimap.copyOf(multimap2);
    }

    @Beta
    public static <K, V> ImmutableMultimap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        return ImmutableListMultimap.copyOf(entries);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableMultimap(ImmutableMap<K, ? extends ImmutableCollection<V>> map, int size) {
        void var2_2;
        void var1_1;
        this.map = var1_1;
        this.size = var2_2;
    }

    @Override
    @Deprecated
    public ImmutableCollection<V> removeAll(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public ImmutableCollection<V> replaceValues(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract ImmutableCollection<V> get(K var1);

    public abstract ImmutableMultimap<V, K> inverse();

    @Override
    @Deprecated
    public final boolean put(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean putAll(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean putAll(Multimap<? extends K, ? extends V> multimap) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    boolean isPartialView() {
        return this.map.isPartialView();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.map.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return value != null && super.containsValue(var1_1);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public ImmutableSet<K> keySet() {
        return this.map.keySet();
    }

    @Override
    Set<K> createKeySet() {
        throw new AssertionError((Object)"unreachable");
    }

    @Override
    public ImmutableMap<K, Collection<V>> asMap() {
        return this.map;
    }

    @Override
    Map<K, Collection<V>> createAsMap() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    public ImmutableCollection<Map.Entry<K, V>> entries() {
        return (ImmutableCollection)super.entries();
    }

    @Override
    ImmutableCollection<Map.Entry<K, V>> createEntries() {
        return new EntryCollection(this);
    }

    @Override
    UnmodifiableIterator<Map.Entry<K, V>> entryIterator() {
        return new UnmodifiableIterator<Map.Entry<K, V>>(this){
            final Iterator<? extends Map.Entry<K, ? extends ImmutableCollection<V>>> asMapItr;
            K currentKey;
            Iterator<V> valueItr;
            final /* synthetic */ ImmutableMultimap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.asMapItr = ((ImmutableCollection)((Object)this.this$0.map.entrySet())).iterator();
                this.currentKey = null;
                this.valueItr = Iterators.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                return this.valueItr.hasNext() || this.asMapItr.hasNext();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public Map.Entry<K, V> next() {
                if (!this.valueItr.hasNext()) {
                    void var1_1;
                    Map.Entry entry = this.asMapItr.next();
                    this.currentKey = entry.getKey();
                    this.valueItr = ((ImmutableCollection)var1_1.getValue()).iterator();
                }
                return Maps.immutableEntry(Objects.requireNonNull(this.currentKey), this.valueItr.next());
            }
        };
    }

    @Override
    Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return CollectSpliterators.flatMap(((ImmutableCollection)((Object)((ImmutableMap)this.asMap()).entrySet())).spliterator(), keyToValueCollectionEntry -> {
            void var1_1;
            Collection collection;
            Object key = keyToValueCollectionEntry.getKey();
            collection = (Collection)collection.getValue();
            return CollectSpliterators.map(collection.spliterator(), value -> {
                void var1_1;
                return Maps.immutableEntry(var1_1, var1_1);
            });
        }, 0x40 | (this instanceof SetMultimap ? 1 : 0), this.size());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void forEach(BiConsumer<? super K, ? super V> action) {
        void var1_1;
        Preconditions.checkNotNull(action);
        this.asMap().forEach((arg_0, arg_1) -> ImmutableMultimap.lambda$forEach$3((BiConsumer)var1_1, arg_0, arg_1));
    }

    @Override
    public ImmutableMultiset<K> keys() {
        return (ImmutableMultiset)super.keys();
    }

    @Override
    ImmutableMultiset<K> createKeys() {
        return new Keys(this);
    }

    @Override
    public ImmutableCollection<V> values() {
        return (ImmutableCollection)super.values();
    }

    @Override
    ImmutableCollection<V> createValues() {
        return new Values(this);
    }

    @Override
    UnmodifiableIterator<V> valueIterator() {
        return new UnmodifiableIterator<V>(this){
            Iterator<? extends ImmutableCollection<V>> valueCollectionItr;
            Iterator<V> valueItr;
            final /* synthetic */ ImmutableMultimap this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.valueCollectionItr = ((ImmutableCollection)this.this$0.map.values()).iterator();
                this.valueItr = Iterators.emptyIterator();
            }

            @Override
            public boolean hasNext() {
                return this.valueItr.hasNext() || this.valueCollectionItr.hasNext();
            }

            @Override
            public V next() {
                if (!this.valueItr.hasNext()) {
                    this.valueItr = this.valueCollectionItr.next().iterator();
                }
                return this.valueItr.next();
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$forEach$3(BiConsumer action, Object key, Collection valueCollection) {
        void var1_1;
        BiConsumer biConsumer;
        valueCollection.forEach((? super T value) -> {
            void var2_2;
            void var1_1;
            biConsumer.accept(var1_1, var2_2);
        });
    }

    private static final class Values<K, V>
    extends ImmutableCollection<V> {
        private final transient ImmutableMultimap<K, V> multimap;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        Values(ImmutableMultimap<K, V> multimap) {
            void var1_1;
            this.multimap = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean contains(Object object) {
            void var1_1;
            return this.multimap.containsValue(var1_1);
        }

        @Override
        public final UnmodifiableIterator<V> iterator() {
            return this.multimap.valueIterator();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @GwtIncompatible
        final int copyIntoArray(Object[] dst, int offset) {
            void var2_2;
            for (ImmutableCollection immutableCollection : this.multimap.map.values()) {
                offset = immutableCollection.copyIntoArray(dst, offset);
            }
            return (int)var2_2;
        }

        @Override
        public final int size() {
            return this.multimap.size();
        }

        @Override
        final boolean isPartialView() {
            return true;
        }
    }

    @GwtIncompatible
    private static final class KeysSerializedForm
    implements Serializable {
        final ImmutableMultimap<?, ?> multimap;

        /*
         * WARNING - void declaration
         */
        KeysSerializedForm(ImmutableMultimap<?, ?> multimap) {
            void var1_1;
            this.multimap = var1_1;
        }

        final Object readResolve() {
            return this.multimap.keys();
        }
    }

    class Keys
    extends ImmutableMultiset<K> {
        final /* synthetic */ ImmutableMultimap this$0;

        /*
         * WARNING - void declaration
         */
        Keys(ImmutableMultimap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object object) {
            void var1_1;
            return this.this$0.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int count(Object element) {
            void var1_1;
            Collection values = this.this$0.map.get(element);
            if (values == null) {
                return 0;
            }
            return var1_1.size();
        }

        @Override
        public ImmutableSet<K> elementSet() {
            return this.this$0.keySet();
        }

        @Override
        public int size() {
            return this.this$0.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Multiset.Entry<K> getEntry(int index) {
            void var1_2;
            Map.Entry entry = (Map.Entry)((ImmutableCollection)((Object)this.this$0.map.entrySet())).asList().get(index);
            return Multisets.immutableEntry(entry.getKey(), ((Collection)var1_2.getValue()).size());
        }

        @Override
        boolean isPartialView() {
            return true;
        }

        @Override
        @GwtIncompatible
        Object writeReplace() {
            return new KeysSerializedForm(this.this$0);
        }
    }

    private static class EntryCollection<K, V>
    extends ImmutableCollection<Map.Entry<K, V>> {
        final ImmutableMultimap<K, V> multimap;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        EntryCollection(ImmutableMultimap<K, V> multimap) {
            void var1_1;
            this.multimap = var1_1;
        }

        @Override
        public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
            return this.multimap.entryIterator();
        }

        @Override
        boolean isPartialView() {
            return this.multimap.isPartialView();
        }

        @Override
        public int size() {
            return this.multimap.size();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object object) {
            if (object instanceof Map.Entry) {
                void var1_1;
                Map.Entry entry = (Map.Entry)object;
                return this.multimap.containsEntry(entry.getKey(), var1_1.getValue());
            }
            return false;
        }
    }

    @GwtIncompatible
    static class FieldSettersHolder {
        static final Serialization.FieldSetter<ImmutableMultimap> MAP_FIELD_SETTER = Serialization.getFieldSetter(ImmutableMultimap.class, "map");
        static final Serialization.FieldSetter<ImmutableMultimap> SIZE_FIELD_SETTER = Serialization.getFieldSetter(ImmutableMultimap.class, "size");

        FieldSettersHolder() {
        }
    }

    public static class Builder<K, V> {
        final Map<K, Collection<V>> builderMap = Platform.preservesInsertionOrderOnPutsMap();
        Comparator<? super K> keyComparator;
        Comparator<? super V> valueComparator;

        Collection<V> newMutableValueCollection() {
            return new ArrayList();
        }

        /*
         * WARNING - void declaration
         */
        public Builder<K, V> put(K key, V value) {
            void var2_2;
            void var3_3;
            CollectPreconditions.checkEntryNotNull(key, value);
            Collection<V> valueCollection = this.builderMap.get(key);
            if (valueCollection == null) {
                void var1_1;
                valueCollection = this.newMutableValueCollection();
                this.builderMap.put(var1_1, valueCollection);
            }
            var3_3.add(var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            void var1_1;
            return this.put(entry.getKey(), var1_1.getValue());
        }

        @Beta
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            for (Map.Entry<K, V> entry : entries) {
                this.put(entry);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<K, V> putAll(K key, Iterable<? extends V> values) {
            void var3_3;
            void var1_1;
            if (key == null) {
                String string = String.valueOf(Iterables.toString(values));
                throw new NullPointerException(string.length() != 0 ? "null key in entry: null=".concat(string) : new String("null key in entry: null="));
            }
            Collection<V> valueCollection = this.builderMap.get(key);
            if (valueCollection != null) {
                values = values.iterator();
                while (values.hasNext()) {
                    Object value = values.next();
                    CollectPreconditions.checkEntryNotNull(key, value);
                    valueCollection.add(value);
                }
                return this;
            }
            Iterator<V> valuesItr = values.iterator();
            if (!valuesItr.hasNext()) {
                return this;
            }
            valueCollection = this.newMutableValueCollection();
            while (valuesItr.hasNext()) {
                V value = valuesItr.next();
                CollectPreconditions.checkEntryNotNull(key, value);
                valueCollection.add(value);
            }
            this.builderMap.put(var1_1, (Collection<void>)var3_3);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<K, V> putAll(K key, V ... values) {
            void var2_2;
            void var1_1;
            return this.putAll((K)var1_1, Arrays.asList(var2_2));
        }

        /*
         * WARNING - void declaration
         */
        public Builder<K, V> putAll(Multimap<? extends K, ? extends V> multimap) {
            for (Map.Entry<K, Collection<V>> entry : multimap.asMap().entrySet()) {
                void var2_2;
                this.putAll(entry.getKey(), (Iterable)var2_2.getValue());
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<K, V> orderKeysBy(Comparator<? super K> keyComparator) {
            void var1_1;
            this.keyComparator = (Comparator)Preconditions.checkNotNull(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<K, V> orderValuesBy(Comparator<? super V> valueComparator) {
            void var1_1;
            this.valueComparator = (Comparator)Preconditions.checkNotNull(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder<K, V> combine(Builder<K, V> other) {
            for (Map.Entry<K, Collection<V>> entry : other.builderMap.entrySet()) {
                void var2_2;
                this.putAll(entry.getKey(), (Iterable)var2_2.getValue());
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public ImmutableMultimap<K, V> build() {
            void var1_1;
            Collection<Map.Entry<K, Collection<V>>> mapEntries = this.builderMap.entrySet();
            if (this.keyComparator != null) {
                mapEntries = Ordering.from(this.keyComparator).onKeys().immutableSortedCopy(mapEntries);
            }
            return ImmutableListMultimap.fromMapEntries(var1_1, this.valueComparator);
        }
    }
}

