/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableAsList;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
final class ImmutableMapValues<K, V>
extends ImmutableCollection<V> {
    private final ImmutableMap<K, V> map;

    /*
     * WARNING - void declaration
     */
    ImmutableMapValues(ImmutableMap<K, V> map) {
        void var1_1;
        this.map = var1_1;
    }

    @Override
    public final int size() {
        return this.map.size();
    }

    @Override
    public final UnmodifiableIterator<V> iterator() {
        return new UnmodifiableIterator<V>(this){
            final UnmodifiableIterator<Map.Entry<K, V>> entryItr;
            final /* synthetic */ ImmutableMapValues this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.entryItr = ((ImmutableCollection)((Object)this.this$0.map.entrySet())).iterator();
            }

            @Override
            public boolean hasNext() {
                return this.entryItr.hasNext();
            }

            @Override
            public V next() {
                return ((Map.Entry)this.entryItr.next()).getValue();
            }
        };
    }

    @Override
    public final Spliterator<V> spliterator() {
        return CollectSpliterators.map(((ImmutableCollection)((Object)this.map.entrySet())).spliterator(), Map.Entry::getValue);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object object) {
        void var1_1;
        return object != null && Iterators.contains(((ImmutableCollection)this).iterator(), var1_1);
    }

    @Override
    final boolean isPartialView() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ImmutableList<V> asList() {
        void var1_1;
        ImmutableList entryList = ((ImmutableCollection)((Object)this.map.entrySet())).asList();
        return new ImmutableAsList<V>(this, (ImmutableList)var1_1){
            final /* synthetic */ ImmutableList val$entryList;
            final /* synthetic */ ImmutableMapValues this$0;
            {
                void var1_1;
                this.this$0 = var1_1;
                this.val$entryList = immutableList;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public V get(int index) {
                void var1_1;
                return ((Map.Entry)this.val$entryList.get((int)var1_1)).getValue();
            }

            @Override
            ImmutableCollection<V> delegateCollection() {
                return this.this$0;
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @GwtIncompatible
    public final void forEach(Consumer<? super V> action) {
        void var1_1;
        Preconditions.checkNotNull(action);
        this.map.forEach((arg_0, arg_1) -> ImmutableMapValues.lambda$forEach$0((Consumer)var1_1, arg_0, arg_1));
    }

    /*
     * WARNING - void declaration
     */
    private static /* synthetic */ void lambda$forEach$0(Consumer action, Object k, Object v) {
        void var2_2;
        action.accept(var2_2);
    }

    @GwtIncompatible
    private static class SerializedForm<V>
    implements Serializable {
        final ImmutableMap<?, V> map;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SerializedForm(ImmutableMap<?, V> map) {
            void var1_1;
            this.map = var1_1;
        }

        Object readResolve() {
            return this.map.values();
        }
    }
}

