/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableBiMap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableEnumMap;
import com.google.common.collect.ImmutableMapEntry;
import com.google.common.collect.ImmutableMapEntrySet;
import com.google.common.collect.ImmutableMapKeySet;
import com.google.common.collect.ImmutableMapValues;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSetMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.JdkBackedImmutableMap;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableMap;
import com.google.common.collect.Sets;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.SortedMap;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.BiFunction;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableMap<K, V>
implements Serializable,
Map<K, V> {
    static final Map.Entry<?, ?>[] EMPTY_ENTRY_ARRAY = new Map.Entry[0];
    private transient ImmutableSet<Map.Entry<K, V>> entrySet;
    private transient ImmutableSet<K> keySet;
    private transient ImmutableCollection<V> values;
    private transient ImmutableSetMultimap<K, V> multimapView;

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        return CollectCollectors.toImmutableMap(keyFunction, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Collector<T, ?, ImmutableMap<K, V>> toImmutableMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction, BinaryOperator<V> mergeFunction) {
        void var2_2;
        void var1_1;
        return CollectCollectors.toImmutableMap(keyFunction, var1_1, var2_2);
    }

    public static <K, V> ImmutableMap<K, V> of() {
        return RegularImmutableMap.EMPTY;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1) {
        void var1_1;
        return ImmutableBiMap.of(k1, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k, var1_1), ImmutableMap.entryOf(var2_2, var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k, var1_1), ImmutableMap.entryOf(var2_2, var3_3), ImmutableMap.entryOf(k3, v3));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k, var1_1), ImmutableMap.entryOf(var2_2, var3_3), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k, var1_1), ImmutableMap.entryOf(var2_2, var3_3), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k, var1_1), ImmutableMap.entryOf(var2_2, var3_3), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5), ImmutableMap.entryOf(k6, v6));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k, var1_1), ImmutableMap.entryOf(var2_2, var3_3), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5), ImmutableMap.entryOf(k6, v6), ImmutableMap.entryOf(k7, v7));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k, var1_1), ImmutableMap.entryOf(var2_2, var3_3), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5), ImmutableMap.entryOf(k6, v6), ImmutableMap.entryOf(k7, v7), ImmutableMap.entryOf(k8, v8));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k, var1_1), ImmutableMap.entryOf(var2_2, var3_3), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5), ImmutableMap.entryOf(k6, v6), ImmutableMap.entryOf(k7, v7), ImmutableMap.entryOf(k8, v8), ImmutableMap.entryOf(k9, v9));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableMap.fromEntries(ImmutableMap.entryOf(k, var1_1), ImmutableMap.entryOf(var2_2, var3_3), ImmutableMap.entryOf(k3, v3), ImmutableMap.entryOf(k4, v4), ImmutableMap.entryOf(k5, v5), ImmutableMap.entryOf(k6, v6), ImmutableMap.entryOf(k7, v7), ImmutableMap.entryOf(k8, v8), ImmutableMap.entryOf(k9, v9), ImmutableMap.entryOf(k10, v10));
    }

    @SafeVarargs
    public static <K, V> ImmutableMap<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        Map.Entry<? extends K, ? extends V>[] entryArray = entries;
        return RegularImmutableMap.fromEntries(entries);
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> Map.Entry<K, V> entryOf(K key, V value) {
        void var1_1;
        K k;
        return new ImmutableMapEntry<K, void>(k, var1_1);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    @Beta
    public static <K, V> Builder<K, V> builderWithExpectedSize(int expectedSize) {
        int n;
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        return new Builder(n);
    }

    /*
     * WARNING - void declaration
     */
    static void checkNoConflict(boolean safe, String conflictDescription, Object entry1, Object entry2) {
        if (!safe) {
            void var3_3;
            void var2_2;
            void var1_1;
            throw ImmutableMap.conflictException((String)var1_1, var2_2, var3_3);
        }
    }

    static IllegalArgumentException conflictException(String conflictDescription, Object entry1, Object entry2) {
        String string;
        String string2;
        String string3;
        string3 = String.valueOf(string3);
        string2 = String.valueOf(string2);
        return new IllegalArgumentException(new StringBuilder(34 + String.valueOf(conflictDescription).length() + String.valueOf(string3).length() + String.valueOf(string2).length()).append("Multiple entries with same ").append(string).append(": ").append(string3).append(" and ").append(string2).toString());
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        Map<K, V> map2;
        if (map instanceof ImmutableMap && !(map instanceof SortedMap)) {
            ImmutableMap kvMap = (ImmutableMap)map;
            if (!kvMap.isPartialView()) {
                void var1_1;
                return var1_1;
            }
        } else if (map instanceof EnumMap) {
            ImmutableMap<K, V> immutableMap = ImmutableMap.copyOfEnumMap((EnumMap)map);
            return immutableMap;
        }
        return ImmutableMap.copyOf(map2.entrySet());
    }

    @Beta
    public static <K, V> ImmutableMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Map.Entry<?, ?>[] entryArray;
        Map.Entry<?, ?>[] entryArray2 = Iterables.toArray(entries, EMPTY_ENTRY_ARRAY);
        switch (entryArray2.length) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                Map.Entry<?, ?>[] onlyEntry = Objects.requireNonNull(entryArray2[0]);
                return ImmutableMap.of(onlyEntry.getKey(), entryArray.getValue());
            }
        }
        return RegularImmutableMap.fromEntries(entryArray);
    }

    /*
     * WARNING - void declaration
     */
    private static <K extends Enum<K>, V> ImmutableMap<K, V> copyOfEnumMap(EnumMap<K, ? extends V> original) {
        EnumMap<K, ? extends V> enumMap;
        EnumMap<K, ? extends V> copy = new EnumMap<K, V>(original);
        for (Map.Entry<K, V> entry : copy.entrySet()) {
            void var2_2;
            CollectPreconditions.checkEntryNotNull(entry.getKey(), var2_2.getValue());
        }
        return ImmutableEnumMap.asImmutable(enumMap);
    }

    ImmutableMap() {
    }

    @Override
    @Deprecated
    public final V put(K k, V v) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V putIfAbsent(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean replace(K key, V oldValue, V newValue) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V replace(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void putAll(Map<? extends K, ? extends V> map) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final V remove(Object o) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean remove(Object key, Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.get(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return ((ImmutableCollection)this.values()).contains(var1_1);
    }

    @Override
    public abstract V get(Object var1);

    /*
     * WARNING - void declaration
     */
    @Override
    public final V getOrDefault(Object key, V defaultValue) {
        void var2_2;
        V result = this.get(key);
        if (result != null) {
            void var1_1;
            return var1_1;
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSet<Map.Entry<K, V>> entrySet() {
        void var1_1;
        ImmutableSet<Map.Entry<K, V>> result = this.entrySet;
        if (result == null) {
            this.entrySet = this.createEntrySet();
            return this.entrySet;
        }
        return var1_1;
    }

    abstract ImmutableSet<Map.Entry<K, V>> createEntrySet();

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableSet<K> keySet() {
        void var1_1;
        ImmutableSet<K> result = this.keySet;
        if (result == null) {
            this.keySet = this.createKeySet();
            return this.keySet;
        }
        return var1_1;
    }

    abstract ImmutableSet<K> createKeySet();

    /*
     * WARNING - void declaration
     */
    UnmodifiableIterator<K> keyIterator() {
        void var1_1;
        Iterator entryIterator = ((ImmutableCollection)((Object)this.entrySet())).iterator();
        return new UnmodifiableIterator<K>(this, (UnmodifiableIterator)var1_1){
            final /* synthetic */ UnmodifiableIterator val$entryIterator;
            {
                this.val$entryIterator = unmodifiableIterator;
            }

            @Override
            public boolean hasNext() {
                return this.val$entryIterator.hasNext();
            }

            @Override
            public K next() {
                return ((Map.Entry)this.val$entryIterator.next()).getKey();
            }
        };
    }

    Spliterator<K> keySpliterator() {
        return CollectSpliterators.map(((ImmutableCollection)((Object)this.entrySet())).spliterator(), Map.Entry::getKey);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableCollection<V> values() {
        void var1_1;
        ImmutableCollection<V> result = this.values;
        if (result == null) {
            this.values = this.createValues();
            return this.values;
        }
        return var1_1;
    }

    abstract ImmutableCollection<V> createValues();

    /*
     * WARNING - void declaration
     */
    public ImmutableSetMultimap<K, V> asMultimap() {
        void var1_1;
        if (this.isEmpty()) {
            return ImmutableSetMultimap.of();
        }
        ImmutableSetMultimap<K, V> result = this.multimapView;
        if (result == null) {
            this.multimapView = new ImmutableSetMultimap(new MapViewOfValuesAsSingletonSets(), this.size(), null);
            return this.multimapView;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        return Maps.equalsImpl(this, var1_1);
    }

    abstract boolean isPartialView();

    @Override
    public int hashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    boolean isHashCodeFast() {
        return false;
    }

    public String toString() {
        return Maps.toStringImpl(this);
    }

    Object writeReplace() {
        return new SerializedForm(this);
    }

    static class SerializedForm<K, V>
    implements Serializable {
        private static final boolean USE_LEGACY_SERIALIZATION = true;
        private final Object keys;
        private final Object values;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SerializedForm(ImmutableMap<K, V> map) {
            void var3_3;
            void var2_2;
            Iterator iterator;
            Object[] keys = new Object[map.size()];
            Object[] values = new Object[map.size()];
            int i = 0;
            for (Map.Entry entry : ((ImmutableMap)((Object)iterator)).entrySet()) {
                keys[i] = entry.getKey();
                values[i] = entry.getValue();
                ++i;
            }
            this.keys = var2_2;
            this.values = var3_3;
        }

        /*
         * WARNING - void declaration
         */
        final Object readResolve() {
            void var3_3;
            if (!(this.keys instanceof ImmutableSet)) {
                return this.legacyReadResolve();
            }
            ImmutableSet keySet = (ImmutableSet)this.keys;
            ImmutableCollection values = (ImmutableCollection)this.values;
            Builder builder = this.makeBuilder(keySet.size());
            Iterator keyIter = ((ImmutableCollection)keySet).iterator();
            Iterator valueIter = values.iterator();
            while (keyIter.hasNext()) {
                builder.put(keyIter.next(), valueIter.next());
            }
            return var3_3.buildOrThrow();
        }

        /*
         * WARNING - void declaration
         */
        final Object legacyReadResolve() {
            void var3_3;
            Object[] keys = (Object[])this.keys;
            Object[] values = (Object[])this.values;
            Builder<Object, Object> builder = this.makeBuilder(keys.length);
            for (int i = 0; i < keys.length; ++i) {
                builder.put(keys[i], values[i]);
            }
            return var3_3.buildOrThrow();
        }

        /*
         * WARNING - void declaration
         */
        Builder<K, V> makeBuilder(int size) {
            void var1_1;
            return new Builder((int)var1_1);
        }
    }

    private final class MapViewOfValuesAsSingletonSets
    extends IteratorBasedImmutableMap<K, ImmutableSet<V>> {
        private MapViewOfValuesAsSingletonSets() {
        }

        @Override
        public final int size() {
            return ImmutableMap.this.size();
        }

        @Override
        final ImmutableSet<K> createKeySet() {
            return ImmutableMap.this.keySet();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object key) {
            void var1_1;
            return ImmutableMap.this.containsKey(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ImmutableSet<V> get(Object key) {
            void var1_1;
            Object outerValue = ImmutableMap.this.get(key);
            if (outerValue == null) {
                return null;
            }
            return ImmutableSet.of(var1_1);
        }

        @Override
        final boolean isPartialView() {
            return ImmutableMap.this.isPartialView();
        }

        @Override
        public final int hashCode() {
            return ImmutableMap.this.hashCode();
        }

        @Override
        final boolean isHashCodeFast() {
            return ImmutableMap.this.isHashCodeFast();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final UnmodifiableIterator<Map.Entry<K, ImmutableSet<V>>> entryIterator() {
            void var1_1;
            Iterator backingIterator = ((ImmutableCollection)((Object)ImmutableMap.this.entrySet())).iterator();
            return new UnmodifiableIterator<Map.Entry<K, ImmutableSet<V>>>(this, (Iterator)var1_1){
                final /* synthetic */ Iterator val$backingIterator;
                {
                    this.val$backingIterator = iterator;
                }

                @Override
                public boolean hasNext() {
                    return this.val$backingIterator.hasNext();
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                public Map.Entry<K, ImmutableSet<V>> next() {
                    void var1_1;
                    Map.Entry backingEntry = (Map.Entry)this.val$backingIterator.next();
                    return new AbstractMapEntry<K, ImmutableSet<V>>(this, (Map.Entry)var1_1){
                        final /* synthetic */ Map.Entry val$backingEntry;
                        {
                            this.val$backingEntry = entry;
                        }

                        @Override
                        public K getKey() {
                            return this.val$backingEntry.getKey();
                        }

                        @Override
                        public ImmutableSet<V> getValue() {
                            return ImmutableSet.of(this.val$backingEntry.getValue());
                        }
                    };
                }
            };
        }
    }

    static abstract class IteratorBasedImmutableMap<K, V>
    extends ImmutableMap<K, V> {
        IteratorBasedImmutableMap() {
        }

        abstract UnmodifiableIterator<Map.Entry<K, V>> entryIterator();

        Spliterator<Map.Entry<K, V>> entrySpliterator() {
            return Spliterators.spliterator(this.entryIterator(), (long)this.size(), 1297);
        }

        @Override
        ImmutableSet<K> createKeySet() {
            return new ImmutableMapKeySet(this);
        }

        @Override
        ImmutableSet<Map.Entry<K, V>> createEntrySet() {
            class EntrySetImpl
            extends ImmutableMapEntrySet<K, V> {
                final /* synthetic */ IteratorBasedImmutableMap this$0;

                /*
                 * WARNING - void declaration
                 */
                EntrySetImpl(IteratorBasedImmutableMap this$0) {
                    void var1_1;
                    this.this$0 = var1_1;
                }

                @Override
                ImmutableMap<K, V> map() {
                    return this.this$0;
                }

                @Override
                public UnmodifiableIterator<Map.Entry<K, V>> iterator() {
                    return this.this$0.entryIterator();
                }
            }
            return new EntrySetImpl(this);
        }

        @Override
        ImmutableCollection<V> createValues() {
            return new ImmutableMapValues(this);
        }
    }

    public static class Builder<K, V> {
        Comparator<? super V> valueComparator;
        Map.Entry<K, V>[] entries;
        int size;
        boolean entriesUsed;

        public Builder() {
            this(4);
        }

        /*
         * WARNING - void declaration
         */
        Builder(int initialCapacity) {
            void var1_1;
            this.entries = new Map.Entry[var1_1];
            this.size = 0;
            this.entriesUsed = false;
        }

        /*
         * WARNING - void declaration
         */
        private void ensureCapacity(int minCapacity) {
            if (minCapacity > this.entries.length) {
                void var1_1;
                this.entries = Arrays.copyOf(this.entries, ImmutableCollection.Builder.expandedCapacity(this.entries.length, (int)var1_1));
                this.entriesUsed = false;
            }
        }

        /*
         * WARNING - void declaration
         */
        public Builder<K, V> put(K key, V value) {
            void var1_1;
            void var2_2;
            Builder builder = this;
            builder.ensureCapacity(builder.size + 1);
            Map.Entry<K, void> entry = ImmutableMap.entryOf(key, var2_2);
            this.entries[this.size++] = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            void var1_1;
            return this.put(entry.getKey(), var1_1.getValue());
        }

        /*
         * WARNING - void declaration
         */
        public Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            void var1_1;
            return this.putAll(var1_1.entrySet());
        }

        /*
         * WARNING - void declaration
         */
        @Beta
        public Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            Iterator iterator;
            if (entries instanceof Collection) {
                Builder builder = this;
                builder.ensureCapacity(builder.size + ((Collection)entries).size());
            }
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var2_2;
                Map.Entry entry = (Map.Entry)iterator.next();
                this.put((Map.Entry<? extends K, ? extends V>)var2_2);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Beta
        public Builder<K, V> orderEntriesByValue(Comparator<? super V> valueComparator) {
            void var1_1;
            Preconditions.checkState(this.valueComparator == null, "valueComparator was already set");
            this.valueComparator = (Comparator)Preconditions.checkNotNull(var1_1, "valueComparator");
            return this;
        }

        /*
         * WARNING - void declaration
         */
        Builder<K, V> combine(Builder<K, V> other) {
            void var1_1;
            Preconditions.checkNotNull(other);
            Builder builder = this;
            builder.ensureCapacity(builder.size + other.size);
            System.arraycopy(other.entries, 0, this.entries, this.size, other.size);
            this.size += var1_1.size;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private ImmutableMap<K, V> build(boolean throwIfDuplicateKeys) {
            void var1_1;
            void var2_3;
            void var3_4;
            Map.Entry<K, V>[] localEntries;
            switch (this.size) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    Map.Entry<K, V> onlyEntry = Objects.requireNonNull(this.entries[0]);
                    return ImmutableMap.of(onlyEntry.getKey(), onlyEntry.getValue());
                }
            }
            int localSize = this.size;
            if (this.valueComparator == null) {
                localEntries = this.entries;
            } else {
                if (this.entriesUsed) {
                    this.entries = Arrays.copyOf(this.entries, this.size);
                }
                localEntries = this.entries;
                if (!throwIfDuplicateKeys) {
                    localEntries = Builder.lastEntryForEachKey(localEntries, this.size);
                    localSize = localEntries.length;
                }
                Arrays.sort(localEntries, 0, localSize, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
            }
            this.entriesUsed = true;
            return RegularImmutableMap.fromEntryArray((int)var3_4, var2_3, (boolean)var1_1);
        }

        public ImmutableMap<K, V> build() {
            return this.buildOrThrow();
        }

        public ImmutableMap<K, V> buildOrThrow() {
            return this.build(true);
        }

        public ImmutableMap<K, V> buildKeepingLast() {
            return this.build(false);
        }

        /*
         * WARNING - void declaration
         */
        @VisibleForTesting
        ImmutableMap<K, V> buildJdkBacked() {
            Preconditions.checkState(this.valueComparator == null, "buildJdkBacked is only for testing; can't use valueComparator");
            switch (this.size) {
                case 0: {
                    return ImmutableMap.of();
                }
                case 1: {
                    void var1_1;
                    Map.Entry<K, V> onlyEntry = Objects.requireNonNull(this.entries[0]);
                    return ImmutableMap.of(onlyEntry.getKey(), var1_1.getValue());
                }
            }
            this.entriesUsed = true;
            return JdkBackedImmutableMap.create(this.size, this.entries, true);
        }

        private static <K, V> Map.Entry<K, V>[] lastEntryForEachKey(Map.Entry<K, V>[] entries, int size) {
            HashSet<K> seen = new HashSet<K>();
            BitSet dups = new BitSet();
            for (int i = size - 1; i >= 0; --i) {
                if (seen.add(entries[i].getKey())) continue;
                dups.set(i);
            }
            if (dups.isEmpty()) {
                return entries;
            }
            Map.Entry[] newEntries = new Map.Entry[size - dups.cardinality()];
            int outI = 0;
            for (int inI = 0; inI < size; ++inI) {
                if (dups.get(inI)) continue;
                newEntries[outI++] = entries[inI];
            }
            return newEntries;
        }
    }
}

