/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.EmptyImmutableListMultimap;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collector;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public class ImmutableListMultimap<K, V>
extends ImmutableMultimap<K, V>
implements ListMultimap<K, V> {
    private transient ImmutableListMultimap<V, K> inverse;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Collector<T, ?, ImmutableListMultimap<K, V>> toImmutableListMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        return CollectCollectors.toImmutableListMultimap(keyFunction, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Collector<T, ?, ImmutableListMultimap<K, V>> flatteningToImmutableListMultimap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends Stream<? extends V>> valuesFunction) {
        void var1_1;
        return CollectCollectors.flatteningToImmutableListMultimap(keyFunction, var1_1);
    }

    public static <K, V> ImmutableListMultimap<K, V> of() {
        return EmptyImmutableListMultimap.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableListMultimap<K, V> of(K k1, V v1) {
        void var2_2;
        void var1_1;
        K k;
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put((Object)k, (Object)var1_1);
        return var2_2.build();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableListMultimap<K, V> of(K k1, V v1, K k2, V v2) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put((Object)k, (Object)var1_1);
        builder.put((Object)var2_2, (Object)var3_3);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableListMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put((Object)k, (Object)var1_1);
        builder.put((Object)var2_2, (Object)var3_3);
        builder.put((Object)k3, (Object)v3);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableListMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put((Object)k, (Object)var1_1);
        builder.put((Object)var2_2, (Object)var3_3);
        builder.put((Object)k3, (Object)v3);
        builder.put((Object)k4, (Object)v4);
        return builder.build();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableListMultimap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        Builder<K, V> builder = ImmutableListMultimap.builder();
        builder.put((Object)k, (Object)var1_1);
        builder.put((Object)var2_2, (Object)var3_3);
        builder.put((Object)k3, (Object)v3);
        builder.put((Object)k4, (Object)v4);
        builder.put((Object)k5, (Object)v5);
        return builder.build();
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableListMultimap<K, V> copyOf(Multimap<? extends K, ? extends V> multimap) {
        Multimap<K, V> multimap2;
        ImmutableListMultimap kvMultimap;
        if (multimap.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        if (multimap instanceof ImmutableListMultimap && !(kvMultimap = (ImmutableListMultimap)multimap).isPartialView()) {
            void var1_1;
            return var1_1;
        }
        return ImmutableListMultimap.fromMapEntries(multimap2.asMap().entrySet(), null);
    }

    @Beta
    public static <K, V> ImmutableListMultimap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Iterable<? extends Map.Entry<? extends K, ? extends V>> iterable;
        return ((Builder)new Builder().putAll((Iterable)iterable)).build();
    }

    /*
     * WARNING - void declaration
     */
    static <K, V> ImmutableListMultimap<K, V> fromMapEntries(Collection<? extends Map.Entry<? extends K, ? extends Collection<? extends V>>> mapEntries, Comparator<? super V> valueComparator) {
        void var3_3;
        void var2_2;
        Iterator<? extends Map.Entry<? extends K, ? extends Collection<? extends V>>> iterator;
        if (mapEntries.isEmpty()) {
            return ImmutableListMultimap.of();
        }
        ImmutableMap.Builder builder = new ImmutableMap.Builder(mapEntries.size());
        int size = 0;
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry)iterator.next();
            Object key = entry.getKey();
            Collection values = (Collection)entry.getValue();
            ImmutableList<Object> list = valueComparator == null ? ImmutableList.copyOf(values) : ImmutableList.sortedCopyOf(valueComparator, values);
            if (list.isEmpty()) continue;
            builder.put(key, list);
            size += list.size();
        }
        return new ImmutableListMultimap(var2_2.buildOrThrow(), (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableListMultimap(ImmutableMap<K, ImmutableList<V>> map, int size) {
        super(var1_1, (int)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableList<V> get(K key) {
        void var1_1;
        ImmutableList list = (ImmutableList)this.map.get(key);
        if (list == null) {
            return ImmutableList.of();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableListMultimap<V, K> inverse() {
        void var1_1;
        ImmutableListMultimap<V, K> result = this.inverse;
        if (result == null) {
            this.inverse = this.invert();
            return this.inverse;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableListMultimap<V, K> invert() {
        void var1_1;
        Builder<K, V> builder = ImmutableListMultimap.builder();
        Iterator iterator = ((ImmutableCollection)this.entries()).iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Map.Entry entry = (Map.Entry)iterator.next();
            builder.put(entry.getValue(), var3_3.getKey());
        }
        ImmutableMultimap invertedMultimap = var1_1.build();
        ((ImmutableListMultimap)var1_1.build()).inverse = this;
        return iterator;
    }

    @Override
    @Deprecated
    public final ImmutableList<V> removeAll(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final ImmutableList<V> replaceValues(K key, Iterable<? extends V> values) {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        Serialization.writeMultimap(this, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        ImmutableMap tmpMap;
        stream.defaultReadObject();
        int keyCount = stream.readInt();
        if (keyCount < 0) {
            throw new InvalidObjectException(new StringBuilder(29).append("Invalid key count ").append(keyCount).toString());
        }
        ImmutableMap.Builder<Object, ImmutableCollection> builder = ImmutableMap.builder();
        int tmpSize = 0;
        for (int i = 0; i < keyCount; ++i) {
            Object key = stream.readObject();
            int valueCount = stream.readInt();
            if (valueCount <= 0) {
                throw new InvalidObjectException(new StringBuilder(31).append("Invalid value count ").append(valueCount).toString());
            }
            ImmutableList.Builder valuesBuilder = ImmutableList.builder();
            for (int j = 0; j < valueCount; ++j) {
                valuesBuilder.add(stream.readObject());
            }
            builder.put(key, valuesBuilder.build());
            tmpSize += valueCount;
        }
        try {
            void var3_3;
            tmpMap = var3_3.buildOrThrow();
        }
        catch (IllegalArgumentException e) {
            throw (InvalidObjectException)new InvalidObjectException(e.getMessage()).initCause(e);
        }
        ImmutableMultimap.FieldSettersHolder.MAP_FIELD_SETTER.set((ImmutableMultimap)this, tmpMap);
        ImmutableMultimap.FieldSettersHolder.SIZE_FIELD_SETTER.set((ImmutableMultimap)this, tmpSize);
    }

    public static final class Builder<K, V>
    extends ImmutableMultimap.Builder<K, V> {
        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> put(K key, V value) {
            void var2_2;
            void var1_1;
            super.put(var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            void var1_1;
            super.put(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Beta
        public final Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            void var1_1;
            super.putAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> putAll(K key, Iterable<? extends V> values) {
            void var2_2;
            void var1_1;
            super.putAll(var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> putAll(K key, V ... values) {
            void var2_2;
            void var1_1;
            super.putAll(var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> putAll(Multimap<? extends K, ? extends V> multimap) {
            void var1_1;
            super.putAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Builder<K, V> combine(ImmutableMultimap.Builder<K, V> other) {
            void var1_1;
            super.combine(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> orderKeysBy(Comparator<? super K> keyComparator) {
            void var1_1;
            super.orderKeysBy(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> orderValuesBy(Comparator<? super V> valueComparator) {
            void var1_1;
            super.orderValuesBy(var1_1);
            return this;
        }

        @Override
        public final ImmutableListMultimap<K, V> build() {
            return (ImmutableListMultimap)super.build();
        }
    }
}

