/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableCollection;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.RegularImmutableList;
import com.google.common.collect.SingletonImmutableList;
import com.google.common.collect.UnmodifiableIterator;
import com.google.common.collect.UnmodifiableListIterator;
import java.io.InvalidObjectException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.RandomAccess;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.UnaryOperator;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableList<E>
extends ImmutableCollection<E>
implements List<E>,
RandomAccess {
    public static <E> Collector<E, ?, ImmutableList<E>> toImmutableList() {
        return CollectCollectors.toImmutableList();
    }

    public static <E> ImmutableList<E> of() {
        return RegularImmutableList.EMPTY;
    }

    public static <E> ImmutableList<E> of(E element) {
        E e;
        return new SingletonImmutableList<E>(e);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2) {
        void var1_1;
        E e;
        return ImmutableList.construct(e, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3) {
        void var2_2;
        void var1_1;
        E e;
        return ImmutableList.construct(e, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableList.construct(e, var1_1, var2_2, var3_3);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableList.construct(e, var1_1, var2_2, var3_3, e5);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5, E e6) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableList.construct(e, var1_1, var2_2, var3_3, e5, e6);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableList.construct(e, var1_1, var2_2, var3_3, e5, e6, e7);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableList.construct(e, var1_1, var2_2, var3_3, e5, e6, e7, e8);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableList.construct(e, var1_1, var2_2, var3_3, e5, e6, e7, e8, e9);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableList.construct(e, var1_1, var2_2, var3_3, e5, e6, e7, e8, e9, e10);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        return ImmutableList.construct(e, var1_1, var2_2, var3_3, e5, e6, e7, e8, e9, e10, e11);
    }

    /*
     * WARNING - void declaration
     */
    @SafeVarargs
    public static <E> ImmutableList<E> of(E e1, E e2, E e3, E e4, E e5, E e6, E e7, E e8, E e9, E e10, E e11, E e12, E ... others) {
        void var3_3;
        void var2_2;
        void var1_1;
        E e;
        Preconditions.checkArgument(others.length <= 0x7FFFFFF3, "the total number of elements must fit in an int");
        Object[] objectArray = new Object[12 + others.length];
        Object[] array = objectArray;
        objectArray[0] = e;
        array[1] = var1_1;
        array[2] = var2_2;
        array[3] = var3_3;
        array[4] = e5;
        array[5] = e6;
        array[6] = e7;
        array[7] = e8;
        array[8] = e9;
        array[9] = e10;
        array[10] = e11;
        array[11] = e12;
        System.arraycopy(others, 0, array, 12, others.length);
        return ImmutableList.construct(array);
    }

    public static <E> ImmutableList<E> copyOf(Iterable<? extends E> elements) {
        Iterable<E> iterable;
        Preconditions.checkNotNull(elements);
        if (elements instanceof Collection) {
            return ImmutableList.copyOf((Collection)elements);
        }
        return ImmutableList.copyOf(iterable.iterator());
    }

    public static <E> ImmutableList<E> copyOf(Collection<? extends E> elements) {
        Collection<E> collection;
        if (elements instanceof ImmutableCollection) {
            Collection<E> list = ((ImmutableCollection)elements).asList();
            if (((ImmutableCollection)list).isPartialView()) {
                return ImmutableList.asImmutableList(((ImmutableCollection)list).toArray());
            }
            return collection;
        }
        return ImmutableList.construct(collection.toArray());
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> copyOf(Iterator<? extends E> elements) {
        Iterator<? extends E> iterator;
        void var1_1;
        if (!elements.hasNext()) {
            return ImmutableList.of();
        }
        E first = elements.next();
        if (!elements.hasNext()) {
            return ImmutableList.of(first);
        }
        return ((Builder)((Builder)new Builder().add((Object)var1_1)).addAll((Iterator)iterator)).build();
    }

    public static <E> ImmutableList<E> copyOf(E[] elements) {
        E[] EArray;
        switch (elements.length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(elements[0]);
            }
        }
        return ImmutableList.construct((Object[])EArray.clone());
    }

    public static <E extends Comparable<? super E>> ImmutableList<E> sortedCopyOf(Iterable<? extends E> elements) {
        Object[] objectArray;
        Object[] array = Iterables.toArray(elements, new Comparable[0]);
        ObjectArrays.checkElementsNotNull(array);
        Arrays.sort(array);
        return ImmutableList.asImmutableList(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    public static <E> ImmutableList<E> sortedCopyOf(Comparator<? super E> comparator, Iterable<? extends E> elements) {
        void var1_1;
        Comparator<? super E> comparator2;
        Preconditions.checkNotNull(comparator);
        Object[] array = Iterables.toArray(elements);
        ObjectArrays.checkElementsNotNull(array);
        Arrays.sort(array, comparator2);
        return ImmutableList.asImmutableList((Object[])var1_1);
    }

    private static <E> ImmutableList<E> construct(Object ... elements) {
        return ImmutableList.asImmutableList(ObjectArrays.checkElementsNotNull(elements));
    }

    static <E> ImmutableList<E> asImmutableList(Object[] elements) {
        return ImmutableList.asImmutableList(elements, elements.length);
    }

    /*
     * WARNING - void declaration
     */
    static <E> ImmutableList<E> asImmutableList(Object[] elements, int length) {
        Object[] objectArray;
        Object[] elementsWithoutTrailingNulls;
        void var1_1;
        switch (length) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                elements = Objects.requireNonNull(elements[0]);
                return ImmutableList.of(elements);
            }
        }
        elementsWithoutTrailingNulls = length < ((Object[])elements).length ? Arrays.copyOf(elements, (int)var1_1) : elementsWithoutTrailingNulls;
        return new RegularImmutableList(objectArray);
    }

    ImmutableList() {
    }

    @Override
    public UnmodifiableIterator<E> iterator() {
        return this.listIterator();
    }

    @Override
    public UnmodifiableListIterator<E> listIterator() {
        return this.listIterator(0);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public UnmodifiableListIterator<E> listIterator(int index) {
        void var1_1;
        ImmutableList immutableList = this;
        return new AbstractIndexedListIterator<E>(immutableList, immutableList.size(), (int)var1_1){
            final /* synthetic */ ImmutableList this$0;
            {
                void var3_3;
                void var2_2;
                void var1_1;
                this.this$0 = var1_1;
                super((int)var2_2, (int)var3_3);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            protected E get(int index) {
                void var1_1;
                return this.this$0.get((int)var1_1);
            }
        };
    }

    @Override
    public void forEach(Consumer<? super E> consumer) {
        Preconditions.checkNotNull(consumer);
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            consumer.accept(this.get(i));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(Object object) {
        void var1_1;
        if (object == null) {
            return -1;
        }
        return Lists.indexOfImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int lastIndexOf(Object object) {
        void var1_1;
        if (object == null) {
            return -1;
        }
        return Lists.lastIndexOfImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object object) {
        void var1_1;
        return this.indexOf(var1_1) >= 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ImmutableList<E> subList(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        void var3_3;
        Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
        int length = toIndex - fromIndex;
        if (length == this.size()) {
            return this;
        }
        if (length == 0) {
            return ImmutableList.of();
        }
        if (var3_3 == true) {
            return ImmutableList.of(this.get(fromIndex));
        }
        return this.subListUnchecked((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    ImmutableList<E> subListUnchecked(int fromIndex, int toIndex) {
        void var1_1;
        void var2_2;
        return new SubList(this, fromIndex, (int)(var2_2 - var1_1));
    }

    @Override
    @Deprecated
    public final boolean addAll(int index, Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E set(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void add(int index, E element) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final E remove(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void replaceAll(UnaryOperator<E> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void sort(Comparator<? super E> c) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final ImmutableList<E> asList() {
        return this;
    }

    @Override
    public Spliterator<E> spliterator() {
        return CollectSpliterators.indexed(this.size(), 1296, this::get);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    int copyIntoArray(Object[] dst, int offset) {
        void var3_3;
        void var2_2;
        int size = this.size();
        for (int i = 0; i < size; ++i) {
            dst[offset + i] = this.get(i);
        }
        return (int)(var2_2 + var3_3);
    }

    public ImmutableList<E> reverse() {
        if (this.size() <= 1) {
            return this;
        }
        return new ReverseImmutableList(this);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object obj) {
        void var1_1;
        return Lists.equalsImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int hashCode() {
        void var1_1;
        int hashCode = 1;
        int n = this.size();
        for (int i = 0; i < n; ++i) {
            hashCode = hashCode * 31 + this.get(i).hashCode();
            hashCode = ~(~hashCode);
        }
        return (int)var1_1;
    }

    private void readObject(ObjectInputStream stream) throws InvalidObjectException {
        throw new InvalidObjectException("Use SerializedForm");
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this.toArray());
    }

    public static <E> Builder<E> builder() {
        return new Builder();
    }

    @Beta
    public static <E> Builder<E> builderWithExpectedSize(int expectedSize) {
        int n;
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        return new Builder(n);
    }

    public static final class Builder<E>
    extends ImmutableCollection.Builder<E> {
        @VisibleForTesting
        Object[] contents;
        private int size;
        private boolean forceCopy;

        public Builder() {
            this(4);
        }

        /*
         * WARNING - void declaration
         */
        Builder(int capacity) {
            void var1_1;
            this.contents = new Object[var1_1];
            this.size = 0;
        }

        /*
         * WARNING - void declaration
         */
        private void getReadyToExpandTo(int minCapacity) {
            if (this.contents.length < minCapacity) {
                void var1_1;
                this.contents = Arrays.copyOf(this.contents, Builder.expandedCapacity(this.contents.length, (int)var1_1));
                this.forceCopy = false;
                return;
            }
            if (this.forceCopy) {
                this.contents = Arrays.copyOf(this.contents, this.contents.length);
                this.forceCopy = false;
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> add(E element) {
            void var1_1;
            Preconditions.checkNotNull(element);
            Builder builder = this;
            builder.getReadyToExpandTo(builder.size + 1);
            this.contents[this.size++] = var1_1;
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> add(E ... elements) {
            void var1_1;
            ObjectArrays.checkElementsNotNull((Object[])elements);
            void v0 = var1_1;
            this.add((Object[])v0, ((void)v0).length);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private void add(Object[] elements, int n) {
            void var2_2;
            void var1_1;
            Builder builder = this;
            builder.getReadyToExpandTo(builder.size + n);
            System.arraycopy(var1_1, 0, this.contents, this.size, n);
            this.size += var2_2;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> addAll(Iterable<? extends E> elements) {
            void var1_1;
            Preconditions.checkNotNull(elements);
            if (elements instanceof Collection) {
                Collection collection = (Collection)elements;
                Builder builder = this;
                builder.getReadyToExpandTo(builder.size + collection.size());
                if (collection instanceof ImmutableCollection) {
                    void var2_2;
                    ImmutableCollection immutableCollection = (ImmutableCollection)var2_2;
                    this.size = var1_1.copyIntoArray(this.contents, this.size);
                    return this;
                }
            }
            super.addAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<E> addAll(Iterator<? extends E> elements) {
            void var1_1;
            super.addAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        final Builder<E> combine(Builder<E> builder) {
            void var1_1;
            Preconditions.checkNotNull(builder);
            this.add(builder.contents, var1_1.size);
            return this;
        }

        @Override
        public final ImmutableList<E> build() {
            this.forceCopy = true;
            return ImmutableList.asImmutableList(this.contents, this.size);
        }
    }

    static class SerializedForm
    implements Serializable {
        final Object[] elements;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SerializedForm(Object[] elements) {
            void var1_1;
            this.elements = var1_1;
        }

        Object readResolve() {
            return ImmutableList.copyOf(this.elements);
        }
    }

    private static class ReverseImmutableList<E>
    extends ImmutableList<E> {
        private final transient ImmutableList<E> forwardList;

        /*
         * WARNING - void declaration
         */
        ReverseImmutableList(ImmutableList<E> backingList) {
            void var1_1;
            this.forwardList = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private int reverseIndex(int index) {
            void var1_1;
            return this.size() - 1 - var1_1;
        }

        /*
         * WARNING - void declaration
         */
        private int reversePosition(int index) {
            void var1_1;
            return this.size() - var1_1;
        }

        @Override
        public ImmutableList<E> reverse() {
            return this.forwardList;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public boolean contains(Object object) {
            void var1_1;
            return ((ImmutableCollection)this.forwardList).contains(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int indexOf(Object object) {
            int index = this.forwardList.lastIndexOf(object);
            if (index >= 0) {
                void var1_2;
                return this.reverseIndex((int)var1_2);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public int lastIndexOf(Object object) {
            int index = this.forwardList.indexOf(object);
            if (index >= 0) {
                void var1_2;
                return this.reverseIndex((int)var1_2);
            }
            return -1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            void var1_1;
            void var2_2;
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.size());
            return ((ImmutableList)this.forwardList.subList(this.reversePosition((int)var2_2), this.reversePosition((int)var1_1))).reverse();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.size());
            return this.forwardList.get(this.reverseIndex((int)var1_1));
        }

        @Override
        public int size() {
            return this.forwardList.size();
        }

        @Override
        boolean isPartialView() {
            return this.forwardList.isPartialView();
        }
    }

    class SubList
    extends ImmutableList<E> {
        final transient int offset;
        final transient int length;
        final /* synthetic */ ImmutableList this$0;

        /*
         * WARNING - void declaration
         */
        SubList(ImmutableList this$0, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.this$0 = var1_1;
            this.offset = var2_2;
            this.length = var3_3;
        }

        @Override
        public int size() {
            return this.length;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public E get(int index) {
            void var1_1;
            Preconditions.checkElementIndex(index, this.length);
            return this.this$0.get((int)(var1_1 + this.offset));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public ImmutableList<E> subList(int fromIndex, int toIndex) {
            void var2_2;
            void var1_1;
            Preconditions.checkPositionIndexes(fromIndex, toIndex, this.length);
            return this.this$0.subList((int)(var1_1 + this.offset), (int)(var2_2 + this.offset));
        }

        @Override
        boolean isPartialView() {
            return true;
        }
    }
}

