/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.Collection;
import java.util.EnumSet;
import java.util.Spliterator;
import java.util.function.Consumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class ImmutableEnumSet<E extends Enum<E>>
extends ImmutableSet<E> {
    private final transient EnumSet<E> delegate;
    private transient int hashCode;

    static ImmutableSet asImmutable(EnumSet set) {
        EnumSet enumSet;
        switch (set.size()) {
            case 0: {
                return ImmutableSet.of();
            }
            case 1: {
                return ImmutableSet.of(Iterables.getOnlyElement(set));
            }
        }
        return new ImmutableEnumSet(enumSet);
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableEnumSet(EnumSet<E> delegate) {
        void var1_1;
        this.delegate = var1_1;
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    public final UnmodifiableIterator<E> iterator() {
        return Iterators.unmodifiableIterator(this.delegate.iterator());
    }

    @Override
    public final Spliterator<E> spliterator() {
        return this.delegate.spliterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void forEach(Consumer<? super E> action) {
        void var1_1;
        this.delegate.forEach(var1_1);
    }

    @Override
    public final int size() {
        return this.delegate.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object object) {
        void var1_1;
        return this.delegate.contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsAll(Collection<?> collection) {
        void var1_1;
        if (collection instanceof ImmutableEnumSet) {
            collection = ((ImmutableEnumSet)collection).delegate;
        }
        return this.delegate.containsAll((Collection<?>)var1_1);
    }

    @Override
    public final boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        void var1_1;
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableEnumSet) {
            object = ((ImmutableEnumSet)((Object)object)).delegate;
        }
        return this.delegate.equals(var1_1);
    }

    @Override
    final boolean isHashCodeFast() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final int hashCode() {
        void var1_1;
        int result = this.hashCode;
        if (result == 0) {
            this.hashCode = this.delegate.hashCode();
            return this.hashCode;
        }
        return (int)var1_1;
    }

    @Override
    public final String toString() {
        return this.delegate.toString();
    }

    @Override
    final Object writeReplace() {
        return new EnumSerializedForm<E>(this.delegate);
    }

    private static class EnumSerializedForm<E extends Enum<E>>
    implements Serializable {
        final EnumSet<E> delegate;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        EnumSerializedForm(EnumSet<E> delegate) {
            void var1_1;
            this.delegate = var1_1;
        }

        Object readResolve() {
            return new ImmutableEnumSet((EnumSet)this.delegate.clone());
        }
    }
}

