/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.CollectSpliterators;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.EnumMap;
import java.util.Map;
import java.util.Spliterator;
import java.util.function.BiConsumer;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
final class ImmutableEnumMap<K extends Enum<K>, V>
extends ImmutableMap.IteratorBasedImmutableMap<K, V> {
    private final transient EnumMap<K, V> delegate;

    static <K extends Enum<K>, V> ImmutableMap<K, V> asImmutable(EnumMap<K, V> map) {
        Map.Entry<K, V> entry;
        switch (map.size()) {
            case 0: {
                return ImmutableMap.of();
            }
            case 1: {
                Map.Entry<K, V> entry2 = Iterables.getOnlyElement(map.entrySet());
                return ImmutableMap.of((Enum)entry2.getKey(), entry.getValue());
            }
        }
        return new ImmutableEnumMap<K, V>(entry);
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableEnumMap(EnumMap<K, V> delegate) {
        void var1_1;
        this.delegate = delegate;
        Preconditions.checkArgument(!var1_1.isEmpty());
    }

    @Override
    final UnmodifiableIterator<K> keyIterator() {
        return Iterators.unmodifiableIterator(this.delegate.keySet().iterator());
    }

    @Override
    final Spliterator<K> keySpliterator() {
        return this.delegate.keySet().spliterator();
    }

    @Override
    public final int size() {
        return this.delegate.size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsKey(Object key) {
        void var1_1;
        return this.delegate.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object key) {
        void var1_1;
        return this.delegate.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean equals(Object object) {
        void var1_1;
        if (object == this) {
            return true;
        }
        if (object instanceof ImmutableEnumMap) {
            object = ((ImmutableEnumMap)((Object)object)).delegate;
        }
        return this.delegate.equals(var1_1);
    }

    @Override
    final UnmodifiableIterator<Map.Entry<K, V>> entryIterator() {
        return Maps.unmodifiableEntryIterator(this.delegate.entrySet().iterator());
    }

    @Override
    final Spliterator<Map.Entry<K, V>> entrySpliterator() {
        return CollectSpliterators.map(this.delegate.entrySet().spliterator(), Maps::unmodifiableEntry);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final void forEach(BiConsumer<? super K, ? super V> action) {
        void var1_1;
        this.delegate.forEach((BiConsumer<K, V>)var1_1);
    }

    @Override
    final boolean isPartialView() {
        return false;
    }

    @Override
    final Object writeReplace() {
        return new EnumSerializedForm<K, V>(this.delegate);
    }

    private static class EnumSerializedForm<K extends Enum<K>, V>
    implements Serializable {
        final EnumMap<K, V> delegate;
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        EnumSerializedForm(EnumMap<K, V> delegate) {
            void var1_1;
            this.delegate = var1_1;
        }

        Object readResolve() {
            return new ImmutableEnumMap(this.delegate);
        }
    }
}

