/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.Platform;
import com.google.common.collect.RegularImmutableAsList;
import com.google.common.collect.UnmodifiableIterator;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class ImmutableCollection<E>
extends AbstractCollection<E>
implements Serializable {
    static final int SPLITERATOR_CHARACTERISTICS = 1296;
    private static final Object[] EMPTY_ARRAY = new Object[0];

    ImmutableCollection() {
    }

    @Override
    public abstract UnmodifiableIterator<E> iterator();

    @Override
    public Spliterator<E> spliterator() {
        return Spliterators.spliterator(this, 1296);
    }

    @Override
    public final Object[] toArray() {
        return this.toArray(EMPTY_ARRAY);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T> T[] toArray(T[] other) {
        void var1_1;
        Preconditions.checkNotNull(other);
        int size = this.size();
        if (other.length < size) {
            Object[] internal = this.internalArray();
            if (internal != null) {
                void var3_3;
                return Platform.copy((Object[])var3_3, this.internalArrayStart(), this.internalArrayEnd(), other);
            }
            other = ObjectArrays.newArray(other, size);
        } else if (other.length > size) {
            other[var2_2] = null;
        }
        this.copyIntoArray(other, 0);
        return var1_1;
    }

    Object[] internalArray() {
        return null;
    }

    int internalArrayStart() {
        throw new UnsupportedOperationException();
    }

    int internalArrayEnd() {
        throw new UnsupportedOperationException();
    }

    @Override
    public abstract boolean contains(Object var1);

    @Override
    @Deprecated
    public final boolean add(E e) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean addAll(Collection<? extends E> newElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeAll(Collection<?> oldElements) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean removeIf(Predicate<? super E> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final boolean retainAll(Collection<?> elementsToKeep) {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public final void clear() {
        throw new UnsupportedOperationException();
    }

    public ImmutableList<E> asList() {
        switch (this.size()) {
            case 0: {
                return ImmutableList.of();
            }
            case 1: {
                return ImmutableList.of(this.iterator().next());
            }
        }
        ImmutableCollection immutableCollection = this;
        return new RegularImmutableAsList(immutableCollection, immutableCollection.toArray());
    }

    abstract boolean isPartialView();

    /*
     * WARNING - void declaration
     */
    int copyIntoArray(Object[] dst, int offset) {
        void var2_2;
        for (Object e : this) {
            dst[offset++] = e;
        }
        return (int)var2_2;
    }

    Object writeReplace() {
        return new ImmutableList.SerializedForm(this.toArray());
    }

    public static abstract class Builder<E> {
        static final int DEFAULT_INITIAL_CAPACITY = 4;

        /*
         * WARNING - void declaration
         */
        static int expandedCapacity(int oldCapacity, int minCapacity) {
            int n;
            if (minCapacity < 0) {
                throw new AssertionError((Object)"cannot store more than MAX_VALUE elements");
            }
            int n2 = oldCapacity;
            int newCapacity = n2 + (n2 >> 1) + 1;
            if (newCapacity < minCapacity) {
                void var1_1;
                newCapacity = Integer.highestOneBit((int)(var1_1 - true)) << 1;
            }
            if (newCapacity < 0) {
                newCapacity = Integer.MAX_VALUE;
            }
            return n;
        }

        Builder() {
        }

        public abstract Builder<E> add(E var1);

        public Builder<E> add(E ... elements) {
            E[] EArray = elements;
            int n = elements.length;
            for (int i = 0; i < n; ++i) {
                E element = EArray[i];
                this.add(element);
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public Builder<E> addAll(Iterable<? extends E> elements) {
            for (E element : elements) {
                void var2_2;
                this.add((E)var2_2);
            }
            return this;
        }

        public Builder<E> addAll(Iterator<? extends E> elements) {
            while (elements.hasNext()) {
                this.add(elements.next());
            }
            return this;
        }

        public abstract ImmutableCollection<E> build();
    }
}

