/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ClassToInstanceMap;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.ImmutableMap;
import com.google.common.primitives.Primitives;
import java.io.Serializable;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public final class ImmutableClassToInstanceMap<B>
extends ForwardingMap<Class<? extends B>, B>
implements ClassToInstanceMap<B>,
Serializable {
    private static final ImmutableClassToInstanceMap<Object> EMPTY = new ImmutableClassToInstanceMap(ImmutableMap.of());
    private final ImmutableMap<Class<? extends B>, B> delegate;

    public static <B> ImmutableClassToInstanceMap<B> of() {
        return EMPTY;
    }

    /*
     * WARNING - void declaration
     */
    public static <B, T extends B> ImmutableClassToInstanceMap<B> of(Class<T> type, T value) {
        Serializable serializable;
        void var1_1;
        Serializable map = ImmutableMap.of(type, var1_1);
        return new ImmutableClassToInstanceMap<B>(serializable);
    }

    public static <B> Builder<B> builder() {
        return new Builder();
    }

    public static <B, S extends B> ImmutableClassToInstanceMap<B> copyOf(Map<? extends Class<? extends S>, ? extends S> map) {
        Map<? extends Class<? extends S>, ? extends S> map2;
        if (map instanceof ImmutableClassToInstanceMap) {
            map = map;
            return map;
        }
        return new Builder().putAll(map2).build();
    }

    /*
     * WARNING - void declaration
     */
    private ImmutableClassToInstanceMap(ImmutableMap<Class<? extends B>, B> delegate) {
        void var1_1;
        this.delegate = var1_1;
    }

    @Override
    protected final Map<Class<? extends B>, B> delegate() {
        return this.delegate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final <T extends B> T getInstance(Class<T> type) {
        void var1_1;
        return (T)this.delegate.get(Preconditions.checkNotNull(var1_1));
    }

    @Override
    @Deprecated
    public final <T extends B> T putInstance(Class<T> type, T value) {
        throw new UnsupportedOperationException();
    }

    final Object readResolve() {
        if (this.isEmpty()) {
            return ImmutableClassToInstanceMap.of();
        }
        return this;
    }

    public static final class Builder<B> {
        private final ImmutableMap.Builder<Class<? extends B>, B> mapBuilder = ImmutableMap.builder();

        /*
         * WARNING - void declaration
         */
        public final <T extends B> Builder<B> put(Class<T> key, T value) {
            void var2_2;
            void var1_1;
            this.mapBuilder.put((Class<B>)var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        public final <T extends B> Builder<B> putAll(Map<? extends Class<? extends T>, ? extends T> map) {
            for (Map.Entry<Class<T>, T> entry : map.entrySet()) {
                void var2_2;
                void var3_3;
                Class<? extends T> type = entry.getKey();
                T value = entry.getValue();
                void v0 = var3_3;
                this.mapBuilder.put((Class<B>)v0, (B)Builder.cast(v0, var2_2));
            }
            return this;
        }

        /*
         * WARNING - void declaration
         */
        private static <B, T extends B> T cast(Class<T> type, B value) {
            void var1_1;
            return Primitives.wrap(type).cast(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public final ImmutableClassToInstanceMap<B> build() {
            void var1_1;
            ImmutableMap<Class<B>, B> map = this.mapBuilder.buildOrThrow();
            if (map.isEmpty()) {
                return ImmutableClassToInstanceMap.of();
            }
            return new ImmutableClassToInstanceMap((ImmutableMap)var1_1);
        }
    }
}

