/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.CollectCollectors;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableBiMapFauxverideShim;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Ordering;
import com.google.common.collect.RegularImmutableBiMap;
import com.google.common.collect.SingletonImmutableBiMap;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collector;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public abstract class ImmutableBiMap<K, V>
extends ImmutableBiMapFauxverideShim<K, V>
implements BiMap<K, V> {
    /*
     * WARNING - void declaration
     */
    public static <T, K, V> Collector<T, ?, ImmutableBiMap<K, V>> toImmutableBiMap(Function<? super T, ? extends K> keyFunction, Function<? super T, ? extends V> valueFunction) {
        void var1_1;
        return CollectCollectors.toImmutableBiMap(keyFunction, var1_1);
    }

    public static <K, V> ImmutableBiMap<K, V> of() {
        return RegularImmutableBiMap.EMPTY;
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1) {
        void var1_1;
        K k;
        return new SingletonImmutableBiMap<K, void>(k, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k, var1_1), ImmutableBiMap.entryOf(var2_2, var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k, var1_1), ImmutableBiMap.entryOf(var2_2, var3_3), ImmutableBiMap.entryOf(k3, v3));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k, var1_1), ImmutableBiMap.entryOf(var2_2, var3_3), ImmutableBiMap.entryOf(k3, v3), ImmutableBiMap.entryOf(k4, v4));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k, var1_1), ImmutableBiMap.entryOf(var2_2, var3_3), ImmutableBiMap.entryOf(k3, v3), ImmutableBiMap.entryOf(k4, v4), ImmutableBiMap.entryOf(k5, v5));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k, var1_1), ImmutableBiMap.entryOf(var2_2, var3_3), ImmutableBiMap.entryOf(k3, v3), ImmutableBiMap.entryOf(k4, v4), ImmutableBiMap.entryOf(k5, v5), ImmutableBiMap.entryOf(k6, v6));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k, var1_1), ImmutableBiMap.entryOf(var2_2, var3_3), ImmutableBiMap.entryOf(k3, v3), ImmutableBiMap.entryOf(k4, v4), ImmutableBiMap.entryOf(k5, v5), ImmutableBiMap.entryOf(k6, v6), ImmutableBiMap.entryOf(k7, v7));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k, var1_1), ImmutableBiMap.entryOf(var2_2, var3_3), ImmutableBiMap.entryOf(k3, v3), ImmutableBiMap.entryOf(k4, v4), ImmutableBiMap.entryOf(k5, v5), ImmutableBiMap.entryOf(k6, v6), ImmutableBiMap.entryOf(k7, v7), ImmutableBiMap.entryOf(k8, v8));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k, var1_1), ImmutableBiMap.entryOf(var2_2, var3_3), ImmutableBiMap.entryOf(k3, v3), ImmutableBiMap.entryOf(k4, v4), ImmutableBiMap.entryOf(k5, v5), ImmutableBiMap.entryOf(k6, v6), ImmutableBiMap.entryOf(k7, v7), ImmutableBiMap.entryOf(k8, v8), ImmutableBiMap.entryOf(k9, v9));
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> of(K k1, V v1, K k2, V v2, K k3, V v3, K k4, V v4, K k5, V v5, K k6, V v6, K k7, V v7, K k8, V v8, K k9, V v9, K k10, V v10) {
        void var3_3;
        void var2_2;
        void var1_1;
        K k;
        return RegularImmutableBiMap.fromEntries(ImmutableBiMap.entryOf(k, var1_1), ImmutableBiMap.entryOf(var2_2, var3_3), ImmutableBiMap.entryOf(k3, v3), ImmutableBiMap.entryOf(k4, v4), ImmutableBiMap.entryOf(k5, v5), ImmutableBiMap.entryOf(k6, v6), ImmutableBiMap.entryOf(k7, v7), ImmutableBiMap.entryOf(k8, v8), ImmutableBiMap.entryOf(k9, v9), ImmutableBiMap.entryOf(k10, v10));
    }

    @SafeVarargs
    public static <K, V> ImmutableBiMap<K, V> ofEntries(Map.Entry<? extends K, ? extends V> ... entries) {
        Map.Entry<? extends K, ? extends V>[] entryArray = entries;
        return RegularImmutableBiMap.fromEntries(entries);
    }

    public static <K, V> Builder<K, V> builder() {
        return new Builder();
    }

    @Beta
    public static <K, V> Builder<K, V> builderWithExpectedSize(int expectedSize) {
        int n;
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        return new Builder(n);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> ImmutableBiMap<K, V> copyOf(Map<? extends K, ? extends V> map) {
        Map<K, V> map2;
        ImmutableBiMap bimap;
        if (map instanceof ImmutableBiMap && !(bimap = (ImmutableBiMap)map).isPartialView()) {
            void var1_1;
            return var1_1;
        }
        return ImmutableBiMap.copyOf(map2.entrySet());
    }

    @Beta
    public static <K, V> ImmutableBiMap<K, V> copyOf(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
        Map.Entry[] entryArray;
        Map.Entry[] entryArray2 = Iterables.toArray(entries, EMPTY_ENTRY_ARRAY);
        switch (entryArray2.length) {
            case 0: {
                return ImmutableBiMap.of();
            }
            case 1: {
                Map.Entry[] entry = entryArray2[0];
                return ImmutableBiMap.of(entry.getKey(), entryArray.getValue());
            }
        }
        return RegularImmutableBiMap.fromEntries(entryArray);
    }

    ImmutableBiMap() {
    }

    @Override
    public abstract ImmutableBiMap<V, K> inverse();

    @Override
    public ImmutableSet<V> values() {
        return ((ImmutableMap)((Object)this.inverse())).keySet();
    }

    @Override
    final ImmutableSet<V> createValues() {
        throw new AssertionError((Object)"should never be called");
    }

    @Override
    @Deprecated
    public final V forcePut(K key, V value) {
        throw new UnsupportedOperationException();
    }

    @Override
    Object writeReplace() {
        return new SerializedForm(this);
    }

    private static class SerializedForm<K, V>
    extends ImmutableMap.SerializedForm<K, V> {
        private static final long serialVersionUID = 0L;

        /*
         * WARNING - void declaration
         */
        SerializedForm(ImmutableBiMap<K, V> bimap) {
            super(var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        Builder<K, V> makeBuilder(int size) {
            void var1_1;
            return new Builder((int)var1_1);
        }
    }

    public static final class Builder<K, V>
    extends ImmutableMap.Builder<K, V> {
        public Builder() {
        }

        /*
         * WARNING - void declaration
         */
        Builder(int size) {
            super((int)var1_1);
            void var1_1;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> put(K key, V value) {
            void var2_2;
            void var1_1;
            super.put(var1_1, var2_2);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> put(Map.Entry<? extends K, ? extends V> entry) {
            void var1_1;
            super.put(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final Builder<K, V> putAll(Map<? extends K, ? extends V> map) {
            void var1_1;
            super.putAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Beta
        public final Builder<K, V> putAll(Iterable<? extends Map.Entry<? extends K, ? extends V>> entries) {
            void var1_1;
            super.putAll(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @Beta
        public final Builder<K, V> orderEntriesByValue(Comparator<? super V> valueComparator) {
            void var1_1;
            super.orderEntriesByValue(var1_1);
            return this;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        final Builder<K, V> combine(ImmutableMap.Builder<K, V> builder) {
            void var1_1;
            super.combine(var1_1);
            return this;
        }

        @Override
        public final ImmutableBiMap<K, V> build() {
            return this.buildOrThrow();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final ImmutableBiMap<K, V> buildOrThrow() {
            switch (this.size) {
                case 0: {
                    return ImmutableBiMap.of();
                }
                case 1: {
                    void var1_1;
                    Map.Entry onlyEntry = Objects.requireNonNull(this.entries[0]);
                    return ImmutableBiMap.of(onlyEntry.getKey(), var1_1.getValue());
                }
            }
            if (this.valueComparator != null) {
                if (this.entriesUsed) {
                    this.entries = Arrays.copyOf(this.entries, this.size);
                }
                Arrays.sort(this.entries, 0, this.size, Ordering.from(this.valueComparator).onResultOf(Maps.valueFunction()));
            }
            this.entriesUsed = true;
            return RegularImmutableBiMap.fromEntryArray(this.size, this.entries);
        }

        @Override
        @Deprecated
        public final ImmutableBiMap<K, V> buildKeepingLast() {
            throw new UnsupportedOperationException("Not supported for bimaps");
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @VisibleForTesting
        final ImmutableBiMap<K, V> buildJdkBacked() {
            Preconditions.checkState(this.valueComparator == null, "buildJdkBacked is for tests only, doesn't support orderEntriesByValue");
            switch (this.size) {
                case 0: {
                    return ImmutableBiMap.of();
                }
                case 1: {
                    void var1_1;
                    Map.Entry onlyEntry = Objects.requireNonNull(this.entries[0]);
                    return ImmutableBiMap.of(onlyEntry.getKey(), var1_1.getValue());
                }
            }
            this.entriesUsed = true;
            return RegularImmutableBiMap.fromEntryArray(this.size, this.entries);
        }
    }
}

