/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.HashMultimapGwtSerializationDependencies;
import com.google.common.collect.Multimap;
import com.google.common.collect.Platform;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true, emulated=true)
public final class HashMultimap<K, V>
extends HashMultimapGwtSerializationDependencies<K, V> {
    private static final int DEFAULT_VALUES_PER_KEY = 2;
    @VisibleForTesting
    transient int expectedValuesPerKey = 2;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <K, V> HashMultimap<K, V> create() {
        return new HashMultimap<K, V>();
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> HashMultimap<K, V> create(int expectedKeys, int expectedValuesPerKey) {
        void var1_1;
        int n;
        return new HashMultimap<K, V>(n, (int)var1_1);
    }

    public static <K, V> HashMultimap<K, V> create(Multimap<? extends K, ? extends V> multimap) {
        Multimap<? extends K, ? extends V> multimap2;
        return new HashMultimap<K, V>(multimap2);
    }

    private HashMultimap() {
        this(12, 2);
    }

    /*
     * WARNING - void declaration
     */
    private HashMultimap(int expectedKeys, int expectedValuesPerKey) {
        super(Platform.newHashMapWithExpectedSize((int)var1_1));
        void var2_2;
        void var1_1;
        Preconditions.checkArgument(expectedValuesPerKey >= 0);
        this.expectedValuesPerKey = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private HashMultimap(Multimap<? extends K, ? extends V> multimap) {
        super(Platform.newHashMapWithExpectedSize(multimap.keySet().size()));
        void var1_1;
        this.putAll((Multimap)var1_1);
    }

    @Override
    final Set<V> createCollection() {
        return Platform.newHashSetWithExpectedSize(this.expectedValuesPerKey);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        Serialization.writeMultimap(this, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var2_2;
        void var1_1;
        void var3_3;
        stream.defaultReadObject();
        this.expectedValuesPerKey = 2;
        int distinctKeys = Serialization.readCount(stream);
        Map map = Platform.newHashMapWithExpectedSize(12);
        this.setMap(var3_3);
        Serialization.populateMultimap(this, (ObjectInputStream)var1_1, (int)var2_2);
    }
}

