/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.AbstractMapEntry;
import com.google.common.collect.BiMap;
import com.google.common.collect.CollectPreconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.Hashing;
import com.google.common.collect.ImmutableEntry;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Serialization;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Arrays;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public final class HashBiMap<K, V>
extends Maps.IteratorBasedAbstractMap<K, V>
implements BiMap<K, V>,
Serializable {
    private static final double LOAD_FACTOR = 1.0;
    private transient BiEntry<K, V>[] hashTableKToV;
    private transient BiEntry<K, V>[] hashTableVToK;
    private transient BiEntry<K, V> firstInKeyInsertionOrder;
    private transient BiEntry<K, V> lastInKeyInsertionOrder;
    private transient int size;
    private transient int mask;
    private transient int modCount;
    private transient BiMap<V, K> inverse;
    @GwtIncompatible
    private static final long serialVersionUID = 0L;

    public static <K, V> HashBiMap<K, V> create() {
        return HashBiMap.create(16);
    }

    public static <K, V> HashBiMap<K, V> create(int expectedSize) {
        int n;
        return new HashBiMap<K, V>(n);
    }

    /*
     * WARNING - void declaration
     */
    public static <K, V> HashBiMap<K, V> create(Map<? extends K, ? extends V> map) {
        void var1_1;
        Map<? extends K, ? extends V> map2;
        HashBiMap<? extends K, ? extends V> bimap = HashBiMap.create(map.size());
        bimap.putAll(map2);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private HashBiMap(int expectedSize) {
        void var1_1;
        this.init((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private void init(int expectedSize) {
        void var1_1;
        CollectPreconditions.checkNonnegative(expectedSize, "expectedSize");
        int tableSize = Hashing.closedTableSize(expectedSize, 1.0);
        this.hashTableKToV = this.createTable(tableSize);
        this.hashTableVToK = this.createTable(tableSize);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        this.size = 0;
        this.mask = var1_1 - true;
        this.modCount = 0;
    }

    /*
     * WARNING - void declaration
     */
    private void delete(BiEntry<K, V> entry) {
        int keyBucket = entry.keyHash & this.mask;
        BiEntry<K, V> prevBucketEntry = null;
        BiEntry<K, V> bucketEntry = this.hashTableKToV[keyBucket];
        while (true) {
            if (bucketEntry == entry) {
                if (prevBucketEntry == null) {
                    this.hashTableKToV[keyBucket] = entry.nextInKToVBucket;
                    break;
                }
                prevBucketEntry.nextInKToVBucket = entry.nextInKToVBucket;
                break;
            }
            prevBucketEntry = bucketEntry;
            bucketEntry = bucketEntry.nextInKToVBucket;
        }
        int valueBucket = entry.valueHash & this.mask;
        prevBucketEntry = null;
        BiEntry<K, V> bucketEntry2 = this.hashTableVToK[valueBucket];
        while (true) {
            if (bucketEntry2 == entry) {
                if (prevBucketEntry == null) {
                    this.hashTableVToK[valueBucket] = entry.nextInVToKBucket;
                    break;
                }
                prevBucketEntry.nextInVToKBucket = entry.nextInVToKBucket;
                break;
            }
            prevBucketEntry = bucketEntry2;
            bucketEntry2 = bucketEntry2.nextInVToKBucket;
        }
        if (entry.prevInKeyInsertionOrder == null) {
            this.firstInKeyInsertionOrder = entry.nextInKeyInsertionOrder;
        } else {
            entry.prevInKeyInsertionOrder.nextInKeyInsertionOrder = entry.nextInKeyInsertionOrder;
        }
        if (entry.nextInKeyInsertionOrder == null) {
            this.lastInKeyInsertionOrder = entry.prevInKeyInsertionOrder;
        } else {
            void var1_1;
            entry.nextInKeyInsertionOrder.prevInKeyInsertionOrder = var1_1.prevInKeyInsertionOrder;
        }
        --this.size;
        ++this.modCount;
    }

    /*
     * WARNING - void declaration
     */
    private void insert(BiEntry<K, V> entry, BiEntry<K, V> oldEntryForKey) {
        int keyBucket = entry.keyHash & this.mask;
        entry.nextInKToVBucket = this.hashTableKToV[keyBucket];
        this.hashTableKToV[keyBucket] = entry;
        int valueBucket = entry.valueHash & this.mask;
        entry.nextInVToKBucket = this.hashTableVToK[valueBucket];
        this.hashTableVToK[var3_3] = entry;
        if (oldEntryForKey == null) {
            entry.prevInKeyInsertionOrder = this.lastInKeyInsertionOrder;
            entry.nextInKeyInsertionOrder = null;
            if (this.lastInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = entry;
            } else {
                this.lastInKeyInsertionOrder.nextInKeyInsertionOrder = entry;
            }
            this.lastInKeyInsertionOrder = entry;
        } else {
            void var2_2;
            entry.prevInKeyInsertionOrder = oldEntryForKey.prevInKeyInsertionOrder;
            if (entry.prevInKeyInsertionOrder == null) {
                this.firstInKeyInsertionOrder = entry;
            } else {
                entry.prevInKeyInsertionOrder.nextInKeyInsertionOrder = entry;
            }
            entry.nextInKeyInsertionOrder = var2_2.nextInKeyInsertionOrder;
            if (entry.nextInKeyInsertionOrder == null) {
                this.lastInKeyInsertionOrder = entry;
            } else {
                void var1_1;
                entry.nextInKeyInsertionOrder.prevInKeyInsertionOrder = var1_1;
            }
        }
        ++this.size;
        ++this.modCount;
    }

    private BiEntry<K, V> seekByKey(Object key, int keyHash) {
        BiEntry<K, V> entry = this.hashTableKToV[keyHash & this.mask];
        while (entry != null) {
            if (keyHash == entry.keyHash && com.google.common.base.Objects.equal(key, entry.key)) {
                return entry;
            }
            entry = entry.nextInKToVBucket;
        }
        return null;
    }

    private BiEntry<K, V> seekByValue(Object value, int valueHash) {
        BiEntry<K, V> entry = this.hashTableVToK[valueHash & this.mask];
        while (entry != null) {
            if (valueHash == entry.valueHash && com.google.common.base.Objects.equal(value, entry.value)) {
                return entry;
            }
            entry = entry.nextInVToKBucket;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsKey(Object key) {
        void var1_1;
        void v0 = var1_1;
        return this.seekByKey(v0, Hashing.smearedHash(v0)) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean containsValue(Object value) {
        void var1_1;
        void v0 = var1_1;
        return this.seekByValue(v0, Hashing.smearedHash(v0)) != null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V get(Object key) {
        void var1_1;
        void v0 = var1_1;
        return Maps.valueOrNull(this.seekByKey(v0, Hashing.smearedHash(v0)));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V put(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        return this.put(var1_1, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    private V put(@ParametricNullness K key, @ParametricNullness V value, boolean force) {
        void var1_1;
        void var2_2;
        int keyHash = Hashing.smearedHash(key);
        int valueHash = Hashing.smearedHash(value);
        BiEntry<K, V> oldEntryForKey = this.seekByKey(key, keyHash);
        if (oldEntryForKey != null && valueHash == oldEntryForKey.valueHash && com.google.common.base.Objects.equal(value, oldEntryForKey.value)) {
            return value;
        }
        BiEntry<K, V> oldEntryForValue = this.seekByValue(value, valueHash);
        if (oldEntryForValue != null) {
            void var3_3;
            if (var3_3 != false) {
                this.delete(oldEntryForValue);
            } else {
                key = String.valueOf(value);
                throw new IllegalArgumentException(new StringBuilder(23 + String.valueOf(key).length()).append("value already present: ").append((String)key).toString());
            }
        }
        BiEntry<K, void> newEntry = new BiEntry<K, void>(key, keyHash, var2_2, valueHash);
        if (oldEntryForKey != null) {
            this.delete(oldEntryForKey);
            this.insert(newEntry, oldEntryForKey);
            oldEntryForKey.prevInKeyInsertionOrder = null;
            oldEntryForKey.nextInKeyInsertionOrder = null;
            return oldEntryForKey.value;
        }
        this.insert((BiEntry<K, V>)var1_1, null);
        this.rehashIfNecessary();
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V forcePut(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        return this.put(var1_1, var2_2, true);
    }

    /*
     * WARNING - void declaration
     */
    private K putInverse(@ParametricNullness V value, @ParametricNullness K key, boolean force) {
        void var1_1;
        void var2_2;
        void var3_3;
        int valueHash = Hashing.smearedHash(value);
        int keyHash = Hashing.smearedHash(key);
        BiEntry<K, V> oldEntryForValue = this.seekByValue(value, valueHash);
        BiEntry<K, V> oldEntryForKey = this.seekByKey(key, keyHash);
        if (oldEntryForValue != null && keyHash == oldEntryForValue.keyHash && com.google.common.base.Objects.equal(key, oldEntryForValue.key)) {
            return key;
        }
        if (oldEntryForKey != null && var3_3 == false) {
            value = String.valueOf(key);
            throw new IllegalArgumentException(new StringBuilder(21 + String.valueOf(value).length()).append("key already present: ").append((String)value).toString());
        }
        if (oldEntryForValue != null) {
            this.delete(oldEntryForValue);
        }
        if (oldEntryForKey != null) {
            this.delete(oldEntryForKey);
        }
        BiEntry<void, V> newEntry = new BiEntry<void, V>(var2_2, keyHash, value, valueHash);
        this.insert((BiEntry<K, V>)var1_1, oldEntryForKey);
        if (oldEntryForKey != null) {
            oldEntryForKey.prevInKeyInsertionOrder = null;
            oldEntryForKey.nextInKeyInsertionOrder = null;
        }
        if (oldEntryForValue != null) {
            oldEntryForValue.prevInKeyInsertionOrder = null;
            oldEntryForValue.nextInKeyInsertionOrder = null;
        }
        this.rehashIfNecessary();
        return Maps.keyOrNull(oldEntryForValue);
    }

    private void rehashIfNecessary() {
        BiEntry<K, V>[] oldKToV = this.hashTableKToV;
        if (Hashing.needsResizing(this.size, oldKToV.length, 1.0)) {
            int newTableSize = oldKToV.length << 1;
            this.hashTableKToV = this.createTable(newTableSize);
            this.hashTableVToK = this.createTable(newTableSize);
            this.mask = newTableSize - 1;
            this.size = 0;
            BiEntry<K, V> entry = this.firstInKeyInsertionOrder;
            while (entry != null) {
                BiEntry<K, V> biEntry = entry;
                this.insert(biEntry, biEntry);
                entry = entry.nextInKeyInsertionOrder;
            }
            ++this.modCount;
        }
    }

    private BiEntry<K, V>[] createTable(int length) {
        return new BiEntry[length];
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final V remove(Object key) {
        void var1_1;
        Object object = key;
        BiEntry<K, V> entry = this.seekByKey(object, Hashing.smearedHash(object));
        if (entry == null) {
            return null;
        }
        this.delete(entry);
        entry.prevInKeyInsertionOrder = null;
        entry.nextInKeyInsertionOrder = null;
        return var1_1.value;
    }

    @Override
    public final void clear() {
        this.size = 0;
        Arrays.fill(this.hashTableKToV, null);
        Arrays.fill(this.hashTableVToK, null);
        this.firstInKeyInsertionOrder = null;
        this.lastInKeyInsertionOrder = null;
        ++this.modCount;
    }

    @Override
    public final int size() {
        return this.size;
    }

    @Override
    public final Set<K> keySet() {
        return new KeySet();
    }

    @Override
    public final Set<V> values() {
        return this.inverse().keySet();
    }

    @Override
    final Iterator<Map.Entry<K, V>> entryIterator() {
        return new Itr<Map.Entry<K, V>>(){
            {
                void var1_1;
                super((HashBiMap)var1_1);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            Map.Entry<K, V> output(BiEntry<K, V> entry) {
                void var1_1;
                return new MapEntry(this, var1_1);
            }

            class MapEntry
            extends AbstractMapEntry<K, V> {
                BiEntry<K, V> delegate;
                final /* synthetic */ 1 this$1;

                /*
                 * WARNING - void declaration
                 */
                MapEntry(1 this$1, BiEntry<K, V> entry) {
                    void var2_2;
                    void var1_1;
                    this.this$1 = var1_1;
                    this.delegate = var2_2;
                }

                @Override
                @ParametricNullness
                public K getKey() {
                    return this.delegate.key;
                }

                @Override
                @ParametricNullness
                public V getValue() {
                    return this.delegate.value;
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                @ParametricNullness
                public V setValue(@ParametricNullness V value) {
                    void var2_2;
                    void var1_1;
                    void var3_3;
                    Object oldValue = this.delegate.value;
                    int valueHash = Hashing.smearedHash(value);
                    if (valueHash == this.delegate.valueHash && com.google.common.base.Objects.equal(value, oldValue)) {
                        return value;
                    }
                    Preconditions.checkArgument(HashBiMap.access$400(this.this$1.HashBiMap.this, value, valueHash) == null, "value already present: %s", value);
                    HashBiMap.access$200(this.this$1.HashBiMap.this, this.delegate);
                    BiEntry newEntry = new BiEntry(this.delegate.key, this.delegate.keyHash, value, (int)var3_3);
                    HashBiMap.access$500(this.this$1.HashBiMap.this, newEntry, this.delegate);
                    this.delegate.prevInKeyInsertionOrder = null;
                    this.delegate.nextInKeyInsertionOrder = null;
                    this.this$1.expectedModCount = this.this$1.HashBiMap.this.modCount;
                    if (this.this$1.toRemove == this.delegate) {
                        this.this$1.toRemove = newEntry;
                    }
                    this.delegate = var1_1;
                    return var2_2;
                }
            }
        };
    }

    @Override
    public final void forEach(BiConsumer<? super K, ? super V> action) {
        Preconditions.checkNotNull(action);
        BiEntry<K, V> entry = this.firstInKeyInsertionOrder;
        while (entry != null) {
            action.accept(entry.key, entry.value);
            entry = entry.nextInKeyInsertionOrder;
        }
    }

    @Override
    public final void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        BiEntry entry;
        Preconditions.checkNotNull(function);
        BiEntry<K, V> oldFirst = this.firstInKeyInsertionOrder;
        this.clear();
        while (entry != null) {
            this.put(entry.key, function.apply(entry.key, entry.value));
            entry = entry.nextInKeyInsertionOrder;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final BiMap<V, K> inverse() {
        void var1_1;
        BiMap<V, K> result = this.inverse;
        if (result == null) {
            this.inverse = new Inverse();
            return this.inverse;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void writeObject(ObjectOutputStream stream) throws IOException {
        void var1_1;
        stream.defaultWriteObject();
        Serialization.writeMap(this, (ObjectOutputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        void var2_2;
        void var1_1;
        stream.defaultReadObject();
        int size = Serialization.readCount(stream);
        this.init(16);
        Serialization.populateMap(this, (ObjectInputStream)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$200(HashBiMap x0, BiEntry x1) {
        void var1_1;
        x0.delete((BiEntry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BiEntry access$300(HashBiMap x0, Object x1, int x2) {
        void var2_2;
        void var1_1;
        return x0.seekByKey(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ BiEntry access$400(HashBiMap x0, Object x1, int x2) {
        void var2_2;
        void var1_1;
        return x0.seekByValue(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ void access$500(HashBiMap x0, BiEntry x1, BiEntry x2) {
        void var2_2;
        void var1_1;
        x0.insert((BiEntry)var1_1, (BiEntry)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Object access$800(HashBiMap x0, Object x1, Object x2, boolean x3) {
        void var3_3;
        void var2_2;
        void var1_1;
        return x0.putInverse(var1_1, var2_2, (boolean)var3_3);
    }

    private static final class InverseSerializedForm<K, V>
    implements Serializable {
        private final HashBiMap<K, V> bimap;

        /*
         * WARNING - void declaration
         */
        InverseSerializedForm(HashBiMap<K, V> bimap) {
            void var1_1;
            this.bimap = var1_1;
        }

        final Object readResolve() {
            return this.bimap.inverse();
        }
    }

    private final class Inverse
    extends Maps.IteratorBasedAbstractMap<V, K>
    implements BiMap<V, K>,
    Serializable {
        private Inverse() {
        }

        final BiMap<K, V> forward() {
            return HashBiMap.this;
        }

        @Override
        public final int size() {
            return HashBiMap.this.size;
        }

        @Override
        public final void clear() {
            this.forward().clear();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final boolean containsKey(Object value) {
            void var1_1;
            return this.forward().containsValue(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K get(Object value) {
            void var1_1;
            void v0 = var1_1;
            return Maps.keyOrNull(HashBiMap.access$400(HashBiMap.this, v0, Hashing.smearedHash(v0)));
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K put(@ParametricNullness V value, @ParametricNullness K key) {
            void var2_2;
            void var1_1;
            return HashBiMap.access$800(HashBiMap.this, var1_1, var2_2, false);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K forcePut(@ParametricNullness V value, @ParametricNullness K key) {
            void var2_2;
            void var1_1;
            return HashBiMap.access$800(HashBiMap.this, var1_1, var2_2, true);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final K remove(Object value) {
            void var1_1;
            Object object = value;
            BiEntry entry = HashBiMap.access$400(HashBiMap.this, object, Hashing.smearedHash(object));
            if (entry == null) {
                return null;
            }
            HashBiMap.access$200(HashBiMap.this, entry);
            entry.prevInKeyInsertionOrder = null;
            entry.nextInKeyInsertionOrder = null;
            return var1_1.key;
        }

        @Override
        public final BiMap<K, V> inverse() {
            return this.forward();
        }

        @Override
        public final Set<V> keySet() {
            return new InverseKeySet();
        }

        @Override
        public final Set<K> values() {
            return this.forward().keySet();
        }

        @Override
        final Iterator<Map.Entry<V, K>> entryIterator() {
            return new Itr<Map.Entry<V, K>>(){
                {
                    void var1_1;
                    super(var1_1.HashBiMap.this);
                }

                /*
                 * WARNING - void declaration
                 */
                @Override
                Map.Entry<V, K> output(BiEntry<K, V> entry) {
                    void var1_1;
                    return new InverseEntry(this, var1_1);
                }

                class InverseEntry
                extends AbstractMapEntry<V, K> {
                    BiEntry<K, V> delegate;
                    final /* synthetic */ 1 this$2;

                    /*
                     * WARNING - void declaration
                     */
                    InverseEntry(1 this$2, BiEntry<K, V> entry) {
                        void var2_2;
                        void var1_1;
                        this.this$2 = var1_1;
                        this.delegate = var2_2;
                    }

                    @Override
                    @ParametricNullness
                    public V getKey() {
                        return this.delegate.value;
                    }

                    @Override
                    @ParametricNullness
                    public K getValue() {
                        return this.delegate.key;
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    @ParametricNullness
                    public K setValue(@ParametricNullness K key) {
                        void var2_2;
                        void var1_1;
                        void var3_3;
                        Object oldKey = this.delegate.key;
                        int keyHash = Hashing.smearedHash(key);
                        if (keyHash == this.delegate.keyHash && com.google.common.base.Objects.equal(key, oldKey)) {
                            return key;
                        }
                        Preconditions.checkArgument(HashBiMap.access$300(this.this$2.HashBiMap.this, key, keyHash) == null, "value already present: %s", key);
                        HashBiMap.access$200(this.this$2.HashBiMap.this, this.delegate);
                        BiEntry newEntry = new BiEntry(key, (int)var3_3, this.delegate.value, this.delegate.valueHash);
                        this.delegate = newEntry;
                        HashBiMap.access$500(this.this$2.HashBiMap.this, (BiEntry)var1_1, null);
                        this.this$2.expectedModCount = this.this$2.HashBiMap.this.modCount;
                        return var2_2;
                    }
                }
            };
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public final void forEach(BiConsumer<? super V, ? super K> action) {
            void var1_1;
            Preconditions.checkNotNull(action);
            HashBiMap.this.forEach((arg_0, arg_1) -> Inverse.lambda$forEach$0((BiConsumer)var1_1, arg_0, arg_1));
        }

        @Override
        public final void replaceAll(BiFunction<? super V, ? super K, ? extends K> function) {
            BiEntry entry;
            Preconditions.checkNotNull(function);
            BiEntry oldFirst = HashBiMap.this.firstInKeyInsertionOrder;
            this.clear();
            while (entry != null) {
                this.put((V)entry.value, (K)function.apply(entry.value, entry.key));
                entry = entry.nextInKeyInsertionOrder;
            }
        }

        final Object writeReplace() {
            return new InverseSerializedForm(HashBiMap.this);
        }

        /*
         * WARNING - void declaration
         */
        private static /* synthetic */ void lambda$forEach$0(BiConsumer action, Object k, Object v) {
            void var1_1;
            void var2_2;
            action.accept(var2_2, var1_1);
        }

        private final class InverseKeySet
        extends Maps.KeySet<V, K> {
            InverseKeySet() {
                super(Inverse.this);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public final boolean remove(Object o) {
                void var1_1;
                Object object = o;
                BiEntry entry = HashBiMap.access$400(HashBiMap.this, object, Hashing.smearedHash(object));
                if (entry == null) {
                    return false;
                }
                HashBiMap.access$200(HashBiMap.this, (BiEntry)var1_1);
                return true;
            }

            @Override
            public final Iterator<V> iterator() {
                return new Itr<V>(this){
                    {
                        void var1_1;
                    }

                    @Override
                    @ParametricNullness
                    V output(BiEntry<K, V> entry) {
                        return entry.value;
                    }
                };
            }
        }
    }

    private final class KeySet
    extends Maps.KeySet<K, V> {
        KeySet() {
            super(HashBiMap.this);
        }

        @Override
        public final Iterator<K> iterator() {
            return new Itr<K>(this){
                {
                    void var1_1;
                }

                @Override
                @ParametricNullness
                K output(BiEntry<K, V> entry) {
                    return entry.key;
                }
            };
        }

        @Override
        public final boolean remove(Object o) {
            Object object = o;
            BiEntry entry = HashBiMap.access$300(HashBiMap.this, object, Hashing.smearedHash(object));
            if (entry == null) {
                return false;
            }
            HashBiMap.access$200(HashBiMap.this, entry);
            entry.prevInKeyInsertionOrder = null;
            var1_1.nextInKeyInsertionOrder = null;
            return true;
        }
    }

    abstract class Itr<T>
    implements Iterator<T> {
        BiEntry<K, V> next;
        BiEntry<K, V> toRemove;
        int expectedModCount;
        int remaining;
        final /* synthetic */ HashBiMap this$0;

        /*
         * WARNING - void declaration
         */
        Itr(HashBiMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
            this.next = this.this$0.firstInKeyInsertionOrder;
            this.toRemove = null;
            this.expectedModCount = this.this$0.modCount;
            this.remaining = this.this$0.size();
        }

        @Override
        public boolean hasNext() {
            if (this.this$0.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            return this.next != null && this.remaining > 0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public T next() {
            void var1_1;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            BiEntry entry = Objects.requireNonNull(this.next);
            this.next = entry.nextInKeyInsertionOrder;
            this.toRemove = entry;
            --this.remaining;
            return this.output((BiEntry)var1_1);
        }

        @Override
        public void remove() {
            if (this.this$0.modCount != this.expectedModCount) {
                throw new ConcurrentModificationException();
            }
            if (this.toRemove == null) {
                throw new IllegalStateException("no calls to next() since the last call to remove()");
            }
            HashBiMap.access$200(this.this$0, this.toRemove);
            this.expectedModCount = this.this$0.modCount;
            this.toRemove = null;
        }

        abstract T output(BiEntry<K, V> var1);
    }

    private static final class BiEntry<K, V>
    extends ImmutableEntry<K, V> {
        final int keyHash;
        final int valueHash;
        BiEntry<K, V> nextInKToVBucket;
        BiEntry<K, V> nextInVToKBucket;
        BiEntry<K, V> nextInKeyInsertionOrder;
        BiEntry<K, V> prevInKeyInsertionOrder;

        /*
         * WARNING - void declaration
         */
        BiEntry(@ParametricNullness K key, int keyHash, @ParametricNullness V value, int valueHash) {
            super(var1_1, var3_3);
            void var2_2;
            void var3_3;
            void var1_1;
            this.keyHash = var2_2;
            this.valueHash = valueHash;
        }
    }
}

