/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.collect.BoundType;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.NullnessCasts;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Range;
import java.io.Serializable;
import java.util.Comparator;

@ElementTypesAreNonnullByDefault
@GwtCompatible(serializable=true)
final class GeneralRange<T>
implements Serializable {
    private final Comparator<? super T> comparator;
    private final boolean hasLowerBound;
    private final T lowerEndpoint;
    private final BoundType lowerBoundType;
    private final boolean hasUpperBound;
    private final T upperEndpoint;
    private final BoundType upperBoundType;
    private transient GeneralRange<T> reverse;

    /*
     * WARNING - void declaration
     */
    static <T extends Comparable> GeneralRange<T> from(Range<T> range) {
        void var3_3;
        Range<T> range2;
        void var2_2;
        void var1_1;
        Object lowerEndpoint = range.hasLowerBound() ? range.lowerEndpoint() : null;
        BoundType lowerBoundType = range.hasLowerBound() ? range.lowerBoundType() : BoundType.OPEN;
        Object upperEndpoint = range.hasUpperBound() ? range.upperEndpoint() : null;
        BoundType upperBoundType = range.hasUpperBound() ? range.upperBoundType() : BoundType.OPEN;
        return new GeneralRange<void>(Ordering.natural(), range.hasLowerBound(), var1_1, (BoundType)var2_2, range2.hasUpperBound(), var3_3, upperBoundType);
    }

    static <T> GeneralRange<T> all(Comparator<? super T> comparator) {
        Comparator<? super T> comparator2;
        return new GeneralRange<Object>(comparator2, false, null, BoundType.OPEN, false, null, BoundType.OPEN);
    }

    /*
     * WARNING - void declaration
     */
    static <T> GeneralRange<T> downTo(Comparator<? super T> comparator, @ParametricNullness T endpoint, BoundType boundType) {
        void var2_2;
        void var1_1;
        Comparator<? super T> comparator2;
        return new GeneralRange<Object>((Comparator<Object>)comparator2, true, var1_1, (BoundType)var2_2, false, null, BoundType.OPEN);
    }

    /*
     * WARNING - void declaration
     */
    static <T> GeneralRange<T> upTo(Comparator<? super T> comparator, @ParametricNullness T endpoint, BoundType boundType) {
        void var2_2;
        void var1_1;
        Comparator<? super T> comparator2;
        return new GeneralRange<void>((Comparator<void>)comparator2, false, (void)null, BoundType.OPEN, true, var1_1, (BoundType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static <T> GeneralRange<T> range(Comparator<? super T> comparator, @ParametricNullness T lower, BoundType lowerType, @ParametricNullness T upper, BoundType upperType) {
        void var3_3;
        void var2_2;
        void var1_1;
        Comparator<? super T> comparator2;
        return new GeneralRange<void>(comparator2, true, var1_1, (BoundType)var2_2, true, var3_3, upperType);
    }

    /*
     * WARNING - void declaration
     */
    private GeneralRange(Comparator<? super T> comparator, boolean hasLowerBound, T lowerEndpoint, BoundType lowerBoundType, boolean hasUpperBound, T upperEndpoint, BoundType upperBoundType) {
        void var2_3;
        this.comparator = Preconditions.checkNotNull(comparator);
        this.hasLowerBound = hasLowerBound;
        this.hasUpperBound = hasUpperBound;
        this.lowerEndpoint = lowerEndpoint;
        this.lowerBoundType = Preconditions.checkNotNull(lowerBoundType);
        this.upperEndpoint = upperEndpoint;
        this.upperBoundType = Preconditions.checkNotNull(upperBoundType);
        if (hasLowerBound) {
            comparator.compare(NullnessCasts.uncheckedCastNullableTToT(lowerEndpoint), NullnessCasts.uncheckedCastNullableTToT(lowerEndpoint));
        }
        if (hasUpperBound) {
            comparator.compare(NullnessCasts.uncheckedCastNullableTToT(upperEndpoint), NullnessCasts.uncheckedCastNullableTToT(upperEndpoint));
        }
        if (var2_3 != false && hasUpperBound) {
            void var1_2;
            void var3_4;
            int cmp = comparator.compare(NullnessCasts.uncheckedCastNullableTToT(lowerEndpoint), NullnessCasts.uncheckedCastNullableTToT(upperEndpoint));
            Preconditions.checkArgument(cmp <= 0, "lowerEndpoint (%s) > upperEndpoint (%s)", (Object)var3_4, upperEndpoint);
            if (var1_2 == false) {
                Preconditions.checkArgument(lowerBoundType != BoundType.OPEN || upperBoundType != BoundType.OPEN);
            }
        }
    }

    final Comparator<? super T> comparator() {
        return this.comparator;
    }

    final boolean hasLowerBound() {
        return this.hasLowerBound;
    }

    final boolean hasUpperBound() {
        return this.hasUpperBound;
    }

    final boolean isEmpty() {
        block4: {
            block3: {
                block2: {
                    if (!this.hasUpperBound()) break block2;
                    GeneralRange generalRange = this;
                    if (generalRange.tooLow(NullnessCasts.uncheckedCastNullableTToT(generalRange.getUpperEndpoint()))) break block3;
                }
                if (!this.hasLowerBound()) break block4;
                GeneralRange generalRange = this;
                if (!generalRange.tooHigh(NullnessCasts.uncheckedCastNullableTToT(generalRange.getLowerEndpoint()))) break block4;
            }
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    final boolean tooLow(@ParametricNullness T t) {
        void var1_2;
        void var2_3;
        if (!this.hasLowerBound()) {
            return false;
        }
        T lbound = NullnessCasts.uncheckedCastNullableTToT(this.getLowerEndpoint());
        int cmp = this.comparator.compare((void)t, var2_3);
        return cmp < 0 | var1_2 == false & this.getLowerBoundType() == BoundType.OPEN;
    }

    /*
     * WARNING - void declaration
     */
    final boolean tooHigh(@ParametricNullness T t) {
        void var1_2;
        void var2_3;
        if (!this.hasUpperBound()) {
            return false;
        }
        T ubound = NullnessCasts.uncheckedCastNullableTToT(this.getUpperEndpoint());
        int cmp = this.comparator.compare((void)t, var2_3);
        return cmp > 0 | var1_2 == false & this.getUpperBoundType() == BoundType.OPEN;
    }

    /*
     * WARNING - void declaration
     */
    final boolean contains(@ParametricNullness T t) {
        void var1_1;
        return !this.tooLow(t) && !this.tooHigh(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    final GeneralRange<T> intersect(GeneralRange<T> other) {
        void var3_3;
        void var2_2;
        int cmp;
        BoundType upType;
        T upEnd;
        boolean hasUpBound;
        BoundType lowType;
        T lowEnd;
        boolean hasLowBound;
        block12: {
            void var1_1;
            block11: {
                block10: {
                    block9: {
                        block8: {
                            int cmp2;
                            block7: {
                                Preconditions.checkNotNull(other);
                                Preconditions.checkArgument(this.comparator.equals(other.comparator));
                                hasLowBound = this.hasLowerBound;
                                lowEnd = this.getLowerEndpoint();
                                lowType = this.getLowerBoundType();
                                if (this.hasLowerBound()) break block7;
                                hasLowBound = other.hasLowerBound;
                                break block8;
                            }
                            if (!other.hasLowerBound() || (cmp2 = this.comparator.compare(this.getLowerEndpoint(), other.getLowerEndpoint())) >= 0 && (cmp2 != 0 || other.getLowerBoundType() != BoundType.OPEN)) break block9;
                        }
                        lowEnd = other.getLowerEndpoint();
                        lowType = other.getLowerBoundType();
                    }
                    hasUpBound = this.hasUpperBound;
                    upEnd = this.getUpperEndpoint();
                    upType = this.getUpperBoundType();
                    if (this.hasUpperBound()) break block10;
                    hasUpBound = other.hasUpperBound;
                    break block11;
                }
                if (!other.hasUpperBound() || (cmp = this.comparator.compare(this.getUpperEndpoint(), other.getUpperEndpoint())) <= 0 && (cmp != 0 || other.getUpperBoundType() != BoundType.OPEN)) break block12;
            }
            upEnd = other.getUpperEndpoint();
            upType = var1_1.getUpperBoundType();
        }
        if (hasLowBound && hasUpBound && ((cmp = this.comparator.compare(lowEnd, upEnd)) > 0 || cmp == 0 && lowType == BoundType.OPEN && upType == BoundType.OPEN)) {
            lowEnd = upEnd;
            lowType = BoundType.OPEN;
            upType = BoundType.CLOSED;
        }
        return new GeneralRange<void>((Comparator<void>)this.comparator, (boolean)var2_2, var3_3, lowType, hasUpBound, (void)upEnd, upType);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean equals(Object obj) {
        if (obj instanceof GeneralRange) {
            void var1_1;
            GeneralRange r = (GeneralRange)obj;
            return this.comparator.equals(r.comparator) && this.hasLowerBound == r.hasLowerBound && this.hasUpperBound == r.hasUpperBound && this.getLowerBoundType().equals((Object)r.getLowerBoundType()) && this.getUpperBoundType().equals((Object)r.getUpperBoundType()) && Objects.equal(this.getLowerEndpoint(), r.getLowerEndpoint()) && Objects.equal(this.getUpperEndpoint(), var1_1.getUpperEndpoint());
        }
        return false;
    }

    public final int hashCode() {
        return Objects.hashCode(new Object[]{this.comparator, this.getLowerEndpoint(), this.getLowerBoundType(), this.getUpperEndpoint(), this.getUpperBoundType()});
    }

    /*
     * WARNING - void declaration
     */
    final GeneralRange<T> reverse() {
        void var1_1;
        GeneralRange<Object> result = this.reverse;
        if (result == null) {
            result = new GeneralRange(Ordering.from(this.comparator).reverse(), this.hasUpperBound, this.getUpperEndpoint(), this.getUpperBoundType(), this.hasLowerBound, this.getLowerEndpoint(), this.getLowerBoundType());
            new GeneralRange(Ordering.from(this.comparator).reverse(), this.hasUpperBound, this.getUpperEndpoint(), this.getUpperBoundType(), this.hasLowerBound, this.getLowerEndpoint(), this.getLowerBoundType()).reverse = this;
            this.reverse = result;
            return this.reverse;
        }
        return var1_1;
    }

    public final String toString() {
        String string = String.valueOf(this.comparator);
        char c = this.lowerBoundType == BoundType.CLOSED ? (char)'[' : '(';
        String string2 = String.valueOf(this.hasLowerBound ? this.lowerEndpoint : "-\u221e");
        String string3 = String.valueOf(this.hasUpperBound ? this.upperEndpoint : "\u221e");
        char c2 = this.upperBoundType == BoundType.CLOSED ? (char)']' : ')';
        return new StringBuilder(4 + String.valueOf(string).length() + String.valueOf(string2).length() + String.valueOf(string3).length()).append(string).append(":").append(c).append(string2).append(',').append(string3).append(c2).toString();
    }

    final T getLowerEndpoint() {
        return this.lowerEndpoint;
    }

    final BoundType getLowerBoundType() {
        return this.lowerBoundType;
    }

    final T getUpperEndpoint() {
        return this.upperEndpoint;
    }

    final BoundType getUpperBoundType() {
        return this.upperBoundType;
    }
}

