/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingSet;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.ParametricNullness;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.SortedSet;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingSortedSet<E>
extends ForwardingSet<E>
implements SortedSet<E> {
    protected ForwardingSortedSet() {
    }

    @Override
    protected abstract SortedSet<E> delegate();

    @Override
    public Comparator<? super E> comparator() {
        return this.delegate().comparator();
    }

    @Override
    @ParametricNullness
    public E first() {
        return this.delegate().first();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedSet<E> headSet(@ParametricNullness E toElement) {
        void var1_1;
        return this.delegate().headSet(var1_1);
    }

    @Override
    @ParametricNullness
    public E last() {
        return this.delegate().last();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedSet<E> subSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
        void var2_2;
        void var1_1;
        return this.delegate().subSet(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedSet<E> tailSet(@ParametricNullness E fromElement) {
        void var1_1;
        return this.delegate().tailSet(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Beta
    protected boolean standardContains(Object object) {
        try {
            void var1_1;
            ForwardingSortedSet forwardingSortedSet = this;
            Object ceiling = forwardingSortedSet.tailSet(object).first();
            return ForwardingSortedMap.unsafeCompare(this.comparator(), forwardingSortedSet, var1_1) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Beta
    protected boolean standardRemove(Object object) {
        try {
            ForwardingSortedSet forwardingSortedSet = this;
            Iterator iterator = forwardingSortedSet.tailSet(object).iterator();
            if (iterator.hasNext()) {
                void var1_1;
                void var3_3;
                Object ceiling = iterator.next();
                if (ForwardingSortedMap.unsafeCompare(this.comparator(), var3_3, var1_1) == 0) {
                    forwardingSortedSet.remove();
                    return true;
                }
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    protected SortedSet<E> standardSubSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
        void var2_2;
        void var1_1;
        return this.tailSet(var1_1).headSet(var2_2);
    }
}

