/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.BoundType;
import com.google.common.collect.DescendingMultiset;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.SortedMultiset;
import com.google.common.collect.SortedMultisets;
import java.util.Comparator;
import java.util.Iterator;
import java.util.NavigableSet;

@ElementTypesAreNonnullByDefault
@Beta
@GwtCompatible(emulated=true)
public abstract class ForwardingSortedMultiset<E>
extends ForwardingMultiset<E>
implements SortedMultiset<E> {
    protected ForwardingSortedMultiset() {
    }

    @Override
    protected abstract SortedMultiset<E> delegate();

    @Override
    public NavigableSet<E> elementSet() {
        return this.delegate().elementSet();
    }

    @Override
    public Comparator<? super E> comparator() {
        return this.delegate().comparator();
    }

    @Override
    public SortedMultiset<E> descendingMultiset() {
        return this.delegate().descendingMultiset();
    }

    @Override
    public Multiset.Entry<E> firstEntry() {
        return this.delegate().firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    protected Multiset.Entry<E> standardFirstEntry() {
        void var1_1;
        Iterator entryIterator = this.entrySet().iterator();
        if (!entryIterator.hasNext()) {
            return null;
        }
        Multiset.Entry entry = entryIterator.next();
        return Multisets.immutableEntry(entry.getElement(), var1_1.getCount());
    }

    @Override
    public Multiset.Entry<E> lastEntry() {
        return this.delegate().lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    protected Multiset.Entry<E> standardLastEntry() {
        void var1_1;
        Iterator<Multiset.Entry<E>> entryIterator = this.descendingMultiset().entrySet().iterator();
        if (!entryIterator.hasNext()) {
            return null;
        }
        Multiset.Entry<E> entry = entryIterator.next();
        return Multisets.immutableEntry(entry.getElement(), var1_1.getCount());
    }

    @Override
    public Multiset.Entry<E> pollFirstEntry() {
        return this.delegate().pollFirstEntry();
    }

    /*
     * WARNING - void declaration
     */
    protected Multiset.Entry<E> standardPollFirstEntry() {
        void var2_2;
        void var1_1;
        Iterator entryIterator = this.entrySet().iterator();
        if (!entryIterator.hasNext()) {
            return null;
        }
        Multiset.Entry entry = entryIterator.next();
        entry = Multisets.immutableEntry(entry.getElement(), entry.getCount());
        var1_1.remove();
        return var2_2;
    }

    @Override
    public Multiset.Entry<E> pollLastEntry() {
        return this.delegate().pollLastEntry();
    }

    /*
     * WARNING - void declaration
     */
    protected Multiset.Entry<E> standardPollLastEntry() {
        void var2_2;
        void var1_1;
        Iterator<Multiset.Entry<E>> entryIterator = this.descendingMultiset().entrySet().iterator();
        if (!entryIterator.hasNext()) {
            return null;
        }
        Multiset.Entry<E> entry = entryIterator.next();
        entry = Multisets.immutableEntry(entry.getElement(), entry.getCount());
        var1_1.remove();
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMultiset<E> headMultiset(@ParametricNullness E upperBound, BoundType boundType) {
        void var2_2;
        void var1_1;
        return this.delegate().headMultiset(var1_1, (BoundType)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMultiset<E> subMultiset(@ParametricNullness E lowerBound, BoundType lowerBoundType, @ParametricNullness E upperBound, BoundType upperBoundType) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.delegate().subMultiset(var1_1, (BoundType)var2_2, var3_3, upperBoundType);
    }

    /*
     * WARNING - void declaration
     */
    protected SortedMultiset<E> standardSubMultiset(@ParametricNullness E lowerBound, BoundType lowerBoundType, @ParametricNullness E upperBound, BoundType upperBoundType) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.tailMultiset(var1_1, (BoundType)var2_2).headMultiset(var3_3, upperBoundType);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMultiset<E> tailMultiset(@ParametricNullness E lowerBound, BoundType boundType) {
        void var2_2;
        void var1_1;
        return this.delegate().tailMultiset(var1_1, (BoundType)var2_2);
    }

    protected abstract class StandardDescendingMultiset
    extends DescendingMultiset<E> {
        final /* synthetic */ ForwardingSortedMultiset this$0;

        /*
         * WARNING - void declaration
         */
        public StandardDescendingMultiset(ForwardingSortedMultiset this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        SortedMultiset<E> forwardMultiset() {
            return this.this$0;
        }
    }

    protected class StandardElementSet
    extends SortedMultisets.NavigableElementSet<E> {
        /*
         * WARNING - void declaration
         */
        public StandardElementSet(ForwardingSortedMultiset this$0) {
            super(var1_1);
            void var1_1;
        }
    }
}

