/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Preconditions;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingMap;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.SortedMap;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingSortedMap<K, V>
extends ForwardingMap<K, V>
implements SortedMap<K, V> {
    protected ForwardingSortedMap() {
    }

    @Override
    protected abstract SortedMap<K, V> delegate();

    @Override
    public Comparator<? super K> comparator() {
        return this.delegate().comparator();
    }

    @Override
    @ParametricNullness
    public K firstKey() {
        return this.delegate().firstKey();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<K, V> headMap(@ParametricNullness K toKey) {
        void var1_1;
        return this.delegate().headMap(var1_1);
    }

    @Override
    @ParametricNullness
    public K lastKey() {
        return this.delegate().lastKey();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<K, V> subMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
        void var2_2;
        void var1_1;
        return this.delegate().subMap(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SortedMap<K, V> tailMap(@ParametricNullness K fromKey) {
        void var1_1;
        return this.delegate().tailMap(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static int unsafeCompare(Comparator<?> comparator, Object o1, Object o2) {
        void var2_2;
        void var1_1;
        Comparator<?> comparator2;
        if (comparator == null) {
            return ((Comparable)o1).compareTo(o2);
        }
        return comparator2.compare(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Beta
    protected boolean standardContainsKey(Object key) {
        try {
            void var1_1;
            ForwardingSortedMap forwardingSortedMap = this;
            Object ceilingKey = forwardingSortedMap.tailMap(key).firstKey();
            return ForwardingSortedMap.unsafeCompare(this.comparator(), forwardingSortedMap, var1_1) == 0;
        }
        catch (ClassCastException | NullPointerException | NoSuchElementException runtimeException) {
            return false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    protected SortedMap<K, V> standardSubMap(K fromKey, K toKey) {
        void var2_2;
        void var1_1;
        Preconditions.checkArgument(ForwardingSortedMap.unsafeCompare(this.comparator(), fromKey, toKey) <= 0, "fromKey must be <= toKey");
        return this.tailMap(var1_1).headMap(var2_2);
    }

    @Beta
    protected class StandardKeySet
    extends Maps.SortedKeySet<K, V> {
        /*
         * WARNING - void declaration
         */
        public StandardKeySet(ForwardingSortedMap this$0) {
            super(var1_1);
            void var1_1;
        }
    }
}

