/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingSortedSet;
import com.google.common.collect.Iterators;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.NavigableSet;
import java.util.SortedSet;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class ForwardingNavigableSet<E>
extends ForwardingSortedSet<E>
implements NavigableSet<E> {
    protected ForwardingNavigableSet() {
    }

    @Override
    protected abstract NavigableSet<E> delegate();

    /*
     * WARNING - void declaration
     */
    @Override
    public E lower(@ParametricNullness E e) {
        void var1_1;
        return this.delegate().lower(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected E standardLower(@ParametricNullness E e) {
        void var1_1;
        return Iterators.getNext(this.headSet(var1_1, false).descendingIterator(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E floor(@ParametricNullness E e) {
        void var1_1;
        return this.delegate().floor(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected E standardFloor(@ParametricNullness E e) {
        void var1_1;
        return Iterators.getNext(this.headSet(var1_1, true).descendingIterator(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E ceiling(@ParametricNullness E e) {
        void var1_1;
        return this.delegate().ceiling(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected E standardCeiling(@ParametricNullness E e) {
        void var1_1;
        return Iterators.getNext(this.tailSet(var1_1, true).iterator(), null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public E higher(@ParametricNullness E e) {
        void var1_1;
        return this.delegate().higher(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected E standardHigher(@ParametricNullness E e) {
        void var1_1;
        return Iterators.getNext(this.tailSet(var1_1, false).iterator(), null);
    }

    @Override
    public E pollFirst() {
        return this.delegate().pollFirst();
    }

    protected E standardPollFirst() {
        return Iterators.pollNext(this.iterator());
    }

    @Override
    public E pollLast() {
        return this.delegate().pollLast();
    }

    protected E standardPollLast() {
        return Iterators.pollNext(this.descendingIterator());
    }

    @ParametricNullness
    protected E standardFirst() {
        return this.iterator().next();
    }

    @ParametricNullness
    protected E standardLast() {
        return this.descendingIterator().next();
    }

    @Override
    public NavigableSet<E> descendingSet() {
        return this.delegate().descendingSet();
    }

    @Override
    public Iterator<E> descendingIterator() {
        return this.delegate().descendingIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NavigableSet<E> subSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.delegate().subSet(var1_1, (boolean)var2_2, var3_3, toInclusive);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    protected NavigableSet<E> standardSubSet(@ParametricNullness E fromElement, boolean fromInclusive, @ParametricNullness E toElement, boolean toInclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.tailSet(var1_1, (boolean)var2_2).headSet(var3_3, toInclusive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected SortedSet<E> standardSubSet(@ParametricNullness E fromElement, @ParametricNullness E toElement) {
        void var2_2;
        void var1_1;
        return this.subSet(var1_1, true, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NavigableSet<E> headSet(@ParametricNullness E toElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.delegate().headSet(var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected SortedSet<E> standardHeadSet(@ParametricNullness E toElement) {
        void var1_1;
        return this.headSet(var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NavigableSet<E> tailSet(@ParametricNullness E fromElement, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.delegate().tailSet(var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected SortedSet<E> standardTailSet(@ParametricNullness E fromElement) {
        void var1_1;
        return this.tailSet(var1_1, true);
    }

    @Beta
    protected class StandardDescendingSet
    extends Sets.DescendingSet<E> {
        /*
         * WARNING - void declaration
         */
        public StandardDescendingSet(ForwardingNavigableSet this$0) {
            super(var1_1);
            void var1_1;
        }
    }
}

