/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingSortedMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import java.util.Iterator;
import java.util.Map;
import java.util.NavigableMap;
import java.util.NavigableSet;
import java.util.NoSuchElementException;
import java.util.SortedMap;
import java.util.function.BiFunction;

@ElementTypesAreNonnullByDefault
@GwtIncompatible
public abstract class ForwardingNavigableMap<K, V>
extends ForwardingSortedMap<K, V>
implements NavigableMap<K, V> {
    protected ForwardingNavigableMap() {
    }

    @Override
    protected abstract NavigableMap<K, V> delegate();

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> lowerEntry(@ParametricNullness K key) {
        void var1_1;
        return this.delegate().lowerEntry(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected Map.Entry<K, V> standardLowerEntry(@ParametricNullness K key) {
        void var1_1;
        return this.headMap(var1_1, false).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K lowerKey(@ParametricNullness K key) {
        void var1_1;
        return this.delegate().lowerKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected K standardLowerKey(@ParametricNullness K key) {
        void var1_1;
        return Maps.keyOrNull(this.lowerEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> floorEntry(@ParametricNullness K key) {
        void var1_1;
        return this.delegate().floorEntry(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected Map.Entry<K, V> standardFloorEntry(@ParametricNullness K key) {
        void var1_1;
        return this.headMap(var1_1, true).lastEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K floorKey(@ParametricNullness K key) {
        void var1_1;
        return this.delegate().floorKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected K standardFloorKey(@ParametricNullness K key) {
        void var1_1;
        return Maps.keyOrNull(this.floorEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> ceilingEntry(@ParametricNullness K key) {
        void var1_1;
        return this.delegate().ceilingEntry(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected Map.Entry<K, V> standardCeilingEntry(@ParametricNullness K key) {
        void var1_1;
        return this.tailMap(var1_1, true).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K ceilingKey(@ParametricNullness K key) {
        void var1_1;
        return this.delegate().ceilingKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected K standardCeilingKey(@ParametricNullness K key) {
        void var1_1;
        return Maps.keyOrNull(this.ceilingEntry(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map.Entry<K, V> higherEntry(@ParametricNullness K key) {
        void var1_1;
        return this.delegate().higherEntry(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected Map.Entry<K, V> standardHigherEntry(@ParametricNullness K key) {
        void var1_1;
        return this.tailMap(var1_1, false).firstEntry();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public K higherKey(@ParametricNullness K key) {
        void var1_1;
        return this.delegate().higherKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected K standardHigherKey(@ParametricNullness K key) {
        void var1_1;
        return Maps.keyOrNull(this.higherEntry(var1_1));
    }

    @Override
    public Map.Entry<K, V> firstEntry() {
        return this.delegate().firstEntry();
    }

    protected Map.Entry<K, V> standardFirstEntry() {
        return Iterables.getFirst(this.entrySet(), null);
    }

    /*
     * WARNING - void declaration
     */
    protected K standardFirstKey() {
        void var1_1;
        Map.Entry<K, V> entry = this.firstEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return var1_1.getKey();
    }

    @Override
    public Map.Entry<K, V> lastEntry() {
        return this.delegate().lastEntry();
    }

    protected Map.Entry<K, V> standardLastEntry() {
        return Iterables.getFirst(this.descendingMap().entrySet(), null);
    }

    /*
     * WARNING - void declaration
     */
    protected K standardLastKey() {
        void var1_1;
        Map.Entry<K, V> entry = this.lastEntry();
        if (entry == null) {
            throw new NoSuchElementException();
        }
        return var1_1.getKey();
    }

    @Override
    public Map.Entry<K, V> pollFirstEntry() {
        return this.delegate().pollFirstEntry();
    }

    protected Map.Entry<K, V> standardPollFirstEntry() {
        return Iterators.pollNext(this.entrySet().iterator());
    }

    @Override
    public Map.Entry<K, V> pollLastEntry() {
        return this.delegate().pollLastEntry();
    }

    protected Map.Entry<K, V> standardPollLastEntry() {
        return Iterators.pollNext(this.descendingMap().entrySet().iterator());
    }

    @Override
    public NavigableMap<K, V> descendingMap() {
        return this.delegate().descendingMap();
    }

    @Override
    public NavigableSet<K> navigableKeySet() {
        return this.delegate().navigableKeySet();
    }

    @Override
    public NavigableSet<K> descendingKeySet() {
        return this.delegate().descendingKeySet();
    }

    @Beta
    protected NavigableSet<K> standardDescendingKeySet() {
        return this.descendingMap().navigableKeySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected SortedMap<K, V> standardSubMap(@ParametricNullness K fromKey, @ParametricNullness K toKey) {
        void var2_2;
        void var1_1;
        return this.subMap(var1_1, true, var2_2, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NavigableMap<K, V> subMap(@ParametricNullness K fromKey, boolean fromInclusive, @ParametricNullness K toKey, boolean toInclusive) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.delegate().subMap(var1_1, (boolean)var2_2, var3_3, toInclusive);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NavigableMap<K, V> headMap(@ParametricNullness K toKey, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.delegate().headMap(var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public NavigableMap<K, V> tailMap(@ParametricNullness K fromKey, boolean inclusive) {
        void var2_2;
        void var1_1;
        return this.delegate().tailMap(var1_1, (boolean)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected SortedMap<K, V> standardHeadMap(@ParametricNullness K toKey) {
        void var1_1;
        return this.headMap(var1_1, false);
    }

    /*
     * WARNING - void declaration
     */
    protected SortedMap<K, V> standardTailMap(@ParametricNullness K fromKey) {
        void var1_1;
        return this.tailMap(var1_1, true);
    }

    @Beta
    protected class StandardNavigableKeySet
    extends Maps.NavigableKeySet<K, V> {
        /*
         * WARNING - void declaration
         */
        public StandardNavigableKeySet(ForwardingNavigableMap this$0) {
            super(var1_1);
            void var1_1;
        }
    }

    @Beta
    protected class StandardDescendingMap
    extends Maps.DescendingMap<K, V> {
        final /* synthetic */ ForwardingNavigableMap this$0;

        /*
         * WARNING - void declaration
         */
        public StandardDescendingMap(ForwardingNavigableMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        NavigableMap<K, V> forward() {
            return this.this$0;
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
            void var1_1;
            this.forward().replaceAll((BiFunction)var1_1);
        }

        @Override
        protected Iterator<Map.Entry<K, V>> entryIterator() {
            return new Iterator<Map.Entry<K, V>>(this){
                private Map.Entry<K, V> toRemove = null;
                private Map.Entry<K, V> nextOrNull = this.this$1.forward().lastEntry();
                final /* synthetic */ StandardDescendingMap this$1;
                {
                    void var1_1;
                    this.this$1 = var1_1;
                }

                @Override
                public boolean hasNext() {
                    return this.nextOrNull != null;
                }

                @Override
                public Map.Entry<K, V> next() {
                    if (this.nextOrNull == null) {
                        throw new NoSuchElementException();
                    }
                    try {
                        Map.Entry entry = this.nextOrNull;
                        return entry;
                    }
                    finally {
                        this.toRemove = this.nextOrNull;
                        this.nextOrNull = this.this$1.forward().lowerEntry(this.nextOrNull.getKey());
                    }
                }

                @Override
                public void remove() {
                    if (this.toRemove == null) {
                        throw new IllegalStateException("no calls to next() since the last call to remove()");
                    }
                    this.this$1.forward().remove(this.toRemove.getKey());
                    this.toRemove = null;
                }
            };
        }
    }
}

