/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.Iterators;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.ParametricNullness;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingMultiset<E>
extends ForwardingCollection<E>
implements Multiset<E> {
    protected ForwardingMultiset() {
    }

    @Override
    protected abstract Multiset<E> delegate();

    /*
     * WARNING - void declaration
     */
    @Override
    public int count(Object element) {
        void var1_1;
        return this.delegate().count(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int add(@ParametricNullness E element, int occurrences) {
        void var2_2;
        void var1_1;
        return this.delegate().add(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int remove(Object element, int occurrences) {
        void var2_2;
        void var1_1;
        return this.delegate().remove(var1_1, (int)var2_2);
    }

    @Override
    public Set<E> elementSet() {
        return this.delegate().elementSet();
    }

    @Override
    public Set<Multiset.Entry<E>> entrySet() {
        return this.delegate().entrySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        return object == this || this.delegate().equals(var1_1);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int setCount(@ParametricNullness E element, int count) {
        void var2_2;
        void var1_1;
        return this.delegate().setCount(var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean setCount(@ParametricNullness E element, int oldCount, int newCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.delegate().setCount(var1_1, (int)var2_2, (int)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean standardContains(Object object) {
        void var1_1;
        return this.count(var1_1) > 0;
    }

    @Override
    protected void standardClear() {
        Iterators.clear(this.entrySet().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    protected int standardCount(Object object) {
        for (Multiset.Entry<E> entry : this.entrySet()) {
            void var3_3;
            if (!Objects.equal(entry.getElement(), object)) continue;
            return var3_3.getCount();
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardAdd(@ParametricNullness E element) {
        void var1_1;
        this.add(var1_1, 1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Beta
    protected boolean standardAddAll(Collection<? extends E> elementsToAdd) {
        void var1_1;
        return Multisets.addAllImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean standardRemove(Object element) {
        void var1_1;
        return this.remove(var1_1, 1) > 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean standardRemoveAll(Collection<?> elementsToRemove) {
        void var1_1;
        return Multisets.removeAllImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected boolean standardRetainAll(Collection<?> elementsToRetain) {
        void var1_1;
        return Multisets.retainAllImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected int standardSetCount(@ParametricNullness E element, int count) {
        void var2_2;
        void var1_1;
        return Multisets.setCountImpl(this, var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardSetCount(@ParametricNullness E element, int oldCount, int newCount) {
        void var3_3;
        void var2_2;
        void var1_1;
        return Multisets.setCountImpl(this, var1_1, (int)var2_2, (int)var3_3);
    }

    protected Iterator<E> standardIterator() {
        return Multisets.iteratorImpl(this);
    }

    protected int standardSize() {
        return Multisets.linearTimeSizeImpl(this);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardEquals(Object object) {
        void var1_1;
        return Multisets.equalsImpl(this, var1_1);
    }

    protected int standardHashCode() {
        return this.entrySet().hashCode();
    }

    @Override
    protected String standardToString() {
        return this.entrySet().toString();
    }

    @Beta
    protected class StandardElementSet
    extends Multisets.ElementSet<E> {
        final /* synthetic */ ForwardingMultiset this$0;

        /*
         * WARNING - void declaration
         */
        public StandardElementSet(ForwardingMultiset this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        Multiset<E> multiset() {
            return this.this$0;
        }

        @Override
        public Iterator<E> iterator() {
            return Multisets.elementIterator(this.multiset().entrySet().iterator());
        }
    }
}

