/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.ParametricNullness;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingMapEntry<K, V>
extends ForwardingObject
implements Map.Entry<K, V> {
    protected ForwardingMapEntry() {
    }

    @Override
    protected abstract Map.Entry<K, V> delegate();

    @Override
    @ParametricNullness
    public K getKey() {
        return this.delegate().getKey();
    }

    @Override
    @ParametricNullness
    public V getValue() {
        return this.delegate().getValue();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public V setValue(@ParametricNullness V value) {
        void var1_1;
        return this.delegate().setValue(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        return this.delegate().equals(var1_1);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardEquals(Object object) {
        if (object instanceof Map.Entry) {
            void var1_1;
            Map.Entry that = (Map.Entry)object;
            return Objects.equal(this.getKey(), that.getKey()) && Objects.equal(this.getValue(), var1_1.getValue());
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected int standardHashCode() {
        void var2_2;
        void var1_1;
        K k = this.getKey();
        V v = this.getValue();
        return (k == null ? 0 : var1_1.hashCode()) ^ (v == null ? 0 : var2_2.hashCode());
    }

    @Beta
    protected String standardToString() {
        String string = String.valueOf(this.getKey());
        String string2 = String.valueOf(this.getValue());
        return new StringBuilder(1 + String.valueOf(string).length() + String.valueOf(string2).length()).append(string).append("=").append(string2).toString();
    }
}

