/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.Iterators;
import com.google.common.collect.Maps;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Sets;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingMap<K, V>
extends ForwardingObject
implements Map<K, V> {
    protected ForwardingMap() {
    }

    @Override
    protected abstract Map<K, V> delegate();

    @Override
    public int size() {
        return this.delegate().size();
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V remove(Object key) {
        void var1_1;
        return this.delegate().remove(var1_1);
    }

    @Override
    public void clear() {
        this.delegate().clear();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsKey(Object key) {
        void var1_1;
        return this.delegate().containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsValue(Object value) {
        void var1_1;
        return this.delegate().containsValue(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V get(Object key) {
        void var1_1;
        return this.delegate().get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V put(@ParametricNullness K key, @ParametricNullness V value) {
        void var2_2;
        void var1_1;
        return this.delegate().put(var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        void var1_1;
        this.delegate().putAll(var1_1);
    }

    @Override
    public Set<K> keySet() {
        return this.delegate().keySet();
    }

    @Override
    public Collection<V> values() {
        return this.delegate().values();
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.delegate().entrySet();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        return object == this || this.delegate().equals(var1_1);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    protected void standardPutAll(Map<? extends K, ? extends V> map) {
        void var1_1;
        Maps.putAllImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    protected V standardRemove(Object key) {
        Iterator<Map.Entry<K, V>> entryIterator = this.entrySet().iterator();
        while (entryIterator.hasNext()) {
            void var1_1;
            void var3_3;
            Map.Entry<K, V> entry = entryIterator.next();
            if (!Objects.equal(entry.getKey(), key)) continue;
            Object value = var3_3.getValue();
            entryIterator.remove();
            return var1_1;
        }
        return null;
    }

    protected void standardClear() {
        Iterators.clear(this.entrySet().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    protected boolean standardContainsKey(Object key) {
        void var1_1;
        return Maps.containsKeyImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardContainsValue(Object value) {
        void var1_1;
        return Maps.containsValueImpl(this, var1_1);
    }

    protected boolean standardIsEmpty() {
        return !this.entrySet().iterator().hasNext();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardEquals(Object object) {
        void var1_1;
        return Maps.equalsImpl(this, var1_1);
    }

    protected int standardHashCode() {
        return Sets.hashCodeImpl(this.entrySet());
    }

    protected String standardToString() {
        return Maps.toStringImpl(this);
    }

    @Beta
    protected abstract class StandardEntrySet
    extends Maps.EntrySet<K, V> {
        final /* synthetic */ ForwardingMap this$0;

        /*
         * WARNING - void declaration
         */
        public StandardEntrySet(ForwardingMap this$0) {
            void var1_1;
            this.this$0 = var1_1;
        }

        @Override
        Map<K, V> map() {
            return this.this$0;
        }
    }

    @Beta
    protected class StandardValues
    extends Maps.Values<K, V> {
        /*
         * WARNING - void declaration
         */
        public StandardValues(ForwardingMap this$0) {
            super(var1_1);
            void var1_1;
        }
    }

    @Beta
    protected class StandardKeySet
    extends Maps.KeySet<K, V> {
        /*
         * WARNING - void declaration
         */
        public StandardKeySet(ForwardingMap this$0) {
            super(var1_1);
            void var1_1;
        }
    }
}

