/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingCollection;
import com.google.common.collect.Lists;
import com.google.common.collect.ParametricNullness;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingList<E>
extends ForwardingCollection<E>
implements List<E> {
    protected ForwardingList() {
    }

    @Override
    protected abstract List<E> delegate();

    /*
     * WARNING - void declaration
     */
    @Override
    public void add(int index, @ParametricNullness E element) {
        void var2_2;
        void var1_1;
        this.delegate().add((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(int index, Collection<? extends E> elements) {
        void var2_2;
        void var1_1;
        return this.delegate().addAll((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public E get(int index) {
        void var1_1;
        return this.delegate().get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int indexOf(Object element) {
        void var1_1;
        return this.delegate().indexOf(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int lastIndexOf(Object element) {
        void var1_1;
        return this.delegate().lastIndexOf(var1_1);
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.delegate().listIterator();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ListIterator<E> listIterator(int index) {
        void var1_1;
        return this.delegate().listIterator((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public E remove(int index) {
        void var1_1;
        return this.delegate().remove((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @ParametricNullness
    public E set(int index, @ParametricNullness E element) {
        void var2_2;
        void var1_1;
        return this.delegate().set((int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        return this.delegate().subList((int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean equals(Object object) {
        void var1_1;
        return object == this || this.delegate().equals(var1_1);
    }

    @Override
    public int hashCode() {
        return this.delegate().hashCode();
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardAdd(@ParametricNullness E element) {
        void var1_1;
        ForwardingList forwardingList = this;
        forwardingList.add(forwardingList.size(), var1_1);
        return true;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardAddAll(int index, Iterable<? extends E> elements) {
        void var2_2;
        void var1_1;
        return Lists.addAllImpl(this, (int)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected int standardIndexOf(Object element) {
        void var1_1;
        return Lists.indexOfImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected int standardLastIndexOf(Object element) {
        void var1_1;
        return Lists.lastIndexOfImpl(this, var1_1);
    }

    protected Iterator<E> standardIterator() {
        return this.listIterator();
    }

    protected ListIterator<E> standardListIterator() {
        return this.listIterator(0);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    protected ListIterator<E> standardListIterator(int start) {
        void var1_1;
        return Lists.listIteratorImpl(this, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    protected List<E> standardSubList(int fromIndex, int toIndex) {
        void var2_2;
        void var1_1;
        return Lists.subListImpl(this, (int)var1_1, (int)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    protected boolean standardEquals(Object object) {
        void var1_1;
        return Lists.equalsImpl(this, var1_1);
    }

    @Beta
    protected int standardHashCode() {
        return Lists.hashCodeImpl(this);
    }
}

