/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.collect.Collections2;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ForwardingObject;
import com.google.common.collect.Iterators;
import com.google.common.collect.ObjectArrays;
import com.google.common.collect.ParametricNullness;
import java.util.Collection;
import java.util.Iterator;

@ElementTypesAreNonnullByDefault
@GwtCompatible
public abstract class ForwardingCollection<E>
extends ForwardingObject
implements Collection<E> {
    protected ForwardingCollection() {
    }

    @Override
    protected abstract Collection<E> delegate();

    @Override
    public Iterator<E> iterator() {
        return this.delegate().iterator();
    }

    @Override
    public int size() {
        return this.delegate().size();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean removeAll(Collection<?> collection) {
        void var1_1;
        return this.delegate().removeAll((Collection<?>)var1_1);
    }

    @Override
    public boolean isEmpty() {
        return this.delegate().isEmpty();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean contains(Object object) {
        void var1_1;
        return this.delegate().contains(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean add(@ParametricNullness E element) {
        void var1_1;
        return this.delegate().add(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean remove(Object object) {
        void var1_1;
        return this.delegate().remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAll(Collection<?> collection) {
        void var1_1;
        return this.delegate().containsAll((Collection<?>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean addAll(Collection<? extends E> collection) {
        void var1_1;
        return this.delegate().addAll(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(Collection<?> collection) {
        void var1_1;
        return this.delegate().retainAll((Collection<?>)var1_1);
    }

    @Override
    public void clear() {
        this.delegate().clear();
    }

    @Override
    public Object[] toArray() {
        return this.delegate().toArray();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T[] toArray(T[] array) {
        void var1_1;
        return this.delegate().toArray((T[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardContains(Object object) {
        void var1_1;
        return Iterators.contains(this.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardContainsAll(Collection<?> collection) {
        void var1_1;
        return Collections2.containsAllImpl(this, var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardAddAll(Collection<? extends E> collection) {
        void var1_1;
        return Iterators.addAll(this, var1_1.iterator());
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardRemove(Object object) {
        Iterator<E> iterator = this.iterator();
        while (iterator.hasNext()) {
            void var2_2;
            if (!Objects.equal(iterator.next(), object)) continue;
            var2_2.remove();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardRemoveAll(Collection<?> collection) {
        void var1_1;
        return Iterators.removeAll(this.iterator(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected boolean standardRetainAll(Collection<?> collection) {
        void var1_1;
        return Iterators.retainAll(this.iterator(), var1_1);
    }

    protected void standardClear() {
        Iterators.clear(this.iterator());
    }

    protected boolean standardIsEmpty() {
        return !this.iterator().hasNext();
    }

    protected String standardToString() {
        return Collections2.toStringImpl(this);
    }

    /*
     * WARNING - void declaration
     */
    protected Object[] standardToArray() {
        void var1_1;
        Object[] newArray = new Object[this.size()];
        return this.toArray((T[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected <T> T[] standardToArray(T[] array) {
        void var1_1;
        return ObjectArrays.toArrayImpl(this, var1_1);
    }
}

