/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.Beta;
import com.google.common.annotations.GwtCompatible;
import com.google.common.annotations.GwtIncompatible;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Optional;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.AbstractIndexedListIterator;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.ImmutableSortedSet;
import com.google.common.collect.Iterables;
import com.google.common.collect.Iterators;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Ordering;
import com.google.common.collect.ParametricNullness;
import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.SortedSet;
import java.util.stream.Stream;

@ElementTypesAreNonnullByDefault
@GwtCompatible(emulated=true)
public abstract class FluentIterable<E>
implements Iterable<E> {
    private final Optional<Iterable<E>> iterableDelegate;

    protected FluentIterable() {
        this.iterableDelegate = Optional.absent();
    }

    /*
     * WARNING - void declaration
     */
    FluentIterable(Iterable<E> iterable) {
        void var1_1;
        this.iterableDelegate = Optional.of(var1_1);
    }

    private Iterable<E> getDelegate() {
        return this.iterableDelegate.or(this);
    }

    public static <E> FluentIterable<E> from(Iterable<E> iterable) {
        Iterable<E> iterable2;
        if (iterable instanceof FluentIterable) {
            return (FluentIterable)iterable;
        }
        final Iterable<E> iterable3 = iterable2;
        return new FluentIterable<E>(iterable3){
            {
                void var1_1;
                super(var1_1);
            }

            @Override
            public Iterator<E> iterator() {
                return iterable3.iterator();
            }
        };
    }

    @Beta
    public static <E> FluentIterable<E> from(E[] elements) {
        return FluentIterable.from(Arrays.asList(elements));
    }

    @Deprecated
    public static <E> FluentIterable<E> from(FluentIterable<E> iterable) {
        return Preconditions.checkNotNull(iterable);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <T> FluentIterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b) {
        void var1_1;
        Iterable<? extends T> iterable;
        return FluentIterable.concatNoDefensiveCopy(new Iterable[]{iterable, var1_1});
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <T> FluentIterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b, Iterable<? extends T> c) {
        void var2_2;
        void var1_1;
        Iterable<? extends T> iterable;
        return FluentIterable.concatNoDefensiveCopy(new Iterable[]{iterable, var1_1, var2_2});
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <T> FluentIterable<T> concat(Iterable<? extends T> a, Iterable<? extends T> b, Iterable<? extends T> c, Iterable<? extends T> d) {
        void var3_3;
        void var2_2;
        void var1_1;
        Iterable<? extends T> iterable;
        return FluentIterable.concatNoDefensiveCopy(new Iterable[]{iterable, var1_1, var2_2, var3_3});
    }

    @Beta
    public static <T> FluentIterable<T> concat(Iterable<? extends T> ... inputs) {
        return FluentIterable.concatNoDefensiveCopy(Arrays.copyOf(inputs, inputs.length));
    }

    @Beta
    public static <T> FluentIterable<T> concat(Iterable<? extends Iterable<? extends T>> inputs) {
        Iterable<? extends Iterable<? extends T>> iterable;
        Preconditions.checkNotNull(inputs);
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return Iterators.concat(Iterators.transform(iterable.iterator(), Iterables.toIterator()));
            }
        };
    }

    private static <T> FluentIterable<T> concatNoDefensiveCopy(Iterable<? extends T> ... inputs) {
        Iterable<? extends T>[] iterableArray;
        Iterable<? extends T>[] iterableArray2 = inputs;
        int n = inputs.length;
        for (int i = 0; i < n; ++i) {
            Iterable<? extends T> iterable = iterableArray2[i];
            Preconditions.checkNotNull(iterable);
        }
        return new FluentIterable<T>(){

            @Override
            public Iterator<T> iterator() {
                3 v0 = this;
                return Iterators.concat(new AbstractIndexedListIterator<Iterator<? extends T>>(v0, v0.iterableArray.length){
                    final /* synthetic */ 3 this$0;
                    {
                        void var2_2;
                        void var1_1;
                        this.this$0 = var1_1;
                        super((int)var2_2);
                    }

                    /*
                     * WARNING - void declaration
                     */
                    @Override
                    public Iterator<? extends T> get(int i) {
                        void var1_1;
                        return this.this$0.iterableArray[var1_1].iterator();
                    }
                });
            }
        };
    }

    @Beta
    public static <E> FluentIterable<E> of() {
        return FluentIterable.from(Collections.emptyList());
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public static <E> FluentIterable<E> of(@ParametricNullness E element, E ... elements) {
        void var1_1;
        return FluentIterable.from(Lists.asList(element, var1_1));
    }

    public String toString() {
        return Iterables.toString(this.getDelegate());
    }

    public final int size() {
        return Iterables.size(this.getDelegate());
    }

    /*
     * WARNING - void declaration
     */
    public final boolean contains(Object target) {
        void var1_1;
        return Iterables.contains(this.getDelegate(), var1_1);
    }

    public final FluentIterable<E> cycle() {
        return FluentIterable.from(Iterables.cycle(this.getDelegate()));
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final FluentIterable<E> append(Iterable<? extends E> other) {
        void var1_1;
        return FluentIterable.concat(this.getDelegate(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Beta
    public final FluentIterable<E> append(E ... elements) {
        void var1_1;
        return FluentIterable.concat(this.getDelegate(), Arrays.asList(var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final FluentIterable<E> filter(Predicate<? super E> predicate) {
        void var1_1;
        return FluentIterable.from(Iterables.filter(this.getDelegate(), var1_1));
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final <T> FluentIterable<T> filter(Class<T> type) {
        void var1_1;
        return FluentIterable.from(Iterables.filter(this.getDelegate(), var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final boolean anyMatch(Predicate<? super E> predicate) {
        void var1_1;
        return Iterables.any(this.getDelegate(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final boolean allMatch(Predicate<? super E> predicate) {
        void var1_1;
        return Iterables.all(this.getDelegate(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final Optional<E> firstMatch(Predicate<? super E> predicate) {
        void var1_1;
        return Iterables.tryFind(this.getDelegate(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <T> FluentIterable<T> transform(Function<? super E, T> function) {
        void var1_1;
        return FluentIterable.from(Iterables.transform(this.getDelegate(), var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public <T> FluentIterable<T> transformAndConcat(Function<? super E, ? extends Iterable<? extends T>> function) {
        void var1_1;
        return FluentIterable.concat(this.transform((Function<? super E, T>)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final Optional<E> first() {
        Iterator<E> iterator = this.getDelegate().iterator();
        if (iterator.hasNext()) {
            void var1_1;
            return Optional.of(var1_1.next());
        }
        return Optional.absent();
    }

    /*
     * WARNING - void declaration
     */
    public final Optional<E> last() {
        void var1_1;
        SortedSet iterable = this.getDelegate();
        if (iterable instanceof List) {
            List list = (List)((Object)iterable);
            if (list.isEmpty()) {
                return Optional.absent();
            }
            List list2 = list;
            return Optional.of(list2.get(list2.size() - 1));
        }
        Iterator<E> iterator = iterable.iterator();
        if (!iterator.hasNext()) {
            return Optional.absent();
        }
        if (iterable instanceof SortedSet) {
            iterable = iterable;
            return Optional.of(iterable.last());
        }
        do {
            E current = iterator.next();
        } while (iterator.hasNext());
        return Optional.of(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final FluentIterable<E> skip(int numberToSkip) {
        void var1_1;
        return FluentIterable.from(Iterables.skip(this.getDelegate(), (int)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public final FluentIterable<E> limit(int maxSize) {
        void var1_1;
        return FluentIterable.from(Iterables.limit(this.getDelegate(), (int)var1_1));
    }

    public final boolean isEmpty() {
        return !this.getDelegate().iterator().hasNext();
    }

    public final ImmutableList<E> toList() {
        return ImmutableList.copyOf(this.getDelegate());
    }

    public final ImmutableList<E> toSortedList(Comparator<? super E> comparator) {
        return Ordering.from(comparator).immutableSortedCopy(this.getDelegate());
    }

    public final ImmutableSet<E> toSet() {
        return ImmutableSet.copyOf(this.getDelegate());
    }

    public final ImmutableSortedSet<E> toSortedSet(Comparator<? super E> comparator) {
        return ImmutableSortedSet.copyOf(comparator, this.getDelegate());
    }

    public final ImmutableMultiset<E> toMultiset() {
        return ImmutableMultiset.copyOf(this.getDelegate());
    }

    /*
     * WARNING - void declaration
     */
    public final <V> ImmutableMap<E, V> toMap(Function<? super E, V> valueFunction) {
        void var1_1;
        return Maps.toMap(this.getDelegate(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <K> ImmutableListMultimap<K, E> index(Function<? super E, K> keyFunction) {
        void var1_1;
        return Multimaps.index(this.getDelegate(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <K> ImmutableMap<K, E> uniqueIndex(Function<? super E, K> keyFunction) {
        void var1_1;
        return Maps.uniqueIndex(this.getDelegate(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @GwtIncompatible
    public final E[] toArray(Class<E> type) {
        void var1_1;
        return Iterables.toArray(this.getDelegate(), var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final <C extends Collection<? super E>> C copyInto(C collection) {
        void var1_1;
        Preconditions.checkNotNull(collection);
        Iterable<E> iterable = this.getDelegate();
        if (iterable instanceof Collection) {
            collection.addAll((Collection)iterable);
        } else {
            Iterator iterator;
            iterator = iterator.iterator();
            while (iterator.hasNext()) {
                void var3_3;
                Object item = iterator.next();
                collection.add(var3_3);
            }
        }
        return var1_1;
    }

    @Beta
    public final String join(Joiner joiner) {
        return joiner.join(this);
    }

    /*
     * WARNING - void declaration
     */
    @ParametricNullness
    public final E get(int position) {
        void var1_1;
        return Iterables.get(this.getDelegate(), (int)var1_1);
    }

    public final Stream<E> stream() {
        return Streams.stream(this.getDelegate());
    }

    private static class FromIterableFunction<E>
    implements Function<Iterable<E>, FluentIterable<E>> {
        private FromIterableFunction() {
        }

        @Override
        public FluentIterable<E> apply(Iterable<E> fromObject) {
            return FluentIterable.from(fromObject);
        }
    }
}

