/*
 * Decompiled with CFR 0.152.
 */
package com.google.common.collect;

import com.google.common.annotations.GwtCompatible;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.ElementTypesAreNonnullByDefault;
import com.google.common.collect.FilteredMultimap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;

@ElementTypesAreNonnullByDefault
@GwtCompatible
final class FilteredMultimapValues<K, V>
extends AbstractCollection<V> {
    private final FilteredMultimap<K, V> multimap;

    /*
     * WARNING - void declaration
     */
    FilteredMultimapValues(FilteredMultimap<K, V> multimap) {
        void var1_1;
        this.multimap = (FilteredMultimap)Preconditions.checkNotNull(var1_1);
    }

    @Override
    public final Iterator<V> iterator() {
        return Maps.valueIterator(this.multimap.entries().iterator());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean contains(Object o) {
        void var1_1;
        return this.multimap.containsValue(var1_1);
    }

    @Override
    public final int size() {
        return this.multimap.size();
    }

    @Override
    public final boolean remove(Object o) {
        Predicate<Map.Entry<K, V>> entryPredicate = this.multimap.entryPredicate();
        Iterator<Map.Entry<K, V>> unfilteredItr = this.multimap.unfiltered().entries().iterator();
        while (unfilteredItr.hasNext()) {
            Map.Entry<K, V> entry = unfilteredItr.next();
            if (!entryPredicate.apply(entry) || !Objects.equal(entry.getValue(), o)) continue;
            unfilteredItr.remove();
            return true;
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean removeAll(Collection<?> c) {
        void var1_1;
        return Iterables.removeIf(this.multimap.unfiltered().entries(), Predicates.and(this.multimap.entryPredicate(), Maps.valuePredicateOnEntries(Predicates.in(var1_1))));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final boolean retainAll(Collection<?> c) {
        void var1_1;
        return Iterables.removeIf(this.multimap.unfiltered().entries(), Predicates.and(this.multimap.entryPredicate(), Maps.valuePredicateOnEntries(Predicates.not(Predicates.in(var1_1)))));
    }

    @Override
    public final void clear() {
        this.multimap.clear();
    }
}

